/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.presentation.impl.typed.alerts;

import com.sap.jvm.profiling.i18n.I18n;
import com.sap.jvm.profiling.presentation.typed.TypedModel;
import com.sap.jvm.profiling.presentation.typed.alerts.AlertsTypedModel;
import com.sap.jvm.profiling.resource.AbstractResource;
import com.sap.jvm.profiling.resource.ProgressReporter;
import com.sap.jvm.profiling.resource.ResourceName;
import com.sap.jvm.profiling.resource.ResourceNameElement;
import com.sap.jvm.profiling.resource.ResourceReader;
import com.sap.jvm.profiling.resource.ResourceWriter;
import com.sap.jvm.profiling.snapshot.SnapshotElement;
import com.sap.jvm.profiling.ui.graph.LineGraphChart;
import com.sap.jvm.profiling.ui.graph.LineGraphSelectionListener;
import com.sap.jvm.profiling.ui.graph.axes.InvalidSelectionRange;
import com.sap.jvm.profiling.ui.graph.axes.XYGraphAxesModel;
import com.sap.jvm.profiling.ui.graph.axes.XYGraphAxisModelListener;
import com.sap.jvm.profiling.ui.graph.dataset.LineGraphDataSet;
import com.sap.jvm.profiling.ui.graph.geometry.Value2D;
import com.sap.jvm.tracing.Trace;
import java.io.EOFException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public class AlertsTypedModelImpl
extends AbstractResource
implements TypedModel,
AlertsTypedModel,
XYGraphAxisModelListener,
LineGraphSelectionListener {
    private String title;
    private final String defaultTitle;
    private byte[] graphUndoStack = new byte[0];
    private double axisMinX;
    private double axisMaxX;
    private double selMin;
    private double selMax;
    private long[] selectionPath;
    private Set<Path> expansionCache = new HashSet<Path>();
    private int sortedColumn;
    private int sortingDirection;

    public AlertsTypedModelImpl(ResourceName name) {
        super(name);
        ResourceNameElement[] elements = name.getElements();
        this.defaultTitle = elements[0] instanceof SnapshotElement ? I18n._ts((I18n.TextType)I18n.TextType.XGRP, (String)"Snapshot Telemetry") : I18n._ts((I18n.TextType)I18n.TextType.XGRP, (String)"Telemetry");
        this.title = this.defaultTitle;
    }

    @Override
    public void setSorting(int column, int direction) {
        this.sortedColumn = column;
        this.sortingDirection = direction;
    }

    @Override
    public int getSortedColumn() {
        return this.sortedColumn;
    }

    @Override
    public int getSortDirection() {
        return this.sortingDirection;
    }

    @Override
    public void saveExpansionState(long[] path, boolean expansion) {
        Path item = new Path(path);
        if (expansion) {
            this.expansionCache.add(item);
        } else {
            this.expansionCache.remove(item);
        }
    }

    @Override
    public List<long[]> getExpanded() {
        if (this.expansionCache.isEmpty()) {
            return null;
        }
        ArrayList<long[]> list = new ArrayList<long[]>(this.expansionCache.size());
        Iterator<Path> i = this.expansionCache.iterator();
        while (i.hasNext()) {
            list.add(i.next().path);
        }
        return list;
    }

    @Override
    public long[] getSelectionPath() {
        return this.selectionPath;
    }

    @Override
    public void setSelectionPath(long[] path) {
        this.selectionPath = path;
    }

    @Override
    public boolean restoreHeartBeatGraphState(LineGraphChart graph) {
        if (this.axisMaxX != this.axisMinX) {
            graph.adjustXAxis(this.axisMinX, this.axisMaxX, false);
            if (this.selMax != this.selMin) {
                graph.selectHorizontal(this.selMin, this.selMax);
            }
            try {
                graph.importUndoStack(this.graphUndoStack);
            }
            catch (IOException e) {
                Trace.error((Throwable)e, (String)"Could not import the UnDo stack!");
            }
            graph.addAxisListener(this);
            graph.addLineGraphSelectionListener(this);
            return true;
        }
        graph.addAxisListener(this);
        graph.addLineGraphSelectionListener(this);
        return false;
    }

    public long calculateWriteWork() {
        return 0L;
    }

    public void write(ResourceWriter writer, ProgressReporter reporter) {
        try {
            writer.writeString(this.title);
            writer.writeDouble(this.axisMinX);
            writer.writeDouble(this.axisMaxX);
            writer.writeDouble(this.selMin);
            writer.writeDouble(this.selMax);
            this.writeByteArray(writer, this.graphUndoStack);
            this.writeLongArray(writer, this.selectionPath);
            writer.writeInt32(this.expansionCache.size());
            for (Path p : this.expansionCache) {
                this.writeLongArray(writer, p.path);
            }
            writer.writeInt32(this.sortedColumn);
            writer.writeInt32(this.sortingDirection);
        }
        catch (IOException e) {
            Trace.error((Throwable)e);
        }
    }

    public void read(ResourceReader reader, ProgressReporter reporter) {
        try {
            this.title = reader.readString();
            this.axisMinX = reader.readDouble();
            this.axisMaxX = reader.readDouble();
            this.selMin = reader.readDouble();
            this.selMax = reader.readDouble();
            this.graphUndoStack = this.readByteArray(reader);
            this.selectionPath = this.readLongArray(reader);
            this.expansionCache.clear();
            int size = reader.readInt32();
            for (int i = 0; i < size; ++i) {
                Path p = new Path(this.readLongArray(reader));
                this.expansionCache.add(p);
            }
            this.sortedColumn = reader.readInt32();
            this.sortingDirection = reader.readInt32();
        }
        catch (EOFException e) {
            Trace.error((Throwable)e);
        }
    }

    private void writeByteArray(ResourceWriter writer, byte[] array) throws IOException {
        writer.writeInt32(array.length);
        for (int i = 0; i < array.length; ++i) {
            writer.writeInt8((int)array[i]);
        }
    }

    private byte[] readByteArray(ResourceReader reader) throws EOFException {
        byte[] result = new byte[reader.readInt32()];
        for (int i = 0; i < result.length; ++i) {
            result[i] = reader.readInt8();
        }
        return result;
    }

    private void writeLongArray(ResourceWriter writer, long[] array) throws IOException {
        if (array == null) {
            writer.writeInt32(-1);
        } else {
            writer.writeInt32(array.length);
            for (int i = 0; i < array.length; ++i) {
                writer.writeInt64(array[i]);
            }
        }
    }

    private long[] readLongArray(ResourceReader reader) throws EOFException {
        int size = reader.readInt32();
        if (size == -1) {
            return null;
        }
        long[] result = new long[size];
        for (int i = 0; i < result.length; ++i) {
            result[i] = reader.readInt64();
        }
        return result;
    }

    @Override
    public String getTitle() {
        return this.title;
    }

    @Override
    public void setTitle(String title) {
        this.title = title == null ? this.defaultTitle : title;
    }

    @Override
    public String getIconKey() {
        return "decorators/telemetry_editor.png";
    }

    public boolean isModifiable() {
        return true;
    }

    public ResourceName[] getDependents() {
        return null;
    }

    @Override
    public void adjustedXAxis(XYGraphAxesModel source) {
        this.axisMinX = source.getMinX();
        this.axisMaxX = source.getMaxX();
    }

    @Override
    public void adjustedYAxis(XYGraphAxesModel source) {
    }

    @Override
    public void adjustedBothAxis(XYGraphAxesModel source) {
        this.axisMinX = source.getMinX();
        this.axisMaxX = source.getMaxX();
    }

    @Override
    public void undoStackChanged(XYGraphAxesModel source) {
        this.graphUndoStack = source.exportUndoStack();
    }

    @Override
    public void selectionReset() {
        this.selMax = 0.0;
        this.selMin = 0.0;
    }

    @Override
    public void horizontalRangeSelectionChanged(double min, double max, List<InvalidSelectionRange> ranges) {
        this.selMin = min;
        this.selMax = max;
    }

    @Override
    public void horizontalRangeSelected(double min, double max, List<InvalidSelectionRange> ranges) {
        this.selMin = min;
        this.selMax = max;
    }

    @Override
    public void rectangleRangeSelectionChanged(double minX, double maxX, double minY, double maxY) {
    }

    @Override
    public void rectangleRangeSelected(double minX, double maxX, double minY, double maxY) {
    }

    @Override
    public void graphSelected(LineGraphDataSet graph) {
    }

    @Override
    public void valueSelected(LineGraphDataSet graph, List<Value2D> values) {
    }

    @Override
    public void selectionClickedOn() {
    }

    private class Path {
        int hash;
        long[] path;

        public Path(long[] path) {
            this.path = path;
        }

        public int hashCode() {
            if (this.hash == 0) {
                this.hash = Arrays.hashCode(this.path);
            }
            return this.hash;
        }

        public boolean equals(Object obj) {
            return obj instanceof Path ? Arrays.equals(this.path, ((Path)obj).path) : false;
        }
    }
}

