/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.presentation.impl.typed.alloc;

import com.sap.jvm.profiling.i18n.I18n;
import com.sap.jvm.profiling.presentation.impl.typed.alloc.AllocationValueSetProvider;
import com.sap.jvm.profiling.presentation.typed.TypedColumnSpec;
import com.sap.jvm.profiling.resource.ResourceName;
import com.sap.jvm.profiling.snapshot.util.Statistic;
import com.sap.jvm.util.pair.IntPair;

public abstract class AbstractArrayLengthHistogramProvider<T extends Statistic<IntPair>>
extends AllocationValueSetProvider<T, IntPair> {
    public AbstractArrayLengthHistogramProvider(ResourceName name, TypedColumnSpec spec, String title, String iconKey) {
        super(spec, title, iconKey, name);
    }

    @Override
    public int getNrOfRows() {
        return ((Statistic)this.statistic).size();
    }

    @Override
    public String getRowColorTag(int row) {
        return "graph.arrays." + row;
    }

    @Override
    public String getRowName(int row) {
        return AbstractArrayLengthHistogramProvider.getShortRange(this.getRowType(row));
    }

    @Override
    public String getRowToolTip(int row) {
        return AbstractArrayLengthHistogramProvider.getToolTipForRange(this.getRowType(row));
    }

    public static String getShortRange(IntPair range) {
        if (range.getSecond() == Integer.MAX_VALUE) {
            return I18n.formatText((String)I18n._s((String)"[{0}-]"), (Object[])new Object[]{AbstractArrayLengthHistogramProvider.getShortLength(range.getFirst())});
        }
        if (range.getFirst() + 1 == range.getSecond()) {
            return I18n.formatText((String)I18n._s((String)"[{0}]"), (Object[])new Object[]{AbstractArrayLengthHistogramProvider.getShortLength(range.getFirst())});
        }
        return I18n.formatText((String)I18n._s((String)"[{0}-{1}]"), (Object[])new Object[]{AbstractArrayLengthHistogramProvider.getShortLength(range.getFirst()), AbstractArrayLengthHistogramProvider.getShortLength(range.getSecond())});
    }

    public static String getToolTipForRange(IntPair range) {
        if (range.getSecond() == Integer.MAX_VALUE) {
            return I18n._s((String)"Arrays with a length of {0} or more", (Object[])new Object[]{range.getFirst()});
        }
        if (range.getFirst() + 1 == range.getSecond()) {
            return I18n._s((String)"Arrays with a length of exactly {0}", (Object[])new Object[]{range.getFirst()});
        }
        return I18n._s((String)"Arrays with a length between {0} and {1} (excluding)", (Object[])new Object[]{range.getFirst(), range.getSecond()});
    }

    private static String getShortLength(int length) {
        int millions = length / 1000000;
        if (millions > 0 && length % 1000000 == 0) {
            return millions + "M";
        }
        int thousands = length / 1000;
        if (thousands > 0 && length % 1000 == 0) {
            return thousands + "k";
        }
        return Integer.toString(length);
    }

    @Override
    public IntPair getRowType(int row) {
        return (IntPair)((Statistic)this.statistic).getKey(row);
    }
}

