/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.presentation.impl.typed.alloc;

import com.sap.jvm.profiling.i18n.I18n;
import com.sap.jvm.profiling.presentation.impl.typed.alloc.AllocationProvider;
import com.sap.jvm.profiling.presentation.impl.typed.alloc.AllocationTableProvider;
import com.sap.jvm.profiling.presentation.impl.typed.alloc.ProviderUtils;
import com.sap.jvm.profiling.presentation.typed.entries.NormalArrayLength;
import com.sap.jvm.profiling.presentation.typed.entries.ProviderEntry;
import com.sap.jvm.profiling.resource.ResourceName;
import com.sap.jvm.profiling.resource.ResourceNameElement;
import com.sap.jvm.profiling.snapshot.alloc.ArrayLengthStatistic;
import com.sap.jvm.profiling.snapshot.alloc.BytesAndObjects;
import com.sap.jvm.profiling.snapshot.alloc.Elements;
import com.sap.jvm.profiling.snapshot.util.ValueStatistic;
import com.sap.jvm.profiling.snapshot.util.column.Column;

public final class ArrayLengthStatisticProvider
extends AllocationTableProvider<ArrayLengthStatistic> {
    public ArrayLengthStatisticProvider(ResourceName name) {
        super(name, I18n._ts((I18n.TextType)I18n.TextType.XTBS, (String)"Array Length Distribution"), "types/array_dimensions.gif", ProviderUtils.appendSingleObjectSizeSpec(ProviderUtils.getBytesAndObjectsSpec(name)).prepend(I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Length"), I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"The array length"), 8265, NormalArrayLength.class, "array_length"));
    }

    @Override
    public ProviderEntry getEntry(int entryId, int column) {
        if (column == 0) {
            return new NormalArrayLength((Integer)((ArrayLengthStatistic)this.statistic).getKey(entryId));
        }
        if (column == this.nrOfColumns - 1) {
            return ProviderUtils.getBytesPerObject((BytesAndObjects)((ArrayLengthStatistic)this.statistic).getValue(entryId));
        }
        return ProviderUtils.getEntry(entryId, column - 1, (ValueStatistic)this.statistic, (AllocationProvider)this);
    }

    @Override
    public Column getColumn(int columnIndex) {
        if (columnIndex == 0) {
            return ((ArrayLengthStatistic)this.statistic).getKeyColumn();
        }
        if (columnIndex == this.nrOfColumns - 1) {
            return null;
        }
        return ProviderUtils.getColumn((ValueStatistic)this.statistic, columnIndex - 1);
    }

    @Override
    protected ResourceName getStatisticName() {
        return this.getResourceName().stripLastElement().addElement((ResourceNameElement)new Elements.CreateArrayLengthStatistic());
    }
}

