/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.presentation.impl.typed.alloc;

import com.sap.jvm.profiling.i18n.I18n;
import com.sap.jvm.profiling.presentation.typed.TypedTimeSeriesProvider;
import com.sap.jvm.profiling.presentation.typed.entries.NrOfBytesPerSecond;
import com.sap.jvm.profiling.presentation.typed.entries.NrOfObjectsPerSecond;
import com.sap.jvm.profiling.resource.ResourceName;
import com.sap.jvm.profiling.resource.ResourceNameElement;
import com.sap.jvm.profiling.snapshot.alloc.Elements;

public class CalledTimeSeriesProvider
extends TypedTimeSeriesProvider {
    public CalledTimeSeriesProvider(ResourceName name) {
        super(name, I18n._ts((I18n.TextType)I18n.TextType.XTBS, (String)"Allocation Rates"), "views/graph.gif", "allocation/rate");
        this.setCurrent(this.getCollectionName(), 4);
        this.addGroup("allocation", I18n._s((String)"Allocation Rates"));
        this.addArea(I18n._ts((I18n.TextType)I18n.TextType.XTBS, (String)"Allocation Rates"), "allocation/rate", I18n._s((String)"Shows the rates of allocations"));
        this.addLine(0, 1, 0, I18n._s((String)"Allocated Bytes per second"), "f000f0", NrOfBytesPerSecond.class);
        this.addLine(1, 1, 0, I18n._s((String)"Allocated objects per second"), "00f0f0", NrOfObjectsPerSecond.class);
        if (name.getSession().getSystemInfo().supportsStackAllocations()) {
            this.addArea(I18n._ts((I18n.TextType)I18n.TextType.XTBS, (String)"Stack Allocation Rates"), "allocation/stackrate", I18n._s((String)"Shows the rates of stack allocations"));
            this.addLine(2, 1, 0, I18n._s((String)"Allocated Stack Bytes per second"), "f000f0", NrOfBytesPerSecond.class);
            this.addLine(3, 1, 0, I18n._s((String)"Allocated Stack objects per second"), "00f0f0", NrOfObjectsPerSecond.class);
        }
        this.addGeneralTimeSeries();
    }

    @Override
    protected ResourceName getCollectionName() {
        return this.getResourceName().stripLastElement().addElement((ResourceNameElement)new Elements.CreateCalledTimeSeriesCollection());
    }
}

