/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.presentation.impl.typed.alloc;

import com.sap.jvm.profiling.i18n.I18n;
import com.sap.jvm.profiling.presentation.impl.typed.SumBehavior;
import com.sap.jvm.profiling.presentation.impl.typed.alloc.AllocationProvider;
import com.sap.jvm.profiling.presentation.impl.typed.alloc.AllocationTableProvider;
import com.sap.jvm.profiling.presentation.impl.typed.alloc.ProviderUtils;
import com.sap.jvm.profiling.presentation.typed.entries.NormalArrayLength;
import com.sap.jvm.profiling.presentation.typed.entries.ProviderEntry;
import com.sap.jvm.profiling.resource.ResourceName;
import com.sap.jvm.profiling.resource.ResourceNameElement;
import com.sap.jvm.profiling.snapshot.alloc.BytesAndObjects;
import com.sap.jvm.profiling.snapshot.alloc.CallingArrayLengthStatistic;
import com.sap.jvm.profiling.snapshot.alloc.Elements;
import com.sap.jvm.profiling.snapshot.util.SelfAndTotalValueStatistic;
import com.sap.jvm.profiling.snapshot.util.column.Column;

public final class CallingArrayLengthStatisticProvider
extends AllocationTableProvider<CallingArrayLengthStatistic> {
    public CallingArrayLengthStatisticProvider(ResourceName name) {
        super(name, I18n._ts((I18n.TextType)I18n.TextType.XTBS, (String)"Array Length Distribution"), "types/array_dimensions.gif", ProviderUtils.appendSingleObjectSizeSpec(ProviderUtils.getSelfAndTotalSpec(name, I18n._ss((String)"Entity, ex: ... affected by {0}, ... time spent in {0}", (String)"this component"), false, false, SumBehavior.SUM_NONE)).prepend(I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Length"), I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"The array length"), 8265, NormalArrayLength.class, "array_length"));
    }

    @Override
    public ProviderEntry getEntry(int entryId, int column) {
        if (column == 0) {
            return new NormalArrayLength((Integer)((CallingArrayLengthStatistic)this.statistic).getKey(entryId));
        }
        if (column == this.nrOfColumns - 1) {
            return ProviderUtils.getBytesPerObject((BytesAndObjects)((CallingArrayLengthStatistic)this.statistic).getTotal(entryId));
        }
        return ProviderUtils.getEntry(entryId, column - 1, (SelfAndTotalValueStatistic)this.statistic, (AllocationProvider)this);
    }

    @Override
    public Column getColumn(int columnIndex) {
        if (columnIndex == 0) {
            return ((CallingArrayLengthStatistic)this.statistic).getKeyColumn();
        }
        if (columnIndex == this.nrOfColumns - 1) {
            return null;
        }
        return ProviderUtils.getColumn((SelfAndTotalValueStatistic)this.statistic, columnIndex - 1);
    }

    @Override
    protected ResourceName getStatisticName() {
        return this.getResourceName().stripLastElement().addElement((ResourceNameElement)new Elements.CreateCallingArrayLengthStatistic());
    }
}

