/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.presentation.impl.typed.alloc;

import com.sap.jvm.profiling.core.type.ClassObject;
import com.sap.jvm.profiling.i18n.I18n;
import com.sap.jvm.profiling.presentation.impl.typed.alloc.AllocationProvider;
import com.sap.jvm.profiling.presentation.impl.typed.alloc.AllocationTableProvider;
import com.sap.jvm.profiling.presentation.impl.typed.alloc.ProviderUtils;
import com.sap.jvm.profiling.presentation.typed.entries.NormalClass;
import com.sap.jvm.profiling.presentation.typed.entries.NormalClassType;
import com.sap.jvm.profiling.presentation.typed.entries.ProviderEntry;
import com.sap.jvm.profiling.resource.ResourceName;
import com.sap.jvm.profiling.resource.ResourceNameElement;
import com.sap.jvm.profiling.snapshot.alloc.ClassStatistic;
import com.sap.jvm.profiling.snapshot.alloc.Elements;
import com.sap.jvm.profiling.snapshot.util.ValueStatistic;
import com.sap.jvm.profiling.snapshot.util.column.Column;

public final class ClassStatisticProvider
extends AllocationTableProvider<ClassStatistic> {
    public ClassStatisticProvider(ResourceName name) {
        super(name, I18n._ts((I18n.TextType)I18n.TextType.XTBS, (String)"Allocated Objects"), "views/class_statistic.gif", ProviderUtils.getBytesAndObjectsSpec(name).prepend(I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Class"), I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"The class of the allocated object"), 73, NormalClass.class, "class_name").prepend(I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)""), I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"The type of the allocated object"), 16385, NormalClassType.class, "class_type"));
    }

    @Override
    public ProviderEntry getEntry(int entryId, int column) {
        if (column == 0) {
            return new NormalClassType((ClassObject)((ClassStatistic)this.statistic).getKey(entryId));
        }
        if (column == 1) {
            return new NormalClass((ClassObject)((ClassStatistic)this.statistic).getKey(entryId));
        }
        return ProviderUtils.getEntry(entryId, column - 2, (ValueStatistic)this.statistic, (AllocationProvider)this);
    }

    @Override
    public Column getColumn(int columnIndex) {
        if (columnIndex == 0) {
            return null;
        }
        if (columnIndex == 1) {
            return ((ClassStatistic)this.statistic).getKeyColumn();
        }
        return ProviderUtils.getColumn((ValueStatistic)this.statistic, columnIndex - 2);
    }

    @Override
    protected ResourceName getStatisticName() {
        return this.getResourceName().stripLastElement().addElement((ResourceNameElement)new Elements.CreateClassStatistic());
    }
}

