/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.presentation.impl.typed.alloc;

import com.sap.jvm.profiling.i18n.I18n;
import com.sap.jvm.profiling.presentation.impl.typed.SumBehavior;
import com.sap.jvm.profiling.presentation.impl.typed.alloc.AllocationProvider;
import com.sap.jvm.profiling.presentation.impl.typed.alloc.AllocationTableProvider;
import com.sap.jvm.profiling.presentation.impl.typed.alloc.ProviderUtils;
import com.sap.jvm.profiling.presentation.typed.entries.NormalParameterSpec;
import com.sap.jvm.profiling.presentation.typed.entries.NrOfInvocations;
import com.sap.jvm.profiling.presentation.typed.entries.ProviderEntry;
import com.sap.jvm.profiling.resource.ResourceName;
import com.sap.jvm.profiling.resource.ResourceNameElement;
import com.sap.jvm.profiling.snapshot.alloc.Elements;
import com.sap.jvm.profiling.snapshot.alloc.MethodParameterStatistic;
import com.sap.jvm.profiling.snapshot.resource.InvocationDist;
import com.sap.jvm.profiling.snapshot.resource.MptSpecName;
import com.sap.jvm.profiling.snapshot.util.SelfAndTotalValueStatistic;
import com.sap.jvm.profiling.snapshot.util.column.Column;

public final class MethodParameterStatisticProvider
extends AllocationTableProvider<MethodParameterStatistic> {
    public MethodParameterStatisticProvider(ResourceName name) {
        super(name, I18n._ts((I18n.TextType)I18n.TextType.XTBS, (String)"Method Parameters"), "views/method_parameter_statistic.gif", ProviderUtils.getSelfAndTotalSpec(name, I18n._ss((String)"Entity, ex: ... affected by {0}, ... time spent in {0}", (String)"this method"), false, false, SumBehavior.SUM_SELF).prepend(I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Invocations"), I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"The number of method invocations"), 69, NrOfInvocations.class, "nr_method_invocations").prepend(I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Parameter Definition"), I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"The name of the parameter definition"), 41, NormalParameterSpec.class, "method_parameter_definition"));
    }

    @Override
    public ProviderEntry getEntry(int entryId, int column) {
        if (column == 0) {
            return new NormalParameterSpec(((MptSpecName)((MethodParameterStatistic)this.statistic).getKey(entryId)).getName());
        }
        if (column == 1) {
            return NrOfInvocations.PROTOTYPE.create(((InvocationDist)((MethodParameterStatistic)this.statistic).getOther(entryId)).getTotalInvocations(), ((InvocationDist)((MethodParameterStatistic)this.statistic).getOther()).getTotalInvocations());
        }
        return ProviderUtils.getEntry(entryId, column - 2, (SelfAndTotalValueStatistic)this.statistic, (AllocationProvider)this);
    }

    @Override
    public Column getColumn(int columnIndex) {
        if (columnIndex == 0) {
            return ((MethodParameterStatistic)this.statistic).getKeyColumn();
        }
        if (columnIndex == 1) {
            return ((MethodParameterStatistic)this.statistic).getOtherColumn();
        }
        return ProviderUtils.getColumn((SelfAndTotalValueStatistic)this.statistic, columnIndex - 2);
    }

    @Override
    protected ResourceName getStatisticName() {
        return this.getResourceName().stripLastElement().addElement((ResourceNameElement)new Elements.CreateMethodParameterStatistic());
    }
}

