/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.presentation.impl.typed.alloc;

import com.sap.jvm.profiling.i18n.I18n;
import com.sap.jvm.profiling.method.parameters.Parameter;
import com.sap.jvm.profiling.presentation.impl.typed.SumBehavior;
import com.sap.jvm.profiling.presentation.impl.typed.alloc.AllocationProvider;
import com.sap.jvm.profiling.presentation.impl.typed.alloc.AllocationTableProvider;
import com.sap.jvm.profiling.presentation.impl.typed.alloc.ProviderUtils;
import com.sap.jvm.profiling.presentation.typed.entries.NormalParameterValue;
import com.sap.jvm.profiling.presentation.typed.entries.NrOfInvocations;
import com.sap.jvm.profiling.presentation.typed.entries.ProviderEntry;
import com.sap.jvm.profiling.resource.ResourceName;
import com.sap.jvm.profiling.resource.ResourceNameElement;
import com.sap.jvm.profiling.snapshot.alloc.Elements;
import com.sap.jvm.profiling.snapshot.alloc.ParameterValuesStatistic;
import com.sap.jvm.profiling.snapshot.resource.InvocationDist;
import com.sap.jvm.profiling.snapshot.util.SelfAndTotalValueStatistic;
import com.sap.jvm.profiling.snapshot.util.column.Column;

public final class ParameterValuesStatisticProvider
extends AllocationTableProvider<ParameterValuesStatistic> {
    public ParameterValuesStatisticProvider(ResourceName name) {
        super(name, I18n._ts((I18n.TextType)I18n.TextType.XTBS, (String)"Parameter Values"), "views/parameter_values.gif", ProviderUtils.getSelfAndTotalSpec(name, I18n._ss((String)"Entity, ex: ... affected by {0}, ... time spent in {0}", (String)"this parameter"), false, false, SumBehavior.SUM_SELF).prepend(I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Invocations"), I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"The number of method invocations"), 69, NrOfInvocations.class, "nr_method_invocations").prepend(I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Parameter Value"), I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"The parameter value"), 41, NormalParameterValue.class, "parameter_value"));
    }

    @Override
    public ProviderEntry getEntry(int entryId, int column) {
        if (column == 0) {
            return new NormalParameterValue((Parameter)((ParameterValuesStatistic)this.statistic).getKey(entryId));
        }
        if (column == 1) {
            return NrOfInvocations.PROTOTYPE.create(((InvocationDist)((ParameterValuesStatistic)this.statistic).getOther(entryId)).getTotalInvocations(), ((InvocationDist)((ParameterValuesStatistic)this.statistic).getOther()).getTotalInvocations());
        }
        return ProviderUtils.getEntry(entryId, column - 2, (SelfAndTotalValueStatistic)this.statistic, (AllocationProvider)this);
    }

    @Override
    public Column getColumn(int columnIndex) {
        if (columnIndex == 0) {
            return ((ParameterValuesStatistic)this.statistic).getKeyColumn();
        }
        if (columnIndex == 1) {
            return ((ParameterValuesStatistic)this.statistic).getOtherColumn();
        }
        return ProviderUtils.getColumn((SelfAndTotalValueStatistic)this.statistic, columnIndex - 2);
    }

    @Override
    protected ResourceName getStatisticName() {
        return this.getResourceName().stripLastElement().addElement((ResourceNameElement)new Elements.CreateParameterValuesStatistic());
    }
}

