/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.presentation.impl.typed.alloc;

import com.sap.jvm.profiling.i18n.I18n;
import com.sap.jvm.profiling.presentation.impl.typed.SumBehavior;
import com.sap.jvm.profiling.presentation.impl.typed.alloc.AllocationProvider;
import com.sap.jvm.profiling.presentation.typed.TypedColumnSpec;
import com.sap.jvm.profiling.presentation.typed.VisibilitySet;
import com.sap.jvm.profiling.presentation.typed.entries.NrOfBytes;
import com.sap.jvm.profiling.presentation.typed.entries.NrOfObjects;
import com.sap.jvm.profiling.presentation.typed.entries.Quantity;
import com.sap.jvm.profiling.resource.ResourceName;
import com.sap.jvm.profiling.snapshot.alloc.BytesAndObjects;
import com.sap.jvm.profiling.snapshot.alloc.BytesAndObjectsColumn;
import com.sap.jvm.profiling.snapshot.util.SelfAndTotalValueStatistic;
import com.sap.jvm.profiling.snapshot.util.SelfAndTotalValueTreeNode;
import com.sap.jvm.profiling.snapshot.util.ValueStatistic;
import com.sap.jvm.profiling.snapshot.util.ValueTreeBase;
import com.sap.jvm.profiling.snapshot.util.column.LongValueColumn;

public class ProviderUtils {
    public static TypedColumnSpec appendSingleObjectSizeSpec(TypedColumnSpec spec) {
        spec.appendColumn("Size per Object", "The size of a single object", 8194, NrOfBytes.class, "bytes_per_object", new VisibilitySet("bytes_per_object", "bytes_per_object", I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Bytes Per Object"), null, I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"Shows the number of bytes per object"), new Integer[0]));
        return spec;
    }

    public static NrOfBytes getBytesPerObject(BytesAndObjects bao) {
        if (bao.getObjects() == 0L) {
            return (NrOfBytes)NrOfBytes.PROTOTYPE.create(0L);
        }
        return (NrOfBytes)NrOfBytes.PROTOTYPE.create(bao.getBytes() / bao.getObjects());
    }

    public static TypedColumnSpec getBytesAndObjectsSpec(ResourceName name) {
        TypedColumnSpec spec = new TypedColumnSpec("Bytes|Objects|Overall");
        VisibilitySet bytes = new VisibilitySet("Bytes", "Group_1", I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Bytes"), "tables/col_nr_of.gif", I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"Number of allocated bytes"), new Integer[0]);
        VisibilitySet objects = new VisibilitySet("Objects", "Group_1", I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Objects"), "tables/col_nr_of.gif", I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"Number of allocated objects"), new Integer[0]);
        VisibilitySet overall = new VisibilitySet("Overall", "Group_2", I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Overall"), "tables/col_nr_of.gif", I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"Overall allocations"), new Integer[0]);
        VisibilitySet heap = new VisibilitySet("Heap", "Group_2", I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Heap"), "tables/col_nr_of.gif", I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"Heap allocations"), new Integer[0]);
        VisibilitySet stack = new VisibilitySet("Stack", "Group_2", I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Stack"), "tables/col_nr_of.gif", I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"Stack allocations"), new Integer[0]);
        spec.appendColumn(I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Bytes"), I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"The number of allocated bytes"), 12550, NrOfBytes.class, "self_bytes", bytes, overall);
        spec.appendColumn(I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Objects"), I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"The number of allocated objects"), 12294, NrOfObjects.class, "self_objects", objects, overall);
        spec.appendColumn(I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Heap Bytes"), I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"The number of bytes allocated on the heap"), 12294, NrOfBytes.class, "self_bytes", bytes, heap);
        spec.appendColumn(I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Heap Objects"), I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"The number of objects allocated on the heap"), 12294, NrOfObjects.class, "self_objects", objects, heap);
        spec.appendColumn(I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Stack Bytes"), I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"The number of bytes allocated on the stack"), 12294, NrOfBytes.class, "self_bytes", bytes, stack);
        spec.appendColumn(I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Stack Objects"), I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"The number of objects allocated on the stack"), 12294, NrOfObjects.class, "self_objects", objects, stack);
        return ProviderUtils.disableUnneededColumns(name, spec);
    }

    public static TypedColumnSpec getSelfAndTotalSpec(ResourceName name, String entity, boolean pluralEntity, boolean sortBySelf, SumBehavior sumBehavior) {
        int sumSelf = sumBehavior.sumSelf() ? 36868 : 4096;
        int sumTotal = sumBehavior.sumTotal() ? 4100 : 4096;
        VisibilitySet bytes = new VisibilitySet("Bytes", "1-BytesAndObjects", I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Bytes"), "tables/col_nr_of.gif", I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"Number of allocated bytes"), new Integer[0]);
        VisibilitySet objects = new VisibilitySet("Objects", "1-BytesAndObjects", I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Objects"), "tables/col_nr_of.gif", I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"Number of allocated objects"), new Integer[0]);
        VisibilitySet self = new VisibilitySet("Self", "2-SelfAndTotal", I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Self"), "tables/col_self_nr_of.gif", I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"Self values"), new Integer[0]);
        VisibilitySet total = new VisibilitySet("Total", "2-SelfAndTotal", I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Total"), "tables/col_total_nr_of.gif", I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"Total values"), new Integer[0]);
        VisibilitySet overall = new VisibilitySet("Overall", "3-HeapAndStack", I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Overall"), "tables/col_nr_of.gif", I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"Overall allocations"), new Integer[0]);
        VisibilitySet heap = new VisibilitySet("Heap", "3-HeapAndStack", I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Heap"), "tables/col_nr_of.gif", I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"Heap allocations"), new Integer[0]);
        VisibilitySet stack = new VisibilitySet("Stack", "3-HeapAndStack", I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Stack"), "tables/col_nr_of.gif", I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"Stack allocations"), new Integer[0]);
        TypedColumnSpec spec = new TypedColumnSpec("Bytes|Self|Total|Overall");
        spec.appendColumn(I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Self Bytes"), I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"The number of bytes allocated directly in {0}", (Object[])new Object[]{entity}), 2 | sumSelf | 0x2000 | (sortBySelf ? 256 : 0), NrOfBytes.class, "self_bytes", bytes, self, overall);
        spec.appendColumn(I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Self Objects"), I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"The number of objects allocated directly in {0}", (Object[])new Object[]{entity}), 2 | sumSelf | 0x2000, NrOfObjects.class, "self_objects", objects, self, overall);
        spec.appendColumn(I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Self Heap Bytes"), I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"The number of bytes allocated on the heap directly in {0}", (Object[])new Object[]{entity}), 2 | sumSelf | 0x2000, NrOfBytes.class, "self_bytes", bytes, self, heap);
        spec.appendColumn(I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Self Heap Objects"), I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"The number of objects allocated on the heap directly in {0}", (Object[])new Object[]{entity}), 2 | sumSelf | 0x2000, NrOfObjects.class, "self_objects", objects, self, heap);
        spec.appendColumn(I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Self Stack Bytes"), I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"The number of bytes allocated on the stack directly in {0}", (Object[])new Object[]{entity}), 2 | sumSelf | 0x2000, NrOfBytes.class, "self_bytes", bytes, self, stack);
        spec.appendColumn(I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Self Stack Objects"), I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"The number of objects allocated on the stack directly in {0}", (Object[])new Object[]{entity}), 2 | sumSelf | 0x2000, NrOfObjects.class, "self_objects", objects, self, stack);
        spec.appendColumn(I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Total Bytes"), I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"The number of bytes allocated directly and indirectly in {0}", (Object[])new Object[]{entity}), 0x2002 | (sortBySelf ? 0 : 256) | sumTotal, NrOfBytes.class, "total_bytes", bytes, total, overall);
        spec.appendColumn(I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Total Objects"), I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"The number of objects allocated directly and indirectly in {0}", (Object[])new Object[]{entity}), 0x2002 | sumTotal, NrOfObjects.class, "total_objects", objects, total, overall);
        spec.appendColumn(I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Total Heap Bytes"), I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"The number of bytes allocated on the heap directly and indirectly in {0}", (Object[])new Object[]{entity}), 0x2002 | sumTotal, NrOfBytes.class, "total_bytes", bytes, total, heap);
        spec.appendColumn(I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Total Heap Objects"), I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"The number of objects allocated on the heap directly and indirectly in {0}", (Object[])new Object[]{entity}), 0x2002 | sumTotal, NrOfObjects.class, "total_objects", objects, total, heap);
        spec.appendColumn(I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Total Stack Bytes"), I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"The number of bytes allocated on the stack directly and indirectly in {0}", (Object[])new Object[]{entity}), 0x2002 | sumTotal, NrOfBytes.class, "total_bytes", bytes, total, stack);
        spec.appendColumn(I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Total Stack Objects"), I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"The number of objects allocated on the stack directly and indirectly in {0}", (Object[])new Object[]{entity}), 0x2002 | sumTotal, NrOfObjects.class, "total_objects", objects, total, stack);
        return ProviderUtils.disableUnneededColumns(name, spec);
    }

    private static LongValueColumn getColumn(BytesAndObjectsColumn column, int columnIndex) {
        switch (columnIndex) {
            case 0: {
                return column.getBytesColumn();
            }
            case 1: {
                return column.getObjectsColumn();
            }
            case 2: {
                return column.getHeapBytesColumn();
            }
            case 3: {
                return column.getHeapObjectsColumn();
            }
            case 4: {
                return column.getStackBytesColumn();
            }
            case 5: {
                return column.getStackObjectsColumn();
            }
        }
        assert (false);
        return null;
    }

    public static LongValueColumn getColumn(ValueStatistic<?, BytesAndObjects> statistic, int columnIndex) {
        return ProviderUtils.getColumn((BytesAndObjectsColumn)statistic.getValueColumn(), columnIndex);
    }

    public static LongValueColumn getColumn(SelfAndTotalValueStatistic<?, BytesAndObjects> statistic, int columnIndex) {
        if (columnIndex < 6) {
            return ProviderUtils.getColumn((BytesAndObjectsColumn)statistic.getSelfColumn(), columnIndex);
        }
        return ProviderUtils.getColumn((BytesAndObjectsColumn)statistic.getTotalColumn(), columnIndex - 6);
    }

    private static Quantity getEntry(BytesAndObjects value, int column, BytesAndObjects total, AllocationProvider provider) {
        switch (column) {
            case 0: {
                return NrOfBytes.PROTOTYPE.create(value.getBytes(), provider.getSnapshotBytes(), total.getBytes());
            }
            case 1: {
                return NrOfObjects.PROTOTYPE.create(value.getObjects(), provider.getSnapshotObjects(), total.getObjects());
            }
            case 2: {
                return NrOfBytes.PROTOTYPE.create(value.getHeapBytes(), provider.getSnapshotBytes(), total.getHeapBytes());
            }
            case 3: {
                return NrOfObjects.PROTOTYPE.create(value.getHeapObjects(), provider.getSnapshotObjects(), total.getHeapObjects());
            }
            case 4: {
                return NrOfBytes.PROTOTYPE.create(value.getStackBytes(), provider.getSnapshotBytes(), total.getStackBytes());
            }
            case 5: {
                return NrOfObjects.PROTOTYPE.create(value.getStackObjects(), provider.getSnapshotObjects(), total.getStackObjects());
            }
        }
        assert (false);
        return null;
    }

    public static Quantity getEntry(int id, int column, SelfAndTotalValueStatistic<?, BytesAndObjects> statistic, AllocationProvider provider) {
        if (column < 6) {
            return ProviderUtils.getEntry(statistic.getSelf(id), column, statistic.getTotal(), provider);
        }
        return ProviderUtils.getEntry(statistic.getTotal(id), column - 6, statistic.getTotal(), provider);
    }

    public static Quantity getEntry(int id, int column, ValueStatistic<?, BytesAndObjects> statistic, AllocationProvider provider) {
        return ProviderUtils.getEntry(statistic.getValue(id), column, statistic.getValue(), provider);
    }

    public static Quantity getEntry(SelfAndTotalValueTreeNode<?, BytesAndObjects> node, int column, ValueTreeBase<?, BytesAndObjects, ?> tree, AllocationProvider provider) {
        if (column < 6) {
            return ProviderUtils.getEntry(node.getSelf(), column, tree.getTotal(), provider);
        }
        return ProviderUtils.getEntry(node.getTotal(), column - 6, tree.getTotal(), provider);
    }

    private static TypedColumnSpec disableUnneededColumns(ResourceName name, TypedColumnSpec spec) {
        if (!name.getSession().getSystemInfo().supportsStackAllocations()) {
            spec.disableVisibilitySets("Heap");
            spec.disableVisibilitySets("Stack");
        }
        return spec;
    }
}

