/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.presentation.impl.typed.alloc;

import com.sap.jvm.profiling.i18n.I18n;
import com.sap.jvm.profiling.presentation.impl.typed.alloc.AllocationProvider;
import com.sap.jvm.profiling.presentation.impl.typed.alloc.AllocationTableProvider;
import com.sap.jvm.profiling.presentation.impl.typed.alloc.ProviderUtils;
import com.sap.jvm.profiling.presentation.typed.entries.NormalThreadId;
import com.sap.jvm.profiling.presentation.typed.entries.NormalThreadName;
import com.sap.jvm.profiling.presentation.typed.entries.ProviderEntry;
import com.sap.jvm.profiling.resource.ResourceName;
import com.sap.jvm.profiling.resource.ResourceNameElement;
import com.sap.jvm.profiling.snapshot.alloc.Elements;
import com.sap.jvm.profiling.snapshot.alloc.ThreadIdStatistic;
import com.sap.jvm.profiling.snapshot.resource.ThreadIdAndName;
import com.sap.jvm.profiling.snapshot.resource.ThreadIdAndNameColumn;
import com.sap.jvm.profiling.snapshot.util.ValueStatistic;
import com.sap.jvm.profiling.snapshot.util.column.Column;

public final class ThreadIdStatisticProvider
extends AllocationTableProvider<ThreadIdStatistic> {
    public ThreadIdStatisticProvider(ResourceName name) {
        super(name, I18n._ts((I18n.TextType)I18n.TextType.XTBS, (String)"Threads By ID"), "views/thread_statistic.gif", ProviderUtils.getBytesAndObjectsSpec(name).prepend(I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Name"), I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"One name of the thread"), 9, NormalThreadName.class, "thread_name").prepend(I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"ID"), I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"The id of the thread"), 8257, NormalThreadId.class, "thread_id"));
        this.getColumnSpec().setCompareKeyColumns(0);
    }

    @Override
    public ProviderEntry getEntry(int entryId, int column) {
        if (column == 0) {
            return new NormalThreadId(((ThreadIdAndName)((ThreadIdStatistic)this.statistic).getKey(entryId)).getId());
        }
        if (column == 1) {
            return new NormalThreadName(((ThreadIdAndName)((ThreadIdStatistic)this.statistic).getKey(entryId)).getUTFName());
        }
        return ProviderUtils.getEntry(entryId, column - 2, (ValueStatistic)this.statistic, (AllocationProvider)this);
    }

    @Override
    public Column getColumn(int columnIndex) {
        if (columnIndex == 0) {
            return ((ThreadIdAndNameColumn)((ThreadIdStatistic)this.statistic).getKeyColumn()).getIdColumn();
        }
        if (columnIndex == 1) {
            return ((ThreadIdAndNameColumn)((ThreadIdStatistic)this.statistic).getKeyColumn()).getNameColumn();
        }
        return ProviderUtils.getColumn((ValueStatistic)this.statistic, columnIndex - 2);
    }

    @Override
    protected ResourceName getStatisticName() {
        return this.getResourceName().stripLastElement().addElement((ResourceNameElement)new Elements.CreateThreadIdStatistic());
    }
}

