/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.presentation.impl.typed.cls;

import com.sap.jvm.profiling.core.type.ClassLoaderObject;
import com.sap.jvm.profiling.i18n.I18n;
import com.sap.jvm.profiling.presentation.impl.typed.cls.ClsProvider;
import com.sap.jvm.profiling.presentation.typed.TypedColumnSpec;
import com.sap.jvm.profiling.presentation.typed.VisibilitySet;
import com.sap.jvm.profiling.presentation.typed.entries.NormalClass;
import com.sap.jvm.profiling.presentation.typed.entries.NormalClassLoader;
import com.sap.jvm.profiling.presentation.typed.entries.NormalClassType;
import com.sap.jvm.profiling.presentation.typed.entries.NrOfBytes;
import com.sap.jvm.profiling.presentation.typed.entries.NrOfObjects;
import com.sap.jvm.profiling.presentation.typed.entries.ProviderEntry;
import com.sap.jvm.profiling.resource.ResourceName;
import com.sap.jvm.profiling.snapshot.cls.ClassGeneration;
import com.sap.jvm.profiling.snapshot.cls.ClassLoaderValue;
import com.sap.jvm.profiling.snapshot.cls.ClsClassLoaderStatistic;
import com.sap.jvm.profiling.snapshot.cls.ClsValue;
import com.sap.jvm.profiling.snapshot.cls.ClsValueByGenerationStatistic;
import com.sap.jvm.profiling.snapshot.cls.ClsValuesColumn;
import com.sap.jvm.profiling.snapshot.util.ValueStatistic;
import com.sap.jvm.profiling.snapshot.util.column.Column;

public class ProviderUtils {
    public static TypedColumnSpec getClassStatisticDumpValueSpec(ResourceName name) {
        VisibilitySet bytes = new VisibilitySet("Bytes", "1-BytesAndObjects", I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Bytes"), "tables/col_nr_of.gif", I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"Number of allocated bytes"), new Integer[0]);
        VisibilitySet objects = new VisibilitySet("Objects", "1-BytesAndObjects", I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Objects"), "tables/col_nr_of.gif", I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"Number of allocated objects"), new Integer[0]);
        VisibilitySet all = new VisibilitySet("All-Generations", "2-Generations", I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"All Generations"), "tables/col_total_nr_of.gif", I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"Summarized values over all generations"), new Integer[0]);
        VisibilitySet young = new VisibilitySet("Young-Generation", "2-Generations", I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Young Generation"), "tables/col_nr_of.gif", I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"Young generation values"), new Integer[0]);
        VisibilitySet old = new VisibilitySet("Old-Generation", "2-Generations", I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Old Generation"), "tables/col_nr_of.gif", I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"Old generation values"), new Integer[0]);
        VisibilitySet perm = new VisibilitySet("Perm-Generation", "2-Generations", I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Perm Generation"), "tables/col_nr_of.gif", I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"Perm generation values"), new Integer[0]);
        TypedColumnSpec spec = new TypedColumnSpec("All-Generations|Bytes|Objects");
        spec.appendColumn(I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Class Type"), I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"The type of the class"), 16385, NormalClassType.class, "class_type", new VisibilitySet[0]);
        spec.appendColumn(I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Class Name"), I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"The class name"), 10, NormalClass.class, "class_name", new VisibilitySet[0]);
        spec.appendColumn(I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Bytes"), I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"Total bytes over all generations"), 45318, NrOfBytes.class, "total_bytes", bytes, all);
        spec.appendColumn(I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Objects"), I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"Total instances of that class"), 45062, NrOfObjects.class, "total_objects", objects, all);
        spec.appendColumn(I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Bytes In Young"), I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"The number of bytes allocated in young"), 45062, NrOfBytes.class, "total_bytes", bytes, young);
        spec.appendColumn(I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Objects In Young"), I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Number of objects in young generation"), 45062, NrOfObjects.class, "total_objects", objects, young);
        spec.appendColumn(I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Bytes In Old"), I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"The number of bytes allocated in old"), 45062, NrOfBytes.class, "total_bytes", bytes, old);
        spec.appendColumn(I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Objects In Old"), I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Number of objects in old generation"), 45062, NrOfObjects.class, "total_objects", objects, old);
        spec.appendColumn(I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Bytes In Perm"), I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"The number of bytes allocated in perm"), 45062, NrOfBytes.class, "total_bytes", bytes, perm);
        spec.appendColumn(I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Objects In Perm"), I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Number of objects in perm generation"), 45062, NrOfObjects.class, "total_objects", objects, perm);
        return spec;
    }

    public static TypedColumnSpec getClassStatisticDumpByClassLoaderSpec(ResourceName name) {
        VisibilitySet bytes = new VisibilitySet("Bytes", "1-BytesAndObjects", I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Bytes"), "tables/col_nr_of.gif", I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"Number of allocated bytes"), new Integer[0]);
        VisibilitySet objects = new VisibilitySet("Objects", "1-BytesAndObjects", I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Objects"), "tables/col_nr_of.gif", I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"Number of allocated objects"), new Integer[0]);
        VisibilitySet classes = new VisibilitySet("Classes", "2-Classes", I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Classes"), "tables/col_nr_of.gif", I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"Number of classes loaded by the class loader"), new Integer[0]);
        VisibilitySet all = new VisibilitySet("All-Generations", "3-Generations", I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"All Generations"), "tables/col_total_nr_of.gif", I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"Summarized values over all generations"), new Integer[0]);
        VisibilitySet young = new VisibilitySet("Young-Generation", "3-Generations", I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Young Generation"), "tables/col_nr_of.gif", I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"Young generation values"), new Integer[0]);
        VisibilitySet old = new VisibilitySet("Old-Generation", "3-Generations", I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Old Generation"), "tables/col_nr_of.gif", I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"Old generation values"), new Integer[0]);
        VisibilitySet perm = new VisibilitySet("Perm-Generation", "3-Generations", I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Perm Generation"), "tables/col_nr_of.gif", I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"Perm generation values"), new Integer[0]);
        TypedColumnSpec spec = new TypedColumnSpec("All-Generations|Bytes|Objects|Classes");
        spec.appendColumn(I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Class Loader"), I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"The class loader"), 9, NormalClassLoader.class, "class_loader", new VisibilitySet[0]);
        spec.appendColumn(I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Bytes"), I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"Total bytes over all generations"), 45318, NrOfBytes.class, "total_bytes", bytes, all);
        spec.appendColumn(I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Objects"), I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"Total instances of that class"), 45062, NrOfObjects.class, "total_objects", objects, all);
        spec.appendColumn(I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Classes"), I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"Classes loaded by the class loader"), 12294, NrOfObjects.class, "total_objects", classes, all);
        spec.appendColumn(I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Bytes In Young"), I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"The number of bytes allocated in young generation"), 45062, NrOfBytes.class, "total_bytes", bytes, young);
        spec.appendColumn(I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Objects In Young"), I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Number of objects in young generation"), 45062, NrOfObjects.class, "total_objects", objects, young);
        spec.appendColumn(I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Bytes In Old"), I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"The number of bytes allocated in old generation"), 45062, NrOfBytes.class, "total_bytes", bytes, old);
        spec.appendColumn(I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Objects In Old"), I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Number of objects in old generation"), 45062, NrOfObjects.class, "total_objects", objects, old);
        spec.appendColumn(I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Bytes In Perm"), I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"The number of bytes allocated in perm generation"), 45062, NrOfBytes.class, "total_bytes", bytes, perm);
        spec.appendColumn(I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Objects In Perm"), I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Number of objects in perm generation"), 45062, NrOfObjects.class, "total_objects", objects, perm);
        return spec;
    }

    public static TypedColumnSpec getClassStatisticDumpByClassLoaderInGenerationSpec(ResourceName name) {
        TypedColumnSpec spec = new TypedColumnSpec("Classes|Bytes|Objects");
        spec.appendColumn(I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Class Loader"), I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"The class loader"), 9, NormalClassLoader.class, "class_loader", new VisibilitySet[0]);
        spec.appendColumn(I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Bytes"), I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"Total bytes within that generation"), 45326, NrOfBytes.class, "total_bytes", new VisibilitySet("Bytes", "1-BytesAndObjects", I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Bytes"), "tables/col_nr_of.gif", I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"Number of allocated bytes"), new Integer[0]));
        spec.appendColumn(I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Objects"), I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"Total instances of that class"), 45062, NrOfObjects.class, "total_objects", new VisibilitySet("Objects", "1-BytesAndObjects", I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Objects"), "tables/col_nr_of.gif", I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"Number of allocated objects"), new Integer[0]));
        spec.appendColumn(I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Classes"), I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"Count of classes"), 12294, NrOfObjects.class, "total_objects", new VisibilitySet("Classes", "2-Classes", I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Classes"), "tables/col_nr_of.gif", I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"Number of classes loaded by the class loader"), new Integer[0]));
        return spec;
    }

    public static ProviderEntry getByGenerationEntryProvider(ClsClassLoaderStatistic statistic, int entryId, int column) {
        if (column == 0) {
            return new NormalClassLoader(((ClassLoaderValue)statistic.getValue(entryId)).getClassLoader());
        }
        if (column == 1) {
            return NrOfBytes.PROTOTYPE.create(((ClassLoaderValue)statistic.getValue(entryId)).getSizeOfObjects(), statistic.getNrOfBytesBelongingToSnapshot(), statistic.getNrOfBytesInView());
        }
        if (column == 2) {
            return NrOfObjects.PROTOTYPE.create(((ClassLoaderValue)statistic.getValue(entryId)).getNrOfObjetcs(), statistic.getNrOfObjectsBelongingToSnapshot(), statistic.getNrOfObjectsInView());
        }
        if (column == 3) {
            return NrOfObjects.PROTOTYPE.create(((ClassLoaderValue)statistic.getValue(entryId)).getClasses(), statistic.getNrOfClassesBelongingToSnapshot(), statistic.getNrOfClassesInView());
        }
        if (column == 5) {
            return NrOfObjects.PROTOTYPE.create(((ClassLoaderValue)statistic.getValue(entryId)).getNrOfObjetcs(ClassGeneration.YOUNG), statistic.getNrOfObjectsBelongingToSnapshot(), statistic.getNrOfObjectsInView());
        }
        if (column == 4) {
            return NrOfBytes.PROTOTYPE.create(((ClassLoaderValue)statistic.getValue(entryId)).getSizeOfObjects(ClassGeneration.YOUNG), statistic.getNrOfBytesBelongingToSnapshot(), statistic.getNrOfBytesInView());
        }
        if (column == 7) {
            return NrOfObjects.PROTOTYPE.create(((ClassLoaderValue)statistic.getValue(entryId)).getNrOfObjetcs(ClassGeneration.OLD), statistic.getNrOfObjectsBelongingToSnapshot(), statistic.getNrOfObjectsInView());
        }
        if (column == 6) {
            return NrOfBytes.PROTOTYPE.create(((ClassLoaderValue)statistic.getValue(entryId)).getSizeOfObjects(ClassGeneration.OLD), statistic.getNrOfBytesBelongingToSnapshot(), statistic.getNrOfBytesInView());
        }
        if (column == 9) {
            return NrOfObjects.PROTOTYPE.create(((ClassLoaderValue)statistic.getValue(entryId)).getNrOfObjetcs(ClassGeneration.PERM), statistic.getNrOfObjectsBelongingToSnapshot(), statistic.getNrOfObjectsInView());
        }
        if (column == 8) {
            return NrOfBytes.PROTOTYPE.create(((ClassLoaderValue)statistic.getValue(entryId)).getSizeOfObjects(ClassGeneration.PERM), statistic.getNrOfBytesBelongingToSnapshot(), statistic.getNrOfBytesInView());
        }
        return null;
    }

    public static ProviderEntry getClassLoaderEntryProvider(ClsClassLoaderStatistic statistic, int entryId, int column) {
        if (column == 0) {
            ClassLoaderObject obj = ((ClassLoaderValue)statistic.getValue(entryId)).getClassLoader();
            return new NormalClassLoader(obj);
        }
        if (column == 1) {
            return NrOfBytes.PROTOTYPE.create(((ClassLoaderValue)statistic.getValue(entryId)).getSizeOfObjects(), statistic.getNrOfBytesBelongingToSnapshot(), statistic.getNrOfBytesInView());
        }
        if (column == 2) {
            return NrOfObjects.PROTOTYPE.create(((ClassLoaderValue)statistic.getValue(entryId)).getNrOfObjetcs(), statistic.getNrOfObjectsBelongingToSnapshot(), statistic.getNrOfObjectsInView());
        }
        if (column == 3) {
            return NrOfObjects.PROTOTYPE.create(((ClassLoaderValue)statistic.getValue(entryId)).getClasses(), statistic.getNrOfClassesBelongingToSnapshot(), statistic.getNrOfClassesInView());
        }
        return null;
    }

    public static TypedColumnSpec getClassStatisticDumpInGenerationSpec(ResourceName name) {
        TypedColumnSpec spec = new TypedColumnSpec("Bytes|Objects");
        spec.appendColumn(I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Class Type"), I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"The type of the class"), 16385, NormalClassType.class, "class_type", new VisibilitySet[0]);
        spec.appendColumn(I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Class Name"), I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"The class name"), 10, NormalClass.class, "class_name", new VisibilitySet[0]);
        spec.appendColumn(I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Bytes"), I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"Total bytes within generations"), 45318, NrOfBytes.class, "total_bytes", new VisibilitySet("Bytes", "1-BytesAndObjects", I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Bytes"), "tables/col_nr_of.gif", I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"Number of allocated bytes"), new Integer[0]));
        spec.appendColumn(I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Objects"), I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"Total instances of that class"), 45062, NrOfObjects.class, "total_objects", new VisibilitySet("Objects", "1-BytesAndObjects", I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Objects"), "tables/col_nr_of.gif", I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"Number of allocated objects"), new Integer[0]));
        return spec;
    }

    public static ProviderEntry getEntryClassStatisticDumpSpec(ClsValueByGenerationStatistic statistic, int entryId, int column) {
        if (column == 0) {
            return new NormalClassType(((ClsValue)statistic.getValue(entryId)).getDelegate());
        }
        if (column == 1) {
            return new NormalClass(((ClsValue)statistic.getValue(entryId)).getDelegate());
        }
        if (column == 2) {
            return NrOfBytes.PROTOTYPE.create(((ClsValue)statistic.getValue(entryId)).getSizeOfObjects(), statistic.getNrOfBytesBelongingToSnapshot(), statistic.getNrOfBytesInView());
        }
        if (column == 3) {
            return NrOfObjects.PROTOTYPE.create(((ClsValue)statistic.getValue(entryId)).getNrOfObjetcs(), statistic.getNrOfObjectsBelongingToSnapshot(), statistic.getNrOfObjectsInView());
        }
        return null;
    }

    private static Column getColumn(ClsValuesColumn column, int columnIndex) {
        return null;
    }

    public static Column getColumn(ValueStatistic<?, ClsValue> statistic, int columnIndex) {
        return ProviderUtils.getColumn((ClsValuesColumn)statistic.getValueColumn(), columnIndex);
    }

    private static ProviderEntry getEntry(ClsValue value, int column, ClsValue total, ClsProvider provider) {
        return null;
    }

    public static ProviderEntry getEntry(int id, int column, ValueStatistic<?, ClsValue> statistic, ClsProvider provider) {
        return ProviderUtils.getEntry(statistic.getValue(id), column, statistic.getValue(), provider);
    }
}

