/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.presentation.impl.typed.compare;

import com.sap.jvm.profiling.i18n.I18n;
import com.sap.jvm.profiling.presentation.impl.typed.compare.CompareTableProviderData;
import com.sap.jvm.profiling.presentation.typed.TypedColumnSpec;
import com.sap.jvm.profiling.presentation.typed.TypedTableModel;
import com.sap.jvm.profiling.presentation.typed.TypedTableProvider;
import com.sap.jvm.profiling.presentation.typed.VisibilitySet;
import com.sap.jvm.profiling.presentation.typed.compare.CreateCompareTableProvider;
import com.sap.jvm.profiling.presentation.typed.compare.CreateCompareTableProviderData;
import com.sap.jvm.profiling.presentation.typed.entries.DiffEntryUtils;
import com.sap.jvm.profiling.presentation.typed.entries.Diffable;
import com.sap.jvm.profiling.presentation.typed.entries.Difference;
import com.sap.jvm.profiling.presentation.typed.entries.ProviderEntry;
import com.sap.jvm.profiling.resource.ProgressReporter;
import com.sap.jvm.profiling.resource.ResourceName;
import com.sap.jvm.profiling.resource.ResourceNameElement;
import com.sap.jvm.profiling.resource.ResourceReader;
import com.sap.jvm.profiling.resource.ResourceWriter;
import com.sap.jvm.profiling.snapshot.Snapshot;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;

public class CompareTableProvider
extends TypedTableProvider<CompareTableProviderData> {
    private CreateCompareTableProvider.SourceTableModelProvider srcProvider;
    private int[] srcColumnMapping;
    private int[] subColumnMapping;

    public CompareTableProvider(ResourceName name, ProgressReporter reporter) throws IOException {
        this(name, ((CreateCompareTableProvider)name.getLastElement()).getSourceTableModelProvider(), reporter);
    }

    private CompareTableProvider(ResourceName name, CreateCompareTableProvider.SourceTableModelProvider srcProvider, ProgressReporter reporter) throws IOException {
        this(name, CompareTableProvider.getModel(srcProvider.getTableModelNameA(), reporter), srcProvider);
    }

    public CompareTableProvider(ResourceName name, TypedTableModel model, CreateCompareTableProvider.SourceTableModelProvider srcProvider) {
        super(name, I18n._ts((I18n.TextType)I18n.TextType.XTBS, (String)"Comparison"), "profiling/compare_tiny.png", CompareTableProvider.getDiffColumnSpec(model.getSpec()));
        this.srcProvider = srcProvider;
        this.createColumnIndizes(model.getSpec());
    }

    public CompareTableProvider(ResourceReader reader, ResourceName name, ProgressReporter reporter) throws IOException {
        this(name, reporter);
    }

    protected void write(ResourceWriter writer, ProgressReporter reporter) throws IOException {
    }

    private static TypedTableModel getModel(ResourceName modelName, ProgressReporter reporter) throws IOException {
        if (modelName == null) {
            throw new IOException("Resource name of table model is null!");
        }
        TypedTableModel result = (TypedTableModel)modelName.getResourceManager().get(modelName, reporter);
        return result;
    }

    private static TypedColumnSpec getDiffColumnSpec(TypedColumnSpec baseSpec) {
        int[] columnsToSearch;
        int nrOfCols = baseSpec.getNrOfColumns();
        ArrayList<Integer> sourceColMapping = new ArrayList<Integer>();
        ArrayList<Integer> subColMapping = new ArrayList<Integer>();
        ArrayList<Boolean> isStandardColMapping = new ArrayList<Boolean>();
        ArrayList<Integer> destColMapping = new ArrayList<Integer>();
        for (int col = 0; col < nrOfCols; ++col) {
            destColMapping.add(sourceColMapping.size());
            Class<?> colType = baseSpec.getColumnType(col);
            if (Diffable.class.isAssignableFrom(colType)) {
                Class<? extends ProviderEntry>[] subTypes = DiffEntryUtils.getSubColumnTypes(colType);
                int nrOfStandardCols = DiffEntryUtils.getNrOfStandardSubColumns(colType);
                for (int i = 0; i < subTypes.length; ++i) {
                    sourceColMapping.add(col);
                    subColMapping.add(i + 1);
                    isStandardColMapping.add(i < nrOfStandardCols);
                }
                continue;
            }
            sourceColMapping.add(col);
            subColMapping.add(0);
            isStandardColMapping.add(Boolean.TRUE);
        }
        int nrOfDestinationCols = sourceColMapping.size();
        String[] columnTexts = new String[nrOfDestinationCols];
        String[] columnToolTips = new String[nrOfDestinationCols];
        int[] defaultSortDirection = new int[nrOfDestinationCols];
        Class[] columnTypes = new Class[nrOfDestinationCols];
        String[] columnTags = new String[nrOfDestinationCols];
        boolean[] noPercentageBars = new boolean[nrOfDestinationCols];
        for (int destCol = 0; destCol < nrOfDestinationCols; ++destCol) {
            int sourceCol = (Integer)sourceColMapping.get(destCol);
            int subCol = (Integer)subColMapping.get(destCol);
            columnTexts[destCol] = baseSpec.getColumnText(sourceCol);
            columnToolTips[destCol] = baseSpec.getColumnToolTip(sourceCol);
            defaultSortDirection[destCol] = baseSpec.getDefaultSortDirection(sourceCol);
            noPercentageBars[destCol] = baseSpec.getNoPercentageBarsFlag(sourceCol);
            Class<?> baseType = baseSpec.getColumnType(sourceCol);
            String baseTag = baseSpec.getColumnTag(sourceCol);
            Class<? extends ProviderEntry> diffType = DiffEntryUtils.getDifferenceType(baseType);
            if (subCol == 0) {
                columnTypes[destCol] = diffType;
                columnTags[destCol] = baseTag + "_diff";
                continue;
            }
            Class<? extends ProviderEntry>[] subTypes = DiffEntryUtils.getSubColumnTypes(baseType);
            columnTypes[destCol] = subTypes[subCol - 1];
            String subTitle = DiffEntryUtils.getSubColumnTitles(baseType)[subCol - 1];
            int n = destCol;
            columnTexts[n] = columnTexts[n] + " (" + subTitle + ")";
            int n2 = destCol;
            columnToolTips[n2] = columnToolTips[n2] + " (" + subTitle + ")";
            columnTags[destCol] = baseTag + "_" + subTitle;
        }
        int[] compareColumns = null;
        int nrOfDefaultSorts = baseSpec.getNrOfDefaultSorts();
        int[] defaultSortOrder = new int[nrOfDefaultSorts];
        for (int i = 0; i < nrOfDefaultSorts; ++i) {
            int destSortCol;
            defaultSortOrder[i] = destSortCol = ((Integer)destColMapping.get(baseSpec.getDefaultSortColumn(i))).intValue();
        }
        int[] searchColumns = baseSpec.getSearchColumns();
        if (searchColumns == null) {
            columnsToSearch = new int[]{};
        } else {
            columnsToSearch = new int[searchColumns.length];
            for (int i = 0; i < columnsToSearch.length; ++i) {
                columnsToSearch[i] = (Integer)destColMapping.get(searchColumns[i]);
            }
        }
        int[] baseColumnsToSum = baseSpec.getColumnsToSum();
        int[] columnsToSum = new int[baseColumnsToSum.length];
        for (int i = 0; i < columnsToSum.length; ++i) {
            columnsToSum[i] = (Integer)destColMapping.get(baseColumnsToSum[i]);
        }
        String defaultVisibleSets = baseSpec.getDefaultVisibleSets();
        VisibilitySet[] srcVisibilitySets = baseSpec.getColumnVisibilitySets();
        ArrayList<VisibilitySet> destVisibilitySets = new ArrayList<VisibilitySet>();
        HashSet<Integer> alreadyProcessedSubCols = new HashSet<Integer>();
        for (VisibilitySet srcSet : srcVisibilitySets) {
            int[] srcColumnIDs = srcSet.getColumns();
            ArrayList<Integer> standardColumns = new ArrayList<Integer>();
            ArrayList<Integer> moreColumns = new ArrayList<Integer>();
            for (int srcColId : srcColumnIDs) {
                int firstDestColId = (Integer)destColMapping.get(srcColId);
                standardColumns.add(firstDestColId);
                if ((Integer)subColMapping.get(firstDestColId) != 1) continue;
                boolean alreadyProcessed = alreadyProcessedSubCols.contains(firstDestColId);
                alreadyProcessedSubCols.add(firstDestColId);
                for (int destCol = firstDestColId + 1; destCol < subColMapping.size() && (Integer)subColMapping.get(destCol) > 1; ++destCol) {
                    if (alreadyProcessed || ((Boolean)isStandardColMapping.get(destCol)).booleanValue()) {
                        standardColumns.add(destCol);
                        continue;
                    }
                    moreColumns.add(destCol);
                }
            }
            VisibilitySet mappedStandardColumns = new VisibilitySet(srcSet.getId(), srcSet.getGroupId(), srcSet.getDisplayName(), srcSet.getIconName(), srcSet.getToolTip(), standardColumns.toArray(new Integer[standardColumns.size()]));
            destVisibilitySets.add(mappedStandardColumns);
            if (moreColumns.size() <= 0) continue;
            VisibilitySet mappedMoreColumns = new VisibilitySet(srcSet.getId() + "_more", srcSet.getGroupId(), I18n._tss((I18n.TextType)I18n.TextType.XLNK, (String)"Label|Link|more information about", (String)"{0} (more details)", (Object[])new Object[]{srcSet.getDisplayName()}), srcSet.getIconName(), I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"More detailed information about the difference.\nIn most cases this shows the old and the new value."), moreColumns.toArray(new Integer[moreColumns.size()]));
            destVisibilitySets.add(mappedMoreColumns);
        }
        TypedColumnSpec result = new TypedColumnSpec(columnTexts, columnToolTips, defaultSortDirection, defaultSortOrder, columnTypes, columnTags, columnsToSum, columnsToSearch, compareColumns, noPercentageBars, destVisibilitySets.toArray(new VisibilitySet[destVisibilitySets.size()]), defaultVisibleSets);
        return result;
    }

    private void createColumnIndizes(TypedColumnSpec baseSpec) {
        int nrOfCols = baseSpec.getNrOfColumns();
        ArrayList<Integer> srcColMappingLst = new ArrayList<Integer>();
        ArrayList<Integer> subColMappingLst = new ArrayList<Integer>();
        for (int col = 0; col < nrOfCols; ++col) {
            Class<?> colType = baseSpec.getColumnType(col);
            if (Diffable.class.isAssignableFrom(colType)) {
                Class<? extends ProviderEntry>[] subTypes = DiffEntryUtils.getSubColumnTypes(colType);
                for (int i = 0; i < subTypes.length; ++i) {
                    srcColMappingLst.add(col);
                    subColMappingLst.add(i + 1);
                }
                continue;
            }
            srcColMappingLst.add(col);
            subColMappingLst.add(0);
        }
        int nrOfDestCols = srcColMappingLst.size();
        this.srcColumnMapping = new int[nrOfDestCols];
        this.subColumnMapping = new int[nrOfDestCols];
        for (int col = 0; col < nrOfDestCols; ++col) {
            this.srcColumnMapping[col] = (Integer)srcColMappingLst.get(col);
            this.subColumnMapping[col] = (Integer)subColMappingLst.get(col);
        }
    }

    @Override
    public ProviderEntry getEntry(int entryId, int column) {
        int sourceCol = this.srcColumnMapping[column];
        int subCol = this.subColumnMapping[column];
        if (subCol == 0) {
            return ((CompareTableProviderData)((Object)this.statistic)).getData()[entryId][sourceCol];
        }
        Difference diffEntry = (Difference)((CompareTableProviderData)((Object)this.statistic)).getData()[entryId][sourceCol];
        return diffEntry.getSubColumnEntry(subCol - 1);
    }

    @Override
    public int getNrOfRows() {
        if (this.statistic == null) {
            return 0;
        }
        return ((CompareTableProviderData)((Object)this.statistic)).getData().length;
    }

    @Override
    public Snapshot getSnapshot() {
        return null;
    }

    @Override
    protected ResourceName getStatisticName() {
        return this.getResourceName().stripLastElement().addElement((ResourceNameElement)new CreateCompareTableProviderData(this.srcProvider));
    }
}

