/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.presentation.impl.typed.compare;

import com.sap.jvm.profiling.i18n.I18n;
import com.sap.jvm.profiling.presentation.typed.EntryContext;
import com.sap.jvm.profiling.presentation.typed.ProviderResource;
import com.sap.jvm.profiling.presentation.typed.TypedColumnSpec;
import com.sap.jvm.profiling.presentation.typed.TypedTableModel;
import com.sap.jvm.profiling.presentation.typed.compare.CreateCompareTableProvider;
import com.sap.jvm.profiling.presentation.typed.compare.CreateCompareTableProviderData;
import com.sap.jvm.profiling.presentation.typed.entries.DiffEntryUtils;
import com.sap.jvm.profiling.presentation.typed.entries.Diffable;
import com.sap.jvm.profiling.presentation.typed.entries.ModifiableKeyEntry;
import com.sap.jvm.profiling.presentation.typed.entries.PersistableProviderEntry;
import com.sap.jvm.profiling.presentation.typed.entries.ProviderEntry;
import com.sap.jvm.profiling.presentation.typed.entries.UniqueEntry;
import com.sap.jvm.profiling.resource.OperationCanceledException;
import com.sap.jvm.profiling.resource.ProgressReporter;
import com.sap.jvm.profiling.resource.ResourceName;
import com.sap.jvm.profiling.resource.ResourceReader;
import com.sap.jvm.profiling.resource.ResourceWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;

public class CompareTableProviderData
extends ProviderResource {
    CreateCompareTableProvider.SourceTableModelProvider srcProvider;
    private static final int VERSION = 0;
    private PersistableProviderEntry[][] providerData;
    private Object tableCreationLock = new Object();
    private boolean tableCreationInProgress = false;

    public CompareTableProviderData(ResourceName name, ProgressReporter reporter) throws IOException {
        super(name);
        CreateCompareTableProviderData createElement = (CreateCompareTableProviderData)name.getLastElement();
        this.srcProvider = createElement.getSourceTableModelProvider();
        this.createTable(reporter);
    }

    public CompareTableProviderData(ResourceReader reader, ResourceName name, ProgressReporter reporter) throws IOException {
        super(name);
        CreateCompareTableProviderData createElement = (CreateCompareTableProviderData)name.getLastElement();
        this.srcProvider = createElement.getSourceTableModelProvider();
        TypedTableModel tableModelA = CompareTableProviderData.getModel(this.srcProvider.getTableModelNameA(), reporter);
        assert (tableModelA != null);
        TypedColumnSpec spec = tableModelA.getSpec();
        reader.readVersion(0, 0);
        int nrRows = reader.readInt32();
        int nrCols = reader.readInt32();
        PersistableProviderEntry[][] data = new PersistableProviderEntry[nrRows][nrCols];
        reporter.addWork(I18n._s((String)"Reading table content... (<%> %)"), (long)nrRows);
        for (int rowId = 0; rowId < nrRows; ++rowId) {
            reporter.reportNextOrThrow();
            for (int colId = 0; colId < nrCols; ++colId) {
                Class<?> type = spec.getColumnType(colId);
                data[rowId][colId] = DiffEntryUtils.read(type, reader);
            }
        }
        this.providerData = data;
    }

    public ProviderEntry[][] getData() {
        return this.providerData;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createTable(ProgressReporter reporter) throws IOException {
        reporter.setMessage(I18n._s((String)"Getting source table data..."));
        Object object = this.tableCreationLock;
        synchronized (object) {
            while (this.tableCreationInProgress) {
                try {
                    if (!reporter.report(1L, 5L)) {
                        return;
                    }
                    this.tableCreationLock.wait(500L);
                }
                catch (InterruptedException e) {
                    return;
                }
            }
            if (this.providerData != null) {
                reporter.report(5L, 5L);
                return;
            }
            this.tableCreationInProgress = true;
            reporter.report(2L, 5L);
        }
        TypedTableModel tableModelA = CompareTableProviderData.getModel(this.srcProvider.getTableModelNameA(), reporter);
        assert (tableModelA != null);
        TypedTableModel tableModelB = CompareTableProviderData.getModel(this.srcProvider.getTableModelNameB(), reporter);
        assert (tableModelB != null);
        reporter.report(3L, 5L);
        tableModelA.ensureItemsCreated(reporter);
        reporter.report(4L, 5L);
        tableModelB.ensureItemsCreated(reporter);
        reporter.report(5L, 5L);
        int nrCols = tableModelA.getNrOfColumns();
        int nrRowsA = tableModelA.getNrOfItems();
        int nrRowsB = tableModelB.getNrOfItems();
        boolean doAccumulate = true;
        for (int col = 0; doAccumulate && col < nrCols; ++col) {
            if (!Diffable.class.isAssignableFrom(tableModelA.getSpec().getColumnType(col))) continue;
            doAccumulate = tableModelA.getSpec().shouldSumColumn(col);
        }
        HashSet<KeyTuple> keyEntriesUnion = new HashSet<KeyTuple>();
        reporter.setWork(I18n._s((String)"Comparing tables... (<%> %)"), (long)(nrRowsA + nrRowsB));
        HashMap<KeyTuple, ArrayList<Integer>> rowsInA = this.getKeyToRowMapping(tableModelA, doAccumulate, DiffEntryUtils.NEW_VIEW_MARK_LABEL, reporter);
        HashMap<KeyTuple, ArrayList<Integer>> rowsInB = this.getKeyToRowMapping(tableModelB, doAccumulate, DiffEntryUtils.OLD_VIEW_MARK_LABEL, reporter);
        if (reporter.isCancelled()) {
            if (rowsInA != null) {
                rowsInA.clear();
            }
            if (rowsInB != null) {
                rowsInB.clear();
            }
            Object object2 = this.tableCreationLock;
            synchronized (object2) {
                this.tableCreationInProgress = false;
                this.tableCreationLock.notifyAll();
            }
            return;
        }
        keyEntriesUnion.addAll(rowsInA.keySet());
        keyEntriesUnion.addAll(rowsInB.keySet());
        int nrRows = keyEntriesUnion.size();
        reporter.setWork(I18n._s((String)"Generating table content... (<%> %)"), (long)nrRows);
        this.providerData = new PersistableProviderEntry[nrRows][nrCols];
        int rowId = 0;
        for (KeyTuple keyEntry : keyEntriesUnion) {
            ArrayList<Integer> rowsA = rowsInA.get(keyEntry);
            ArrayList<Integer> rowsB = rowsInB.get(keyEntry);
            ProviderEntry[] accumulatedRowA = this.accumulateRows(rowsA, tableModelA, keyEntry);
            ProviderEntry[] accumulatedRowB = this.accumulateRows(rowsB, tableModelB, keyEntry);
            this.computeDifference(accumulatedRowA, accumulatedRowB, rowId);
            ++rowId;
            if (reporter.reportNext()) continue;
            this.providerData = null;
            Object object3 = this.tableCreationLock;
            synchronized (object3) {
                this.tableCreationInProgress = false;
                this.tableCreationLock.notifyAll();
            }
            throw new OperationCanceledException();
        }
        tableModelB = null;
        Object object4 = this.tableCreationLock;
        synchronized (object4) {
            this.tableCreationInProgress = false;
            this.tableCreationLock.notifyAll();
        }
    }

    private HashMap<KeyTuple, ArrayList<Integer>> getKeyToRowMapping(TypedTableModel tableModel, boolean accumulate, String label, ProgressReporter reporter) {
        int nrRows = tableModel.getNrOfItems();
        int[] keyColumns = tableModel.getSpec().getCompareKeyColumns();
        HashMap<KeyTuple, ArrayList<Integer>> mapping = new HashMap<KeyTuple, ArrayList<Integer>>();
        HashMap<KeyTuple, Integer> nrRowsPerKey = new HashMap<KeyTuple, Integer>();
        for (int rowId = 0; rowId < nrRows; ++rowId) {
            int currentRow = tableModel.getItemId(rowId);
            KeyTuple keyTuple = new KeyTuple(tableModel, currentRow, keyColumns);
            if (nrRowsPerKey.get(keyTuple) == null) {
                assert (mapping.get(keyTuple) == null);
                ArrayList<Integer> rowsWithThisKey = new ArrayList<Integer>();
                rowsWithThisKey.add(currentRow);
                mapping.put(keyTuple, rowsWithThisKey);
                nrRowsPerKey.put(keyTuple, 1);
            } else {
                int duplicates = (Integer)nrRowsPerKey.get(keyTuple) + 1;
                nrRowsPerKey.put(keyTuple, duplicates);
                if (accumulate) {
                    mapping.get(keyTuple).add(currentRow);
                } else {
                    KeyTuple newKey;
                    String suffix;
                    if (duplicates == 2) {
                        suffix = "#1_" + label;
                        newKey = keyTuple.getModifiedVariant(suffix);
                        mapping.put(newKey, mapping.remove(keyTuple));
                    }
                    suffix = "#" + duplicates + "_" + label;
                    newKey = keyTuple.getModifiedVariant(suffix);
                    assert (mapping.get(newKey) == null);
                    ArrayList<Integer> newRowList = new ArrayList<Integer>();
                    newRowList.add(currentRow);
                    mapping.put(newKey, newRowList);
                }
            }
            if (reporter.reportNext()) continue;
            mapping.clear();
            return null;
        }
        return mapping;
    }

    protected void write(ResourceWriter writer, ProgressReporter reporter) throws IOException {
        assert (this.providerData != null);
        writer.writeVersion(0);
        int nrRows = this.providerData.length;
        int nrCols = nrRows == 0 ? 0 : this.providerData[0].length;
        writer.writeInt32(nrRows);
        writer.writeInt32(nrCols);
        reporter.addWork(I18n._s((String)"Writing table content..."), (long)nrRows);
        for (int rowId = 0; rowId < nrRows; ++rowId) {
            reporter.reportNextOrThrow();
            for (int colId = 0; colId < nrCols; ++colId) {
                assert (this.providerData[rowId][colId] != null);
                this.providerData[rowId][colId].write(writer);
            }
        }
    }

    private ProviderEntry[] accumulateRows(ArrayList<Integer> tableRows, TypedTableModel tableModel, KeyTuple keyTuple) {
        int nrCols = tableModel.getNrOfColumns();
        int[] keyCols = tableModel.getSpec().getCompareKeyColumns();
        ProviderEntry[] accumulatedRow = new ProviderEntry[nrCols];
        if (tableRows != null) {
            int currentRow = tableRows.get(0);
            block0: for (int col = 0; col < nrCols; ++col) {
                for (int keyIdx = 0; keyIdx < keyCols.length; ++keyIdx) {
                    if (col != keyCols[keyIdx]) continue;
                    accumulatedRow[col] = keyTuple.getEntry(keyIdx);
                    continue block0;
                }
                ProviderEntry currentEntry = tableModel.getEntryForItem(currentRow, col);
                if (currentEntry instanceof Diffable) {
                    if (tableRows.size() == 1) {
                        accumulatedRow[col] = currentEntry;
                        continue;
                    }
                    ProviderEntry[] entries = new ProviderEntry[tableRows.size()];
                    for (int row = 0; row < tableRows.size(); ++row) {
                        entries[row] = tableModel.getEntryForItem(tableRows.get(row), col);
                    }
                    accumulatedRow[col] = ((Diffable)((Object)currentEntry)).getAccumulation(entries);
                    continue;
                }
                accumulatedRow[col] = CompareTableProviderData.getPersistable(currentEntry);
            }
        }
        return accumulatedRow;
    }

    private void computeDifference(ProviderEntry[] entryRowA, ProviderEntry[] entryRowB, int rowId) {
        int nrCols = entryRowA.length;
        for (int col = 0; col < nrCols; ++col) {
            ProviderEntry anyEntry;
            ProviderEntry entryA = entryRowA[col];
            ProviderEntry entryB = entryRowB[col];
            ProviderEntry providerEntry = anyEntry = entryA != null ? entryA : entryB;
            assert (anyEntry != null);
            if (!(anyEntry instanceof Diffable)) {
                assert (anyEntry instanceof PersistableProviderEntry);
                this.providerData[rowId][col] = (PersistableProviderEntry)anyEntry;
                continue;
            }
            this.providerData[rowId][col] = ((Diffable)((Object)anyEntry)).getDifference(entryA, entryB);
        }
    }

    private static PersistableProviderEntry getPersistable(ProviderEntry entry) {
        if (entry instanceof PersistableProviderEntry) {
            return (PersistableProviderEntry)entry;
        }
        if (entry instanceof UniqueEntry) {
            return ((UniqueEntry)entry).getPersistable();
        }
        throw new IllegalArgumentException("Can't get persistable entry for type " + entry.getClass());
    }

    private static TypedTableModel getModel(ResourceName modelName, ProgressReporter reporter) throws IOException {
        if (modelName == null) {
            return null;
        }
        TypedTableModel result = (TypedTableModel)modelName.getResourceManager().get(modelName, reporter);
        return result;
    }

    @Override
    public EntryContext getEntryContext() {
        throw new UnsupportedOperationException();
    }

    public ResourceName[] getDependents() {
        return null;
    }

    private static class KeyTuple {
        private final PersistableProviderEntry[] keyEntries;
        private int variantIdx = -1;
        private String variantSuffix;

        public KeyTuple(TypedTableModel model, int row, int[] keyColumns) {
            this.variantSuffix = null;
            this.keyEntries = new PersistableProviderEntry[keyColumns.length];
            for (int i = 0; i < keyColumns.length; ++i) {
                this.keyEntries[i] = CompareTableProviderData.getPersistable(model.getEntryForItem(row, keyColumns[i]));
                if (!(this.keyEntries[i] instanceof ModifiableKeyEntry) || this.variantIdx != -1) continue;
                this.variantIdx = i;
            }
        }

        private KeyTuple(PersistableProviderEntry[] keyEntries2copy, int variantIdx2copy) {
            this.keyEntries = new PersistableProviderEntry[keyEntries2copy.length];
            System.arraycopy(keyEntries2copy, 0, this.keyEntries, 0, this.keyEntries.length);
            this.variantIdx = variantIdx2copy;
        }

        public PersistableProviderEntry getEntry(int tupleIndex) {
            return this.keyEntries[tupleIndex];
        }

        public KeyTuple getModifiedVariant(String label) {
            KeyTuple result = new KeyTuple(this.keyEntries, this.variantIdx);
            if (this.variantIdx != -1) {
                result.keyEntries[this.variantIdx] = ((ModifiableKeyEntry)this.keyEntries[this.variantIdx]).getModifiedEntry(label);
            } else {
                result.variantSuffix = label;
            }
            return result;
        }

        public int hashCode() {
            int hc = 17;
            int hashMultiplier = 59;
            hc = hc * hashMultiplier + this.keyEntries.length;
            for (int i = 0; i < this.keyEntries.length; ++i) {
                hc = hc * hashMultiplier + this.keyEntries[i].hashCode();
            }
            hc = hc * hashMultiplier + this.variantIdx;
            if (this.variantSuffix != null) {
                hc = hc * hashMultiplier + this.variantSuffix.hashCode();
            }
            return hc;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj instanceof KeyTuple) {
                KeyTuple other = (KeyTuple)obj;
                if (this.keyEntries.length != other.keyEntries.length) {
                    return false;
                }
                if (this.variantIdx != other.variantIdx) {
                    return false;
                }
                if (this.variantSuffix == null ? other.variantSuffix != null : !this.variantSuffix.equals(other.variantSuffix)) {
                    return false;
                }
                for (int i = 0; i < this.keyEntries.length; ++i) {
                    if (this.keyEntries[i].equals(other.keyEntries[i])) continue;
                    return false;
                }
                return true;
            }
            return false;
        }
    }
}

