/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.presentation.impl.typed.gc;

import com.sap.jvm.profiling.i18n.I18n;
import com.sap.jvm.profiling.presentation.impl.typed.gc.GcEventTableProvider;
import com.sap.jvm.profiling.presentation.impl.typed.gc.ProviderUtils;
import com.sap.jvm.profiling.presentation.typed.entries.NormalGcEventId;
import com.sap.jvm.profiling.presentation.typed.entries.ProviderEntry;
import com.sap.jvm.profiling.resource.ResourceName;
import com.sap.jvm.profiling.resource.ResourceNameElement;
import com.sap.jvm.profiling.snapshot.elements.FilterByGcEventType;
import com.sap.jvm.profiling.snapshot.gc.Elements;
import com.sap.jvm.profiling.snapshot.gc.GcEventId;
import com.sap.jvm.profiling.snapshot.gc.GcEventStatisticValueElement;
import com.sap.jvm.profiling.snapshot.gc.GcEventStatisticValuesColumn;
import com.sap.jvm.profiling.snapshot.gc.GcEventValueStatistic;
import com.sap.jvm.profiling.snapshot.gc.GcEventValueStatisticUtil;
import com.sap.jvm.profiling.snapshot.gc.GcStatisticValueElement;
import com.sap.jvm.profiling.snapshot.util.column.Column;
import java.util.List;

public final class GcEventValueStatisticProvider
extends GcEventTableProvider<GcEventValueStatistic> {
    private final List<GcEventStatisticValueElement> valueElements;

    public GcEventValueStatisticProvider(ResourceName name) {
        this(name, GcEventValueStatisticUtil.getValueElements(name), GcEventValueStatisticUtil.getDefaultVisibleColumnTags(name));
    }

    public GcEventValueStatisticProvider(ResourceName name, List<GcEventStatisticValueElement> valueElements, List<String> defaultColumns) {
        super(name, GcEventValueStatisticProvider.getTypeName(name), "profiling/gc_event_statistic.png", ProviderUtils.getGcEventValueSpec(name, valueElements, defaultColumns).prepend(I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"GC Event"), I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"The GC event"), 269, NormalGcEventId.class, "gc_event"));
        this.valueElements = valueElements;
    }

    @Override
    public ProviderEntry getEntry(int entryId, int column) {
        if (column == 0) {
            return new NormalGcEventId((GcEventId)((GcEventValueStatistic)this.statistic).getKey(entryId));
        }
        int elementId = column - 1;
        GcStatisticValueElement[] statisticElements = GcStatisticValueElement.values();
        if (elementId < statisticElements.length) {
            return ProviderUtils.getEntry(entryId, statisticElements[elementId], (GcEventValueStatistic)this.statistic, this);
        }
        return ProviderUtils.getEntry(entryId, this.valueElements.get(elementId -= statisticElements.length), (GcEventValueStatistic)this.statistic, this);
    }

    @Override
    public Column getColumn(int columnIndex) {
        if (columnIndex == 0) {
            return ((GcEventValueStatistic)this.statistic).getKeyColumn();
        }
        GcEventStatisticValuesColumn valueColumn = (GcEventStatisticValuesColumn)((GcEventValueStatistic)this.statistic).getValueColumn();
        int elementId = columnIndex - 1;
        GcStatisticValueElement[] statisticElements = GcStatisticValueElement.values();
        if (elementId < statisticElements.length) {
            return valueColumn.getStatisticValuesColumn().getColumn(elementId);
        }
        return valueColumn.getColumn(elementId -= statisticElements.length);
    }

    @Override
    protected ResourceName getStatisticName() {
        return this.getResourceName().stripLastElement().addElement((ResourceNameElement)new Elements.CreateGcEventValueStatistic());
    }

    private static String getTypeName(ResourceName name) {
        FilterByGcEventType filterElement = null;
        ResourceNameElement[] elements = name.getElements();
        for (int i = elements.length - 1; i > 0; --i) {
            if (!(elements[i] instanceof FilterByGcEventType)) continue;
            filterElement = (FilterByGcEventType)elements[i];
            break;
        }
        if (filterElement != null) {
            return filterElement.getName();
        }
        return I18n._ts((I18n.TextType)I18n.TextType.XTBS, (String)"GC Events");
    }
}

