/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.presentation.impl.typed.gc;

import com.sap.jvm.profiling.i18n.I18n;
import com.sap.jvm.profiling.icons.ImageRepository;
import com.sap.jvm.profiling.presentation.description.DescriptionViewer;
import com.sap.jvm.profiling.presentation.description.renderer.Margin;
import com.sap.jvm.profiling.presentation.description.renderer.MarginNode;
import com.sap.jvm.profiling.presentation.description.renderer.ParagraphNode;
import com.sap.jvm.profiling.presentation.description.renderer.RendererStyle;
import com.sap.jvm.profiling.presentation.description.renderer.StyleNode;
import com.sap.jvm.profiling.presentation.description.renderer.TableStyle;
import com.sap.jvm.profiling.presentation.impl.typed.gc.GcProvider;
import com.sap.jvm.profiling.presentation.impl.typed.html.renderer.HTMLBarChartNode;
import com.sap.jvm.profiling.presentation.impl.typed.html.renderer.HTMLPieChartNode;
import com.sap.jvm.profiling.presentation.typed.TypedReportProvider;
import com.sap.jvm.profiling.presentation.typed.gc.Elements;
import com.sap.jvm.profiling.resource.ProgressReporter;
import com.sap.jvm.profiling.resource.ResourceName;
import com.sap.jvm.profiling.resource.ResourceNameElement;
import com.sap.jvm.profiling.snapshot.SnapshotResourceManagerFactory;
import com.sap.jvm.profiling.snapshot.gc.Elements;
import com.sap.jvm.profiling.snapshot.gc.GcReportCollection;
import com.sap.jvm.profiling.snapshot.gc.GcReportNode;
import com.sap.jvm.profiling.snapshot.gc.GcSnapshot;
import com.sap.jvm.profiling.ui.graph.SingleBarValueChart;
import com.sap.jvm.profiling.ui.graph.dataset.AccSingleBarDataSet;
import com.sap.jvm.profiling.ui.graph.dataset.PieGraphDataSet;
import com.sap.jvm.profiling.ui.graph.renderer.Color;
import com.sap.jvm.profiling.viewer.renderer.BarChartNode;
import com.sap.jvm.profiling.viewer.renderer.ChartNodeInitializer;
import com.sap.jvm.profiling.viewer.renderer.PercentageBarNode;
import com.sap.jvm.profiling.viewer.renderer.PieChartNode;
import com.sap.jvm.profiling.viewer.renderer.RendererNode;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;

public final class GcReportProvider
extends TypedReportProvider
implements GcProvider {
    public static final int DESIRED_REPORT_WIDTH = 800;
    public static final int SECTION_MARGIN = 20;
    private final GcSnapshot snapshot;
    private boolean firstSection;
    private int currentMargin;
    private HashMap<String, RendererNode> imageNodeCache = new HashMap();

    public GcReportProvider(ResourceName name) {
        super(name, GcReportProvider.getTitle(name), "views/report_view.gif");
        this.snapshot = (GcSnapshot)SnapshotResourceManagerFactory.get(name.getSession()).getSnapshot(name);
    }

    private static String getTitle(ResourceName name) {
        ResourceNameElement createElement = name.getLastElement();
        if (createElement instanceof Elements.CreateGcConfigurationReportProvider) {
            return I18n._ts((I18n.TextType)I18n.TextType.XTBS, (String)"GC Configuration");
        }
        return I18n._ts((I18n.TextType)I18n.TextType.XTBS, (String)"GC Report");
    }

    @Override
    public RendererNode getReport(DescriptionViewer viewer, ProgressReporter reporter) throws IOException {
        ResourceNameElement createElement = this.getResourceName().getLastElement();
        boolean justConfiguration = createElement instanceof Elements.CreateGcConfigurationReportProvider;
        ResourceName baseName = this.getResourceName().stripLastElement();
        ResourceName collectionName = baseName.addElement((ResourceNameElement)(justConfiguration ? new Elements.CreateConfigurationReportCollection() : new Elements.CreateReportCollection()));
        GcReportCollection collection = (GcReportCollection)collectionName.getResourceManager().get(collectionName, reporter);
        return this.getRendererNode(viewer, collection.getReportRoot());
    }

    private RendererNode getRendererNode(DescriptionViewer viewer, GcReportNode node) {
        this.firstSection = true;
        this.currentMargin = 0;
        this.imageNodeCache.clear();
        RendererNode result = this.getRendererNodeImpl(viewer, node);
        this.imageNodeCache.clear();
        return result;
    }

    private RendererNode getRendererNodeImpl(DescriptionViewer viewer, GcReportNode node) {
        if (node instanceof GcReportNode.Section) {
            return this.getSectionNode(viewer, (GcReportNode.Section)node);
        }
        if (node instanceof GcReportNode.FormattedText) {
            GcReportNode.FormattedText text = (GcReportNode.FormattedText)node;
            RendererNode result = this.replace(viewer, text.getText(), new RendererNode[0]);
            if (text.isBold()) {
                result = viewer.newChangeBoldNode(true, result);
            }
            if (text.isItalic()) {
                result = viewer.newChangeItalicsNode(true, result);
            }
            if (text.getFontSizeIncrease() != 0) {
                result = viewer.newFontSizeChangeNode(text.getFontSizeIncrease(), result);
            }
            if (text.getRgb() >= 0) {
                result = viewer.newColorNode(text.getRgb(), -1, -1, -1, -1, -1, -1, result);
            }
            return result;
        }
        if (node instanceof GcReportNode.Text) {
            return this.replace(viewer, ((GcReportNode.Text)node).getText(), new RendererNode[0]);
        }
        if (node instanceof GcReportNode.Icon) {
            return this.getIconNode(viewer, (GcReportNode.Icon)node);
        }
        if (node instanceof GcReportNode.PercentageBar) {
            return this.getPercentageBar(viewer, (GcReportNode.PercentageBar)node);
        }
        if (node instanceof GcReportNode.Paragraph) {
            return this.getParagraphNode(viewer, (GcReportNode.MultiChildNode)node);
        }
        if (node instanceof GcReportNode.Note) {
            this.currentMargin += 20;
            RendererNode content = this.getParagraphNode(viewer, (GcReportNode.MultiChildNode)node);
            String title = ((GcReportNode.Note)node).getTitle();
            RendererNode note = viewer.newStyleNode(content, RendererStyle.NOTE);
            if (title != null && title.length() > 0) {
                ParagraphNode<?> titleNode = viewer.newParagraphNode(viewer.newChangeBoldNode(true, viewer.newTextNode(title)));
                note = viewer.newMultiChildNode(titleNode, note);
            }
            note = viewer.newMarginNode(note, new Margin(20));
            this.currentMargin -= 20;
            return note;
        }
        if (node instanceof GcReportNode.Table) {
            return this.getTableNode(viewer, (GcReportNode.Table)node);
        }
        if (node instanceof GcReportNode.ComposedText) {
            GcReportNode.ComposedText formatted = (GcReportNode.ComposedText)node;
            RendererNode[] arguments = this.getChildren(viewer, formatted);
            return this.replace(viewer, formatted.getTextPattern(), arguments);
        }
        if (node instanceof GcReportNode.Link) {
            GcReportNode.Link linkNode = (GcReportNode.Link)node;
            RendererNode child = this.getRendererNodeImpl(viewer, linkNode.getChild());
            return this.link(viewer, linkNode.getLocation(), linkNode.getOptions(), child);
        }
        if (node instanceof GcReportNode.PieChart) {
            return this.getPieNode(viewer, (GcReportNode.PieChart)node);
        }
        if (node instanceof GcReportNode.AccBarChart) {
            return this.getBarChartNode(viewer, (GcReportNode.AccBarChart)node);
        }
        if (node instanceof GcReportNode.MultiChildNode) {
            RendererNode[] resultChildren = this.getChildren(viewer, (GcReportNode.MultiChildNode)node);
            return viewer.newMultiChildNode(resultChildren);
        }
        return null;
    }

    private RendererNode getParagraphNode(DescriptionViewer viewer, GcReportNode.MultiChildNode node) {
        RendererNode[] lines = this.getChildren(viewer, node);
        if (lines.length == 0) {
            return viewer.newLineBreakNode();
        }
        if (lines.length == 1) {
            return viewer.newParagraphNode(lines[0]);
        }
        ArrayList<RendererNode> resultChildren = new ArrayList<RendererNode>(lines.length * 2 - 1);
        for (int i = 0; i < lines.length; ++i) {
            resultChildren.add(lines[i]);
            if (i >= lines.length - 1) continue;
            resultChildren.add(viewer.newLineBreakNode());
        }
        return viewer.newParagraphNode(viewer.newMultiChildNode(resultChildren.toArray(new RendererNode[resultChildren.size()])));
    }

    private RendererNode getSectionNode(DescriptionViewer viewer, GcReportNode.Section section) {
        GcReportNode[] children = section.getChildren();
        GcReportNode.Icon icon = section.getIcon();
        RendererNode title = viewer.newTextNode(section.getTitle());
        if (icon != null) {
            StyleNode<?> iconNode = viewer.newStyleNode(this.getIconNode(viewer, icon), RendererStyle.IMG);
            title = viewer.newMultiChildNode(iconNode, viewer.newTextNode("  "), title);
        }
        title = viewer.newStyleNode(title, this.firstSection ? RendererStyle.FIRST_TITLE : RendererStyle.TITLE);
        this.firstSection = false;
        this.currentMargin += 20;
        RendererNode[] contentNodes = new RendererNode[children.length];
        for (int i = 0; i < children.length; ++i) {
            contentNodes[i] = this.getRendererNodeImpl(viewer, children[i]);
        }
        MarginNode<?> content = viewer.newMarginNode(viewer.newMultiChildNode(contentNodes), new Margin(20));
        this.currentMargin -= 20;
        return viewer.newMultiChildNode(title, content);
    }

    private RendererNode getPieNode(DescriptionViewer viewer, GcReportNode.PieChart pie) {
        PieChartNode result = viewer.newPieChartNode();
        if (result instanceof HTMLPieChartNode) {
            int width = 800 - this.currentMargin;
            int heigth = width * 2 / 5;
            ((HTMLPieChartNode)result).setBounds(width, heigth);
        }
        result.setAltTag(pie.getAltTag());
        PieGraphDataSet dataSet = new PieGraphDataSet(pie.getTitle());
        for (int i = 0; i < pie.size(); ++i) {
            dataSet.addValue(pie.getValue(i), pie.getLabel(i), new Color(pie.getColor(i)));
        }
        dataSet.setStartAngle(90);
        dataSet.setRotateCW(true);
        result.setData(dataSet);
        result.setLegendEnabled(true);
        return result;
    }

    private RendererNode getBarChartNode(DescriptionViewer viewer, GcReportNode.AccBarChart barChart) {
        BarChartNode result = viewer.newBarChartNode();
        boolean horizontal = barChart.isHorizontal();
        if (result instanceof HTMLBarChartNode) {
            if (horizontal) {
                int width = 800 - this.currentMargin;
                int heigth = width / 9;
                ((HTMLBarChartNode)result).setBounds(width, heigth);
            } else {
                ((HTMLBarChartNode)result).setBounds(100, 300);
            }
        }
        result.setGraphInitializer(new ChartNodeInitializer<SingleBarValueChart, BarChartNode>(){

            @Override
            public void init(SingleBarValueChart chart, BarChartNode node) {
                chart.setType(SingleBarValueChart.Type.HORIZONTAL);
                chart.enableShadows(true);
            }

            @Override
            public String getChartTitle() {
                return null;
            }
        });
        result.setAltTag(barChart.getAltTag());
        AccSingleBarDataSet dataSet = new AccSingleBarDataSet();
        dataSet.setMaxValue(barChart.getMax());
        dataSet.setInlinedText(null);
        long total = 0L;
        long[] values = barChart.getValues();
        String[] labels = barChart.getDescriptionLabels();
        String[] ranges = barChart.getRangeLabels();
        for (int i = 0; i < values.length; ++i) {
            dataSet.addValue(values[i], labels[i]);
            if (ranges[i] != null) {
                dataSet.setRangeMarker(total, total + values[i], ranges[i], Color.BLACK);
            }
            total += values[i];
            if (labels[i] == null) continue;
            dataSet.setValueMarker(total, labels[i]);
        }
        result.setData(dataSet);
        return result;
    }

    private RendererNode getTableNode(DescriptionViewer viewer, GcReportNode.Table table) {
        GcReportNode[][] gcContent = table.getContent();
        int rows = gcContent.length;
        int columns = rows > 0 ? gcContent[0].length : table.getRelativeWidths().length;
        RendererNode[][] content = new RendererNode[rows][columns];
        for (int row = 0; row < rows; ++row) {
            content[row] = new RendererNode[columns];
            for (int col = 0; col < columns; ++col) {
                content[row][col] = this.getRendererNodeImpl(viewer, gcContent[row][col]);
            }
        }
        TableStyle style = new TableStyle();
        style.setContentCellPadding(3, 15, 3, 15);
        style.setHeaderCellPadding(4, 15, 4, 15);
        int[] colAlignment = table.getColAlignment();
        int[] headerAlignment = table.getHeaderAlignment();
        for (int i = 0; i < columns; ++i) {
            int a = colAlignment[i];
            TableStyle.Align align = a == -1 ? TableStyle.Align.LEFT : (a == 0 ? TableStyle.Align.CENTER : TableStyle.Align.RIGHT);
            style.setColumnAlignment(i, align);
            a = headerAlignment[i];
            align = a == -1 ? TableStyle.Align.LEFT : (a == 0 ? TableStyle.Align.CENTER : TableStyle.Align.RIGHT);
            style.setHeaderColumnAlignment(i, align);
        }
        return viewer.newTable(table.getHeadings(), table.getRelativeWidths(), table.isShowBorder(), table.isShowGrid(), table.getAlignment(), content, style);
    }

    private RendererNode[] getChildren(DescriptionViewer viewer, GcReportNode.MultiChildNode node) {
        GcReportNode[] children = node.getChildren();
        RendererNode[] resultChildren = new RendererNode[children.length];
        for (int i = 0; i < children.length; ++i) {
            resultChildren[i] = this.getRendererNodeImpl(viewer, children[i]);
        }
        return resultChildren;
    }

    private RendererNode getIconNode(DescriptionViewer viewer, GcReportNode.Icon node) {
        String iconKey = null;
        String altText = null;
        switch (node.getSeverity()) {
            case GREEN: {
                iconKey = "profiling/severity_info.png";
                break;
            }
            case RED: {
                iconKey = "profiling/severity_error.png";
                break;
            }
            case YELLOW: {
                iconKey = "profiling/severity_warning.png";
                break;
            }
            case NOTHING: {
                iconKey = "profiling/severity_ok.png";
                break;
            }
        }
        String key = iconKey + "|" + altText;
        RendererNode imageNode = this.imageNodeCache.get(key);
        if (imageNode == null) {
            imageNode = viewer.newImageNode(ImageRepository.getImageURI(iconKey), altText);
            this.imageNodeCache.put(key, imageNode);
        }
        return imageNode;
    }

    private RendererNode getPercentageBar(DescriptionViewer viewer, GcReportNode.PercentageBar node) {
        PercentageBarNode bar = viewer.newPercentageBarNode();
        bar.setPercentage(node.getPercentage(), 0.0, 0.0);
        int rgb = node.getColor();
        int red = rgb >> 16 & 0xFF;
        red = 2 * red / 3;
        int green = rgb >> 8 & 0xFF;
        green = 2 * green / 3;
        int blue = rgb & 0xFF;
        blue = 2 * blue / 3;
        int borderColor = rgb = red << 16 | green << 8 | blue;
        if (node instanceof GcReportNode.LegendBox) {
            bar.setDisplayFormatHint(PercentageBarNode.DisplayFormatHint.ICON);
        }
        return viewer.newColorNode(node.getColor(), -1, -1, borderColor, -1, -1, -1, bar);
    }
}

