/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.presentation.impl.typed.gc;

import com.sap.jvm.profiling.ProfilingSession;
import com.sap.jvm.profiling.i18n.I18n;
import com.sap.jvm.profiling.presentation.typed.TypedTimeSeriesProvider;
import com.sap.jvm.profiling.presentation.typed.gc.Attribute;
import com.sap.jvm.profiling.presentation.typed.gc.GcTimeSeriesMetaData;
import com.sap.jvm.profiling.presentation.typed.gc.GcTimeSeriesSelection;
import com.sap.jvm.profiling.presentation.typed.gc.elements.SelectTimeSeriesElement;
import com.sap.jvm.profiling.resource.ResourceName;
import com.sap.jvm.profiling.resource.ResourceNameElement;
import com.sap.jvm.profiling.snapshot.gc.Elements;
import com.sap.jvm.profiling.snapshot.gc.GcTimeSeriesAnnotation;
import com.sap.jvm.profiling.ui.graph.dataset.LineGraphAnnotation;
import com.sap.jvm.profiling.ui.graph.renderer.ColorPool;
import java.util.List;

public final class GcTimeSeriesProvider
extends TypedTimeSeriesProvider {
    private final ColorPool colPool = ColorPool.getPool();

    public GcTimeSeriesProvider(ResourceName name) {
        super(name, I18n._ts((I18n.TextType)I18n.TextType.XTBS, (String)"GCs (Graphical)"), "views/graph.gif", GcTimeSeriesProvider.getDefaultVisibility(name));
        this.addSelectedTimeSeries(GcTimeSeriesProvider.getTimeSeriesSelection(name));
        this.setCurrentTag("gc/markers", I18n._s((String)"Markers"), I18n._s((String)"Shows indications for important GC events in all graphs"));
        this.addGlobalEvents(698, new LineGraphAnnotation(LineGraphAnnotation.Severity.INFO, null, 0.0).getBorderColor(), "decorators/info_small.gif", I18n._s((String)"GC infos"));
        this.addGlobalEvents(699, new LineGraphAnnotation(LineGraphAnnotation.Severity.WARNING, null, 0.0).getBorderColor(), "decorators/warning.gif", I18n._s((String)"GC warnings"));
        this.addGlobalEvents(700, new LineGraphAnnotation(LineGraphAnnotation.Severity.ERROR, null, 0.0).getBorderColor(), "navigation/delete_small.gif", I18n._s((String)"GC errors"));
        this.addGeneralTimeSeries();
    }

    private void addSelectedTimeSeries(GcTimeSeriesSelection attributesSelection) {
        this.setCurrent(this.getCollectionName(), 717);
        this.addGroup("gc", I18n._s((String)"GC Attributes"));
        List<GcTimeSeriesSelection.Area> graphAreas = attributesSelection.getAreas();
        for (int areaIdx = 0; areaIdx < graphAreas.size(); ++areaIdx) {
            GcTimeSeriesSelection.Area area = graphAreas.get(areaIdx);
            this.addArea(area.getTitle(), area.getTag(), area.getDescription());
            this.resetColorPool();
            int[] series = area.getTimeSeries();
            boolean[] secondary = area.getSecondary();
            for (int ii = 0; ii < series.length; ++ii) {
                this.addGraph(series[ii], secondary[ii]);
            }
        }
    }

    private void addGraph(int seriesIdx, boolean secondary) {
        ProfilingSession session = this.getResourceName().getSession();
        Attribute<?> attribute = GcTimeSeriesMetaData.ATTRIBUTE_FOR_TIMESERIES[seriesIdx];
        if (attribute != null) {
            if (secondary) {
                this.addLineSecondary(seriesIdx, 0, this.getPresentation(seriesIdx), GcTimeSeriesMetaData.getDescriptionForTimeSeries(seriesIdx, session), this.getColor(seriesIdx), attribute.getType());
            } else {
                this.addLine(seriesIdx, 0, this.getPresentation(seriesIdx), GcTimeSeriesMetaData.getDescriptionForTimeSeries(seriesIdx, session), this.getColor(seriesIdx), attribute.getType());
            }
        } else if (seriesIdx == 701) {
            this.addEvents(701, new LineGraphAnnotation(LineGraphAnnotation.Severity.INFO, null, 0.0).getBorderColor(), "decorators/annotation_concurrent_gc.png", I18n._s((String)"Concurrent GCs"));
        }
    }

    private String getColor(int idx) {
        switch (idx) {
            case 10: {
                return this.colPool.getColor(3, 15).getString();
            }
            case 0: {
                return this.colPool.getColor(4, 2).getString();
            }
            case 27: {
                return this.colPool.getColor(0, 27).getString();
            }
            case 17: {
                return this.colPool.getColor(1, 11).getString();
            }
            case 703: {
                return this.colPool.getColor(0, 27).getString();
            }
            case 702: {
                return this.colPool.getColor(1, 11).getString();
            }
            case 704: {
                return this.colPool.getColor(5, 0).getString();
            }
            case 705: {
                return this.colPool.getColor(5, 2).getString();
            }
            case 706: {
                return this.colPool.getColor(5, 11).getString();
            }
            case 707: {
                return this.colPool.getColor(3, 1).getString();
            }
        }
        return this.colPool.getNext().getString();
    }

    private int getPresentation(int seriesIdx) {
        switch (seriesIdx) {
            case 0: 
            case 3: 
            case 4: 
            case 10: 
            case 17: 
            case 27: 
            case 704: 
            case 705: 
            case 706: 
            case 707: {
                return 0;
            }
        }
        return 3;
    }

    private void resetColorPool() {
        this.colPool.setDefinedStart(3, 15, 2, 7, 27, 11, 10);
    }

    private static String getDefaultVisibility(ResourceName name) {
        List<GcTimeSeriesSelection.Area> areas = GcTimeSeriesProvider.getTimeSeriesSelection(name).getAreas();
        int numAreas = areas.size();
        if (GcTimeSeriesProvider.isDefaultSelection(name)) {
            numAreas = 3;
        }
        StringBuilder result = new StringBuilder();
        for (int i = 0; i < numAreas; ++i) {
            if (i != 0) {
                result.append('|');
            }
            result.append(areas.get(i).getTag());
        }
        return result.toString();
    }

    private static GcTimeSeriesSelection getTimeSeriesSelection(ResourceName name) {
        GcTimeSeriesSelection result = GcTimeSeriesProvider.getSelectionFromResourceName(name);
        if (result == null) {
            result = GcTimeSeriesSelection.getDefault();
        }
        return result;
    }

    private static boolean isDefaultSelection(ResourceName name) {
        GcTimeSeriesSelection selection = GcTimeSeriesProvider.getSelectionFromResourceName(name);
        return selection == null;
    }

    private static GcTimeSeriesSelection getSelectionFromResourceName(ResourceName name) {
        ResourceNameElement element = name.stripLastElement().getLastElement();
        if (element instanceof SelectTimeSeriesElement) {
            SelectTimeSeriesElement selectElement = (SelectTimeSeriesElement)element;
            return selectElement.getSelection();
        }
        return null;
    }

    @Override
    protected ResourceName getCollectionName() {
        ResourceName baseName = this.getResourceName().stripLastElement();
        while (baseName.getLastElement() instanceof SelectTimeSeriesElement) {
            baseName = baseName.stripLastElement();
        }
        return baseName.addElement((ResourceNameElement)new Elements.CreateTimeSeriesCollection());
    }

    @Override
    protected String getAnnotationMessage(Object data) {
        if (data instanceof GcTimeSeriesAnnotation) {
            return ((GcTimeSeriesAnnotation)data).getText();
        }
        return super.getAnnotationMessage(data);
    }

    @Override
    protected String getAnnotationIconKey(Object obj) {
        if (obj instanceof GcTimeSeriesAnnotation) {
            GcTimeSeriesAnnotation data = (GcTimeSeriesAnnotation)obj;
            int iconKey = data.getIconKey();
            if (iconKey == 0) {
                return null;
            }
            if (iconKey == 1) {
                return "decorators/annotation_full_gc.gif";
            }
            if (iconKey == 2) {
                return "decorators/annotation_gc_locker.png";
            }
            if (iconKey == 3) {
                return "decorators/annotation_gc_concmode_failure.png";
            }
            assert (false);
        }
        return super.getAnnotationIconKey(obj);
    }
}

