/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.presentation.impl.typed.gc;

import com.sap.jvm.profiling.ProfilingSession;
import com.sap.jvm.profiling.memory.event.GcType;
import com.sap.jvm.profiling.presentation.impl.typed.gc.GcEventValueStatisticProvider;
import com.sap.jvm.profiling.presentation.impl.typed.gc.GcProvider;
import com.sap.jvm.profiling.presentation.typed.TypedColumnSpec;
import com.sap.jvm.profiling.presentation.typed.VisibilitySet;
import com.sap.jvm.profiling.presentation.typed.entries.ProviderEntry;
import com.sap.jvm.profiling.presentation.typed.gc.Attribute;
import com.sap.jvm.profiling.presentation.typed.gc.GcEventAttribute;
import com.sap.jvm.profiling.presentation.typed.gc.GcStatisticAttribute;
import com.sap.jvm.profiling.resource.ResourceName;
import com.sap.jvm.profiling.snapshot.Snapshot;
import com.sap.jvm.profiling.snapshot.SnapshotResourceManagerFactory;
import com.sap.jvm.profiling.snapshot.gc.GcErrata;
import com.sap.jvm.profiling.snapshot.gc.GcEventStatisticValue;
import com.sap.jvm.profiling.snapshot.gc.GcEventStatisticValueElement;
import com.sap.jvm.profiling.snapshot.gc.GcEventValueStatistic;
import com.sap.jvm.profiling.snapshot.gc.GcSnapshot;
import com.sap.jvm.profiling.snapshot.gc.GcStatisticValue;
import com.sap.jvm.profiling.snapshot.gc.GcStatisticValueElement;
import com.sap.jvm.profiling.snapshot.gc.GcStatisticValuesColumn;
import com.sap.jvm.profiling.snapshot.gc.StatisticValueElement;
import com.sap.jvm.profiling.snapshot.util.ValueStatistic;
import com.sap.jvm.profiling.snapshot.util.column.Column;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;

public class ProviderUtils {
    private static final StatisticValueElement[] DEFAULT_COLUMNS_GC_STATISTIC = new StatisticValueElement[]{GcStatisticValueElement.MAX_PAUSE_TIME, GcStatisticValueElement.TIME_STAMP, GcStatisticValueElement.GC_CAUSE, GcStatisticValueElement.GC_TYPE, GcStatisticValueElement.COLLECTION_SET, GcStatisticValueElement.PROMOTION_FAILURES, GcStatisticValueElement.BYTES_IN_NON_PERM_BEFORE_AND_AFTER, GcStatisticValueElement.BYTES_IN_NON_PERM_DIFFERENCE};
    private static final HashMap<Object, Integer> typeFlags = new HashMap();
    private static final HashMap<Object, Integer> removeFlags = new HashMap();

    private static StatisticValueElement[] applicableDefaultColumnsGcStatistic(ResourceName name) {
        ProfilingSession session = name.getSession();
        Snapshot snapshot = SnapshotResourceManagerFactory.get(session).getSnapshot(name);
        assert (snapshot instanceof GcSnapshot);
        GcType gcType = ((GcSnapshot)snapshot).getGcType();
        return (StatisticValueElement[])Arrays.stream(DEFAULT_COLUMNS_GC_STATISTIC).filter(e -> e.isApplicable(session, gcType, null)).toArray(StatisticValueElement[]::new);
    }

    public static TypedColumnSpec getGcValueSpec(ResourceName name) {
        GcStatisticValueElement[] elements = GcStatisticValueElement.values();
        TypedColumnSpec spec = new TypedColumnSpec(ProviderUtils.getColumnVisibility(ProviderUtils.applicableDefaultColumnsGcStatistic(name)));
        ProfilingSession session = name.getSession();
        for (GcStatisticValueElement element : elements) {
            GcStatisticAttribute attr = GcStatisticAttribute.getAttributeForElement(element);
            int flags = ProviderUtils.getColumnFlags(attr, false);
            ProviderUtils.appendColumn(attr, flags, session, spec);
        }
        return spec;
    }

    public static TypedColumnSpec getGcEventValueSpec(ResourceName name, List<GcEventStatisticValueElement> elements, List<String> defaultColumns) {
        ProfilingSession session = name.getSession();
        GcStatisticValueElement[] statisticElements = GcStatisticValueElement.values();
        TypedColumnSpec spec = new TypedColumnSpec(ProviderUtils.getColumnVisibility(defaultColumns));
        for (GcStatisticValueElement element : statisticElements) {
            GcStatisticAttribute attr = GcStatisticAttribute.getAttributeForElement(element);
            int flags = ProviderUtils.getColumnFlags(attr, true);
            ProviderUtils.appendColumn(attr, flags, session, spec);
        }
        for (GcEventStatisticValueElement element : elements) {
            GcEventAttribute attr = GcEventAttribute.getAttributeForElement(element);
            int flags = ProviderUtils.getColumnFlags(attr, true);
            ProviderUtils.appendColumn(attr, flags, session, spec);
        }
        return spec;
    }

    public static Column getColumn(ValueStatistic<?, GcStatisticValue> statistic, int columnIndex) {
        return ((GcStatisticValuesColumn)statistic.getValueColumn()).getColumn(columnIndex);
    }

    private static ProviderEntry getEntry(GcStatisticValue value, int column, GcStatisticValue total) {
        GcStatisticValueElement element = GcStatisticValueElement.values()[column];
        return GcStatisticAttribute.getEntry(element, value, total);
    }

    public static ProviderEntry getEntry(int id, int column, ValueStatistic<?, GcStatisticValue> statistic, GcProvider provider) {
        return ProviderUtils.getEntry(statistic.getValue(id), column, statistic.getValue());
    }

    public static ProviderEntry getEntry(int id, StatisticValueElement element, GcEventValueStatistic statistic, GcEventValueStatisticProvider provider) {
        GcEventStatisticValue value = (GcEventStatisticValue)statistic.getValue(id);
        GcEventStatisticValue total = (GcEventStatisticValue)statistic.getValue();
        if (element instanceof GcStatisticValueElement) {
            return GcStatisticAttribute.getEntry((GcStatisticValueElement)element, value.getGcStatisticData(), total.getGcStatisticData());
        }
        return GcEventAttribute.getEntry((GcEventStatisticValueElement)element, (GcEventStatisticValue)statistic.getValue(id), (GcEventStatisticValue)statistic.getValue());
    }

    private static String getColumnVisibility(StatisticValueElement[] columnElements) {
        ArrayList<String> tags = new ArrayList<String>(columnElements.length);
        for (StatisticValueElement element : columnElements) {
            tags.add(element.getColumnTag());
        }
        return ProviderUtils.getColumnVisibility(tags);
    }

    private static String getColumnVisibility(List<String> columnTags) {
        StringBuilder result = new StringBuilder();
        boolean first = true;
        for (String tag : columnTags) {
            if (!first) {
                result.append("|");
            }
            result.append(tag);
            first = false;
        }
        return result.toString();
    }

    private static void appendColumn(Attribute<?> attr, int flags, ProfilingSession session, TypedColumnSpec spec) {
        String errata = GcErrata.getErrataText(attr.getValueElement(), session.getSystemInfo());
        String colName = attr.getColumnName(session);
        String toolTip = attr.getLongDescription(session);
        if (errata != null) {
            colName = colName + " \u00b9";
            toolTip = toolTip + "\n\u00b9\u207e " + errata;
        }
        spec.appendColumn(colName, toolTip, flags, attr.getType(), attr.getValueElement().getColumnTag(), new VisibilitySet(attr.getValueElement().getColumnTag(), "Group_1", attr.getColumnName(session), "types/fixme.gif", attr.getLongDescription(session), new Integer[0]));
    }

    private static int getColumnFlags(Attribute<?> attribute, boolean eventStat) {
        Integer removedFlags;
        Integer additionalFlags;
        int flags = attribute.getColumnFlags();
        flags |= 2;
        StatisticValueElement element = attribute.getValueElement();
        if (element == GcStatisticValueElement.MAX_PAUSE_TIME && !eventStat || element == GcEventStatisticValueElement.DURATION && eventStat) {
            flags |= 0x100;
        }
        if ((additionalFlags = typeFlags.get(element)) != null) {
            flags |= additionalFlags.intValue();
        }
        if ((removedFlags = removeFlags.get(element)) != null) {
            flags &= ~removedFlags.intValue();
        }
        return flags;
    }

    static {
        typeFlags.put(GcStatisticValueElement.GC_TYPE, 8);
        typeFlags.put(GcStatisticValueElement.GC_CAUSE, 8);
        int sumAndAvg = 4100;
        for (GcStatisticValueElement element : GcStatisticValueElement.values()) {
            if (!element.name().startsWith("CUMULATIV")) continue;
            removeFlags.put(element, sumAndAvg);
        }
    }
}

