/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.presentation.impl.typed.html.renderer;

import com.sap.jvm.profiling.presentation.impl.html.HTMLSink;
import com.sap.jvm.profiling.presentation.impl.typed.html.renderer.HTMLRendererNode;
import com.sap.jvm.profiling.ui.graph.GraphChartContainer;
import com.sap.jvm.profiling.ui.graph.SingleBarValueChart;
import com.sap.jvm.profiling.ui.graph.awt.renderer.AwtRenderer;
import com.sap.jvm.profiling.ui.graph.renderer.Color;
import com.sap.jvm.profiling.viewer.renderer.BarChartNode;
import java.awt.image.BufferedImage;

public class HTMLBarChartNode
extends BarChartNode
implements HTMLRendererNode {
    private int width;
    private int height;

    public HTMLBarChartNode(int width, int height) {
        this.width = width;
        this.height = height;
    }

    public void setBounds(int width, int height) {
        this.width = width;
        this.height = height;
    }

    @Override
    public int getAlignment() {
        return -1;
    }

    @Override
    public void render(HTMLSink sink) {
        AwtRenderer renderer = new AwtRenderer(this.width, this.height);
        renderer.setDefaultBackground(Color.WHITE);
        GraphChartContainer chartsContainer = new GraphChartContainer(renderer, 1);
        chartsContainer.enableCellMarginBottom(false);
        final SingleBarValueChart barChart = new SingleBarValueChart(chartsContainer);
        chartsContainer.addChart(barChart);
        barChart.addGraph(this.getData());
        if (this.getInitializer() != null) {
            if (this.getInitializer().getChartTitle() != null) {
                chartsContainer.setChartTitle(this.getInitializer().getChartTitle(), 0);
            }
            chartsContainer.setInitializer(new Runnable(){

                @Override
                public void run() {
                    HTMLBarChartNode.this.getInitializer().init(barChart, HTMLBarChartNode.this);
                }
            });
        } else {
            String name = barChart.getAllGraphs().isEmpty() ? "Chart" : barChart.getAllGraphs().get(0).getName();
            chartsContainer.setChartTitle(name, 0);
        }
        BufferedImage img = renderer.getImage();
        BufferedImage bi = img.getSubimage(0, 0, img.getWidth(), img.getHeight());
        StringBuilder tmpTag = new StringBuilder("singlebargraph" + Math.random() * 1000.0);
        sink.writeImage(tmpTag.toString(), bi, this.getAltTag());
        bi.flush();
        renderer.dispose();
    }

    @Override
    public boolean needsTextColor() {
        return false;
    }
}

