/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.presentation.impl.typed.html.renderer;

import com.sap.jvm.profiling.presentation.impl.html.HTMLSink;
import com.sap.jvm.profiling.presentation.impl.typed.html.renderer.HTMLRendererNode;
import com.sap.jvm.profiling.ui.graph.BarGraphChart;
import com.sap.jvm.profiling.ui.graph.GraphChartContainer;
import com.sap.jvm.profiling.ui.graph.awt.renderer.AwtRenderer;
import com.sap.jvm.profiling.ui.graph.renderer.Color;
import com.sap.jvm.profiling.viewer.renderer.BarsChartNode;
import java.awt.image.BufferedImage;

public class HTMLBarsChartNode
extends BarsChartNode
implements HTMLRendererNode {
    private int width;
    private int height;

    public HTMLBarsChartNode(int width, int height) {
        this.width = width;
        this.height = height;
    }

    @Override
    public int getAlignment() {
        return -1;
    }

    @Override
    public void render(HTMLSink sink) {
        AwtRenderer renderer = new AwtRenderer(this.width, this.height);
        renderer.setDefaultBackground(Color.WHITE);
        GraphChartContainer chartsContainer = new GraphChartContainer(renderer, 1);
        chartsContainer.enableCellMarginBottom(false);
        final BarGraphChart barChart = new BarGraphChart(chartsContainer, true, true);
        chartsContainer.addChart(barChart);
        if (this.getInitializer() != null) {
            if (this.getInitializer().getChartTitle() != null) {
                chartsContainer.setChartTitle(this.getInitializer().getChartTitle(), 0);
            }
            chartsContainer.setInitializer(new Runnable(){

                @Override
                public void run() {
                    HTMLBarsChartNode.this.getInitializer().init(barChart, HTMLBarsChartNode.this);
                }
            });
        } else {
            chartsContainer.setChartTitle("Chart", 0);
        }
        barChart.addGraph(this.getData());
        BufferedImage img = renderer.getImage();
        BufferedImage bi = img.getSubimage(0, 0, img.getWidth(), img.getHeight());
        StringBuilder tmpTag = new StringBuilder("linegraph" + Math.random() * 1000.0);
        sink.writeImage(tmpTag.toString(), bi, this.getAltTag());
        bi.flush();
        renderer.dispose();
    }

    @Override
    public boolean needsTextColor() {
        return false;
    }
}

