/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.presentation.impl.typed.html.renderer;

import com.sap.jvm.profiling.i18n.I18n;
import com.sap.jvm.profiling.presentation.impl.html.HTMLSink;
import com.sap.jvm.profiling.presentation.impl.typed.html.renderer.HTMLRendererNode;
import com.sap.jvm.profiling.ui.graph.GraphChartContainer;
import com.sap.jvm.profiling.ui.graph.LineGraphSimpleChart;
import com.sap.jvm.profiling.ui.graph.awt.renderer.AwtRenderer;
import com.sap.jvm.profiling.ui.graph.axes.AxisCaptionProviderBase;
import com.sap.jvm.profiling.ui.graph.dataset.LineGraphDataSet;
import com.sap.jvm.profiling.ui.graph.geometry.Point2D;
import com.sap.jvm.profiling.ui.graph.renderer.Color;
import com.sap.jvm.profiling.viewer.renderer.LineChartNode;
import java.awt.image.BufferedImage;
import java.util.Map;

public class HTMLLineChartNode
extends LineChartNode
implements HTMLRendererNode {
    private int width;
    private int height;

    public HTMLLineChartNode(int width, int height) {
        this.width = width;
        this.height = height;
    }

    @Override
    public int getAlignment() {
        return -1;
    }

    @Override
    public void render(HTMLSink sink) {
        AwtRenderer renderer = new AwtRenderer(this.width, this.height);
        renderer.setDefaultBackground(Color.WHITE);
        GraphChartContainer chartsContainer = new GraphChartContainer(renderer, 1);
        final LineGraphSimpleChart lineChart = new LineGraphSimpleChart(chartsContainer, true, true);
        chartsContainer.addChart(lineChart);
        String chartTitle = null;
        if (this.getInitializer() != null) {
            chartTitle = this.getInitializer().getChartTitle();
            chartsContainer.setInitializer(new Runnable(){

                @Override
                public void run() {
                    HTMLLineChartNode.this.getInitializer().init(lineChart, HTMLLineChartNode.this);
                }
            });
        } else {
            lineChart.setYAxisCaptionProvider(new AxisCaptionProviderBase(){

                @Override
                public String provideAxisTitle(double min, double max) {
                    return I18n._s((String)"Y-Axis");
                }
            });
            lineChart.setXAxisCaptionProvider(new AxisCaptionProviderBase(){

                @Override
                public String provideAxisTitle(double min, double max) {
                    return I18n._s((String)"X-Axis");
                }
            });
            chartsContainer.setInitializer(new Runnable(){

                @Override
                public void run() {
                    lineChart.adjustXAxis(HTMLLineChartNode.this.getXRangeMin(), HTMLLineChartNode.this.getXRangeMax(), false);
                    lineChart.adjustYAxis(HTMLLineChartNode.this.getYRangeMin(), HTMLLineChartNode.this.getYRangeMax(), false);
                }
            });
        }
        if (chartTitle == null && (chartTitle = this.getTitle()) == null) {
            chartTitle = I18n._s((String)"Chart");
        }
        chartsContainer.setChartTitle(chartTitle, 0);
        for (LineGraphDataSet set : this.getData()) {
            lineChart.addGraph(set);
        }
        BufferedImage img = renderer.getImage();
        BufferedImage bi = img.getSubimage(0, 0, img.getWidth(), img.getHeight());
        StringBuilder tmpTag = new StringBuilder("linegraph" + Math.random() * 1000.0);
        String altTag = this.getAltTag();
        if (altTag == null) {
            StringBuilder altBuilder = new StringBuilder();
            altBuilder.append(lineChart.getAccessibleControlName());
            altBuilder.append(" \"").append(chartTitle).append("\"");
            altTag = altBuilder.toString();
        }
        boolean writeToolTips = true;
        sink.writeImageWithAddition(tmpTag.toString(), bi, altTag, " title=\"\" border=\"0\"" + (writeToolTips ? " usemap=\"#ChartToolTips-" + tmpTag + "\"" : ""));
        if (writeToolTips) {
            sink.writeHTML("<map name=\"ChartToolTips-" + tmpTag + "\">\n");
            for (Map.Entry<Point2D, String> e : lineChart.getEmphasizedPointsTooltips().entrySet()) {
                sink.writeHTML("<area shape=\"circle\" coords=\"");
                Point2D p = e.getKey();
                sink.writeHTML(p.x - 1 + "," + (p.y - 2) + ", 4");
                sink.writeHTML("\" title=\"");
                sink.writeTitleText(e.getValue());
                sink.writeHTML("\">");
            }
            sink.writeHTML("</map>");
        }
        bi.flush();
        renderer.dispose();
    }

    @Override
    public boolean needsTextColor() {
        return false;
    }
}

