/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.presentation.impl.typed.html.renderer;

import com.sap.jvm.profiling.presentation.impl.html.HTMLSink;
import com.sap.jvm.profiling.presentation.impl.typed.html.renderer.HTMLRendererNode;
import com.sap.jvm.profiling.viewer.renderer.PercentageBarNode;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;

public final class HTMLPercentageBarNode
extends PercentageBarNode
implements HTMLRendererNode {
    private static final int HEIGHT = 14;
    private static final int SLIM_HEIGHT = 10;

    public int getWidth() {
        switch (this.getDisplayFormatHint()) {
            case ICON: {
                return this.getHeight();
            }
            case NARROW: {
                return 34;
            }
            case WIDEx2: {
                return 102;
            }
            case WIDEx3: {
                return 150;
            }
        }
        return 50;
    }

    public int getHeight() {
        switch (this.getDisplayFormatHint()) {
            case SLIM: {
                return 10;
            }
        }
        return 14;
    }

    private void renderAsImage(HTMLSink sink, int[] widths) {
        String tag;
        StringBuilder tmpTag = new StringBuilder("percentage-bar");
        tmpTag.append(this.getDisplayFormatHint().name());
        tmpTag.append(sink.colorAsHex("", sink.getColor4(), ""));
        int nrOfBars = 0;
        for (int i = 0; i < 6; ++i) {
            if (widths[i] <= 0) continue;
            ++nrOfBars;
        }
        int mask = -2;
        int offset = 0;
        if (nrOfBars > 1) {
            mask = -4;
            offset = 2;
        }
        int origSum = 0;
        int newSum = 0;
        for (int i = 0; i < 6; ++i) {
            widths[i] = ((origSum += widths[i]) + offset & mask) - newSum;
            newSum += widths[i];
        }
        if (widths[0] > 0) {
            tmpTag.append(sink.colorAsHex("", sink.getColor7(), ""));
            tmpTag.append("w0");
            tmpTag.append(widths[0]);
        }
        if (widths[1] > 0) {
            tmpTag.append(sink.colorAsHex("", sink.getColor6(), ""));
            tmpTag.append("w1");
            tmpTag.append(widths[1]);
        }
        if (widths[2] > 0) {
            tmpTag.append(sink.colorAsHex("", sink.getColor5(), ""));
            tmpTag.append("w2");
            tmpTag.append(widths[2]);
        }
        if (widths[3] > 0) {
            tmpTag.append(sink.colorAsHex("", sink.getColor3(), ""));
            tmpTag.append("w3");
            tmpTag.append(widths[3]);
        }
        if (widths[4] > 0) {
            tmpTag.append(sink.colorAsHex("", sink.getColor2(), ""));
            tmpTag.append("w4");
            tmpTag.append(widths[4]);
        }
        if (widths[5] > 0) {
            tmpTag.append(sink.colorAsHex("", sink.getColor1(), ""));
            tmpTag.append("w5");
            tmpTag.append(widths[5]);
        }
        if (sink.writeImage(tag = tmpTag.toString(), null, null)) {
            return;
        }
        int width = this.getWidth();
        int height = this.getHeight();
        BufferedImage bi = new BufferedImage(width, height, 2);
        Graphics2D g = bi.createGraphics();
        g.setBackground(new Color(0, 0, 0, 0));
        g.clearRect(0, 0, width, height);
        g.setColor(new Color(sink.getColor4()));
        g.drawRect(0, 0, width - 1, height - 1);
        int x = 1;
        if (widths[0] > 0) {
            g.setColor(new Color(sink.getColor7()));
            g.fillRect(x, 1, widths[0], height - 2);
            x += widths[0];
        }
        if (widths[1] > 0) {
            g.setColor(new Color(sink.getColor6()));
            g.fillRect(x, 1, widths[1], height - 2);
            x += widths[1];
        }
        if (widths[2] > 0) {
            g.setColor(new Color(sink.getColor5()));
            g.fillRect(x, 1, widths[2], height - 2);
            x += widths[2];
        }
        if (widths[3] > 0) {
            g.setColor(new Color(sink.getColor3()));
            g.fillRect(x, 1, widths[3], height - 2);
            x += widths[3];
        }
        if (widths[4] > 0) {
            g.setColor(new Color(sink.getColor2()));
            g.fillRect(x, 1, widths[4], height - 2);
            x += widths[4];
        }
        if (widths[5] > 0) {
            g.setColor(new Color(sink.getColor1()));
            g.fillRect(x, 1, widths[5], height - 2);
            x += widths[5];
        }
        sink.writeImage(tag, bi, null);
        bi.flush();
    }

    @Override
    public void render(HTMLSink sink) {
        int[] widths;
        int totalWidth = this.getWidth() - 2;
        widths = new int[]{(int)(this.getDisplayPercentage(this.getPercentage6()) * (double)totalWidth), (int)(this.getDisplayPercentage(this.getPercentage5()) * (double)totalWidth) - widths[0], (int)(this.getDisplayPercentage(this.getPercentage4()) * (double)totalWidth) - widths[0] - widths[1], (int)(this.getDisplayPercentage(this.getPercentage3()) * (double)totalWidth) - widths[0] - widths[1] - widths[2], (int)(this.getDisplayPercentage(this.getPercentage2()) * (double)totalWidth) - widths[0] - widths[1] - widths[2] - widths[3], (int)(this.getDisplayPercentage(this.getPercentage1()) * (double)totalWidth) - widths[0] - widths[1] - widths[2] - widths[3] - widths[4], totalWidth - widths[0] - widths[1] - widths[2] - widths[3] - widths[4] - widths[5]};
        this.renderAsImage(sink, widths);
    }

    @Override
    public int getAlignment() {
        return -1;
    }

    private double getDisplayPercentage(double realPercentage) {
        return realPercentage;
    }

    @Override
    public boolean needsTextColor() {
        return false;
    }
}

