/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.presentation.impl.typed.html.renderer;

import com.sap.jvm.profiling.i18n.DataFormatter;
import com.sap.jvm.profiling.presentation.impl.html.HTMLSink;
import com.sap.jvm.profiling.presentation.impl.typed.html.renderer.HTMLRendererNode;
import com.sap.jvm.profiling.ui.graph.EmptyChart;
import com.sap.jvm.profiling.ui.graph.GraphChartContainer;
import com.sap.jvm.profiling.ui.graph.PieGraphChart;
import com.sap.jvm.profiling.ui.graph.PieGraphToolTipProvider;
import com.sap.jvm.profiling.ui.graph.awt.renderer.AwtRenderer;
import com.sap.jvm.profiling.ui.graph.dataset.PieGraphDataSet;
import com.sap.jvm.profiling.ui.graph.geometry.Point2D;
import com.sap.jvm.profiling.ui.graph.renderer.Color;
import com.sap.jvm.profiling.viewer.renderer.PieChartNode;
import java.awt.image.BufferedImage;
import java.util.ArrayList;

public class HTMLPieChartNode
extends PieChartNode
implements HTMLRendererNode {
    private int width;
    private int height;

    public HTMLPieChartNode(int width, int height) {
        this.width = width;
        this.height = height;
    }

    public void setBounds(int width, int height) {
        this.width = width;
        this.height = height;
    }

    @Override
    public int getAlignment() {
        return -1;
    }

    @Override
    public void render(HTMLSink sink) {
        AwtRenderer renderer = new AwtRenderer(this.width, this.height);
        renderer.setDefaultBackground(Color.WHITE);
        int columns = this.isLegendEnabled() ? 3 : 1;
        GraphChartContainer chartsContainer = new GraphChartContainer(renderer, columns);
        chartsContainer.enableCellMarginBottom(false);
        final PieGraphChart pieChart = new PieGraphChart(chartsContainer);
        pieChart.addGraph(this.getData());
        chartsContainer.enableLegend(this.isLegendEnabled());
        if (this.isLegendEnabled()) {
            for (PieGraphDataSet.PiePiece piece : this.getData().getPieces()) {
                if (this.isLegendItemsWithPercentEnabled()) {
                    int digits = this.getData().getPercentDigits();
                    String percentage = digits == -1 ? DataFormatter.getPercentage((double)(piece.getPercent() / 100.0)) : DataFormatter.getPercentage((double)(piece.getPercent() / 100.0), (int)digits);
                    chartsContainer.addLegendItem(percentage + " " + piece.getName(), piece.getColor());
                    continue;
                }
                chartsContainer.addLegendItem(piece.getName(), piece.getColor());
            }
            EmptyChart emptyChart = new EmptyChart(chartsContainer);
            chartsContainer.setPositionAnchor(emptyChart.getLegendAnchors()[1]);
            chartsContainer.addChart(pieChart, 2, 1);
            chartsContainer.addChart(emptyChart, 1, 1);
            chartsContainer.setChartTitle("", 1);
        } else {
            chartsContainer.addChart(pieChart);
        }
        chartsContainer.setChartTitle(this.getTitle(), 0);
        if (this.getInitializer() != null) {
            if (this.getInitializer().getChartTitle() != null) {
                chartsContainer.setChartTitle(this.getInitializer().getChartTitle(), 0);
            }
            chartsContainer.setInitializer(new Runnable(){

                @Override
                public void run() {
                    HTMLPieChartNode.this.getInitializer().init(pieChart, HTMLPieChartNode.this);
                    if (pieChart.getSelection().length == 0 && !HTMLPieChartNode.this.getData().getFixedToolTips()) {
                        pieChart.getPieGraph().setFillRatio(0.85);
                    }
                }
            });
        } else if (pieChart.getSelection().length == 0 && !this.getData().getFixedToolTips()) {
            pieChart.getPieGraph().setFillRatio(0.85);
        }
        BufferedImage img = renderer.getImage();
        BufferedImage bi = img.getSubimage(0, 0, img.getWidth(), img.getHeight());
        StringBuilder tmpTag = new StringBuilder("piegraph" + Math.random() * 1000.0);
        boolean writeToolTips = !this.getData().getFixedToolTips();
        String altTag = this.getAltTag();
        if (altTag == null) {
            altTag = this.getDefaultAltTag(pieChart);
        }
        sink.writeImageWithAddition(tmpTag.toString(), bi, altTag, " title=\"\" border=\"0\"" + (writeToolTips ? " usemap=\"#ChartToolTips-" + tmpTag + "\"" : ""));
        if (writeToolTips) {
            sink.writeHTML("<map name=\"ChartToolTips-" + tmpTag + "\">\n");
            ArrayList<PieGraphDataSet.PiePiece> pieces = this.getData().getPieces();
            PieGraphToolTipProvider toolTipsProvider = pieChart.getToolTipsProvider(this.getData());
            for (int pieceIdx = 0; pieceIdx < pieces.size(); ++pieceIdx) {
                sink.writeHTML("<area shape=\"poly\" coords=\"");
                Point2D[] path = pieChart.getPieGraph().getArc(pieceIdx).asPath();
                for (int j = 0; j < path.length; ++j) {
                    if (j > 0) {
                        sink.writeHTML(",");
                    }
                    int x = path[j].x;
                    int y = img.getHeight() - path[j].y;
                    sink.writeHTML(x + "," + y);
                }
                sink.writeHTML("\" title=\"");
                sink.writeTitleText(toolTipsProvider.provideToolTip(this.getData(), pieces.get(pieceIdx)));
                sink.writeHTML("\">");
            }
            sink.writeHTML("</map>");
        }
        bi.flush();
        renderer.dispose();
    }

    private String getDefaultAltTag(PieGraphChart pieChart) {
        StringBuilder altTag = new StringBuilder();
        altTag.append(pieChart.getAccessibleControlName());
        altTag.append(". ");
        altTag.append(pieChart.getAccessibleStateText());
        altTag.append(": ");
        PieGraphToolTipProvider toolTipsProvider = pieChart.getToolTipsProvider(this.getData());
        ArrayList<PieGraphDataSet.PiePiece> pieces = this.getData().getPieces();
        for (int pieceIdx = 0; pieceIdx < pieces.size(); ++pieceIdx) {
            if (pieceIdx != 0) {
                altTag.append(", ");
            }
            altTag.append(toolTipsProvider.provideToolTip(this.getData(), pieces.get(pieceIdx)));
        }
        String alt = altTag.toString();
        return alt;
    }

    @Override
    public boolean needsTextColor() {
        return false;
    }
}

