/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.presentation.impl.typed.io;

import com.sap.jvm.profiling.core.type.UTF8String;
import com.sap.jvm.profiling.i18n.I18n;
import com.sap.jvm.profiling.presentation.impl.typed.SumBehavior;
import com.sap.jvm.profiling.presentation.impl.typed.io.IOProvider;
import com.sap.jvm.profiling.presentation.impl.typed.io.IOTableProvider;
import com.sap.jvm.profiling.presentation.impl.typed.io.ProviderUtils;
import com.sap.jvm.profiling.presentation.typed.entries.NormalFileName;
import com.sap.jvm.profiling.presentation.typed.entries.ProviderEntry;
import com.sap.jvm.profiling.presentation.typed.io.Elements;
import com.sap.jvm.profiling.resource.ResourceName;
import com.sap.jvm.profiling.resource.ResourceNameElement;
import com.sap.jvm.profiling.snapshot.io.CalledOpenFileStatistic;
import com.sap.jvm.profiling.snapshot.io.Elements;
import com.sap.jvm.profiling.snapshot.util.SelfAndTotalValueStatistic;
import com.sap.jvm.profiling.snapshot.util.column.Column;

public final class CalledOpenFileStatisticProvider
extends IOTableProvider<CalledOpenFileStatistic> {
    public CalledOpenFileStatisticProvider(ResourceName name) {
        super(name, I18n._ts((I18n.TextType)I18n.TextType.XTBS, (String)"Open Files"), "views/io_file_statistic.png", ProviderUtils.getSelfAndTotalSpec(name, false, SumBehavior.SUM_SELF, I18n._ss((String)"Entity, ex: ... affected by {0}, ... time spent in {0}", (String)"this file")).prepend(I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Name"), I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"The name of the file"), 13, NormalFileName.class, "file_name"));
    }

    @Override
    public ProviderEntry getEntry(int entryId, int column) {
        if (column == 0) {
            return new NormalFileName((UTF8String)((CalledOpenFileStatistic)this.statistic).getKey(entryId));
        }
        return ProviderUtils.getEntry(entryId, column - 1, (SelfAndTotalValueStatistic)this.statistic, (IOProvider)this);
    }

    @Override
    public Column getColumn(int columnIndex) {
        if (columnIndex == 0) {
            return ((CalledOpenFileStatistic)this.statistic).getKeyColumn();
        }
        return ProviderUtils.getColumn(columnIndex - 1, (SelfAndTotalValueStatistic)this.statistic);
    }

    @Override
    protected ResourceName getStatisticName() {
        Elements.CreateCalledOpenFileStatisticProvider createElement = (Elements.CreateCalledOpenFileStatisticProvider)this.getResourceName().getLastElement();
        ResourceName filterName = createElement.getName();
        return this.getResourceName().stripLastElement().addElement((ResourceNameElement)new Elements.CreateCalledOpenFileStatistic(filterName));
    }
}

