/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.presentation.impl.typed.io;

import com.sap.jvm.profiling.i18n.I18n;
import com.sap.jvm.profiling.presentation.impl.typed.io.IOProvider;
import com.sap.jvm.profiling.presentation.impl.typed.io.IOTableProvider;
import com.sap.jvm.profiling.presentation.impl.typed.io.ProviderUtils;
import com.sap.jvm.profiling.presentation.typed.entries.NormalFileId;
import com.sap.jvm.profiling.presentation.typed.entries.ProviderEntry;
import com.sap.jvm.profiling.resource.ResourceName;
import com.sap.jvm.profiling.resource.ResourceNameElement;
import com.sap.jvm.profiling.snapshot.io.DetailedFileStatistic;
import com.sap.jvm.profiling.snapshot.io.Elements;
import com.sap.jvm.profiling.snapshot.resource.FileId;
import com.sap.jvm.profiling.snapshot.util.ValueStatistic;
import com.sap.jvm.profiling.snapshot.util.column.Column;

public final class DetailedFileStatisticProvider
extends IOTableProvider<DetailedFileStatistic> {
    public DetailedFileStatisticProvider(ResourceName name) {
        super(name, I18n._ts((I18n.TextType)I18n.TextType.XTBS, (String)"Files (Detailed)"), "views/io_file_statistic.png", ProviderUtils.getDetailedFileStatisticSpec(name).prepend(I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"ID"), I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"A unique ID for the file access"), 73, NormalFileId.class, "file_id"));
    }

    @Override
    public ProviderEntry getEntry(int entryId, int column) {
        if (column == 0) {
            return new NormalFileId(((FileId)((DetailedFileStatistic)this.statistic).getKey(entryId)).getId(), ((FileId)((DetailedFileStatistic)this.statistic).getKey(entryId)).getIndex());
        }
        return ProviderUtils.getEntryDetailed(entryId, column - 1, (ValueStatistic)this.statistic, (IOProvider)this);
    }

    @Override
    public Column getColumn(int columnIndex) {
        if (columnIndex == 0) {
            return ((DetailedFileStatistic)this.statistic).getKeyColumn();
        }
        return ProviderUtils.getColumnDetailed(columnIndex - 1, (ValueStatistic)this.statistic);
    }

    @Override
    protected ResourceName getStatisticName() {
        return this.getResourceName().stripLastElement().addElement((ResourceNameElement)new Elements.CreateDetailedFileStatistic());
    }
}

