/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.presentation.impl.typed.io;

import com.sap.jvm.profiling.i18n.I18n;
import com.sap.jvm.profiling.presentation.impl.typed.SumBehavior;
import com.sap.jvm.profiling.presentation.impl.typed.io.IOProvider;
import com.sap.jvm.profiling.presentation.typed.TypedColumnSpec;
import com.sap.jvm.profiling.presentation.typed.VisibilitySet;
import com.sap.jvm.profiling.presentation.typed.entries.ElapsedTime;
import com.sap.jvm.profiling.presentation.typed.entries.FileDescriptor;
import com.sap.jvm.profiling.presentation.typed.entries.NormalThreadId;
import com.sap.jvm.profiling.presentation.typed.entries.NormalThreadName;
import com.sap.jvm.profiling.presentation.typed.entries.NrOfBytes;
import com.sap.jvm.profiling.presentation.typed.entries.NrOfBytesPerSecond;
import com.sap.jvm.profiling.presentation.typed.entries.NrOfClosedFiles;
import com.sap.jvm.profiling.presentation.typed.entries.NrOfInvocations;
import com.sap.jvm.profiling.presentation.typed.entries.NrOfOpenedFiles;
import com.sap.jvm.profiling.presentation.typed.entries.ProviderEntry;
import com.sap.jvm.profiling.presentation.typed.entries.Quantity;
import com.sap.jvm.profiling.presentation.typed.entries.Timestamp;
import com.sap.jvm.profiling.resource.ResourceName;
import com.sap.jvm.profiling.snapshot.io.IODetails;
import com.sap.jvm.profiling.snapshot.io.IODetailsColumn;
import com.sap.jvm.profiling.snapshot.io.IOOperations;
import com.sap.jvm.profiling.snapshot.io.IOOperationsAndDetails;
import com.sap.jvm.profiling.snapshot.io.IOOperationsAndDetailsColumn;
import com.sap.jvm.profiling.snapshot.io.IOOperationsColumn;
import com.sap.jvm.profiling.snapshot.util.SelfAndTotalValueStatistic;
import com.sap.jvm.profiling.snapshot.util.SelfAndTotalValueTreeNode;
import com.sap.jvm.profiling.snapshot.util.SelfTotalAndOtherValueStatistic;
import com.sap.jvm.profiling.snapshot.util.ValueStatistic;
import com.sap.jvm.profiling.snapshot.util.ValueTreeBase;
import com.sap.jvm.profiling.snapshot.util.column.Column;

public final class ProviderUtils {
    private static final long INVALID = 0L;

    public static TypedColumnSpec getFileStatisticSpec(ResourceName name) {
        VisibilitySet openCount = new VisibilitySet("OpenCount", "Group_1", I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Open Count"), "tables/col_nr_of.gif", I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"Number of open operations"), new Integer[0]);
        VisibilitySet closeCount = new VisibilitySet("CloseCount", "Group_1", I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Close Count"), "tables/col_nr_of.gif", I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"Number of close operations"), new Integer[0]);
        VisibilitySet bytes = new VisibilitySet("Bytes", "Group_2", I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Bytes"), "tables/col_bytes.gif", I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"Number of read or written bytes"), new Integer[0]);
        VisibilitySet time = new VisibilitySet("Time", "Group_2", I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Time"), "tables/col_time.gif", I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"Duration of read or write operations"), new Integer[0]);
        VisibilitySet ops = new VisibilitySet("Operations", "Group_2", I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Operations"), "tables/column.gif", I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"Number of read or write operations"), new Integer[0]);
        VisibilitySet flow = new VisibilitySet("Throughput", "Group_2", I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Throughput"), "tables/column.gif", I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"Throughput of read or write operations"), new Integer[0]);
        VisibilitySet avgBytes = new VisibilitySet("AverageBytes", "Group_2", I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Average Bytes"), "tables/col_bytes.gif", I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"Average number of read or written bytes"), new Integer[0]);
        VisibilitySet avgDuration = new VisibilitySet("AverageDuration", "Group_2", I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Average Duration"), "tables/col_time.gif", I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"Average duration of read or write operations"), new Integer[0]);
        VisibilitySet read = new VisibilitySet("Read", "Group_3", I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Read"), "tables/col_read_bytes.gif", I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"Columns linked to reading operations"), new Integer[0]);
        VisibilitySet write = new VisibilitySet("Write", "Group_3", I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Write"), "tables/col_write_bytes.gif", I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"Columns linked to writing operations"), new Integer[0]);
        TypedColumnSpec spec = new TypedColumnSpec("Read|Write|OpenCount|Bytes|Time");
        spec.appendColumn(I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Opened"), I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"The number of times this file was opened"), 45318, NrOfOpenedFiles.class, "nr_opened_files", openCount);
        spec.appendColumn(I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Closed"), I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"The number of times this file was closed"), 45062, NrOfClosedFiles.class, "nr_closed_files", closeCount);
        spec.appendColumn(I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Read Bytes"), I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"The total number of bytes read from this file"), 45062, NrOfBytes.class, "read_bytes", bytes, read);
        spec.appendColumn(I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Written Bytes"), I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"The total number of bytes written to this file"), 45062, NrOfBytes.class, "written_bytes", bytes, write);
        spec.appendColumn(I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Read Time"), I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"The total time spent in reading from this file"), 45062, ElapsedTime.class, "elapsed_time_reading_nanoseconds", time, read);
        spec.appendColumn(I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Write Time"), I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"The total time spent in writing bytes to this file"), 45062, ElapsedTime.class, "elapsed_time_writing_nanoseconds", time, write);
        spec.appendColumn(I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Read Operations"), I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"The total number of read operations to this file"), 45062, NrOfInvocations.class, "nr_read_operations", ops, read);
        spec.appendColumn(I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Write Operations"), I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"The total number of write operations to this file"), 45062, NrOfInvocations.class, "nr_write_operations", ops, write);
        spec.appendColumn(I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Read Throughput"), I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"The throughput of the read operations to this file"), 12290, NrOfBytesPerSecond.class, "throughput_read_operations_bytes_per_second", flow, read);
        spec.appendColumn(I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Write Throughput"), I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"The throughput of the write operations to this file"), 12290, NrOfBytesPerSecond.class, "throughput_write_operations_bytes_per_second", flow, write);
        spec.appendColumn(I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Avg Read Bytes"), I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"The average number of bytes read from this file"), 12290, NrOfBytes.class, "read_bytes_average", avgBytes, read);
        spec.appendColumn(I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Avg Written Bytes"), I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"The average number of bytes written to this file"), 12290, NrOfBytes.class, "written_bytes_average", avgBytes, write);
        spec.appendColumn(I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Avg Read Duration"), I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"The average time of read operations to this file"), 12290, ElapsedTime.class, "reading_operation_average_time_nanoseconds", avgDuration, read);
        spec.appendColumn(I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Avg Write Duration"), I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"The average time of write operations to this file"), 12290, ElapsedTime.class, "writing_operation_average_time_nanoseconds", avgDuration, write);
        return spec;
    }

    public static TypedColumnSpec getDetailedFileStatisticSpec(ResourceName name) {
        VisibilitySet fd = new VisibilitySet("FD", "Group_1", I18n._tss((I18n.TextType)I18n.TextType.XCOL, (String)"short for file descriptor", (String)"FD"), "tables/column.gif", I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"File Descriptor"), new Integer[0]);
        VisibilitySet bytes = new VisibilitySet("Bytes", "Group_2", I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Bytes"), "tables/col_bytes.gif", I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"Number of read or written bytes"), new Integer[0]);
        VisibilitySet time = new VisibilitySet("Time", "Group_2", I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Time"), "tables/col_time.gif", I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"Duration of read or write operations"), new Integer[0]);
        VisibilitySet ops = new VisibilitySet("Operations", "Group_2", I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Operations"), "tables/column.gif", I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"Number of read or write operations"), new Integer[0]);
        VisibilitySet flow = new VisibilitySet("Throughput", "Group_2", I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Throughput"), "tables/column.gif", I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"Throughput of read or write operations"), new Integer[0]);
        VisibilitySet avgBytes = new VisibilitySet("AverageBytes", "Group_2", I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Average Bytes"), "tables/col_bytes.gif", I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"Average number of read or written bytes"), new Integer[0]);
        VisibilitySet avgDuration = new VisibilitySet("AverageDuration", "Group_2", I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Average Duration"), "tables/col_time.gif", I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"Average duration of read or write operations"), new Integer[0]);
        VisibilitySet openTs = new VisibilitySet("OpenTimestamp", "Group_3", I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Open Timestamp"), "decorators/dates.gif", I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"Open timestamp"), new Integer[0]);
        VisibilitySet closeTs = new VisibilitySet("CloseTimestamp", "Group_3", I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Close Timestamp"), "decorators/dates.gif", I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"Close timestamp"), new Integer[0]);
        VisibilitySet openThread = new VisibilitySet("OpeningThread", "Group_4", I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Opening Thread"), "views/thread_statistic.gif", I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"Opening thread"), new Integer[0]);
        VisibilitySet closeThread = new VisibilitySet("ClosingThread", "Group_4", I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Closing Thread"), "views/thread_statistic.gif", I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"Closing thread"), new Integer[0]);
        VisibilitySet read = new VisibilitySet("Read", "Group_5", I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Read"), "tables/col_read_bytes.gif", I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"Columns linked to reading operations"), 1, 3, 5, 7, 9, 11);
        VisibilitySet write = new VisibilitySet("Write", "Group_5", I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Write"), "tables/col_write_bytes.gif", I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"Columns linked to writing operations"), 2, 4, 6, 8, 10, 12);
        TypedColumnSpec spec = new TypedColumnSpec("Read|Write|Bytes|Time|OpeningThread");
        spec.appendColumn(I18n._tss((I18n.TextType)I18n.TextType.XCOL, (String)"short for file descriptor", (String)"FD"), I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"The file descriptor"), 8194, FileDescriptor.class, "file_descriptor", fd);
        spec.appendColumn(I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Read Bytes"), I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"The total number of bytes read from this file"), 45318, NrOfBytes.class, "read_bytes", bytes, read);
        spec.appendColumn(I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Written Bytes"), I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"The total number of bytes written to this file"), 45062, NrOfBytes.class, "written_bytes", bytes, write);
        spec.appendColumn(I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Read Time"), I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"The total time spent in reading from this file"), 45062, ElapsedTime.class, "elapsed_time_reading_nanoseconds", time, read);
        spec.appendColumn(I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Write Time"), I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"The total time spent in writing bytes to this file"), 45062, ElapsedTime.class, "elapsed_time_writing_nanoseconds", time, write);
        spec.appendColumn(I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Read Operations"), I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"The total number of read operations to this file"), 45062, NrOfInvocations.class, "nr_read_operations", ops, read);
        spec.appendColumn(I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Write Operations"), I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"The total number of write operations to this file"), 45062, NrOfInvocations.class, "nr_write_operations", ops, write);
        spec.appendColumn(I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Read Throughput"), I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"The throughput of the read operations to this file"), 12290, NrOfBytesPerSecond.class, "throughput_read_operations_bytes_per_second", flow, read);
        spec.appendColumn(I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Write Throughput"), I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"The throughput of the write operations to this file"), 12290, NrOfBytesPerSecond.class, "throughput_write_operations_bytes_per_second", flow, write);
        spec.appendColumn(I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Avg Read Bytes"), I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"The average number of bytes read from this file"), 12290, NrOfBytes.class, "read_bytes_average", avgBytes, read);
        spec.appendColumn(I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Avg Written Bytes"), I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"The average number of bytes written to this file"), 12290, NrOfBytes.class, "written_bytes_average", avgBytes, write);
        spec.appendColumn(I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Avg Read Duration"), I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"The average time of read operations to this file"), 12290, ElapsedTime.class, "reading_operation_average_time_nanoseconds", avgDuration, read);
        spec.appendColumn(I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Avg Write Duration"), I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"The average time of write operations to this file"), 12290, ElapsedTime.class, "writing_operation_average_time_nanoseconds", avgDuration, write);
        spec.appendColumn(I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Opened At"), I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"Timestamp when the file was opened"), 8194, Timestamp.class, "timestamp_file_opened_milliseconds_since_midnight_1970-01-01_UTC", openTs);
        spec.appendColumn(I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Closed At"), I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"Timestamp when the file was closed"), 8194, Timestamp.class, "timestamp_file_closed_milliseconds_since_midnight_1970-01-01_UTC", closeTs);
        spec.appendColumn(I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Opening Thread ID"), I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"The id of the thread which opened the file."), 2, NormalThreadId.class, "opening_thread_id", openThread);
        spec.appendColumn(I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Opening Thread Name"), I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"One name of the thread which opened the file."), 2, NormalThreadName.class, "opening_thread_name", openThread);
        spec.appendColumn(I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Closing Thread ID"), I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"The id of the thread which closed the file."), 2, NormalThreadId.class, "closing_thread_id", closeThread);
        spec.appendColumn(I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Closing Thread Name"), I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"One name of the thread which closed the file."), 2, NormalThreadName.class, "closing_thread_name", closeThread);
        return spec;
    }

    public static TypedColumnSpec getSelfAndTotalSpec(ResourceName name, boolean sortBySelf, SumBehavior sumBehavior, String entity) {
        int sumSelf = sumBehavior.sumSelf() ? 4100 : 4096;
        int sumTotal = sumBehavior.sumTotal() ? 4100 : 4096;
        VisibilitySet openCount = new VisibilitySet("OpenCount", "Group_1", I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Open Count"), "tables/col_nr_of.gif", I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"Number of open operations"), new Integer[0]);
        VisibilitySet closeCount = new VisibilitySet("CloseCount", "Group_1", I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Close Count"), "tables/col_nr_of.gif", I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"Number of close operations"), new Integer[0]);
        VisibilitySet bytes = new VisibilitySet("Bytes", "Group_2", I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Bytes"), "tables/col_bytes.gif", I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"Number of read or written bytes"), new Integer[0]);
        VisibilitySet time = new VisibilitySet("Time", "Group_2", I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Time"), "tables/col_time.gif", I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"Duration of read or write operations"), new Integer[0]);
        VisibilitySet ops = new VisibilitySet("Operations", "Group_2", I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Operations"), "tables/column.gif", I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"Number of read or write operations"), new Integer[0]);
        VisibilitySet flow = new VisibilitySet("Throughput", "Group_2", I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Throughput"), "tables/column.gif", I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"Throughput of read or write operations"), new Integer[0]);
        VisibilitySet avgBytes = new VisibilitySet("AverageBytes", "Group_2", I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Average Bytes"), "tables/col_bytes.gif", I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"Average number of read or written bytes"), new Integer[0]);
        VisibilitySet avgDuration = new VisibilitySet("AverageDuration", "Group_2", I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Average Duration"), "tables/col_time.gif", I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"Average duration of read or write operations"), new Integer[0]);
        VisibilitySet read = new VisibilitySet("Read", "Group_3", I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Read"), "tables/col_read_bytes.gif", I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"Columns linked to reading operations"), new Integer[0]);
        VisibilitySet write = new VisibilitySet("Write", "Group_3", I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Write"), "tables/col_write_bytes.gif", I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"Columns linked to writing operations"), new Integer[0]);
        VisibilitySet self = new VisibilitySet("Self", "Group_4", I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Self"), "tables/col_self_nr_of.gif", I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"Self"), new Integer[0]);
        VisibilitySet total = new VisibilitySet("Total", "Group_4", I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Total"), "tables/col_total_nr_of.gif", I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"Total"), new Integer[0]);
        TypedColumnSpec spec = new TypedColumnSpec("Read|Write|Self|Total|Bytes|Time");
        spec.appendColumn(I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Self Opened"), I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"The total number of files directly opened within {0}", (Object[])new Object[]{entity}), 0x2002 | sumSelf | 0x8000, NrOfOpenedFiles.class, "self_nr_opened_files", openCount, self);
        spec.appendColumn(I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Total Opened"), I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"The total number of files opened within {0}", (Object[])new Object[]{entity}), 0x2002 | sumTotal | 0x8000, NrOfOpenedFiles.class, "total_nr_opened_files", openCount, total);
        spec.appendColumn(I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Self Closed"), I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"The total number of files directly closed within {0}", (Object[])new Object[]{entity}), 0x2002 | sumSelf | 0x8000, NrOfClosedFiles.class, "self_nr_closed_files", closeCount, self);
        spec.appendColumn(I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Total Closed"), I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"The total number of files closed within {0}", (Object[])new Object[]{entity}), 0x2002 | sumTotal | 0x8000, NrOfClosedFiles.class, "total_nr_closed_files", closeCount, total);
        spec.appendColumn(I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Self Read Bytes"), I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"The total number of bytes directly read within {0}", (Object[])new Object[]{entity}), 2 | (sortBySelf ? 256 : 0) | 0x2000 | sumSelf | 0x8000, NrOfBytes.class, "self_read_bytes", bytes, read, self);
        spec.appendColumn(I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Total Read Bytes"), I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"The total number of bytes read within {0}", (Object[])new Object[]{entity}), 2 | (sortBySelf ? 0 : 256) | 0x2000 | sumTotal | 0x8000, NrOfBytes.class, "total_read_bytes", bytes, read, total);
        spec.appendColumn(I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Self Written Bytes"), I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"The total number of bytes directly written by {0}", (Object[])new Object[]{entity}), 0x2002 | sumSelf | 0x8000, NrOfBytes.class, "self_written_bytes", bytes, write, self);
        spec.appendColumn(I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Total Written Bytes"), I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"The total number of bytes written by {0}", (Object[])new Object[]{entity}), 0x2002 | sumTotal | 0x8000, NrOfBytes.class, "total_written_bytes", bytes, write, total);
        spec.appendColumn(I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Self Read Time"), I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"The total time directly spent in {0} for reading bytes", (Object[])new Object[]{entity}), 0x2002 | sumSelf | 0x8000, ElapsedTime.class, "self_elapsed_time_reading_nanoseconds", time, read, self);
        spec.appendColumn(I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Total Read Time"), I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"The total time spent in {0} for reading bytes", (Object[])new Object[]{entity}), 0x2002 | sumTotal | 0x8000, ElapsedTime.class, "total_elapsed_time_reading_nanoseconds", time, read, total);
        spec.appendColumn(I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Self Write Time"), I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"The total time directly spent in {0} for writing bytes", (Object[])new Object[]{entity}), 0x2002 | sumSelf | 0x8000, ElapsedTime.class, "self_elapsed_time_writing_nanoseconds", time, write, self);
        spec.appendColumn(I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Total Write Time"), I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"The total time spent in {0} for writing bytes", (Object[])new Object[]{entity}), 0x2002 | sumTotal | 0x8000, ElapsedTime.class, "total_elapsed_time_writing_nanoseconds", time, write, total);
        spec.appendColumn(I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Self Read Operations"), I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"The total number of read operations performed directly in {0}", (Object[])new Object[]{entity}), 0x2002 | sumSelf | 0x8000, NrOfInvocations.class, "self_nr_read_operations", ops, read, self);
        spec.appendColumn(I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Total Read Operations"), I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"The total number of read operations performed in {0}", (Object[])new Object[]{entity}), 0x2002 | sumTotal | 0x8000, NrOfInvocations.class, "total_nr_read_operations", ops, read, total);
        spec.appendColumn(I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Self Write Operations"), I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"The total number of write operations performed directly in {0}", (Object[])new Object[]{entity}), 0x2002 | sumSelf | 0x8000, NrOfInvocations.class, "self_nr_write_operations", ops, write, self);
        spec.appendColumn(I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Total Write Operations"), I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"The total number of write operations performed in {0}", (Object[])new Object[]{entity}), 0x2002 | sumTotal | 0x8000, NrOfInvocations.class, "total_nr_write_operations", ops, write, total);
        spec.appendColumn(I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Self Read Throughput"), I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"The throughput of read operations directly performed in {0}", (Object[])new Object[]{entity}), 12290, NrOfBytesPerSecond.class, "self_throughput_read_operations_bytes_per_second", flow, read, self);
        spec.appendColumn(I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Total Read Throughput"), I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"The throughput of read operations performed in {0}", (Object[])new Object[]{entity}), 12290, NrOfBytesPerSecond.class, "total_throughput_read_operations_bytes_per_second", flow, read, total);
        spec.appendColumn(I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Self Write Throughput"), I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"The throughput of write operations directly performed in {0}", (Object[])new Object[]{entity}), 12290, NrOfBytesPerSecond.class, "self_throughput_write_operations_bytes_per_second", flow, write, self);
        spec.appendColumn(I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Total Write Throughput"), I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"The throughput of write operations performed in {0}", (Object[])new Object[]{entity}), 12290, NrOfBytesPerSecond.class, "total_throughput_write_operations_bytes_per_second", flow, write, total);
        spec.appendColumn(I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Self Avg Read Bytes"), I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"The average number of bytes directly read in {0}", (Object[])new Object[]{entity}), 12290, NrOfBytes.class, "self_read_bytes_average", avgBytes, read, self);
        spec.appendColumn(I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Total Avg Read Bytes"), I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"The average number of bytes read in {0}", (Object[])new Object[]{entity}), 12290, NrOfBytes.class, "total_read_bytes_average", avgBytes, read, total);
        spec.appendColumn(I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Self Avg Written Bytes"), I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"The average number of bytes directly written in {0}", (Object[])new Object[]{entity}), 12290, NrOfBytes.class, "self_written_bytes_average", avgBytes, write, self);
        spec.appendColumn(I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Total Avg Written Bytes"), I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"The average number of bytes written in {0}", (Object[])new Object[]{entity}), 12290, NrOfBytes.class, "total_written_bytes_average", avgBytes, write, total);
        spec.appendColumn(I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Self Avg Read Duration"), I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"The average duration of read operations directly performed in {0}", (Object[])new Object[]{entity}), 12290, ElapsedTime.class, "self_reading_operation_average_time_nanoseconds", avgDuration, read, self);
        spec.appendColumn(I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Total Avg Read Duration"), I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"The average duration of read operations performed in {0}", (Object[])new Object[]{entity}), 12290, ElapsedTime.class, "total_reading_operation_average_time_nanoseconds", avgDuration, read, total);
        spec.appendColumn(I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Self Avg Write Duration"), I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"The average duration of write operations directly performed in {0}", (Object[])new Object[]{entity}), 12290, ElapsedTime.class, "self_writing_operation_average_time_nanoseconds", avgDuration, write, self);
        spec.appendColumn(I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Total Avg Write Duration"), I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"The average duration of write operations performed in {0}", (Object[])new Object[]{entity}), 12290, ElapsedTime.class, "total_writing_operation_average_time_nanoseconds", avgDuration, write, total);
        return spec;
    }

    public static TypedColumnSpec getSelfAndTotalDetailedSpec(ResourceName name, boolean sortBySelf, SumBehavior sumBehavior, String entity) {
        int sumSelf = sumBehavior.sumSelf() ? 4100 : 4096;
        int sumTotal = sumBehavior.sumTotal() ? 4100 : 4096;
        VisibilitySet fd = new VisibilitySet("FD", "Group_1", I18n._tss((I18n.TextType)I18n.TextType.XCOL, (String)"short for file descriptor", (String)"FD"), "tables/column.gif", I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"File Descriptor"), new Integer[0]);
        VisibilitySet bytes = new VisibilitySet("Bytes", "Group_2", I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Bytes"), "tables/col_bytes.gif", I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"Number of read or written bytes"), new Integer[0]);
        VisibilitySet time = new VisibilitySet("Time", "Group_2", I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Time"), "tables/col_time.gif", I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"Duration of read or write operations"), new Integer[0]);
        VisibilitySet ops = new VisibilitySet("Operations", "Group_2", I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Operations"), "tables/column.gif", I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"Number of read or write operations"), new Integer[0]);
        VisibilitySet flow = new VisibilitySet("Throughput", "Group_2", I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Throughput"), "tables/column.gif", I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"Throughput of read or write operations"), new Integer[0]);
        VisibilitySet avgBytes = new VisibilitySet("AverageBytes", "Group_2", I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Average Bytes"), "tables/col_bytes.gif", I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"Average number of read or written bytes"), new Integer[0]);
        VisibilitySet avgDuration = new VisibilitySet("AverageDuration", "Group_2", I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Average Duration"), "tables/col_time.gif", I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"Average duration of read or write operations"), new Integer[0]);
        VisibilitySet openTs = new VisibilitySet("OpenTimestamp", "Group_3", I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Open Timestamp"), "decorators/dates.gif", I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"Open timestamp"), new Integer[0]);
        VisibilitySet closeTs = new VisibilitySet("CloseTimestamp", "Group_3", I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Close Timestamp"), "decorators/dates.gif", I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"Close timestamp"), new Integer[0]);
        VisibilitySet openThread = new VisibilitySet("OpeningThread", "Group_4", I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Opening Thread"), "views/thread_statistic.gif", I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"Opening thread"), new Integer[0]);
        VisibilitySet closeThread = new VisibilitySet("ClosingThread", "Group_4", I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Closing Thread"), "views/thread_statistic.gif", I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"Closing thread"), new Integer[0]);
        VisibilitySet read = new VisibilitySet("Read", "Group_5", I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Read"), "tables/col_read_bytes.gif", I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"Columns linked to reading operations"), new Integer[0]);
        VisibilitySet write = new VisibilitySet("Write", "Group_5", I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Write"), "tables/col_write_bytes.gif", I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"Columns linked to writing operations"), new Integer[0]);
        VisibilitySet self = new VisibilitySet("Self", "Group_6", I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Self"), "tables/col_self_nr_of.gif", I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"Self"), new Integer[0]);
        VisibilitySet total = new VisibilitySet("Total", "Group_6", I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Total"), "tables/col_total_nr_of.gif", I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"Total"), new Integer[0]);
        TypedColumnSpec spec = new TypedColumnSpec("Read|Write|Self|Total|Bytes|Time|OpeningThread");
        spec.appendColumn(I18n._tss((I18n.TextType)I18n.TextType.XCOL, (String)"short for file descriptor", (String)"FD"), I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"The file descriptor"), 8194, FileDescriptor.class, "file_descriptor", fd);
        spec.appendColumn(I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Self Read Bytes"), I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"The total number of bytes directly read within {0}", (Object[])new Object[]{entity}), 0x2002 | sumSelf | (sortBySelf ? 256 : 0) | 0x8000, NrOfBytes.class, "self_read_bytes", bytes, read, self);
        spec.appendColumn(I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Total Read Bytes"), I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"The total number of bytes read within {0}", (Object[])new Object[]{entity}), 0x2002 | sumTotal | (sortBySelf ? 0 : 256) | 0x8000, NrOfBytes.class, "total_read_bytes", bytes, read, total);
        spec.appendColumn(I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Self Written Bytes"), I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"The total number of bytes directly written by {0}", (Object[])new Object[]{entity}), 0x2002 | sumSelf | 0x8000, NrOfBytes.class, "self_written_bytes", bytes, write, self);
        spec.appendColumn(I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Total Written Bytes"), I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"The total number of bytes written by {0}", (Object[])new Object[]{entity}), 0x2002 | sumTotal | 0x8000, NrOfBytes.class, "total_written_bytes", bytes, write, total);
        spec.appendColumn(I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Self Read Time"), I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"The total time directly spent in {0} for reading bytes", (Object[])new Object[]{entity}), 0x2002 | sumSelf | 0x8000, ElapsedTime.class, "self_elapsed_time_reading_nanoseconds", time, read, self);
        spec.appendColumn(I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Total Read Time"), I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"The total time spent in {0} for reading bytes", (Object[])new Object[]{entity}), 0x2002 | sumTotal | 0x8000, ElapsedTime.class, "total_elapsed_time_reading_nanoseconds", time, read, total);
        spec.appendColumn(I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Self Write Time"), I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"The total time directly spent in {0} for writing bytes", (Object[])new Object[]{entity}), 0x2002 | sumSelf | 0x8000, ElapsedTime.class, "self_elapsed_time_writing_nanoseconds", time, write, self);
        spec.appendColumn(I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Total Write Time"), I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"The total time spent in {0} for writing bytes", (Object[])new Object[]{entity}), 0x2002 | sumTotal | 0x8000, ElapsedTime.class, "total_elapsed_time_writing_nanoseconds", time, write, total);
        spec.appendColumn(I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Self Read Operations"), I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"The total number of read operations performed directly in {0}", (Object[])new Object[]{entity}), 0x2002 | sumSelf | 0x8000, NrOfInvocations.class, "self_nr_read_operations", ops, read, self);
        spec.appendColumn(I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Total Read Operations"), I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"The total number of read operations performed in {0}", (Object[])new Object[]{entity}), 0x2002 | sumTotal | 0x8000, NrOfInvocations.class, "total_nr_read_operations", ops, read, total);
        spec.appendColumn(I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Self Write Operations"), I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"The total number of write operations performed directly in {0}", (Object[])new Object[]{entity}), 0x2002 | sumSelf | 0x8000, NrOfInvocations.class, "self_nr_write_operations", ops, write, self);
        spec.appendColumn(I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Total Write Operations"), I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"The total number of write operations performed in {0}", (Object[])new Object[]{entity}), 0x2002 | sumTotal | 0x8000, NrOfInvocations.class, "total_nr_write_operations", ops, write, total);
        spec.appendColumn(I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Self Read Throughput"), I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"The throughput of read operations directly performed in {0}", (Object[])new Object[]{entity}), 12290, NrOfBytesPerSecond.class, "self_throughput_read_operations_bytes_per_second", flow, read, self);
        spec.appendColumn(I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Total Read Throughput"), I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"The throughput of read operations performed in {0}", (Object[])new Object[]{entity}), 12290, NrOfBytesPerSecond.class, "total_throughput_read_operations_bytes_per_second", flow, read, total);
        spec.appendColumn(I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Self Write Throughput"), I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"The throughput of write operations directly performed in {0}", (Object[])new Object[]{entity}), 12290, NrOfBytesPerSecond.class, "self_throughput_write_operations_bytes_per_second", flow, write, self);
        spec.appendColumn(I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Total Write Throughput"), I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"The throughput of write operations performed in {0}", (Object[])new Object[]{entity}), 12290, NrOfBytesPerSecond.class, "total_throughput_write_operations_bytes_per_second", flow, write, total);
        spec.appendColumn(I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Self Avg Read Bytes"), I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"The average number of bytes directly read in {0}", (Object[])new Object[]{entity}), 12290, NrOfBytes.class, "self_read_bytes_average", avgBytes, read, self);
        spec.appendColumn(I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Total Avg Read Bytes"), I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"The average number of bytes read in {0}", (Object[])new Object[]{entity}), 12290, NrOfBytes.class, "total_read_bytes_average", avgBytes, read, total);
        spec.appendColumn(I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Self Avg Written Bytes"), I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"The average number of bytes directly written in {0}", (Object[])new Object[]{entity}), 12290, NrOfBytes.class, "self_written_bytes_average", avgBytes, write, self);
        spec.appendColumn(I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Total Avg Written Bytes"), I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"The average number of bytes written in {0}", (Object[])new Object[]{entity}), 12290, NrOfBytes.class, "total_written_bytes_average", avgBytes, write, total);
        spec.appendColumn(I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Self Avg Read Duration"), I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"The average duration of read operations directly performed in {0}", (Object[])new Object[]{entity}), 12290, ElapsedTime.class, "self_reading_operation_average_time_nanoseconds", avgDuration, read, self);
        spec.appendColumn(I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Total Avg Read Duration"), I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"The average duration of read operations performed in {0}", (Object[])new Object[]{entity}), 12290, ElapsedTime.class, "total_reading_operation_average_time_nanoseconds", avgDuration, read, total);
        spec.appendColumn(I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Self Avg Write Duration"), I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"The average duration of write operations directly performed in {0}", (Object[])new Object[]{entity}), 12290, ElapsedTime.class, "self_writing_operation_average_time_nanoseconds", avgDuration, write, self);
        spec.appendColumn(I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Total Avg Write Duration"), I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"The average duration of write operations performed in {0}", (Object[])new Object[]{entity}), 12290, ElapsedTime.class, "total_writing_operation_average_time_nanoseconds", avgDuration, write, total);
        spec.appendColumn(I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Opened At"), I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"Timestamp when the file was opened"), 8194, Timestamp.class, "timestamp_file_opened_milliseconds_since_midnight_1970-01-01_UTC", openTs);
        spec.appendColumn(I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Closed At"), I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"Timestamp when the file was closed"), 8194, Timestamp.class, "timestamp_file_closed_milliseconds_since_midnight_1970-01-01_UTC", closeTs);
        spec.appendColumn(I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Opening Thread ID"), I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"The id of the thread which opened the file."), 2, NormalThreadId.class, "opening_thread_id", openThread);
        spec.appendColumn(I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Opening Thread Name"), I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"One name of the thread which opened the file."), 2, NormalThreadName.class, "opening_thread_name", openThread);
        spec.appendColumn(I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Closing Thread ID"), I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"The id of the thread which closed the file."), 2, NormalThreadId.class, "closing_thread_id", closeThread);
        spec.appendColumn(I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Closing Thread Name"), I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"One name of the thread which closed the file."), 2, NormalThreadName.class, "closing_thread_name", closeThread);
        return spec;
    }

    public static TypedColumnSpec getIOStatisticBaseSpec(ResourceName name, String entity) {
        VisibilitySet openCount = new VisibilitySet("OpenCount", "Group_1", I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Open Count"), "tables/col_nr_of.gif", I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"Number of open operations"), new Integer[0]);
        VisibilitySet closeCount = new VisibilitySet("CloseCount", "Group_1", I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Close Count"), "tables/col_nr_of.gif", I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"Number of close operations"), 1);
        VisibilitySet bytes = new VisibilitySet("Bytes", "Group_2", I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Bytes"), "tables/col_bytes.gif", I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"Number of read or written bytes"), 2, 3);
        VisibilitySet time = new VisibilitySet("Time", "Group_2", I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Time"), "tables/col_time.gif", I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"Duration of read or write operations"), 4, 5);
        VisibilitySet ops = new VisibilitySet("Operations", "Group_2", I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Operations"), "tables/column.gif", I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"Number of read or write operations"), 6, 7);
        VisibilitySet flow = new VisibilitySet("Throughput", "Group_2", I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Throughput"), "tables/column.gif", I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"Throughput of read or write operations"), 8, 9);
        VisibilitySet avgBytes = new VisibilitySet("AverageBytes", "Group_2", I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Average Bytes"), "tables/col_bytes.gif", I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"Average number of read or written bytes"), 10, 11);
        VisibilitySet avgDuration = new VisibilitySet("AverageDuration", "Group_2", I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Average Duration"), "tables/col_time.gif", I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"Average duration of read or write operations"), 12, 13);
        VisibilitySet read = new VisibilitySet("Read", "Group_3", I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Read"), "tables/col_read_bytes.gif", I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"Columns linked to reading operations"), 2, 4, 6, 8, 10, 12);
        VisibilitySet write = new VisibilitySet("Write", "Group_3", I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Write"), "tables/col_write_bytes.gif", I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"Columns linked to writing operations"), 3, 5, 7, 9, 11, 13);
        TypedColumnSpec spec = new TypedColumnSpec("Read|Write|OpenCount|Bytes|Time");
        spec.appendColumn(I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Opened"), I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"The number of times a file was opened by {0}", (Object[])new Object[]{entity}), 45318, NrOfOpenedFiles.class, "nr_opened_files", openCount);
        spec.appendColumn(I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Closed"), I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"The number of times a file was closed by {0}", (Object[])new Object[]{entity}), 45062, NrOfClosedFiles.class, "nr_closed_files", closeCount);
        spec.appendColumn(I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Read Bytes"), I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"The total number of bytes read by {0}", (Object[])new Object[]{entity}), 45062, NrOfBytes.class, "read_bytes", bytes, read);
        spec.appendColumn(I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Written Bytes"), I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"The total number of bytes written by {0}", (Object[])new Object[]{entity}), 45062, NrOfBytes.class, "written_bytes", bytes, write);
        spec.appendColumn(I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Read Time"), I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"The total time spent in reading files by {0}", (Object[])new Object[]{entity}), 45062, ElapsedTime.class, "elapsed_time_reading_nanoseconds", time, read);
        spec.appendColumn(I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Write Time"), I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"The total time spent in writing files by {0}", (Object[])new Object[]{entity}), 45062, ElapsedTime.class, "elapsed_time_writing_nanoseconds", time, write);
        spec.appendColumn(I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Read Operations"), I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"The total number of read operations performed by {0}", (Object[])new Object[]{entity}), 45062, NrOfInvocations.class, "nr_read_operations", ops, read);
        spec.appendColumn(I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Write Operations"), I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"The total number of write operations performed by {0}", (Object[])new Object[]{entity}), 45062, NrOfInvocations.class, "nr_write_operations", ops, write);
        spec.appendColumn(I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Read Throughput"), I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"The throughput of the read operations performed by {0}", (Object[])new Object[]{entity}), 12290, NrOfBytesPerSecond.class, "throughput_read_operations_bytes_per_second", flow, read);
        spec.appendColumn(I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Write Throughput"), I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"The throughput of the write operations performed by {0}", (Object[])new Object[]{entity}), 12290, NrOfBytesPerSecond.class, "throughput_write_operations_bytes_per_second", flow, write);
        spec.appendColumn(I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Avg Read Bytes"), I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"The average number of bytes read by {0}", (Object[])new Object[]{entity}), 12290, NrOfBytes.class, "read_bytes_average", avgBytes, read);
        spec.appendColumn(I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Avg Written Bytes"), I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"The average number of bytes written by {0}", (Object[])new Object[]{entity}), 12290, NrOfBytes.class, "written_bytes_average", avgBytes, write);
        spec.appendColumn(I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Avg Read Duration"), I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"The average time of read operations performed by {0}", (Object[])new Object[]{entity}), 12290, ElapsedTime.class, "reading_operation_average_time_nanoseconds", avgDuration, read);
        spec.appendColumn(I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Avg Write Duration"), I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"The average time of write operations performed by {0}", (Object[])new Object[]{entity}), 12290, ElapsedTime.class, "writing_operation_average_time_nanoseconds", avgDuration, write);
        return spec;
    }

    public static Column getColumn(IOOperationsColumn column, int columnIndex) {
        switch (columnIndex) {
            case 0: {
                return column.getOpenCountColumn();
            }
            case 1: {
                return column.getCloseCountColumn();
            }
            case 2: {
                return column.getReadBytesColumn();
            }
            case 3: {
                return column.getWrittenBytesColumn();
            }
            case 4: {
                return column.getReadTimeColumn();
            }
            case 5: {
                return column.getWriteTimeColumn();
            }
            case 6: {
                return column.getReadOperationsColumn();
            }
            case 7: {
                return column.getWriteOperationsColumn();
            }
            case 8: {
                return column.getReadTroughputColumn();
            }
            case 9: {
                return column.getWriteThroughputColumn();
            }
            case 10: {
                return column.getReadBytesPerOperationColumn();
            }
            case 11: {
                return column.getWrittenBytesPerOperationColumn();
            }
            case 12: {
                return column.getTimePerReadOperationColumn();
            }
            case 13: {
                return column.getTimePerWriteOperationColumn();
            }
        }
        assert (false);
        return null;
    }

    private static Quantity getEntry(IOOperations value, int column, IOOperations total, IOProvider provider) {
        switch (column) {
            case 0: {
                return NrOfOpenedFiles.PROTOTYPE.create(value.getOpenCount(), total.getOpenCount());
            }
            case 1: {
                return NrOfClosedFiles.PROTOTYPE.create(value.getCloseCount(), total.getCloseCount());
            }
            case 2: {
                return NrOfBytes.PROTOTYPE.create(value.getReadBytes(), total.getReadBytes());
            }
            case 3: {
                return NrOfBytes.PROTOTYPE.create(value.getWrittenBytes(), total.getWrittenBytes());
            }
            case 4: {
                return ElapsedTime.PROTOTYPE.create(value.getReadTime(), total.getReadTime());
            }
            case 5: {
                return ElapsedTime.PROTOTYPE.create(value.getWriteTime(), total.getWriteTime());
            }
            case 6: {
                return NrOfInvocations.PROTOTYPE.create(value.getReadOperations(), total.getReadOperations());
            }
            case 7: {
                return NrOfInvocations.PROTOTYPE.create(value.getWriteOperations(), total.getWriteOperations());
            }
            case 8: {
                return NrOfBytesPerSecond.PROTOTYPE.create(value.getReadTime() == 0L ? 0L : (long)((double)value.getReadBytes() * 1.0E9 / (double)value.getReadTime()));
            }
            case 9: {
                return NrOfBytesPerSecond.PROTOTYPE.create(value.getWriteTime() == 0L ? 0L : (long)((double)value.getWrittenBytes() * 1.0E9 / (double)value.getWriteTime()));
            }
            case 10: {
                return NrOfBytes.PROTOTYPE.create(value.getReadOperations() == 0L ? 0L : value.getReadBytes() / value.getReadOperations());
            }
            case 11: {
                return NrOfBytes.PROTOTYPE.create(value.getWriteOperations() == 0L ? 0L : value.getWrittenBytes() / value.getWriteOperations());
            }
            case 12: {
                return ElapsedTime.PROTOTYPE.create(value.getReadOperations() == 0L ? 0L : value.getReadTime() / value.getReadOperations());
            }
            case 13: {
                return ElapsedTime.PROTOTYPE.create(value.getWriteOperations() == 0L ? 0L : value.getWriteTime() / value.getWriteOperations());
            }
        }
        assert (false);
        return null;
    }

    private static Column getColumn(IOOperationsAndDetailsColumn column, int columnIndex) {
        switch (columnIndex) {
            case 0: {
                return column.getFdColumn();
            }
            case 1: {
                return column.getReadBytesColumn();
            }
            case 2: {
                return column.getWrittenBytesColumn();
            }
            case 3: {
                return column.getReadTimeColumn();
            }
            case 4: {
                return column.getWriteTimeColumn();
            }
            case 5: {
                return column.getReadOperationsColumn();
            }
            case 6: {
                return column.getWriteOperationsColumn();
            }
            case 7: {
                return column.getReadTroughputColumn();
            }
            case 8: {
                return column.getWriteThroughputColumn();
            }
            case 9: {
                return column.getReadBytesPerOperationColumn();
            }
            case 10: {
                return column.getWrittenBytesPerOperationColumn();
            }
            case 11: {
                return column.getTimePerReadOperationColumn();
            }
            case 12: {
                return column.getTimePerWriteOperationColumn();
            }
            case 13: {
                return column.getOpenTimestampColumn();
            }
            case 14: {
                return column.getCloseTimestampColumn();
            }
            case 15: {
                return column.getOpeningThreadIdColumn();
            }
            case 16: {
                return column.getOpeningThreadNameColumn();
            }
            case 17: {
                return column.getClosingThreadIdColumn();
            }
            case 18: {
                return column.getClosingThreadNameColumn();
            }
        }
        assert (false);
        return null;
    }

    private static ProviderEntry getEntryDetailed(IOOperationsAndDetails value, int column, IOOperationsAndDetails total, IOProvider provider) {
        switch (column) {
            case 0: {
                return new FileDescriptor(value.getFd());
            }
            case 1: {
                return NrOfBytes.PROTOTYPE.create(value.getReadBytes(), total.getReadBytes());
            }
            case 2: {
                return NrOfBytes.PROTOTYPE.create(value.getWrittenBytes(), total.getWrittenBytes());
            }
            case 3: {
                return ElapsedTime.PROTOTYPE.create(value.getReadTime(), total.getReadTime());
            }
            case 4: {
                return ElapsedTime.PROTOTYPE.create(value.getWriteTime(), total.getWriteTime());
            }
            case 5: {
                return NrOfInvocations.PROTOTYPE.create(value.getReadOperations(), total.getReadOperations());
            }
            case 6: {
                return NrOfInvocations.PROTOTYPE.create(value.getWriteOperations(), total.getWriteOperations());
            }
            case 7: {
                return NrOfBytesPerSecond.PROTOTYPE.create(value.getReadTime() == 0L ? 0L : (long)((double)value.getReadBytes() * 1.0E9 / (double)value.getReadTime()));
            }
            case 8: {
                return NrOfBytesPerSecond.PROTOTYPE.create(value.getWriteTime() == 0L ? 0L : (long)((double)value.getWrittenBytes() * 1.0E9 / (double)value.getWriteTime()));
            }
            case 9: {
                return NrOfBytes.PROTOTYPE.create(value.getReadOperations() == 0L ? 0L : value.getReadBytes() / value.getReadOperations());
            }
            case 10: {
                return NrOfBytes.PROTOTYPE.create(value.getWriteOperations() == 0L ? 0L : value.getWrittenBytes() / value.getWriteOperations());
            }
            case 11: {
                return ElapsedTime.PROTOTYPE.create(value.getReadOperations() == 0L ? 0L : value.getReadTime() / value.getReadOperations());
            }
            case 12: {
                return ElapsedTime.PROTOTYPE.create(value.getWriteOperations() == 0L ? 0L : value.getWriteTime() / value.getWriteOperations());
            }
            case 13: {
                long openTimestamp = value.getOpenTimestamp();
                if (openTimestamp != 0L) {
                    return new Timestamp(openTimestamp);
                }
                return new Timestamp(I18n._ss((String)"Missing timestamp|File open", (String)"<not available>"));
            }
            case 14: {
                long closeTimestamp = value.getCloseTimestamp();
                if (closeTimestamp != 0L) {
                    return new Timestamp(closeTimestamp);
                }
                return new Timestamp(I18n._ss((String)"Missing timestamp|File close", (String)"<never closed>"));
            }
            case 15: {
                return new NormalThreadId(value.getOpeningThreadId());
            }
            case 16: {
                return new NormalThreadName(value.getOpeningThreadName(), I18n._ss((String)"Missing thread name|File open", (String)"<not available>"));
            }
            case 17: {
                return new NormalThreadId(value.getClosingThreadId());
            }
            case 18: {
                return new NormalThreadName(value.getClosingThreadName(), I18n._ss((String)"Missing thread name|File close", (String)"<never closed>"));
            }
        }
        assert (false);
        return null;
    }

    private static Column getColumn(IODetailsColumn column, int columnIndex) {
        switch (columnIndex) {
            case 0: {
                return column.getFdColumn();
            }
            case 1: {
                return column.getOpenTimestampColumn();
            }
            case 2: {
                return column.getCloseTimestampColumn();
            }
            case 3: {
                return column.getOpeningThreadIdColumn();
            }
            case 4: {
                return column.getOpeningThreadNameColumn();
            }
            case 5: {
                return column.getOpeningThreadIdColumn();
            }
            case 6: {
                return column.getOpeningThreadNameColumn();
            }
        }
        assert (false);
        return null;
    }

    private static ProviderEntry getEntry(IODetails value, int column) {
        switch (column) {
            case 0: {
                return new FileDescriptor(value.getFd());
            }
            case 1: {
                long openTimestamp = value.getOpenTimestamp();
                if (openTimestamp != 0L) {
                    return new Timestamp(openTimestamp);
                }
                return new Timestamp(I18n._ss((String)"Missing timestamp|File open", (String)"<not available>"));
            }
            case 2: {
                long closeTimestamp = value.getCloseTimestamp();
                if (closeTimestamp != 0L) {
                    return new Timestamp(closeTimestamp);
                }
                return new Timestamp(I18n._ss((String)"Missing timestamp|File close", (String)"<never closed>"));
            }
            case 3: {
                return new NormalThreadId(value.getOpeningThreadId());
            }
            case 4: {
                return new NormalThreadName(value.getOpeningThreadName(), I18n._ss((String)"Missing thread name|File open", (String)"<not available>"));
            }
            case 5: {
                return new NormalThreadId(value.getClosingThreadId());
            }
            case 6: {
                return new NormalThreadName(value.getClosingThreadName(), I18n._ss((String)"Missing thread name|File close", (String)"<never closed>"));
            }
        }
        assert (false);
        return null;
    }

    public static Column getColumn(int column, SelfAndTotalValueStatistic<?, IOOperations> statistic) {
        if ((column & 1) == 0) {
            return ProviderUtils.getColumn((IOOperationsColumn)statistic.getSelfColumn(), column / 2);
        }
        return ProviderUtils.getColumn((IOOperationsColumn)statistic.getTotalColumn(), column / 2);
    }

    public static Quantity getEntry(int id, int column, SelfAndTotalValueStatistic<?, IOOperations> statistic, IOProvider provider) {
        if ((column & 1) == 0) {
            return ProviderUtils.getEntry(statistic.getSelf(id), column / 2, statistic.getTotal(), provider);
        }
        return ProviderUtils.getEntry(statistic.getTotal(id), column / 2, statistic.getTotal(), provider);
    }

    public static Column getColumnDetailed(int column, SelfTotalAndOtherValueStatistic<?, IOOperations, IODetails> statistic) {
        if (column == 0) {
            return ProviderUtils.getColumn((IODetailsColumn)statistic.getOtherColumn(), column);
        }
        if (column > 24) {
            return ProviderUtils.getColumn((IODetailsColumn)statistic.getOtherColumn(), column - 24);
        }
        int selfTotalCol = column + 3;
        if ((selfTotalCol & 1) == 0) {
            return ProviderUtils.getColumn((IOOperationsColumn)statistic.getSelfColumn(), selfTotalCol / 2);
        }
        return ProviderUtils.getColumn((IOOperationsColumn)statistic.getTotalColumn(), selfTotalCol / 2);
    }

    public static ProviderEntry getEntryDetailed(int id, int column, SelfTotalAndOtherValueStatistic<?, IOOperations, IODetails> statistic, IOProvider provider) {
        if (column == 0) {
            return ProviderUtils.getEntry(statistic.getOther(id), column);
        }
        if (column > 24) {
            return ProviderUtils.getEntry(statistic.getOther(id), column - 24);
        }
        int selfTotalCol = column + 3;
        if ((selfTotalCol & 1) == 0) {
            return ProviderUtils.getEntry((IOOperations)statistic.getSelf(id), selfTotalCol / 2, (IOOperations)statistic.getTotal(), provider);
        }
        return ProviderUtils.getEntry((IOOperations)statistic.getTotal(id), selfTotalCol / 2, (IOOperations)statistic.getTotal(), provider);
    }

    public static Column getColumn(int column, ValueStatistic<?, IOOperations> statistic) {
        return ProviderUtils.getColumn((IOOperationsColumn)statistic.getValueColumn(), column);
    }

    public static Quantity getEntry(int id, int column, ValueStatistic<?, IOOperations> statistic, IOProvider provider) {
        return ProviderUtils.getEntry(statistic.getValue(id), column, statistic.getValue(), provider);
    }

    public static Column getColumnDetailed(int column, ValueStatistic<?, IOOperationsAndDetails> statistic) {
        return ProviderUtils.getColumn((IOOperationsAndDetailsColumn)((Object)statistic.getValueColumn()), column);
    }

    public static ProviderEntry getEntryDetailed(int id, int column, ValueStatistic<?, IOOperationsAndDetails> statistic, IOProvider provider) {
        return ProviderUtils.getEntryDetailed(statistic.getValue(id), column, statistic.getValue(), provider);
    }

    public static Quantity getEntry(SelfAndTotalValueTreeNode<?, IOOperations> node, int column, ValueTreeBase<?, IOOperations, ?> tree, IOProvider provider) {
        if ((column & 1) == 0) {
            return ProviderUtils.getEntry(node.getSelf(), column / 2, tree.getTotal(), provider);
        }
        return ProviderUtils.getEntry(node.getTotal(), column / 2, tree.getTotal(), provider);
    }
}

