/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.presentation.impl.typed.io;

import com.sap.jvm.profiling.i18n.I18n;
import com.sap.jvm.profiling.presentation.graph.ProfilingColors;
import com.sap.jvm.profiling.presentation.typed.TypedTimeSeriesProvider;
import com.sap.jvm.profiling.presentation.typed.entries.ElapsedTimePerSecond;
import com.sap.jvm.profiling.presentation.typed.entries.NrOfBytesPerSecond;
import com.sap.jvm.profiling.presentation.typed.entries.NrOfOpenedFiles;
import com.sap.jvm.profiling.presentation.typed.entries.NrOfOperationsPerSecond;
import com.sap.jvm.profiling.resource.ResourceName;
import com.sap.jvm.profiling.resource.ResourceNameElement;
import com.sap.jvm.profiling.snapshot.io.Elements;

public final class TimeSeriesProvider
extends TypedTimeSeriesProvider {
    public TimeSeriesProvider(ResourceName name) {
        super(name, I18n._ts((I18n.TextType)I18n.TextType.XTBS, (String)"File I/O Rates"), "views/graph.gif", "io/open-files|io/bytes-rate|ops/read|ops/write");
        String color1 = ProfilingColors.FILE_IO_COLOR.getString();
        String color2 = ProfilingColors.NETWORK_IO_COLOR.getString();
        this.setCurrent(this.getCollectionName(), 7);
        this.addGroup("io", I18n._s((String)"File I/O Rates"));
        this.addGroup("ops", I18n._s((String)"Transfer Type (Read/Write)"));
        this.setCurrentTag("ops/read", I18n._ts((I18n.TextType)I18n.TextType.XTBS, (String)"Read"), I18n._s((String)"Shows graphs linked to read operations"));
        this.setCurrentTag("ops/write", I18n._ts((I18n.TextType)I18n.TextType.XTBS, (String)"Write"), I18n._s((String)"Shows graphs linked to write operations"));
        this.addArea(I18n._ts((I18n.TextType)I18n.TextType.XTBS, (String)"Open Files"), "io/open-files", I18n._s((String)"Shows the number of open files"));
        this.addLine(0, 0, 1, I18n._s((String)"Open Files"), color1, NrOfOpenedFiles.class);
        this.addArea(I18n._ts((I18n.TextType)I18n.TextType.XTBS, (String)"File Transfer Rates"), "io/bytes-rate", I18n._s((String)"Shows the file transfer rates"));
        this.addLine(1, 0, 1, I18n._s((String)"Read Bytes per second"), (Object)color1, "ops/read&io/bytes-rate", NrOfBytesPerSecond.class);
        this.addLine(4, 0, 1, I18n._s((String)"Written Bytes per second"), (Object)color2, "ops/write&io/bytes-rate", NrOfBytesPerSecond.class);
        this.addArea(I18n._ts((I18n.TextType)I18n.TextType.XTBS, (String)"File Transfer Operations"), "io/operations-rate", I18n._s((String)"Shows the file transfer operation rates"));
        this.addLine(2, 0, 1, I18n._s((String)"Read Operations per second"), (Object)color1, "ops/read&io/operations-rate", NrOfOperationsPerSecond.class);
        this.addLine(5, 0, 1, I18n._s((String)"Write Operations per second"), (Object)color2, "ops/write&io/operations-rate", NrOfOperationsPerSecond.class);
        this.addArea(I18n._ts((I18n.TextType)I18n.TextType.XTBS, (String)"File Transfer Times"), "io/time-rate", I18n._s((String)"Shows the file transfer times"));
        this.addLine(3, 0, 1, I18n._s((String)"Read Time per second"), (Object)color1, "ops/read&io/time-rate", ElapsedTimePerSecond.class);
        this.addLine(6, 0, 1, I18n._s((String)"Write Time per second"), (Object)color2, "ops/write&io/time-rate", ElapsedTimePerSecond.class);
        this.addGeneralTimeSeries();
    }

    @Override
    protected ResourceName getCollectionName() {
        return this.getResourceName().stripLastElement().addElement((ResourceNameElement)new Elements.CreateIOTimeSeriesCollection());
    }
}

