/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.presentation.impl.typed.mpt;

import com.sap.jvm.profiling.core.ProfilingCapabilities;
import com.sap.jvm.profiling.i18n.I18n;
import com.sap.jvm.profiling.presentation.typed.TypedColumnSpec;
import com.sap.jvm.profiling.presentation.typed.VisibilitySet;
import com.sap.jvm.profiling.presentation.typed.entries.CpuTime;
import com.sap.jvm.profiling.presentation.typed.entries.ElapsedTime;
import com.sap.jvm.profiling.presentation.typed.entries.NrOfInvocations;
import com.sap.jvm.profiling.presentation.typed.entries.Quantity;
import com.sap.jvm.profiling.resource.ResourceName;
import com.sap.jvm.profiling.snapshot.mpt.CpuAndElapsedTime;
import com.sap.jvm.profiling.snapshot.mpt.CpuAndElapsedTimeColumn;
import com.sap.jvm.profiling.snapshot.mpt.InvocationDistColumn;
import com.sap.jvm.profiling.snapshot.mpt.InvocationsAndTime;
import com.sap.jvm.profiling.snapshot.mpt.InvocationsAndTimeColumn;
import com.sap.jvm.profiling.snapshot.resource.InvocationDist;
import com.sap.jvm.profiling.snapshot.util.SelfAndTotalValueTreeNode;
import com.sap.jvm.profiling.snapshot.util.SelfTotalAndOtherValueStatistic;
import com.sap.jvm.profiling.snapshot.util.ValueStatistic;
import com.sap.jvm.profiling.snapshot.util.column.LongValueColumn;

public class ProviderUtils {
    public static TypedColumnSpec getInvocationsAndTimeSpec(ResourceName name) {
        TypedColumnSpec spec = new TypedColumnSpec("Invocations|CpuTime|ElapsedTime");
        spec.appendColumn(I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Invocations"), I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"The number of invocations"), 12550, NrOfInvocations.class, "nr_method_invocations", new VisibilitySet("Invocations", "InvocationsAndTime", I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Invocations"), "tables/col_mpt_invocations.gif", I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"Number of invocations"), new Integer[0]));
        spec.appendColumn(I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Interpreted Invocations"), I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"The number of interpreted invocations of non-native methods"), 45062, NrOfInvocations.class, "nr_method_invocations", new VisibilitySet("InterpretedInvocations", "InvocationsAndTime", I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Interpreted Invocations"), "tables/col_mpt_invocations.gif", I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"Number of invocations to interpreted non-native methods"), new Integer[0]));
        spec.appendColumn(I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Interpreted Native Invocations"), I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"The number of interpreted invocations of native methods"), 45062, NrOfInvocations.class, "nr_method_invocations", new VisibilitySet("InterpretedNativeInvocations", "InvocationsAndTime", I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Interpreted Native Invocations"), "tables/col_mpt_invocations.gif", I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"Number of invocations to compiled native methods"), new Integer[0]));
        spec.appendColumn(I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Compiled Invocations"), I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"The number of compiled but not inlined invocations of non-native methods"), 45062, NrOfInvocations.class, "nr_method_invocations", new VisibilitySet("CompiledInvocations", "InvocationsAndTime", I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Compiled Invocations"), "tables/col_mpt_invocations.gif", I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"Number of invocations to compiled non-native methods"), new Integer[0]));
        spec.appendColumn(I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Compiled Native Invocations"), I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"The number of compiled but not inlined invocations of native methods"), 45062, NrOfInvocations.class, "nr_method_invocations", new VisibilitySet("CompiledNativeInvocations", "InvocationsAndTime", I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Compiled Native Invocations"), "tables/col_mpt_invocations.gif", I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"Number of invocations to compiled native methods"), new Integer[0]));
        spec.appendColumn(I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Inlined Invocations"), I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"The number of inlined invocations of non-native methods"), 45062, NrOfInvocations.class, "nr_method_invocations", new VisibilitySet("InlinedInvocations", "InvocationsAndTime", I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Inlined Invocations"), "tables/col_mpt_invocations.gif", I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"Number of invocations to inlined non-native methods"), new Integer[0]));
        spec.appendColumn(I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Inlined Native Invocations"), I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"The number of inlined invocations of native methods"), 45062, NrOfInvocations.class, "nr_method_invocations", new VisibilitySet("InlinedNativeInvocations", "InvocationsAndTime", I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Inlined Native Invocations"), "tables/col_mpt_invocations.gif", I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"Number of invocations to inlined native methods"), new Integer[0]));
        spec.appendColumn(I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Compiled Tier 1 Invocations"), I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"The number of compiled but not inlined invocations in tier 1 of non-native methods"), 45062, NrOfInvocations.class, "nr_method_invocations", new VisibilitySet("CompiledTier1Invocations", "InvocationsAndTime", I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Compiled Tier 1 Invocations"), "tables/col_mpt_invocations.gif", I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"Number of invocations to compiled non-native methods in tier 1"), new Integer[0]));
        spec.appendColumn(I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Compiled Native Tier 1 Invocations"), I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"The number of compiled but not inlined invocations in tier 1 of native methods"), 45062, NrOfInvocations.class, "nr_method_invocations", new VisibilitySet("CompiledNativeTier1Invocations", "InvocationsAndTime", I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Compiled Native Tier 1 Invocations"), "tables/col_mpt_invocations.gif", I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"Number of invocations to compiled native methods in tier 1"), new Integer[0]));
        spec.appendColumn(I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Inlined Invocations Tier 1"), I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"The number of inlined invocations in tier 1 of non-native methods"), 45062, NrOfInvocations.class, "nr_method_invocations", new VisibilitySet("InlinedTier1Invocations", "InvocationsAndTime", I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Inlined Tier 1 Invocations"), "tables/col_mpt_invocations.gif", I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"Number of invocations to inlined non-native methods in tier 1"), new Integer[0]));
        spec.appendColumn(I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Inlined Native Tier 1 Invocations"), I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"The number of inlined invocations in tier 1 of native methods"), 45062, NrOfInvocations.class, "nr_method_invocations", new VisibilitySet("InlinedNativeTier1Invocations", "InvocationsAndTime", I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Inlined Native Tier 1 Invocations"), "tables/col_mpt_invocations.gif", I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"Number of invocations to inlined native methods in tier 1"), new Integer[0]));
        spec.appendColumn(I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Other Invocations"), I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"The number of other (unknown) invocations"), 45062, NrOfInvocations.class, "nr_method_invocations", new VisibilitySet("OtherInvocations", "InvocationsAndTime", I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Other Invocations"), "tables/col_mpt_invocations.gif", I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"Number of other invocations"), new Integer[0]));
        spec.appendColumn(I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"CPU Time"), I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"The CPU times used"), 45094, CpuTime.class, "cpu_time_nanoseconds", new VisibilitySet("CpuTime", "InvocationsAndTime", I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"CPU Time"), "tables/col_cpu_time.gif", I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"CPU time spent in methods"), new Integer[0]));
        spec.appendColumn(I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Elapsed Time"), I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"The elapsed time"), 45126, ElapsedTime.class, "elapsed_time_nanoseconds", new VisibilitySet("ElapsedTime", "InvocationsAndTime", I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Elapsed Time"), "tables/col_elapsed_time.gif", I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"Time spent in methods"), new Integer[0]));
        return ProviderUtils.disableUnneededColumns(name, spec);
    }

    private static LongValueColumn getColumn(CpuAndElapsedTimeColumn column, int columnIndex) {
        switch (columnIndex) {
            case 0: {
                return column.getCpuTimeColumn();
            }
            case 1: {
                return column.getElapsedTimeColumn();
            }
        }
        assert (false);
        return null;
    }

    private static Quantity getEntry(CpuAndElapsedTime value, int column, CpuAndElapsedTime total) {
        switch (column) {
            case 0: {
                return CpuTime.PROTOTYPE.create(value.getCpuTime());
            }
            case 1: {
                return ElapsedTime.PROTOTYPE.create(value.getElapsedTime());
            }
        }
        assert (false);
        return null;
    }

    private static LongValueColumn getColumn(InvocationDistColumn column, int columnIndex) {
        switch (columnIndex) {
            case 0: {
                return column.getTotalInvocationsColumn();
            }
            case 1: {
                return column.getInlinedInvocationsColumn();
            }
            case 2: {
                return column.getNativeInterpreterInvocationsColumn();
            }
            case 3: {
                return column.getCompiledInvocationsColumn();
            }
            case 4: {
                return column.getNativeCompiledInvocationsColumn();
            }
            case 5: {
                return column.getInlinedInvocationsColumn();
            }
            case 6: {
                return column.getNativeInlinedInvocationsColumn();
            }
            case 7: {
                return column.getCompiledTier1InvocationsColumn();
            }
            case 8: {
                return column.getNativeCompiledTier1InvocationsColumn();
            }
            case 9: {
                return column.getInlinedTier1InvocationsColumn();
            }
            case 10: {
                return column.getNativeInlinedTier1InvocationsColumn();
            }
            case 11: {
                return column.getOtherInvocationsColumn();
            }
        }
        assert (false);
        return null;
    }

    private static Quantity getEntry(InvocationDist value, int column) {
        switch (column) {
            case 0: {
                return NrOfInvocations.PROTOTYPE.create(value.getTotalInvocations());
            }
            case 1: {
                return NrOfInvocations.PROTOTYPE.create(value.getInterpreterInvocations());
            }
            case 2: {
                return NrOfInvocations.PROTOTYPE.create(value.getNativeInterpreterInvocations());
            }
            case 3: {
                return NrOfInvocations.PROTOTYPE.create(value.getCompiledInvocations());
            }
            case 4: {
                return NrOfInvocations.PROTOTYPE.create(value.getNativeCompiledInvocations());
            }
            case 5: {
                return NrOfInvocations.PROTOTYPE.create(value.getInlinedInvocations());
            }
            case 6: {
                return NrOfInvocations.PROTOTYPE.create(value.getNativeInlinedInvocations());
            }
            case 7: {
                return NrOfInvocations.PROTOTYPE.create(value.getCompiledTier1Invocations());
            }
            case 8: {
                return NrOfInvocations.PROTOTYPE.create(value.getNativeCompiledTier1Invocations());
            }
            case 9: {
                return NrOfInvocations.PROTOTYPE.create(value.getInlinedTier1Invocations());
            }
            case 10: {
                return NrOfInvocations.PROTOTYPE.create(value.getNativeInlinedTier1Invocations());
            }
            case 11: {
                return NrOfInvocations.PROTOTYPE.create(value.getOtherInvocations());
            }
        }
        assert (false);
        return null;
    }

    public static Quantity getEntry(int id, int column, SelfTotalAndOtherValueStatistic<?, CpuAndElapsedTime, InvocationDist> statistic) {
        if (column < 12) {
            return ProviderUtils.getEntry(statistic.getOther(id), column);
        }
        return ProviderUtils.getEntry((CpuAndElapsedTime)statistic.getTotal(id), column - 12, (CpuAndElapsedTime)statistic.getTotal());
    }

    public static LongValueColumn getColumn(int columnIndex, SelfTotalAndOtherValueStatistic<?, CpuAndElapsedTime, InvocationDist> statistic) {
        if (columnIndex < 12) {
            return ProviderUtils.getColumn((InvocationDistColumn)statistic.getOtherColumn(), columnIndex);
        }
        return ProviderUtils.getColumn((CpuAndElapsedTimeColumn)statistic.getTotalColumn(), columnIndex - 12);
    }

    private static LongValueColumn getColumn(InvocationsAndTimeColumn column, int columnIndex) {
        if (columnIndex < 12) {
            return ProviderUtils.getColumn(column.getInvocationDistColumn(), columnIndex);
        }
        if (columnIndex == 12) {
            return column.getCpuTimeColumn();
        }
        if (columnIndex == 13) {
            return column.getElapsedTimeColumn();
        }
        assert (false);
        return null;
    }

    private static Quantity getEntry(InvocationsAndTime value, int column, InvocationsAndTime total) {
        if (column < 12) {
            return ProviderUtils.getEntry(value.getInvocations(), column);
        }
        if (column == 12) {
            return CpuTime.PROTOTYPE.create(value.getCpuTime());
        }
        if (column == 13) {
            return ElapsedTime.PROTOTYPE.create(value.getElapsedTime());
        }
        assert (false);
        return null;
    }

    public static Quantity getEntry(int id, int column, ValueStatistic<?, InvocationsAndTime> statistic) {
        return ProviderUtils.getEntry(statistic.getValue(id), column, statistic.getValue());
    }

    public static LongValueColumn getColumn(int column, ValueStatistic<?, InvocationsAndTime> statistic) {
        return ProviderUtils.getColumn((InvocationsAndTimeColumn)statistic.getValueColumn(), column);
    }

    public static Quantity getEntry(SelfAndTotalValueTreeNode<?, InvocationsAndTime> node, int column) {
        return ProviderUtils.getEntry(node.getTotal(), column, null);
    }

    private static TypedColumnSpec disableUnneededColumns(ResourceName name, TypedColumnSpec spec) {
        ProfilingCapabilities capabilities = name.getSession().getCapabilities();
        boolean hasDistribution = capabilities.hasInterpreterInformationInMPT();
        boolean hasTier1Info = name.getSession().getSystemInfo().mptSupportsTierInformation();
        if (!hasDistribution) {
            spec.disableVisibilitySets("InterpretedInvocations|InterpretedNativeInvocations|CompiledInvocations|CompiledNativeInvocations|InlinedInvocations|InlinedNativeInvocations");
        }
        if (!hasTier1Info) {
            spec.disableVisibilitySets("CompiledTier1Invocations|CompiledNativeTier1Invocations|InlinedTier1Invocations|InlinedNativeTier1Invocations");
        }
        return spec;
    }
}

