/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.presentation.impl.typed.net;

import com.sap.jvm.profiling.i18n.I18n;
import com.sap.jvm.profiling.presentation.impl.typed.SumBehavior;
import com.sap.jvm.profiling.presentation.impl.typed.net.NetworkProvider;
import com.sap.jvm.profiling.presentation.impl.typed.net.NetworkTableProvider;
import com.sap.jvm.profiling.presentation.impl.typed.net.ProviderUtils;
import com.sap.jvm.profiling.presentation.typed.entries.NormalThreadId;
import com.sap.jvm.profiling.presentation.typed.entries.NormalThreadName;
import com.sap.jvm.profiling.presentation.typed.entries.ProviderEntry;
import com.sap.jvm.profiling.resource.ResourceName;
import com.sap.jvm.profiling.resource.ResourceNameElement;
import com.sap.jvm.profiling.snapshot.net.CallingThreadIdStatistic;
import com.sap.jvm.profiling.snapshot.net.Elements;
import com.sap.jvm.profiling.snapshot.resource.ThreadIdAndName;
import com.sap.jvm.profiling.snapshot.resource.ThreadIdAndNameColumn;
import com.sap.jvm.profiling.snapshot.util.SelfAndTotalValueStatistic;
import com.sap.jvm.profiling.snapshot.util.column.Column;

public final class CallingThreadIdStatisticProvider
extends NetworkTableProvider<CallingThreadIdStatistic> {
    public CallingThreadIdStatisticProvider(ResourceName name) {
        super(name, I18n._ts((I18n.TextType)I18n.TextType.XTBS, (String)"Threads by ID"), "views/thread_statistic.gif", ProviderUtils.getSelfAndTotalSpec(name, false, SumBehavior.SUM_NONE, I18n._ss((String)"Entity, ex: ... affected by {0}, ... time spent in {0}", (String)"this thread")).prepend(I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Name"), I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"One name of the thread"), 9, NormalThreadName.class, "thread_name").prepend(I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"ID"), I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"The thread id"), 8257, NormalThreadId.class, "thread_id"));
    }

    @Override
    public ProviderEntry getEntry(int entryId, int column) {
        if (column == 0) {
            return new NormalThreadId(((ThreadIdAndName)((CallingThreadIdStatistic)this.statistic).getKey(entryId)).getId());
        }
        if (column == 1) {
            return new NormalThreadName(((ThreadIdAndName)((CallingThreadIdStatistic)this.statistic).getKey(entryId)).getUTFName());
        }
        return ProviderUtils.getEntry(entryId, column - 2, (SelfAndTotalValueStatistic)this.statistic, (NetworkProvider)this);
    }

    @Override
    public Column getColumn(int columnIndex) {
        if (columnIndex == 0) {
            return ((ThreadIdAndNameColumn)((CallingThreadIdStatistic)this.statistic).getKeyColumn()).getIdColumn();
        }
        if (columnIndex == 1) {
            return ((ThreadIdAndNameColumn)((CallingThreadIdStatistic)this.statistic).getKeyColumn()).getNameColumn();
        }
        return ProviderUtils.getColumn(columnIndex - 2, (SelfAndTotalValueStatistic)this.statistic);
    }

    @Override
    protected ResourceName getStatisticName() {
        return this.getResourceName().stripLastElement().addElement((ResourceNameElement)new Elements.CreateCallingThreadIdStatistic());
    }
}

