/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.presentation.impl.typed.net;

import com.sap.jvm.profiling.i18n.I18n;
import com.sap.jvm.profiling.presentation.impl.typed.net.NetworkProvider;
import com.sap.jvm.profiling.presentation.impl.typed.net.NetworkTableProvider;
import com.sap.jvm.profiling.presentation.impl.typed.net.ProviderUtils;
import com.sap.jvm.profiling.presentation.typed.entries.ProviderEntry;
import com.sap.jvm.profiling.presentation.typed.net.Elements;
import com.sap.jvm.profiling.resource.ResourceName;
import com.sap.jvm.profiling.resource.ResourceNameElement;
import com.sap.jvm.profiling.snapshot.net.Elements;
import com.sap.jvm.profiling.snapshot.net.NetworkConnection;
import com.sap.jvm.profiling.snapshot.net.NetworkConnectionColumn;
import com.sap.jvm.profiling.snapshot.net.OpenSocketStatistic;
import com.sap.jvm.profiling.snapshot.util.ValueStatistic;
import com.sap.jvm.profiling.snapshot.util.column.Column;

public final class OpenSocketStatisticProvider
extends NetworkTableProvider<OpenSocketStatistic> {
    public OpenSocketStatisticProvider(ResourceName name) {
        super(name, I18n._ts((I18n.TextType)I18n.TextType.XTBS, (String)"Open Sockets"), "views/network_socket_statistic.png", ProviderUtils.prependNetworkConnection(ProviderUtils.getSocketStatisticSpec(name, I18n._ss((String)"Entity, ex: ... times {0} was opened, ... time spent in reading from {0}", (String)"this socket"))));
    }

    @Override
    public ProviderEntry getEntry(int entryId, int column) {
        if (column >= 0 && column < 5) {
            return ProviderUtils.getEntry((NetworkConnection)((OpenSocketStatistic)this.statistic).getKey(entryId), column);
        }
        return ProviderUtils.getEntryWithLatencies(entryId, column - 5, (ValueStatistic)this.statistic, (NetworkProvider)this);
    }

    @Override
    public Column getColumn(int columnIndex) {
        if (columnIndex >= 0 && columnIndex < 5) {
            return ProviderUtils.getColumn((NetworkConnectionColumn)((OpenSocketStatistic)this.statistic).getKeyColumn(), columnIndex);
        }
        return ProviderUtils.getColumnWithLatencies(columnIndex - 5, (ValueStatistic)this.statistic);
    }

    @Override
    protected ResourceName getStatisticName() {
        Elements.CreateOpenSocketStatisticProvider createElement = (Elements.CreateOpenSocketStatisticProvider)this.getResourceName().getLastElement();
        ResourceName filterName = createElement.getName();
        return this.getResourceName().stripLastElement().addElement((ResourceNameElement)new Elements.CreateOpenSocketStatistic(filterName));
    }
}

