/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.presentation.impl.typed.net;

import com.sap.jvm.profiling.i18n.I18n;
import com.sap.jvm.profiling.presentation.impl.typed.SumBehavior;
import com.sap.jvm.profiling.presentation.impl.typed.net.NetworkProvider;
import com.sap.jvm.profiling.presentation.typed.TypedColumnSpec;
import com.sap.jvm.profiling.presentation.typed.VisibilitySet;
import com.sap.jvm.profiling.presentation.typed.entries.ElapsedTime;
import com.sap.jvm.profiling.presentation.typed.entries.FileDescriptor;
import com.sap.jvm.profiling.presentation.typed.entries.NormalNetworkAddress;
import com.sap.jvm.profiling.presentation.typed.entries.NormalNetworkConnectionType;
import com.sap.jvm.profiling.presentation.typed.entries.NormalNetworkEndpointType;
import com.sap.jvm.profiling.presentation.typed.entries.NormalNetworkLatencyId;
import com.sap.jvm.profiling.presentation.typed.entries.NormalNetworkPort;
import com.sap.jvm.profiling.presentation.typed.entries.NormalString;
import com.sap.jvm.profiling.presentation.typed.entries.NormalThreadId;
import com.sap.jvm.profiling.presentation.typed.entries.NormalThreadName;
import com.sap.jvm.profiling.presentation.typed.entries.NrOfBytes;
import com.sap.jvm.profiling.presentation.typed.entries.NrOfBytesPerSecond;
import com.sap.jvm.profiling.presentation.typed.entries.NrOfClosedSockets;
import com.sap.jvm.profiling.presentation.typed.entries.NrOfInvocations;
import com.sap.jvm.profiling.presentation.typed.entries.NrOfOpenedSockets;
import com.sap.jvm.profiling.presentation.typed.entries.NrOfReadWriteRoundtrips;
import com.sap.jvm.profiling.presentation.typed.entries.NrOfRoundtrips;
import com.sap.jvm.profiling.presentation.typed.entries.NrOfWriteReadRoundtrips;
import com.sap.jvm.profiling.presentation.typed.entries.ProviderEntry;
import com.sap.jvm.profiling.presentation.typed.entries.Quantity;
import com.sap.jvm.profiling.presentation.typed.entries.Timestamp;
import com.sap.jvm.profiling.resource.ResourceName;
import com.sap.jvm.profiling.snapshot.net.NetworkConnection;
import com.sap.jvm.profiling.snapshot.net.NetworkConnectionColumn;
import com.sap.jvm.profiling.snapshot.net.NetworkDetails;
import com.sap.jvm.profiling.snapshot.net.NetworkDetailsColumn;
import com.sap.jvm.profiling.snapshot.net.NetworkHost;
import com.sap.jvm.profiling.snapshot.net.NetworkHostColumn;
import com.sap.jvm.profiling.snapshot.net.NetworkLatencies;
import com.sap.jvm.profiling.snapshot.net.NetworkLatenciesColumn;
import com.sap.jvm.profiling.snapshot.net.NetworkOperations;
import com.sap.jvm.profiling.snapshot.net.NetworkOperationsAndDetails;
import com.sap.jvm.profiling.snapshot.net.NetworkOperationsAndDetailsColumn;
import com.sap.jvm.profiling.snapshot.net.NetworkOperationsAndLatencies;
import com.sap.jvm.profiling.snapshot.net.NetworkOperationsAndLatenciesColumn;
import com.sap.jvm.profiling.snapshot.net.NetworkOperationsColumn;
import com.sap.jvm.profiling.snapshot.net.NetworkService;
import com.sap.jvm.profiling.snapshot.net.NetworkServiceColumn;
import com.sap.jvm.profiling.snapshot.resource.NetworkLatencyId;
import com.sap.jvm.profiling.snapshot.util.SelfAndTotalValueStatistic;
import com.sap.jvm.profiling.snapshot.util.SelfAndTotalValueTreeNode;
import com.sap.jvm.profiling.snapshot.util.SelfTotalAndOtherValueStatistic;
import com.sap.jvm.profiling.snapshot.util.ValueStatistic;
import com.sap.jvm.profiling.snapshot.util.ValueTreeBase;
import com.sap.jvm.profiling.snapshot.util.column.Column;

public final class ProviderUtils {
    private static final long INVALID = 0L;

    public static TypedColumnSpec getSocketStatisticSpec(ResourceName name, String entity) {
        VisibilitySet openCount = new VisibilitySet("OpenCount", "Group_1", I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Open Count"), "tables/col_nr_of.gif", I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"Number of open operations"), new Integer[0]);
        VisibilitySet closeCount = new VisibilitySet("CloseCount", "Group_1", I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Close Count"), "tables/col_nr_of.gif", I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"Number of close operations"), new Integer[0]);
        VisibilitySet bytes = new VisibilitySet("Bytes", "Group_2", I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Bytes"), "tables/col_bytes.gif", I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"Number of read or written bytes"), new Integer[0]);
        VisibilitySet time = new VisibilitySet("Time", "Group_2", I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Time"), "tables/col_time.gif", I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"Duration of read or write operations"), new Integer[0]);
        VisibilitySet ops = new VisibilitySet("Operations", "Group_2", I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Operations"), "tables/column.gif", I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"Number of read or write operations"), new Integer[0]);
        VisibilitySet flow = new VisibilitySet("Throughput", "Group_2", I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Throughput"), "tables/column.gif", I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"Throughput of read or write operations"), new Integer[0]);
        VisibilitySet avgBytes = new VisibilitySet("AverageBytes", "Group_2", I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Average Bytes"), "tables/col_bytes.gif", I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"Average number of read or written bytes"), new Integer[0]);
        VisibilitySet avgDuration = new VisibilitySet("AverageDuration", "Group_2", I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Average Duration"), "tables/col_time.gif", I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"Average duration of read or write operations"), new Integer[0]);
        VisibilitySet read = new VisibilitySet("Read", "Group_3", I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Read"), "tables/col_read_bytes.gif", I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"Columns linked to reading operations"), new Integer[0]);
        VisibilitySet write = new VisibilitySet("Write", "Group_3", I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Write"), "tables/col_write_bytes.gif", I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"Columns linked to writing operations"), new Integer[0]);
        VisibilitySet latency = new VisibilitySet("Latency", "Group_4", I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Latency"), "tables/col_time.gif", I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"Columns linked to latencies that are relevant for the connection side\nOn the server side, this is the latency between read and write operations\nOn the client side, this is the latency between write and read operations"), new Integer[0]);
        VisibilitySet rwLatency = new VisibilitySet("Read/Write Latency", "Group_4", I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Read/Write Latency"), "tables/col_time.gif", I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"Columns linked to latencies between read and write operations"), new Integer[0]);
        VisibilitySet wrLatency = new VisibilitySet("Write/Read Latency", "Group_4", I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Write/Read Latency"), "tables/col_time.gif", I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"Columns linked to latencies between write and read operations"), new Integer[0]);
        TypedColumnSpec spec = new TypedColumnSpec("Read|Write|OpenCount|Bytes|Time");
        spec.appendColumn(I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Opened"), I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"The number of times {0} was opened", (Object[])new Object[]{entity}), 45318, NrOfOpenedSockets.class, "nr_opened_sockets", openCount);
        spec.appendColumn(I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Closed"), I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"The number of times {0} was closed", (Object[])new Object[]{entity}), 45062, NrOfClosedSockets.class, "nr_closed_sockets", closeCount);
        spec.appendColumn(I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Read Bytes"), I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"The total number of bytes read from {0}", (Object[])new Object[]{entity}), 45062, NrOfBytes.class, "read_bytes", bytes, read);
        spec.appendColumn(I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Written Bytes"), I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"The total number of bytes written to {0}", (Object[])new Object[]{entity}), 45062, NrOfBytes.class, "written_bytes", bytes, write);
        spec.appendColumn(I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Read Time"), I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"The total time spent in reading from {0}", (Object[])new Object[]{entity}), 45062, ElapsedTime.class, "elapsed_time_reading_nanoseconds", time, read);
        spec.appendColumn(I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Write Time"), I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"The total time spent in writing bytes to {0}", (Object[])new Object[]{entity}), 45062, ElapsedTime.class, "elapsed_time_writing_nanoseconds", time, write);
        spec.appendColumn(I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Read Operations"), I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"The total number of read operations to {0}", (Object[])new Object[]{entity}), 45062, NrOfInvocations.class, "nr_read_operations", ops, read);
        spec.appendColumn(I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Write Operations"), I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"The total number of write operations to {0}", (Object[])new Object[]{entity}), 45062, NrOfInvocations.class, "nr_write_operations", ops, write);
        spec.appendColumn(I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Read Throughput"), I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"The throughput of the read operations to {0}", (Object[])new Object[]{entity}), 12290, NrOfBytesPerSecond.class, "throughput_read_operations_bytes_per_second", flow, read);
        spec.appendColumn(I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Write Throughput"), I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"The throughput of the write operations to {0}", (Object[])new Object[]{entity}), 12290, NrOfBytesPerSecond.class, "throughput_write_operations_bytes_per_second", flow, write);
        spec.appendColumn(I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Avg Read Bytes"), I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"The average number of bytes read from {0}", (Object[])new Object[]{entity}), 12290, NrOfBytesPerSecond.class, "read_bytes_average", avgBytes, read);
        spec.appendColumn(I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Avg Written Bytes"), I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"The average number of bytes written to {0}", (Object[])new Object[]{entity}), 12290, NrOfBytesPerSecond.class, "written_bytes_average", avgBytes, write);
        spec.appendColumn(I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Avg Read Duration"), I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"The average time of read operations to {0}", (Object[])new Object[]{entity}), 12290, ElapsedTime.class, "reading_operation_average_time_nanoseconds", avgDuration, read);
        spec.appendColumn(I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Avg Write Duration"), I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"The average time of write operations to {0}", (Object[])new Object[]{entity}), 12290, ElapsedTime.class, "writing_operation_average_time_nanoseconds", avgDuration, write);
        spec.appendColumn(I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Min Latency"), I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"The minimum latency between operations to {0} relevant for the connection side.\nOn the server side, this is the latency between read and write operations.\nOn the client side, this is the latency between write and read operations.", (Object[])new Object[]{entity}), 12290, ElapsedTime.class, "min_default_latency", latency);
        spec.appendColumn(I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Max Latency"), I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"The maximum latency between operations to {0} relevant for the connection side.\nOn the server side, this is the latency between read and write operations.\nOn the client side, this is the latency between write and read operations.", (Object[])new Object[]{entity}), 12290, ElapsedTime.class, "max_default_latency", latency);
        spec.appendColumn(I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Latency"), I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"The accumulated latency between operations to {0} relevant for the connection side.\nOn the server side, this is the latency between read and write operations.\nOn the client side, this is the latency between write and read operations.", (Object[])new Object[]{entity}), 12294, ElapsedTime.class, "default_latency_sum", latency);
        spec.appendColumn(I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Roundtrips"), I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"The number of roundtrips between operations to {0} relevant for the connection side.\nOn the server side, this is the number of roundtrips between read and write operations.\nOn the client side, this is the number of roundtrips between write and read operations.", (Object[])new Object[]{entity}), 45062, NrOfRoundtrips.class, "default_latency_count", latency);
        spec.appendColumn(I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Avg Latency"), I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"The average latency between operations to {0} relevant for the connection side.\nOn the server side, this is the latency between read and write operations.\nOn the client side, this is the latency between write and read operations.", (Object[])new Object[]{entity}), 12290, ElapsedTime.class, "avg_default_latency", latency);
        spec.appendColumn(I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Min R/W Latency"), I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"The minimum latency between read and write operations to {0}", (Object[])new Object[]{entity}), 12290, ElapsedTime.class, "min_read_write_latency", rwLatency);
        spec.appendColumn(I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Max R/W Latency"), I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"The maximum latency between read and write operations to {0}", (Object[])new Object[]{entity}), 12290, ElapsedTime.class, "max_read_write_latency", rwLatency);
        spec.appendColumn(I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Read/Write Latency"), I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"The accumulated latency between read and write operations to {0}", (Object[])new Object[]{entity}), 12294, ElapsedTime.class, "read_write_latency_sum", rwLatency);
        spec.appendColumn(I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Read/Write Roundtrips"), I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"The number of roundtrips between read and write operations to {0}", (Object[])new Object[]{entity}), 12294, NrOfReadWriteRoundtrips.class, "read_write_latency_count", rwLatency);
        spec.appendColumn(I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Avg R/W Latency"), I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"The average latency between read and write operations to {0}", (Object[])new Object[]{entity}), 12290, ElapsedTime.class, "avg_read_write_latency", rwLatency);
        spec.appendColumn(I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Min W/R Latency"), I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"The minimum latency between write and read operations to {0}", (Object[])new Object[]{entity}), 12290, ElapsedTime.class, "min_write_read_latency", wrLatency);
        spec.appendColumn(I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Max W/R Latency"), I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"The maximum latency between write and read operations to {0}", (Object[])new Object[]{entity}), 12290, ElapsedTime.class, "max_write_read_latency", wrLatency);
        spec.appendColumn(I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Write/Read Latency"), I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"The accumulated latency between write and read operations to {0}", (Object[])new Object[]{entity}), 12294, ElapsedTime.class, "write_read_latency_sum", wrLatency);
        spec.appendColumn(I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Write/Read Roundtrips"), I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"The number of roundtrips between write and read operations to {0}", (Object[])new Object[]{entity}), 12294, NrOfWriteReadRoundtrips.class, "write_read_latency_count", wrLatency);
        spec.appendColumn(I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Avg W/R Latency"), I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"The average latency between write and read operations to {0}", (Object[])new Object[]{entity}), 12290, ElapsedTime.class, "avg_write_read_latency", wrLatency);
        return spec;
    }

    public static TypedColumnSpec getDetailedSocketStatisticSpec(ResourceName name) {
        VisibilitySet fd = new VisibilitySet("FD", "Group_1", I18n._tss((I18n.TextType)I18n.TextType.XCOL, (String)"short for file descriptor", (String)"FD"), "tables/column.gif", I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"File Descriptor"), new Integer[0]);
        VisibilitySet bytes = new VisibilitySet("Bytes", "Group_2", I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Bytes"), "tables/col_bytes.gif", I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"Number of read or written bytes"), new Integer[0]);
        VisibilitySet time = new VisibilitySet("Time", "Group_2", I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Time"), "tables/col_time.gif", I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"Duration of read or write operations"), new Integer[0]);
        VisibilitySet ops = new VisibilitySet("Operations", "Group_2", I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Operations"), "tables/column.gif", I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"Number of read or write operations"), new Integer[0]);
        VisibilitySet flow = new VisibilitySet("Throughput", "Group_2", I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Throughput"), "tables/column.gif", I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"Throughput of read or write operations"), new Integer[0]);
        VisibilitySet avgBytes = new VisibilitySet("AverageBytes", "Group_2", I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Average Bytes"), "tables/col_bytes.gif", I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"Average number of read or written bytes"), new Integer[0]);
        VisibilitySet avgDuration = new VisibilitySet("AverageDuration", "Group_2", I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Average Duration"), "tables/col_time.gif", I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"Average duration of read or write operations"), new Integer[0]);
        VisibilitySet openTs = new VisibilitySet("OpenTimestamp", "Group_3", I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Open Timestamp"), "decorators/dates.gif", I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"Open timestamp"), new Integer[0]);
        VisibilitySet closeTs = new VisibilitySet("CloseTimestamp", "Group_3", I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Close Timestamp"), "decorators/dates.gif", I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"Close timestamp"), new Integer[0]);
        VisibilitySet openThread = new VisibilitySet("OpeningThread", "Group_4", I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Opening Thread"), "views/thread_statistic.gif", I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"Opening thread"), new Integer[0]);
        VisibilitySet closeThread = new VisibilitySet("ClosingThread", "Group_4", I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Closing Thread"), "views/thread_statistic.gif", I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"Closing thread"), new Integer[0]);
        VisibilitySet read = new VisibilitySet("Read", "Group_5", I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Read"), "tables/col_read_bytes.gif", I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"Columns linked to reading operations"), new Integer[0]);
        VisibilitySet write = new VisibilitySet("Write", "Group_5", I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Write"), "tables/col_write_bytes.gif", I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"Columns linked to writing operations"), new Integer[0]);
        VisibilitySet latency = new VisibilitySet("Latency", "Group_6", I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Latency"), "tables/col_time.gif", I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"Columns linked to latencies that are relevant for the connection side\nOn the server side, this is the latency between read and write operations\nOn the client side, this is the latency between write and read operations"), new Integer[0]);
        VisibilitySet rwLatency = new VisibilitySet("Read/Write Latency", "Group_6", I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Read/Write Latency"), "tables/col_time.gif", I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"Columns linked to latencies between read and write operations"), new Integer[0]);
        VisibilitySet wrLatency = new VisibilitySet("Write/Read Latency", "Group_6", I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Write/Read Latency"), "tables/col_time.gif", I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"Columns linked to latencies between write and read operations"), new Integer[0]);
        TypedColumnSpec spec = new TypedColumnSpec("Read|Write|Bytes|Time|OpeningThread");
        spec.appendColumn(I18n._tss((I18n.TextType)I18n.TextType.XCOL, (String)"short for file descriptor", (String)"FD"), I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"The file descriptor"), 8194, FileDescriptor.class, "file_descriptor", fd);
        spec.appendColumn(I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Read Bytes"), I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"The total number of bytes read from this socket"), 45318, NrOfBytes.class, "read_bytes", bytes, read);
        spec.appendColumn(I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Written Bytes"), I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"The total number of bytes written to this socket"), 45062, NrOfBytes.class, "written_bytes", bytes, write);
        spec.appendColumn(I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Read Time"), I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"The total time spent in reading from this socket"), 45062, ElapsedTime.class, "elapsed_time_reading_nanoseconds", time, read);
        spec.appendColumn(I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Write Time"), I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"The total time spent in writing bytes to this socket"), 45062, ElapsedTime.class, "elapsed_time_writing_nanoseconds", time, write);
        spec.appendColumn(I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Read Operations"), I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"The total number of read operations to this socket"), 45062, NrOfInvocations.class, "nr_read_operations", ops, read);
        spec.appendColumn(I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Write Operations"), I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"The total number of write operations to this socket"), 45062, NrOfInvocations.class, "nr_write_operations", ops, write);
        spec.appendColumn(I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Read Throughput"), I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"The throughput of the read operations to this socket"), 12290, NrOfBytesPerSecond.class, "throughput_read_operations_bytes_per_second", flow, read);
        spec.appendColumn(I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Write Throughput"), I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"The throughput of the write operations to this socket"), 12290, NrOfBytesPerSecond.class, "throughput_write_operations_bytes_per_second", flow, write);
        spec.appendColumn(I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Avg Read Bytes"), I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"The average number of bytes read from this socket"), 12290, NrOfBytes.class, "read_bytes_average", avgBytes, read);
        spec.appendColumn(I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Avg Written Bytes"), I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"The average number of bytes written to this socket"), 12290, NrOfBytes.class, "written_bytes_average", avgBytes, write);
        spec.appendColumn(I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Avg Read Duration"), I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"The average time of read operations to this socket"), 12290, ElapsedTime.class, "reading_operation_average_time_nanoseconds", avgDuration, read);
        spec.appendColumn(I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Avg Write Duration"), I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"The average time of write operations to this socket"), 12290, ElapsedTime.class, "writing_operation_average_time_nanoseconds", avgDuration, write);
        spec.appendColumn(I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Opened At"), I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"Timestamp when the socket was opened"), 12290, Timestamp.class, "timestamp_socket_opened_milliseconds_since_midnight_1970-01-01_UTC", openTs);
        spec.appendColumn(I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Closed At"), I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"Timestamp when the socket was closed"), 12290, Timestamp.class, "timestamp_socket_closed_milliseconds_since_midnight_1970-01-01_UTC", closeTs);
        spec.appendColumn(I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Opening Thread ID"), I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"The id of the thread which opened the socket."), 12290, NormalThreadId.class, "opening_thread_id", openThread);
        spec.appendColumn(I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Opening Thread Name"), I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"One name of the thread which opened the socket."), 12290, NormalThreadName.class, "opening_thread_name", openThread);
        spec.appendColumn(I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Closing Thread ID"), I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"The id of the thread which closed the socket."), 12290, NormalThreadId.class, "closing_thread_id", closeThread);
        spec.appendColumn(I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Closing Thread Name"), I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"One name of the thread which closed the socket."), 12290, NormalThreadName.class, "closing_thread_name", closeThread);
        spec.appendColumn(I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Min Latency"), I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"The minimum latency between operations to the socket relevant for the connection side.\nOn the server side, this is the latency between read and write operations.\nOn the client side, this is the latency between write and read operations."), 12290, ElapsedTime.class, "min_default_latency", latency);
        spec.appendColumn(I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Max Latency"), I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"The maximum latency between operations to the socket relevant for the connection side.\nOn the server side, this is the latency between read and write operations.\nOn the client side, this is the latency between write and read operations."), 12290, ElapsedTime.class, "max_default_latency", latency);
        spec.appendColumn(I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Latency"), I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"The accumulated latency between operations to the socket relevant for the connection side.\nOn the server side, this is the latency between read and write operations.\nOn the client side, this is the latency between write and read operations."), 12294, ElapsedTime.class, "default_latency_sum", latency);
        spec.appendColumn(I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Roundtrips"), I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"The number of roundtrips between operations to the socket relevant for the connection side.\nOn the server side, this is the number of roundtrips between read and write operations.\nOn the client side, this is the number of roundtrips between write and read operations."), 45062, NrOfRoundtrips.class, "default_latency_count", latency);
        spec.appendColumn(I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Avg Latency"), I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"The average latency between operations to the socket relevant for the connection side.\nOn the server side, this is the latency between read and write operations.\nOn the client side, this is the latency between write and read operations."), 12290, ElapsedTime.class, "avg_default_latency", latency);
        spec.appendColumn(I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Min R/W Latency"), I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"The minimum latency between read and write operations to this socket"), 12290, ElapsedTime.class, "min_read_write_latency", rwLatency);
        spec.appendColumn(I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Max R/W Latency"), I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"The maximum latency between read and write operations to this socket"), 12290, ElapsedTime.class, "max_read_write_latency", rwLatency);
        spec.appendColumn(I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Read/Write Latency"), I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"The accumulated latency between read and write operations to this socket"), 12294, ElapsedTime.class, "read_write_latency_sum", rwLatency);
        spec.appendColumn(I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Read/Write Roundtrips"), I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"The number of roundtrips between read and write operations to this socket"), 12294, NrOfReadWriteRoundtrips.class, "read_write_latency_count", rwLatency);
        spec.appendColumn(I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Avg R/W Latency"), I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"The average latency between read and write operations to this socket"), 12290, ElapsedTime.class, "avg_read_write_latency", rwLatency);
        spec.appendColumn(I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Min W/R Latency"), I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"The minimum latency between write and read operations to this socket"), 12290, ElapsedTime.class, "min_write_read_latency", wrLatency);
        spec.appendColumn(I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Max W/R Latency"), I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"The maximum latency between write and read operations to this socket"), 12290, ElapsedTime.class, "max_write_read_latency", wrLatency);
        spec.appendColumn(I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Write/Read Latency"), I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"The accumulated latency between write and read operations to this socket"), 12294, ElapsedTime.class, "write_read_latency_sum", wrLatency);
        spec.appendColumn(I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Write/Read Roundtrips"), I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"The number of roundtrips between write and read operations to this socket"), 12294, NrOfWriteReadRoundtrips.class, "write_read_latency_count", wrLatency);
        spec.appendColumn(I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Avg W/R Latency"), I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"The average latency between write and read operations to this socket"), 12290, ElapsedTime.class, "avg_write_read_latency", wrLatency);
        return spec;
    }

    public static TypedColumnSpec getSelfAndTotalSpec(ResourceName name, boolean sortBySelf, SumBehavior sumBehavior, String entity) {
        int sumSelf = 0x3000 | (sumBehavior.sumSelf() ? 4 : 0);
        int sumTotal = 0x3000 | (sumBehavior.sumTotal() ? 4 : 0);
        VisibilitySet openCount = new VisibilitySet("OpenCount", "Group_1", I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Open Count"), "tables/col_nr_of.gif", I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"Number of open operations"), new Integer[0]);
        VisibilitySet closeCount = new VisibilitySet("CloseCount", "Group_1", I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Close Count"), "tables/col_nr_of.gif", I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"Number of close operations"), new Integer[0]);
        VisibilitySet bytes = new VisibilitySet("Bytes", "Group_2", I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Bytes"), "tables/col_bytes.gif", I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"Number of read or written bytes"), new Integer[0]);
        VisibilitySet time = new VisibilitySet("Time", "Group_2", I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Time"), "tables/col_time.gif", I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"Duration of read or write operations"), new Integer[0]);
        VisibilitySet ops = new VisibilitySet("Operations", "Group_2", I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Operations"), "tables/column.gif", I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"Number of read or write operations"), new Integer[0]);
        VisibilitySet flow = new VisibilitySet("Throughput", "Group_2", I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Throughput"), "tables/column.gif", I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"Throughput of read or write operations"), new Integer[0]);
        VisibilitySet avgBytes = new VisibilitySet("AverageBytes", "Group_2", I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Average Bytes"), "tables/col_bytes.gif", I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"Average number of read or written bytes"), new Integer[0]);
        VisibilitySet avgDuration = new VisibilitySet("AverageDuration", "Group_2", I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Average Duration"), "tables/col_time.gif", I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"Average duration of read or write operations"), new Integer[0]);
        VisibilitySet read = new VisibilitySet("Read", "Group_3", I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Read"), "tables/col_read_bytes.gif", I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"Columns linked to reading operations"), new Integer[0]);
        VisibilitySet write = new VisibilitySet("Write", "Group_3", I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Write"), "tables/col_write_bytes.gif", I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"Columns linked to writing operations"), new Integer[0]);
        VisibilitySet self = new VisibilitySet("Self", "Group_4", I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Self"), "tables/col_self_nr_of.gif", I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"Self"), new Integer[0]);
        VisibilitySet total = new VisibilitySet("Total", "Group_4", I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Total"), "tables/col_total_nr_of.gif", I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"Total"), new Integer[0]);
        TypedColumnSpec spec = new TypedColumnSpec("Read|Write|Self|Total|Bytes|Time");
        spec.appendColumn(I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Self Opened"), I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"The total number of sockets directly opened within {0}", (Object[])new Object[]{entity}), 2 | sumSelf | 0x8000, NrOfOpenedSockets.class, "self_nr_opened_sockets", openCount, self);
        spec.appendColumn(I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Total Opened"), I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"The total number of sockets opened within {0}", (Object[])new Object[]{entity}), 2 | sumTotal | 0x8000, NrOfOpenedSockets.class, "total_nr_opened_sockets", openCount, total);
        spec.appendColumn(I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Self Closed"), I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"The total number of sockets directly closed within {0}", (Object[])new Object[]{entity}), 2 | sumSelf | 0x8000, NrOfClosedSockets.class, "self_nr_closed_sockets", closeCount, self);
        spec.appendColumn(I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Total Closed"), I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"The total number of sockets closed within {0}", (Object[])new Object[]{entity}), 2 | sumTotal | 0x8000, NrOfClosedSockets.class, "total_nr_closed_sockets", closeCount, total);
        spec.appendColumn(I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Self Read Bytes"), I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"The total number of bytes directly read within {0}", (Object[])new Object[]{entity}), 2 | sumSelf | (sortBySelf ? 256 : 0) | 0x8000, NrOfBytes.class, "self_read_bytes", bytes, read, self);
        spec.appendColumn(I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Total Read Bytes"), I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"The total number of bytes read within {0}", (Object[])new Object[]{entity}), 2 | sumTotal | (sortBySelf ? 0 : 256) | 0x8000, NrOfBytes.class, "total_read_bytes", bytes, read, total);
        spec.appendColumn(I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Self Written Bytes"), I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"The total number of bytes directly written by {0}", (Object[])new Object[]{entity}), 2 | sumSelf | 0x8000, NrOfBytes.class, "self_written_bytes", bytes, write, self);
        spec.appendColumn(I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Total Written Bytes"), I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"The total number of bytes written by {0}", (Object[])new Object[]{entity}), 2 | sumTotal | 0x8000, NrOfBytes.class, "total_written_bytes", bytes, write, total);
        spec.appendColumn(I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Self Read Time"), I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"The total time directly spent in {0} for reading bytes", (Object[])new Object[]{entity}), 2 | sumSelf | 0x8000, ElapsedTime.class, "self_elapsed_time_reading_nanoseconds", time, read, self);
        spec.appendColumn(I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Total Read Time"), I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"The total time spent in {0} for reading bytes", (Object[])new Object[]{entity}), 2 | sumTotal | 0x8000, ElapsedTime.class, "total_elapsed_time_reading_nanoseconds", time, read, total);
        spec.appendColumn(I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Self Write Time"), I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"The total time directly spent in {0} for writing bytes", (Object[])new Object[]{entity}), 2 | sumSelf | 0x8000, ElapsedTime.class, "self_elapsed_time_writing_nanoseconds", time, write, self);
        spec.appendColumn(I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Total Write Time"), I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"The total time spent in {0} for writing bytes", (Object[])new Object[]{entity}), 2 | sumTotal | 0x8000, ElapsedTime.class, "total_elapsed_time_writing_nanoseconds", time, write, total);
        spec.appendColumn(I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Self Read Operations"), I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"The total number of read operations performed directly in {0}", (Object[])new Object[]{entity}), 2 | sumSelf | 0x8000, NrOfInvocations.class, "self_nr_read_operations", ops, read, self);
        spec.appendColumn(I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Total Read Operations"), I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"The total number of read operations performed in {0}", (Object[])new Object[]{entity}), 2 | sumTotal | 0x8000, NrOfInvocations.class, "total_nr_read_operations", ops, read, total);
        spec.appendColumn(I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Self Write Operations"), I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"The total number of write operations performed directly in {0}", (Object[])new Object[]{entity}), 2 | sumSelf | 0x8000, NrOfInvocations.class, "self_nr_write_operations", ops, write, self);
        spec.appendColumn(I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Total Write Operations"), I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"The total number of write operations performed in {0}", (Object[])new Object[]{entity}), 2 | sumTotal | 0x8000, NrOfInvocations.class, "total_nr_write_operations", ops, write, total);
        spec.appendColumn(I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Self Read Throughput"), I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"The throughput of read operations directly performed in {0}", (Object[])new Object[]{entity}), 12290, NrOfBytesPerSecond.class, "self_throughput_read_operations_bytes_per_second", flow, read, self);
        spec.appendColumn(I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Total Read Throughput"), I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"The throughput of read operations performed in {0}", (Object[])new Object[]{entity}), 12290, NrOfBytesPerSecond.class, "total_throughput_read_operations_bytes_per_second", flow, read, total);
        spec.appendColumn(I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Self Write Throughput"), I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"The throughput of write operations directly performed in {0}", (Object[])new Object[]{entity}), 12290, NrOfBytesPerSecond.class, "self_throughput_write_operations_bytes_per_second", flow, write, self);
        spec.appendColumn(I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Total Write Throughput"), I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"The throughput of write operations performed in {0}", (Object[])new Object[]{entity}), 12290, NrOfBytesPerSecond.class, "total_throughput_write_operations_bytes_per_second", flow, write, total);
        spec.appendColumn(I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Self Avg Read Bytes"), I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"The average number of bytes directly read in {0}", (Object[])new Object[]{entity}), 12290, NrOfBytes.class, "self_read_bytes_average", avgBytes, read, self);
        spec.appendColumn(I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Total Avg Read Bytes"), I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"The average number of bytes read in {0}", (Object[])new Object[]{entity}), 12290, NrOfBytes.class, "total_read_bytes_average", avgBytes, read, total);
        spec.appendColumn(I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Self Avg Written Bytes"), I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"The average number of bytes directly written in {0}", (Object[])new Object[]{entity}), 12290, NrOfBytes.class, "self_written_bytes_average", avgBytes, write, self);
        spec.appendColumn(I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Total Avg Written Bytes"), I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"The average number of bytes written in {0}", (Object[])new Object[]{entity}), 12290, NrOfBytes.class, "total_written_bytes_average", avgBytes, write, total);
        spec.appendColumn(I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Self Avg Read Duration"), I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"The average duration of read operations directly performed in {0}", (Object[])new Object[]{entity}), 12290, ElapsedTime.class, "self_reading_operation_average_time_nanoseconds", avgDuration, read, self);
        spec.appendColumn(I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Total Avg Read Duration"), I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"The average duration of read operations performed in {0}", (Object[])new Object[]{entity}), 12290, ElapsedTime.class, "total_reading_operation_average_time_nanoseconds", avgDuration, read, total);
        spec.appendColumn(I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Self Avg Write Duration"), I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"The average duration of write operations directly performed in {0}", (Object[])new Object[]{entity}), 12290, ElapsedTime.class, "self_writing_operation_average_time_nanoseconds", avgDuration, write, self);
        spec.appendColumn(I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Total Avg Write Duration"), I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"The average duration of write operations performed in {0}", (Object[])new Object[]{entity}), 12290, ElapsedTime.class, "total_writing_operation_average_time_nanoseconds", avgDuration, write, total);
        return spec;
    }

    public static TypedColumnSpec getSelfAndTotalDetailedSpec(ResourceName name, boolean sortBySelf, SumBehavior sumBehavior, String entity) {
        int sumSelf = 0x3000 | (sumBehavior.sumSelf() ? 4 : 0);
        int sumTotal = 0x3000 | (sumBehavior.sumTotal() ? 4 : 0);
        VisibilitySet fd = new VisibilitySet("FD", "Group_1", I18n._tss((I18n.TextType)I18n.TextType.XCOL, (String)"short for file descriptor", (String)"FD"), "tables/column.gif", I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"File Descriptor"), new Integer[0]);
        VisibilitySet bytes = new VisibilitySet("Bytes", "Group_2", I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Bytes"), "tables/col_bytes.gif", I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"Number of read or written bytes"), new Integer[0]);
        VisibilitySet time = new VisibilitySet("Time", "Group_2", I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Time"), "tables/col_time.gif", I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"Duration of read or write operations"), new Integer[0]);
        VisibilitySet ops = new VisibilitySet("Operations", "Group_2", I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Operations"), "tables/column.gif", I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"Number of read or write operations"), new Integer[0]);
        VisibilitySet flow = new VisibilitySet("Throughput", "Group_2", I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Throughput"), "tables/column.gif", I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"Throughput of read or write operations"), new Integer[0]);
        VisibilitySet avgBytes = new VisibilitySet("AverageBytes", "Group_2", I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Average Bytes"), "tables/col_bytes.gif", I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"Average number of read or written bytes"), new Integer[0]);
        VisibilitySet avgDuration = new VisibilitySet("AverageDuration", "Group_2", I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Average Duration"), "tables/col_time.gif", I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"Average duration of read or write operations"), new Integer[0]);
        VisibilitySet openTs = new VisibilitySet("OpenTimestamp", "Group_3", I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Open Timestamp"), "decorators/dates.gif", I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"Open timestamp"), new Integer[0]);
        VisibilitySet closeTs = new VisibilitySet("CloseTimestamp", "Group_3", I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Close Timestamp"), "decorators/dates.gif", I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"Close timestamp"), new Integer[0]);
        VisibilitySet openThread = new VisibilitySet("OpeningThread", "Group_4", I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Opening Thread"), "views/thread_statistic.gif", I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"Opening thread"), new Integer[0]);
        VisibilitySet closeThread = new VisibilitySet("ClosingThread", "Group_4", I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Closing Thread"), "views/thread_statistic.gif", I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"Closing thread"), new Integer[0]);
        VisibilitySet read = new VisibilitySet("Read", "Group_5", I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Read"), "tables/col_read_bytes.gif", I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"Columns linked to reading operations"), new Integer[0]);
        VisibilitySet write = new VisibilitySet("Write", "Group_5", I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Write"), "tables/col_write_bytes.gif", I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"Columns linked to writing operations"), new Integer[0]);
        VisibilitySet self = new VisibilitySet("Self", "Group_6", I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Self"), "tables/col_self_nr_of.gif", I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"Self"), new Integer[0]);
        VisibilitySet total = new VisibilitySet("Total", "Group_6", I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Total"), "tables/col_total_nr_of.gif", I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"Total"), new Integer[0]);
        TypedColumnSpec spec = new TypedColumnSpec("Read|Write|Self|Total|Bytes|Time|OpeningThread");
        spec.appendColumn(I18n._tss((I18n.TextType)I18n.TextType.XCOL, (String)"short for file descriptor", (String)"FD"), I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"The file descriptor"), 8194, FileDescriptor.class, "file_descriptor", fd);
        spec.appendColumn(I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Self Read Bytes"), I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"The total number of bytes directly read within {0}", (Object[])new Object[]{entity}), 2 | sumSelf | (sortBySelf ? 256 : 0) | 0x8000, NrOfBytes.class, "self_read_bytes", bytes, read, self);
        spec.appendColumn(I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Total Read Bytes"), I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"The total number of bytes read within {0}", (Object[])new Object[]{entity}), 2 | sumTotal | (sortBySelf ? 0 : 256) | 0x8000, NrOfBytes.class, "total_read_bytes", bytes, read, total);
        spec.appendColumn(I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Self Written Bytes"), I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"The total number of bytes directly written by {0}", (Object[])new Object[]{entity}), 2 | sumSelf | 0x8000, NrOfBytes.class, "self_written_bytes", bytes, write, self);
        spec.appendColumn(I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Total Written Bytes"), I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"The total number of bytes written by {0}", (Object[])new Object[]{entity}), 2 | sumTotal | 0x8000, NrOfBytes.class, "total_written_bytes", bytes, write, total);
        spec.appendColumn(I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Self Read Time"), I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"The total time directly spent in {0} for reading bytes", (Object[])new Object[]{entity}), 2 | sumSelf | 0x8000, ElapsedTime.class, "self_elapsed_time_reading_nanoseconds", time, read, self);
        spec.appendColumn(I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Total Read Time"), I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"The total time spent in {0} for reading bytes", (Object[])new Object[]{entity}), 2 | sumTotal | 0x8000, ElapsedTime.class, "total_elapsed_time_reading_nanoseconds", time, read, total);
        spec.appendColumn(I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Self Write Time"), I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"The total time directly spent in {0} for writing bytes", (Object[])new Object[]{entity}), 2 | sumSelf | 0x8000, ElapsedTime.class, "self_elapsed_time_writing_nanoseconds", time, write, self);
        spec.appendColumn(I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Total Write Time"), I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"The total time spent in {0} for writing bytes", (Object[])new Object[]{entity}), 2 | sumTotal | 0x8000, ElapsedTime.class, "total_elapsed_time_writing_nanoseconds", time, write, total);
        spec.appendColumn(I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Self Read Operations"), I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"The total number of read operations performed directly in {0}", (Object[])new Object[]{entity}), 2 | sumSelf | 0x8000, NrOfInvocations.class, "self_nr_read_operations", ops, read, self);
        spec.appendColumn(I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Total Read Operations"), I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"The total number of read operations performed in {0}", (Object[])new Object[]{entity}), 2 | sumTotal | 0x8000, NrOfInvocations.class, "total_nr_read_operations", ops, read, total);
        spec.appendColumn(I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Self Write Operations"), I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"The total number of write operations performed directly in {0}", (Object[])new Object[]{entity}), 2 | sumSelf | 0x8000, NrOfInvocations.class, "self_nr_write_operations", ops, write, self);
        spec.appendColumn(I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Total Write Operations"), I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"The total number of write operations performed in {0}", (Object[])new Object[]{entity}), 2 | sumTotal | 0x8000, NrOfInvocations.class, "total_nr_write_operations", ops, write, total);
        spec.appendColumn(I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Self Read Throughput"), I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"The throughput of read operations directly performed in {0}", (Object[])new Object[]{entity}), 12290, NrOfBytesPerSecond.class, "self_throughput_read_operations_bytes_per_second", flow, read, self);
        spec.appendColumn(I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Total Read Throughput"), I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"The throughput of read operations performed in {0}", (Object[])new Object[]{entity}), 12290, NrOfBytesPerSecond.class, "total_throughput_read_operations_bytes_per_second", flow, read, total);
        spec.appendColumn(I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Self Write Throughput"), I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"The throughput of write operations directly performed in {0}", (Object[])new Object[]{entity}), 12290, NrOfBytesPerSecond.class, "self_throughput_write_operations_bytes_per_second", flow, write, self);
        spec.appendColumn(I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Total Write Throughput"), I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"The throughput of write operations performed in {0}", (Object[])new Object[]{entity}), 12290, NrOfBytesPerSecond.class, "total_throughput_write_operations_bytes_per_second", flow, write, total);
        spec.appendColumn(I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Self Avg Read Bytes"), I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"The average number of bytes directly read in {0}", (Object[])new Object[]{entity}), 12290, NrOfBytes.class, "self_read_bytes_average", avgBytes, read, self);
        spec.appendColumn(I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Total Avg Read Bytes"), I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"The average number of bytes read in {0}", (Object[])new Object[]{entity}), 12290, NrOfBytes.class, "total_read_bytes_average", avgBytes, read, total);
        spec.appendColumn(I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Self Avg Written Bytes"), I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"The average number of bytes directly written in {0}", (Object[])new Object[]{entity}), 12290, NrOfBytes.class, "self_written_bytes_average", avgBytes, write, self);
        spec.appendColumn(I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Total Avg Written Bytes"), I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"The average number of bytes written in {0}", (Object[])new Object[]{entity}), 12290, NrOfBytes.class, "total_written_bytes_average", avgBytes, write, total);
        spec.appendColumn(I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Self Avg Read Duration"), I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"The average duration of read operations directly performed in {0}", (Object[])new Object[]{entity}), 12290, ElapsedTime.class, "self_reading_operation_average_time_nanoseconds", avgDuration, read, self);
        spec.appendColumn(I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Total Avg Read Duration"), I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"The average duration of read operations performed in {0}", (Object[])new Object[]{entity}), 12290, ElapsedTime.class, "total_reading_operation_average_time_nanoseconds", avgDuration, read, total);
        spec.appendColumn(I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Self Avg Write Duration"), I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"The average duration of write operations directly performed in {0}", (Object[])new Object[]{entity}), 12290, ElapsedTime.class, "self_writing_operation_average_time_nanoseconds", avgDuration, write, self);
        spec.appendColumn(I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Total Avg Write Duration"), I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"The average duration of write operations performed in {0}", (Object[])new Object[]{entity}), 12290, ElapsedTime.class, "total_writing_operation_average_time_nanoseconds", avgDuration, write, total);
        spec.appendColumn(I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Opened At"), I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"Timestamp when the socket was opened"), 2, Timestamp.class, "timestamp_socket_opened_milliseconds_since_midnight_1970-01-01_UTC", openTs);
        spec.appendColumn(I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Closed At"), I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"Timestamp when the socket was closed"), 2, Timestamp.class, "timestamp_socket_closed_milliseconds_since_midnight_1970-01-01_UTC", closeTs);
        spec.appendColumn(I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Opening Thread ID"), I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"The id of the thread which opened the socket."), 2, NormalThreadId.class, "opening_thread_id", openThread);
        spec.appendColumn(I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Opening Thread Name"), I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"One name of the thread which opened the socket."), 2, NormalThreadName.class, "opening_thread_name", openThread);
        spec.appendColumn(I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Closing Thread ID"), I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"The id of the thread which closed the socket."), 2, NormalThreadId.class, "closing_thread_id", closeThread);
        spec.appendColumn(I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Closing Thread Name"), I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"One name of the thread which closed the socket."), 2, NormalThreadName.class, "closing_thread_name", closeThread);
        return spec;
    }

    public static TypedColumnSpec getNetStatisticBaseSpec(ResourceName name, String entity) {
        VisibilitySet openCount = new VisibilitySet("OpenCount", "Group_1", I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Open Count"), "tables/col_nr_of.gif", I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"Number of open operations"), new Integer[0]);
        VisibilitySet closeCount = new VisibilitySet("CloseCount", "Group_1", I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Close Count"), "tables/col_nr_of.gif", I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"Number of close operations"), new Integer[0]);
        VisibilitySet bytes = new VisibilitySet("Bytes", "Group_2", I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Bytes"), "tables/col_bytes.gif", I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"Number of read or written bytes"), new Integer[0]);
        VisibilitySet time = new VisibilitySet("Time", "Group_2", I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Time"), "tables/col_time.gif", I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"Duration of read or write operations"), new Integer[0]);
        VisibilitySet ops = new VisibilitySet("Operations", "Group_2", I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Operations"), "tables/column.gif", I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"Number of read or write operations"), new Integer[0]);
        VisibilitySet flow = new VisibilitySet("Throughput", "Group_2", I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Throughput"), "tables/column.gif", I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"Throughput of read or write operations"), new Integer[0]);
        VisibilitySet avgBytes = new VisibilitySet("AverageBytes", "Group_2", I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Average Bytes"), "tables/col_bytes.gif", I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"Average number of read or written bytes"), new Integer[0]);
        VisibilitySet avgDuration = new VisibilitySet("AverageDuration", "Group_2", I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Average Duration"), "tables/col_time.gif", I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"Average duration of read or write operations"), new Integer[0]);
        VisibilitySet read = new VisibilitySet("Read", "Group_3", I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Read"), "tables/col_read_bytes.gif", I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"Columns linked to reading operations"), new Integer[0]);
        VisibilitySet write = new VisibilitySet("Write", "Group_3", I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Write"), "tables/col_write_bytes.gif", I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"Columns linked to writing operations"), new Integer[0]);
        TypedColumnSpec spec = new TypedColumnSpec("Read|Write|OpenCount|Bytes|Time");
        spec.appendColumn(I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Opened"), I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"The number of times a socket was opened by {0}", (Object[])new Object[]{entity}), 45318, NrOfOpenedSockets.class, "nr_opened_sockets", openCount);
        spec.appendColumn(I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Closed"), I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"The number of times a socket was closed by {0}", (Object[])new Object[]{entity}), 45062, NrOfClosedSockets.class, "nr_closed_sockets", closeCount);
        spec.appendColumn(I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Read Bytes"), I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"The total number of bytes read by {0}", (Object[])new Object[]{entity}), 45062, NrOfBytes.class, "read_bytes", bytes, read);
        spec.appendColumn(I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Written Bytes"), I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"The total number of bytes written by {0}", (Object[])new Object[]{entity}), 45062, NrOfBytes.class, "written_bytes", bytes, write);
        spec.appendColumn(I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Read Time"), I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"The total time spent in reading sockets by {0}", (Object[])new Object[]{entity}), 45062, ElapsedTime.class, "elapsed_time_reading_nanoseconds", time, read);
        spec.appendColumn(I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Write Time"), I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"The total time spent in writing sockets by {0}", (Object[])new Object[]{entity}), 45062, ElapsedTime.class, "elapsed_time_writing_nanoseconds", time, write);
        spec.appendColumn(I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Read Operations"), I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"The total number of read operations performed by {0}", (Object[])new Object[]{entity}), 45062, NrOfInvocations.class, "nr_read_operations", ops, read);
        spec.appendColumn(I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Write Operations"), I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"The total number of write operations performed by {0}", (Object[])new Object[]{entity}), 45062, NrOfInvocations.class, "nr_write_operations", ops, write);
        spec.appendColumn(I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Read Throughput"), I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"The throughput of the read operations performed by {0}", (Object[])new Object[]{entity}), 12290, NrOfBytesPerSecond.class, "throughput_read_operations_bytes_per_second", flow, read);
        spec.appendColumn(I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Write Throughput"), I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"The throughput of the write operations performed by {0}", (Object[])new Object[]{entity}), 12290, NrOfBytesPerSecond.class, "throughput_write_operations_bytes_per_second", flow, write);
        spec.appendColumn(I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Avg Read Bytes"), I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"The average number of bytes read by {0}", (Object[])new Object[]{entity}), 12290, NrOfBytes.class, "read_bytes_average", avgBytes, read);
        spec.appendColumn(I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Avg Written Bytes"), I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"The average number of bytes written by {0}", (Object[])new Object[]{entity}), 12290, NrOfBytes.class, "written_bytes_average", avgBytes, write);
        spec.appendColumn(I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Avg Read Duration"), I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"The average time of read operations performed by {0}", (Object[])new Object[]{entity}), 12290, ElapsedTime.class, "reading_operation_average_time_nanoseconds", avgDuration, read);
        spec.appendColumn(I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Avg Write Duration"), I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"The average time of write operations performed by {0}", (Object[])new Object[]{entity}), 12290, ElapsedTime.class, "writing_operation_average_time_nanoseconds", avgDuration, write);
        return spec;
    }

    public static TypedColumnSpec getSocketLatencyStatisticSpec(ResourceName name) {
        TypedColumnSpec spec = new TypedColumnSpec("Latency");
        spec.appendColumn(I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Latency"), I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"The latency between operations to this socket relevant for the connection side.\nOn the server side, this is the latency between read and write operations.\nOn the client side, this is the latency between write and read operations."), 262, ElapsedTime.class, "default_latency_sum", new VisibilitySet("Latency", "Group_4", I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Latency"), "tables/col_time.gif", I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"Columns linked to latencies that are relevant for the connection side\nOn the server side, this is the latency between read and write operations\nOn the client side, this is the latency between write and read operations"), new Integer[0]));
        spec.appendColumn(I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Read/Write Latency"), I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"The latency between read and write operations to this socket"), 12294, ElapsedTime.class, "read_write_latency_sum", new VisibilitySet("Read/Write Latency", "Group_4", I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Read/Write Latency"), "tables/col_time.gif", I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"Columns linked to latencies between read and write operations"), new Integer[0]));
        spec.appendColumn(I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Write/Read Latency"), I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"The latency between write and read operations to this socket"), 12294, ElapsedTime.class, "write_read_latency_sum", new VisibilitySet("Write/Read Latency", "Group_4", I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Write/Read Latency"), "tables/col_time.gif", I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"Columns linked to latencies between write and read operations"), new Integer[0]));
        return spec;
    }

    public static TypedColumnSpec prependNetworkConnection(TypedColumnSpec spec) {
        return spec.prepend(I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Protocol"), I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"Indicates whether a stream (TCP) or datagram (UDP) connection was used"), 1289, NormalNetworkConnectionType.class, "network_connection_type").prepend(I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Remote Port"), I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"The remote port of the socket"), 1289, NormalNetworkPort.class, "network_port").prepend(I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Remote Address"), I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"The remote address of the socket"), 1289, NormalNetworkAddress.class, "network_address").prepend(I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Local Port"), I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"The local port of the socket"), 1289, NormalNetworkPort.class, "network_port").prepend(I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Local Address"), I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"The local address of the socket"), 1289, NormalNetworkAddress.class, "network_address");
    }

    public static TypedColumnSpec prependNetworkService(TypedColumnSpec spec) {
        return spec.prepend(I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Protocol"), I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"Indicates whether a stream (TCP) or datagram (UDP) connection was used"), 1289, NormalNetworkConnectionType.class, "network_connection_type").prepend(I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Server/Client"), I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"Type of the connection side"), 1289, NormalNetworkEndpointType.class, "network_endpoint_type").prepend(I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Service Port"), I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"The port of the network service"), 1289, NormalNetworkPort.class, "network_port").prepend(I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Service Name"), I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"The short name of the network service"), 265, NormalString.class, "network_service_name");
    }

    public static TypedColumnSpec prependNetworkHost(TypedColumnSpec spec) {
        return spec.prepend(I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Address"), I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"The IP address of the host"), 1289, NormalNetworkAddress.class, "network_address").prepend(I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Host Name"), I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"The host name or IP address of the remote host"), 265, NormalString.class, "network_host_name");
    }

    public static TypedColumnSpec prependNetworkLatencyIndex(TypedColumnSpec spec) {
        return spec.prepend(I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Timestamp"), I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"The timestamp of the first operation"), 8457, Timestamp.class, "network_latency_id").prepend(I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Index"), I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"The index of the roundtrip"), 265, NormalNetworkLatencyId.class, "network_latency_id");
    }

    public static Column getColumn(NetworkOperationsColumn column, int columnIndex) {
        switch (columnIndex) {
            case 0: {
                return column.getOpenCountColumn();
            }
            case 1: {
                return column.getCloseCountColumn();
            }
            case 2: {
                return column.getReadBytesColumn();
            }
            case 3: {
                return column.getWrittenBytesColumn();
            }
            case 4: {
                return column.getReadTimeColumn();
            }
            case 5: {
                return column.getWriteTimeColumn();
            }
            case 6: {
                return column.getReadOperationsColumn();
            }
            case 7: {
                return column.getWriteOperationsColumn();
            }
            case 8: {
                return column.getReadTroughputColumn();
            }
            case 9: {
                return column.getWriteThroughputColumn();
            }
            case 10: {
                return column.getReadBytesPerOperationColumn();
            }
            case 11: {
                return column.getWrittenBytesPerOperationColumn();
            }
            case 12: {
                return column.getTimePerReadOperationColumn();
            }
            case 13: {
                return column.getTimePerWriteOperationColumn();
            }
        }
        assert (false);
        return null;
    }

    private static Quantity getEntry(NetworkOperations value, int column, NetworkOperations total, NetworkProvider provider) {
        switch (column) {
            case 0: {
                return NrOfOpenedSockets.PROTOTYPE.create(value.getOpenCount(), total.getOpenCount());
            }
            case 1: {
                return NrOfClosedSockets.PROTOTYPE.create(value.getCloseCount(), total.getCloseCount());
            }
            case 2: {
                return NrOfBytes.PROTOTYPE.create(value.getReadBytes(), total.getReadBytes());
            }
            case 3: {
                return NrOfBytes.PROTOTYPE.create(value.getWrittenBytes(), total.getWrittenBytes());
            }
            case 4: {
                return ElapsedTime.PROTOTYPE.create(value.getReadTime(), total.getReadTime());
            }
            case 5: {
                return ElapsedTime.PROTOTYPE.create(value.getWriteTime(), total.getWriteTime());
            }
            case 6: {
                return NrOfInvocations.PROTOTYPE.create(value.getReadOperations(), total.getReadOperations());
            }
            case 7: {
                return NrOfInvocations.PROTOTYPE.create(value.getWriteOperations(), total.getWriteOperations());
            }
            case 8: {
                return NrOfBytesPerSecond.PROTOTYPE.create(value.getReadTime() == 0L ? 0L : (long)((double)value.getReadBytes() * 1.0E9 / (double)value.getReadTime()));
            }
            case 9: {
                return NrOfBytesPerSecond.PROTOTYPE.create(value.getWriteTime() == 0L ? 0L : (long)((double)value.getWrittenBytes() * 1.0E9 / (double)value.getWriteTime()));
            }
            case 10: {
                return NrOfBytes.PROTOTYPE.create(value.getReadOperations() == 0L ? 0L : value.getReadBytes() / value.getReadOperations());
            }
            case 11: {
                return NrOfBytes.PROTOTYPE.create(value.getWriteOperations() == 0L ? 0L : value.getWrittenBytes() / value.getWriteOperations());
            }
            case 12: {
                return ElapsedTime.PROTOTYPE.create(value.getReadOperations() == 0L ? 0L : value.getReadTime() / value.getReadOperations());
            }
            case 13: {
                return ElapsedTime.PROTOTYPE.create(value.getWriteOperations() == 0L ? 0L : value.getWriteTime() / value.getWriteOperations());
            }
        }
        assert (false);
        return null;
    }

    private static Column getColumn(NetworkOperationsAndDetailsColumn column, int columnIndex) {
        switch (columnIndex) {
            case 0: {
                return column.getFdColumn();
            }
            case 1: {
                return column.getReadBytesColumn();
            }
            case 2: {
                return column.getWrittenBytesColumn();
            }
            case 3: {
                return column.getReadTimeColumn();
            }
            case 4: {
                return column.getWriteTimeColumn();
            }
            case 5: {
                return column.getReadOperationsColumn();
            }
            case 6: {
                return column.getWriteOperationsColumn();
            }
            case 7: {
                return column.getReadTroughputColumn();
            }
            case 8: {
                return column.getWriteThroughputColumn();
            }
            case 9: {
                return column.getReadBytesPerOperationColumn();
            }
            case 10: {
                return column.getWrittenBytesPerOperationColumn();
            }
            case 11: {
                return column.getTimePerReadOperationColumn();
            }
            case 12: {
                return column.getTimePerWriteOperationColumn();
            }
            case 13: {
                return column.getOpenTimestampColumn();
            }
            case 14: {
                return column.getCloseTimestampColumn();
            }
            case 15: {
                return column.getOpeningThreadIdColumn();
            }
            case 16: {
                return column.getOpeningThreadNameColumn();
            }
            case 17: {
                return column.getClosingThreadIdColumn();
            }
            case 18: {
                return column.getClosingThreadNameColumn();
            }
            case 19: {
                return column.getMinDefaultLatencyColumn();
            }
            case 20: {
                return column.getMaxDefaultLatencyColumn();
            }
            case 21: {
                return column.getDefaultLatencySumColumn();
            }
            case 22: {
                return column.getDefaultLatencyCountColumn();
            }
            case 23: {
                return column.getAverageDefaultLatencyColumn();
            }
            case 24: {
                return column.getMinReadWriteLatencyColumn();
            }
            case 25: {
                return column.getMaxReadWriteLatencyColumn();
            }
            case 26: {
                return column.getReadWriteLatencySumColumn();
            }
            case 27: {
                return column.getReadWriteLatencyCountColumn();
            }
            case 28: {
                return column.getAverageReadWriteLatencyColumn();
            }
            case 29: {
                return column.getMinWriteReadLatencyColumn();
            }
            case 30: {
                return column.getMaxWriteReadLatencyColumn();
            }
            case 31: {
                return column.getWriteReadLatencySumColumn();
            }
            case 32: {
                return column.getWriteReadLatencyCountColumn();
            }
            case 33: {
                return column.getAverageWriteReadLatencyColumn();
            }
        }
        assert (false);
        return null;
    }

    private static ProviderEntry getEntryDetailed(NetworkOperationsAndDetails value, int column, NetworkOperationsAndDetails total, NetworkProvider provider) {
        switch (column) {
            case 0: {
                return new FileDescriptor(value.getFd());
            }
            case 1: {
                return NrOfBytes.PROTOTYPE.create(value.getReadBytes(), total.getReadBytes());
            }
            case 2: {
                return NrOfBytes.PROTOTYPE.create(value.getWrittenBytes(), total.getWrittenBytes());
            }
            case 3: {
                return ElapsedTime.PROTOTYPE.create(value.getReadTime(), total.getReadTime());
            }
            case 4: {
                return ElapsedTime.PROTOTYPE.create(value.getWriteTime(), total.getWriteTime());
            }
            case 5: {
                return NrOfInvocations.PROTOTYPE.create(value.getReadOperations(), total.getReadOperations());
            }
            case 6: {
                return NrOfInvocations.PROTOTYPE.create(value.getWriteOperations(), total.getWriteOperations());
            }
            case 7: {
                return NrOfBytesPerSecond.PROTOTYPE.create(value.getReadTime() == 0L ? 0L : (long)((double)value.getReadBytes() * 1.0E9 / (double)value.getReadTime()));
            }
            case 8: {
                return NrOfBytesPerSecond.PROTOTYPE.create(value.getWriteTime() == 0L ? 0L : (long)((double)value.getWrittenBytes() * 1.0E9 / (double)value.getWriteTime()));
            }
            case 9: {
                return NrOfBytes.PROTOTYPE.create(value.getReadOperations() == 0L ? 0L : value.getReadBytes() / value.getReadOperations());
            }
            case 10: {
                return NrOfBytes.PROTOTYPE.create(value.getWriteOperations() == 0L ? 0L : value.getWrittenBytes() / value.getWriteOperations());
            }
            case 11: {
                return ElapsedTime.PROTOTYPE.create(value.getReadOperations() == 0L ? 0L : value.getReadTime() / value.getReadOperations());
            }
            case 12: {
                return ElapsedTime.PROTOTYPE.create(value.getWriteOperations() == 0L ? 0L : value.getWriteTime() / value.getWriteOperations());
            }
            case 13: {
                long openTimestamp = value.getOpenTimestamp();
                if (openTimestamp != 0L) {
                    return new Timestamp(openTimestamp);
                }
                return new Timestamp(I18n._ss((String)"Missing timestamp|Socket open", (String)"<not available>"));
            }
            case 14: {
                long closeTimestamp = value.getCloseTimestamp();
                if (closeTimestamp != 0L) {
                    return new Timestamp(closeTimestamp);
                }
                return new Timestamp(I18n._ss((String)"Missing timestamp|Socket close", (String)"<never closed>"));
            }
            case 15: {
                return new NormalThreadId(value.getOpeningThreadId());
            }
            case 16: {
                return new NormalThreadName(value.getOpeningThreadName(), I18n._ss((String)"Missing thread name|Socket open", (String)"<not available>"));
            }
            case 17: {
                return new NormalThreadId(value.getClosingThreadId());
            }
            case 18: {
                return new NormalThreadName(value.getClosingThreadName(), I18n._ss((String)"Missing thread name|Socket close", (String)"<never closed>"));
            }
            case 19: {
                return ElapsedTime.PROTOTYPE.create(value.getMinDefaultLatency() * 1000000L, total.getMinDefaultLatency() * 1000000L);
            }
            case 20: {
                return ElapsedTime.PROTOTYPE.create(value.getMaxDefaultLatency() * 1000000L, total.getMaxDefaultLatency() * 1000000L);
            }
            case 21: {
                return ElapsedTime.PROTOTYPE.create(value.getDefaultLatencySum() * 1000000L, total.getDefaultLatencySum() * 1000000L);
            }
            case 22: {
                return NrOfRoundtrips.PROTOTYPE.create(value.getDefaultLatencyCount(), total.getDefaultLatencyCount());
            }
            case 23: {
                return ElapsedTime.PROTOTYPE.create(value.getDefaultLatencyCount() == 0L ? 0L : value.getDefaultLatencySum() * 1000000L / value.getDefaultLatencyCount());
            }
            case 24: {
                return ElapsedTime.PROTOTYPE.create(value.getMinReadWriteLatency() * 1000000L, total.getMinReadWriteLatency() * 1000000L);
            }
            case 25: {
                return ElapsedTime.PROTOTYPE.create(value.getMaxReadWriteLatency() * 1000000L, total.getMaxReadWriteLatency() * 1000000L);
            }
            case 26: {
                return ElapsedTime.PROTOTYPE.create(value.getReadWriteLatencySum() * 1000000L, total.getReadWriteLatencySum() * 1000000L);
            }
            case 27: {
                return NrOfReadWriteRoundtrips.PROTOTYPE.create(value.getReadWriteLatencyCount(), total.getReadWriteLatencyCount());
            }
            case 28: {
                return ElapsedTime.PROTOTYPE.create(value.getReadWriteLatencyCount() == 0L ? 0L : value.getReadWriteLatencySum() * 1000000L / value.getReadWriteLatencyCount());
            }
            case 29: {
                return ElapsedTime.PROTOTYPE.create(value.getMinWriteReadLatency() * 1000000L, total.getMinWriteReadLatency() * 1000000L);
            }
            case 30: {
                return ElapsedTime.PROTOTYPE.create(value.getMaxWriteReadLatency() * 1000000L, total.getMaxWriteReadLatency() * 1000000L);
            }
            case 31: {
                return ElapsedTime.PROTOTYPE.create(value.getWriteReadLatencySum() * 1000000L, total.getWriteReadLatencySum() * 1000000L);
            }
            case 32: {
                return NrOfWriteReadRoundtrips.PROTOTYPE.create(value.getWriteReadLatencyCount(), total.getWriteReadLatencyCount());
            }
            case 33: {
                return ElapsedTime.PROTOTYPE.create(value.getWriteReadLatencyCount() == 0L ? 0L : value.getWriteReadLatencySum() * 1000000L / value.getWriteReadLatencyCount());
            }
        }
        assert (false);
        return null;
    }

    public static Column getColumn(NetworkOperationsAndLatenciesColumn column, int columnIndex) {
        switch (columnIndex) {
            case 0: {
                return column.getOpenCountColumn();
            }
            case 1: {
                return column.getCloseCountColumn();
            }
            case 2: {
                return column.getReadBytesColumn();
            }
            case 3: {
                return column.getWrittenBytesColumn();
            }
            case 4: {
                return column.getReadTimeColumn();
            }
            case 5: {
                return column.getWriteTimeColumn();
            }
            case 6: {
                return column.getReadOperationsColumn();
            }
            case 7: {
                return column.getWriteOperationsColumn();
            }
            case 8: {
                return column.getReadTroughputColumn();
            }
            case 9: {
                return column.getWriteThroughputColumn();
            }
            case 10: {
                return column.getReadBytesPerOperationColumn();
            }
            case 11: {
                return column.getWrittenBytesPerOperationColumn();
            }
            case 12: {
                return column.getTimePerReadOperationColumn();
            }
            case 13: {
                return column.getTimePerWriteOperationColumn();
            }
            case 14: {
                return column.getMinDefaultLatencyColumn();
            }
            case 15: {
                return column.getMaxDefaultLatencyColumn();
            }
            case 16: {
                return column.getDefaultLatencySumColumn();
            }
            case 17: {
                return column.getDefaultLatencyCountColumn();
            }
            case 18: {
                return column.getAverageDefaultLatencyColumn();
            }
            case 19: {
                return column.getMinReadWriteLatencyColumn();
            }
            case 20: {
                return column.getMaxReadWriteLatencyColumn();
            }
            case 21: {
                return column.getReadWriteLatencySumColumn();
            }
            case 22: {
                return column.getReadWriteLatencyCountColumn();
            }
            case 23: {
                return column.getAverageReadWriteLatencyColumn();
            }
            case 24: {
                return column.getMinWriteReadLatencyColumn();
            }
            case 25: {
                return column.getMaxWriteReadLatencyColumn();
            }
            case 26: {
                return column.getWriteReadLatencySumColumn();
            }
            case 27: {
                return column.getWriteReadLatencyCountColumn();
            }
            case 28: {
                return column.getAverageWriteReadLatencyColumn();
            }
        }
        assert (false);
        return null;
    }

    private static Quantity getEntryWithLatencies(NetworkOperationsAndLatencies value, int column, NetworkOperationsAndLatencies total, NetworkProvider provider) {
        switch (column) {
            case 0: {
                return NrOfOpenedSockets.PROTOTYPE.create(value.getOpenCount(), total.getOpenCount());
            }
            case 1: {
                return NrOfClosedSockets.PROTOTYPE.create(value.getCloseCount(), total.getCloseCount());
            }
            case 2: {
                return NrOfBytes.PROTOTYPE.create(value.getReadBytes(), total.getReadBytes());
            }
            case 3: {
                return NrOfBytes.PROTOTYPE.create(value.getWrittenBytes(), total.getWrittenBytes());
            }
            case 4: {
                return ElapsedTime.PROTOTYPE.create(value.getReadTime(), total.getReadTime());
            }
            case 5: {
                return ElapsedTime.PROTOTYPE.create(value.getWriteTime(), total.getWriteTime());
            }
            case 6: {
                return NrOfInvocations.PROTOTYPE.create(value.getReadOperations(), total.getReadOperations());
            }
            case 7: {
                return NrOfInvocations.PROTOTYPE.create(value.getWriteOperations(), total.getWriteOperations());
            }
            case 8: {
                return NrOfBytesPerSecond.PROTOTYPE.create(value.getReadTime() == 0L ? 0L : (long)((double)value.getReadBytes() * 1.0E9 / (double)value.getReadTime()));
            }
            case 9: {
                return NrOfBytesPerSecond.PROTOTYPE.create(value.getWriteTime() == 0L ? 0L : (long)((double)value.getWrittenBytes() * 1.0E9 / (double)value.getWriteTime()));
            }
            case 10: {
                return NrOfBytes.PROTOTYPE.create(value.getReadOperations() == 0L ? 0L : value.getReadBytes() / value.getReadOperations());
            }
            case 11: {
                return NrOfBytes.PROTOTYPE.create(value.getWriteOperations() == 0L ? 0L : value.getWrittenBytes() / value.getWriteOperations());
            }
            case 12: {
                return ElapsedTime.PROTOTYPE.create(value.getReadOperations() == 0L ? 0L : value.getReadTime() / value.getReadOperations());
            }
            case 13: {
                return ElapsedTime.PROTOTYPE.create(value.getWriteOperations() == 0L ? 0L : value.getWriteTime() / value.getWriteOperations());
            }
            case 14: {
                return ElapsedTime.PROTOTYPE.create(value.getMinDefaultLatency() * 1000000L, total.getMinDefaultLatency() * 1000000L);
            }
            case 15: {
                return ElapsedTime.PROTOTYPE.create(value.getMaxDefaultLatency() * 1000000L, total.getMaxDefaultLatency() * 1000000L);
            }
            case 16: {
                return ElapsedTime.PROTOTYPE.create(value.getDefaultLatencySum() * 1000000L, total.getDefaultLatencySum() * 1000000L);
            }
            case 17: {
                return NrOfRoundtrips.PROTOTYPE.create(value.getDefaultLatencyCount(), total.getDefaultLatencyCount());
            }
            case 18: {
                return ElapsedTime.PROTOTYPE.create(value.getDefaultLatencyCount() == 0L ? 0L : value.getDefaultLatencySum() * 1000000L / value.getDefaultLatencyCount());
            }
            case 19: {
                return ElapsedTime.PROTOTYPE.create(value.getMinReadWriteLatency() * 1000000L, total.getMinReadWriteLatency() * 1000000L);
            }
            case 20: {
                return ElapsedTime.PROTOTYPE.create(value.getMaxReadWriteLatency() * 1000000L, total.getMaxReadWriteLatency() * 1000000L);
            }
            case 21: {
                return ElapsedTime.PROTOTYPE.create(value.getReadWriteLatencySum() * 1000000L, total.getReadWriteLatencySum() * 1000000L);
            }
            case 22: {
                return NrOfReadWriteRoundtrips.PROTOTYPE.create(value.getReadWriteLatencyCount(), total.getReadWriteLatencyCount());
            }
            case 23: {
                return ElapsedTime.PROTOTYPE.create(value.getReadWriteLatencyCount() == 0L ? 0L : value.getReadWriteLatencySum() * 1000000L / value.getReadWriteLatencyCount());
            }
            case 24: {
                return ElapsedTime.PROTOTYPE.create(value.getMinWriteReadLatency() * 1000000L, total.getMinWriteReadLatency() * 1000000L);
            }
            case 25: {
                return ElapsedTime.PROTOTYPE.create(value.getMaxWriteReadLatency() * 1000000L, total.getMaxWriteReadLatency() * 1000000L);
            }
            case 26: {
                return ElapsedTime.PROTOTYPE.create(value.getWriteReadLatencySum() * 1000000L, total.getWriteReadLatencySum() * 1000000L);
            }
            case 27: {
                return NrOfWriteReadRoundtrips.PROTOTYPE.create(value.getWriteReadLatencyCount(), total.getWriteReadLatencyCount());
            }
            case 28: {
                return ElapsedTime.PROTOTYPE.create(value.getWriteReadLatencyCount() == 0L ? 0L : value.getWriteReadLatencySum() * 1000000L / value.getWriteReadLatencyCount());
            }
        }
        assert (false);
        return null;
    }

    public static Column getColumn(NetworkLatenciesColumn column, int columnIndex) {
        switch (columnIndex) {
            case 0: {
                return column.getDefaultLatencySumColumn();
            }
            case 1: {
                return column.getReadWriteLatencySumColumn();
            }
            case 2: {
                return column.getWriteReadLatencySumColumn();
            }
        }
        assert (false);
        return null;
    }

    private static Quantity getEntryWithLatenciesOnly(NetworkLatencies value, int column, NetworkLatencies total, NetworkProvider provider) {
        switch (column) {
            case 0: {
                return ElapsedTime.PROTOTYPE.create(value.getDefaultLatencySum() * 1000000L, total.getDefaultLatencySum() * 1000000L);
            }
            case 1: {
                return ElapsedTime.PROTOTYPE.create(value.getReadWriteLatencySum() * 1000000L, total.getReadWriteLatencySum() * 1000000L);
            }
            case 2: {
                return ElapsedTime.PROTOTYPE.create(value.getWriteReadLatencySum() * 1000000L, total.getWriteReadLatencySum() * 1000000L);
            }
        }
        assert (false);
        return null;
    }

    private static Column getColumn(NetworkDetailsColumn column, int columnIndex) {
        switch (columnIndex) {
            case 0: {
                return column.getFdColumn();
            }
            case 1: {
                return column.getOpenTimestampColumn();
            }
            case 2: {
                return column.getCloseTimestampColumn();
            }
            case 3: {
                return column.getOpeningThreadIdColumn();
            }
            case 4: {
                return column.getOpeningThreadNameColumn();
            }
            case 5: {
                return column.getOpeningThreadIdColumn();
            }
            case 6: {
                return column.getOpeningThreadNameColumn();
            }
        }
        assert (false);
        return null;
    }

    private static ProviderEntry getEntry(NetworkDetails value, int column) {
        switch (column) {
            case 0: {
                return new FileDescriptor(value.getFd());
            }
            case 1: {
                long openTimestamp = value.getOpenTimestamp();
                if (openTimestamp != 0L) {
                    return new Timestamp(openTimestamp);
                }
                return new Timestamp(I18n._ss((String)"Missing timestamp|Socket open", (String)"<not available>"));
            }
            case 2: {
                long closeTimestamp = value.getCloseTimestamp();
                if (closeTimestamp != 0L) {
                    return new Timestamp(closeTimestamp);
                }
                return new Timestamp(I18n._ss((String)"Missing timestamp|Socket close", (String)"<never closed>"));
            }
            case 3: {
                return new NormalThreadId(value.getOpeningThreadId());
            }
            case 4: {
                return new NormalThreadName(value.getOpeningThreadName(), I18n._ss((String)"Missing thread name|Socket open", (String)"<not available>"));
            }
            case 5: {
                return new NormalThreadId(value.getClosingThreadId());
            }
            case 6: {
                return new NormalThreadName(value.getClosingThreadName(), I18n._ss((String)"Missing thread name|Socket close", (String)"<never closed>"));
            }
        }
        assert (false);
        return null;
    }

    public static Column getColumn(int column, SelfAndTotalValueStatistic<?, NetworkOperations> statistic) {
        if ((column & 1) == 0) {
            return ProviderUtils.getColumn((NetworkOperationsColumn)statistic.getSelfColumn(), column / 2);
        }
        return ProviderUtils.getColumn((NetworkOperationsColumn)statistic.getTotalColumn(), column / 2);
    }

    public static Quantity getEntry(int id, int column, SelfAndTotalValueStatistic<?, NetworkOperations> statistic, NetworkProvider provider) {
        if ((column & 1) == 0) {
            return ProviderUtils.getEntry(statistic.getSelf(id), column / 2, statistic.getTotal(), provider);
        }
        return ProviderUtils.getEntry(statistic.getTotal(id), column / 2, statistic.getTotal(), provider);
    }

    public static Column getColumnDetailed(int column, SelfTotalAndOtherValueStatistic<?, NetworkOperations, NetworkDetails> statistic) {
        if (column == 0) {
            return ProviderUtils.getColumn((NetworkDetailsColumn)statistic.getOtherColumn(), column);
        }
        if (column > 24) {
            return ProviderUtils.getColumn((NetworkDetailsColumn)statistic.getOtherColumn(), column - 24);
        }
        int selfTotalCol = column + 3;
        if ((selfTotalCol & 1) == 0) {
            return ProviderUtils.getColumn((NetworkOperationsColumn)statistic.getSelfColumn(), selfTotalCol / 2);
        }
        return ProviderUtils.getColumn((NetworkOperationsColumn)statistic.getTotalColumn(), selfTotalCol / 2);
    }

    public static ProviderEntry getEntryDetailed(int id, int column, SelfTotalAndOtherValueStatistic<?, NetworkOperations, NetworkDetails> statistic, NetworkProvider provider) {
        if (column == 0) {
            return ProviderUtils.getEntry(statistic.getOther(id), column);
        }
        if (column > 24) {
            return ProviderUtils.getEntry(statistic.getOther(id), column - 24);
        }
        int selfTotalCol = column + 3;
        if ((selfTotalCol & 1) == 0) {
            return ProviderUtils.getEntry((NetworkOperations)statistic.getSelf(id), selfTotalCol / 2, (NetworkOperations)statistic.getTotal(), provider);
        }
        return ProviderUtils.getEntry((NetworkOperations)statistic.getTotal(id), selfTotalCol / 2, (NetworkOperations)statistic.getTotal(), provider);
    }

    public static Column getColumn(int column, ValueStatistic<?, NetworkOperations> statistic) {
        return ProviderUtils.getColumn((NetworkOperationsColumn)statistic.getValueColumn(), column);
    }

    public static Quantity getEntry(int id, int column, ValueStatistic<?, NetworkOperations> statistic, NetworkProvider provider) {
        return ProviderUtils.getEntry(statistic.getValue(id), column, statistic.getValue(), provider);
    }

    public static Column getColumnDetailed(int column, ValueStatistic<?, NetworkOperationsAndDetails> statistic) {
        return ProviderUtils.getColumn((NetworkOperationsAndDetailsColumn)((Object)statistic.getValueColumn()), column);
    }

    public static ProviderEntry getEntryDetailed(int id, int column, ValueStatistic<?, NetworkOperationsAndDetails> statistic, NetworkProvider provider) {
        return ProviderUtils.getEntryDetailed(statistic.getValue(id), column, statistic.getValue(), provider);
    }

    public static Column getColumnWithLatencies(int column, ValueStatistic<?, NetworkOperationsAndLatencies> statistic) {
        return ProviderUtils.getColumn((NetworkOperationsAndLatenciesColumn)statistic.getValueColumn(), column);
    }

    public static ProviderEntry getEntryWithLatencies(int id, int column, ValueStatistic<?, NetworkOperationsAndLatencies> statistic, NetworkProvider provider) {
        return ProviderUtils.getEntryWithLatencies(statistic.getValue(id), column, statistic.getValue(), provider);
    }

    public static Column getColumnWithLatenciesOnly(int column, ValueStatistic<?, NetworkLatencies> statistic) {
        return ProviderUtils.getColumn((NetworkLatenciesColumn)statistic.getValueColumn(), column);
    }

    public static ProviderEntry getEntryWithLatenciesOnly(int id, int column, ValueStatistic<?, NetworkLatencies> statistic, NetworkProvider provider) {
        return ProviderUtils.getEntryWithLatenciesOnly(statistic.getValue(id), column, statistic.getValue(), provider);
    }

    public static Quantity getEntry(SelfAndTotalValueTreeNode<?, NetworkOperations> node, int column, ValueTreeBase<?, NetworkOperations, ?> tree, NetworkProvider provider) {
        if ((column & 1) == 0) {
            return ProviderUtils.getEntry(node.getSelf(), column / 2, tree.getTotal(), provider);
        }
        return ProviderUtils.getEntry(node.getTotal(), column / 2, tree.getTotal(), provider);
    }

    public static Column getColumn(NetworkConnectionColumn column, int columnIndex) {
        switch (columnIndex) {
            case 0: {
                return column.getLocalAddressColumn();
            }
            case 1: {
                return column.getLocalPortColumn();
            }
            case 2: {
                return column.getRemoteAddressColumn();
            }
            case 3: {
                return column.getRemotePortColumn();
            }
            case 4: {
                return column.getSocketTypeColumn();
            }
        }
        assert (false);
        return null;
    }

    public static Column getColumn(NetworkServiceColumn column, int columnIndex) {
        switch (columnIndex) {
            case 0: {
                return column.getServiceNameColumn();
            }
            case 1: {
                return column.getPortColumn();
            }
            case 2: {
                return column.getServerClientColumn();
            }
            case 3: {
                return column.getSocketTypeColumn();
            }
        }
        assert (false);
        return null;
    }

    public static Column getColumn(NetworkHostColumn column, int columnIndex) {
        switch (columnIndex) {
            case 0: {
                return column.getHostnameColumn();
            }
            case 1: {
                return column.getAddressColumn();
            }
        }
        assert (false);
        return null;
    }

    public static ProviderEntry getEntry(NetworkConnection connection, int column) {
        switch (column) {
            case 0: {
                return new NormalNetworkAddress(connection.getLocalAddress(), true);
            }
            case 1: {
                return new NormalNetworkPort(connection.getLocalPort());
            }
            case 2: {
                return new NormalNetworkAddress(connection.getRemoteAddress(), false);
            }
            case 3: {
                return new NormalNetworkPort(connection.getRemotePort());
            }
            case 4: {
                return new NormalNetworkConnectionType(connection.isStreamSocket());
            }
        }
        assert (false);
        return null;
    }

    public static ProviderEntry getEntry(NetworkService service, int column) {
        switch (column) {
            case 0: {
                return new NormalString(service.getServiceName());
            }
            case 1: {
                return new NormalNetworkPort(service.getPort());
            }
            case 2: {
                return new NormalNetworkEndpointType(service.getSideType());
            }
            case 3: {
                return new NormalNetworkConnectionType(service.isStream());
            }
        }
        assert (false);
        return null;
    }

    public static ProviderEntry getEntry(NetworkHost host, int column) {
        switch (column) {
            case 0: {
                return new NormalString(host.getHostname());
            }
            case 1: {
                return new NormalNetworkAddress(host.getAddress(), false);
            }
        }
        assert (false);
        return null;
    }

    public static ProviderEntry getEntry(NetworkLatencyId latencyId, int column) {
        switch (column) {
            case 0: {
                return new NormalNetworkLatencyId(latencyId.getId());
            }
            case 1: {
                return new Timestamp(latencyId.getTimestamp());
            }
        }
        assert (false);
        return null;
    }
}

