/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.presentation.impl.typed.net;

import com.sap.jvm.profiling.i18n.I18n;
import com.sap.jvm.profiling.presentation.impl.typed.net.NetworkProvider;
import com.sap.jvm.profiling.presentation.impl.typed.net.NetworkTableProvider;
import com.sap.jvm.profiling.presentation.impl.typed.net.ProviderUtils;
import com.sap.jvm.profiling.presentation.typed.entries.ProviderEntry;
import com.sap.jvm.profiling.resource.ResourceName;
import com.sap.jvm.profiling.resource.ResourceNameElement;
import com.sap.jvm.profiling.snapshot.net.Elements;
import com.sap.jvm.profiling.snapshot.net.SocketLatencyStatistic;
import com.sap.jvm.profiling.snapshot.resource.NetworkLatencyId;
import com.sap.jvm.profiling.snapshot.util.ValueStatistic;
import com.sap.jvm.profiling.snapshot.util.column.Column;

public final class SocketLatencyStatisticProvider
extends NetworkTableProvider<SocketLatencyStatistic> {
    public SocketLatencyStatisticProvider(ResourceName name) {
        super(name, I18n._ts((I18n.TextType)I18n.TextType.XTBS, (String)"Roundtrip Delays"), "views/network_roundtrip.png", ProviderUtils.prependNetworkLatencyIndex(ProviderUtils.getSocketLatencyStatisticSpec(name)));
    }

    @Override
    public ProviderEntry getEntry(int entryId, int column) {
        if (column >= 0 && column < 2) {
            return ProviderUtils.getEntry((NetworkLatencyId)((SocketLatencyStatistic)this.statistic).getKey(entryId), column);
        }
        return ProviderUtils.getEntryWithLatenciesOnly(entryId, column - 2, (ValueStatistic)this.statistic, (NetworkProvider)this);
    }

    @Override
    public Column getColumn(int columnIndex) {
        if (columnIndex >= 0 && columnIndex < 2) {
            return ((SocketLatencyStatistic)this.statistic).getKeyColumn();
        }
        return ProviderUtils.getColumnWithLatenciesOnly(columnIndex - 2, (ValueStatistic)this.statistic);
    }

    @Override
    protected ResourceName getStatisticName() {
        return this.getResourceName().stripLastElement().addElement((ResourceNameElement)new Elements.CreateSocketLatencyStatistic());
    }
}

