/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.presentation.impl.typed.renderer;

import com.sap.jvm.profiling.i18n.DataFormatter;
import com.sap.jvm.profiling.i18n.I18n;
import com.sap.jvm.profiling.presentation.impl.typed.renderer.EntryRendererBase;
import com.sap.jvm.profiling.presentation.impl.typed.renderer.RendererThemeImpl;
import com.sap.jvm.profiling.presentation.typed.ColumnContext;
import com.sap.jvm.profiling.presentation.typed.EntryContext;
import com.sap.jvm.profiling.presentation.typed.entries.ArrayLengthRange;
import com.sap.jvm.profiling.presentation.typed.entries.ProviderEntry;
import com.sap.jvm.profiling.viewer.ModelViewer;
import com.sap.jvm.profiling.viewer.renderer.RendererInfo;
import com.sap.jvm.profiling.viewer.renderer.RendererNode;
import com.sap.jvm.profiling.viewer.renderer.TextNode;

public final class ArrayLengthRangeRenderer
extends EntryRendererBase {
    private static final int THOUSAND = 1000;
    private static final int MILLION = 1000000;
    private final TextNode root;

    public ArrayLengthRangeRenderer(ModelViewer viewer, RendererThemeImpl theme) {
        super(viewer, theme);
        this.root = viewer.newTextNode(null);
        this.setCombinedTexts(I18n._s((String)"{0} array length ranges"), I18n._s((String)"{0} other array length ranges"), I18n._s((String)"{0} skipped array length ranges"));
    }

    @Override
    public RendererNode getRenderer(ProviderEntry entry, EntryContext context, ColumnContext columnContext) {
        ArrayLengthRange range = (ArrayLengthRange)entry;
        if (range.getFrom() + 1 == range.getTo()) {
            this.root.setText("[" + this.formatIndex(range.getFrom()) + "]");
        } else {
            this.root.setText("[" + this.formatIndex(range.getFrom()) + " - " + this.formatIndex(range.getTo()) + "]");
        }
        return this.root;
    }

    @Override
    public RendererNode getMaximumVersion(RendererInfo info, EntryContext context, ColumnContext columnContext) {
        this.root.setText("[7293847928739 - 24379487928739487]");
        return this.root;
    }

    @Override
    public RendererNode getMinimumVersion(RendererInfo info, EntryContext context, ColumnContext columnContext) {
        this.root.setText("[0000320 - 2342343]");
        return this.root;
    }

    private String formatIndex(int index) {
        if (index == 0) {
            return DataFormatter.getNumberText((long)index);
        }
        if (index == Integer.MAX_VALUE) {
            return "...";
        }
        if (index % 1000000 == 0) {
            return DataFormatter.getNumberText((long)(index / 1000000)) + DataFormatter.UNIT_SEP + "M";
        }
        if (index % 1000 == 0) {
            return DataFormatter.getNumberText((long)(index / 1000)) + DataFormatter.UNIT_SEP + "k";
        }
        return DataFormatter.getNumberText((long)index);
    }
}

