/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.presentation.impl.typed.renderer;

import com.sap.jvm.profiling.i18n.DataFormatter;
import com.sap.jvm.profiling.i18n.I18n;
import com.sap.jvm.profiling.presentation.impl.typed.renderer.RendererThemeImpl;
import com.sap.jvm.profiling.presentation.impl.typed.renderer.SampleDistributionRendererBase;
import com.sap.jvm.profiling.presentation.typed.ColumnContext;
import com.sap.jvm.profiling.presentation.typed.EntryContext;
import com.sap.jvm.profiling.presentation.typed.entries.ProviderEntry;
import com.sap.jvm.profiling.presentation.typed.entries.TimeDistributionEntryBase;
import com.sap.jvm.profiling.viewer.ModelViewer;
import com.sap.jvm.profiling.viewer.renderer.PercentageBarNode;
import com.sap.jvm.profiling.viewer.renderer.RendererInfo;
import com.sap.jvm.profiling.viewer.renderer.RendererNode;

public class BasicSampleDistributionRenderer
extends SampleDistributionRendererBase {
    public static final String PERCENTAGE_TAG = "basicSampleDistribution.percentage-bar";
    private final PercentageBarNode percentageNode;
    private final RendererNode rootNode;

    public BasicSampleDistributionRenderer(ModelViewer viewer, RendererThemeImpl theme) {
        super(viewer, theme);
        this.percentageNode = viewer.newPercentageBarNode();
        this.rootNode = viewer.newAlignNode(1, viewer.newMultiChildNode(viewer.newSpaceNode(5), theme.decorate(PERCENTAGE_TAG, viewer, this.percentageNode), viewer.newSpaceNode(5)));
    }

    @Override
    public RendererNode getRenderer(ProviderEntry rawEntry, EntryContext context, ColumnContext columnContext) {
        TimeDistributionEntryBase entry = (TimeDistributionEntryBase)rawEntry;
        if (entry.getTotalTime() == 0L) {
            this.percentageNode.setPercentage(0.0, 0.0, 0.0, 0.0, 0.0, 0.0);
        } else {
            double p4 = entry.getInterpreterPercentage();
            double p3 = p4 + entry.getCompiledPercentage();
            double p2 = p3 + entry.getInlinedPercentage();
            double p1 = p2 + entry.getNativeInterpreterPercentage() + entry.getNativeCompiledPercentage() + entry.getNativeInlinedPercentage();
            this.percentageNode.setPercentage(p1, p2, p3, p4, 0.0, 0.0);
        }
        return this.rootNode;
    }

    @Override
    public RendererNode getMaximumVersion(RendererInfo info, EntryContext context, ColumnContext columnContext) {
        return this.rootNode;
    }

    @Override
    public String getToolTip(ProviderEntry rawEntry, EntryContext context, ColumnContext columnContext) {
        TimeDistributionEntryBase entry = (TimeDistributionEntryBase)rawEntry;
        if (entry.getTotalTime() == 0L) {
            return null;
        }
        StringBuilder result = new StringBuilder();
        result.append(I18n._s((String)"Time in interpreter: {0} ({1})\n", (Object[])new Object[]{BasicSampleDistributionRenderer.getTimeText(entry.getInterpreterTime()), DataFormatter.getPercentage((double)entry.getInterpreterPercentage())}));
        result.append(I18n._s((String)"Time compiled: {0} ({1})\n", (Object[])new Object[]{BasicSampleDistributionRenderer.getTimeText(entry.getCompiledTime()), DataFormatter.getPercentage((double)entry.getCompiledPercentage())}));
        result.append(I18n._s((String)"Time inlined: {0} ({1})\n", (Object[])new Object[]{BasicSampleDistributionRenderer.getTimeText(entry.getInlinedTime()), DataFormatter.getPercentage((double)entry.getInlinedPercentage())}));
        result.append(I18n._s((String)"Time in native: {0} ({1})\n", (Object[])new Object[]{BasicSampleDistributionRenderer.getTimeText(entry.getNativeCompiledTime() + entry.getNativeInlinedTime() + entry.getNativeInterpreterTime()), DataFormatter.getPercentage((double)(entry.getNativeInterpreterPercentage() + entry.getNativeCompiledPercentage() + entry.getNativeInlinedPercentage()))}));
        result.append(I18n._s((String)"Time other: {0} ({1})", (Object[])new Object[]{BasicSampleDistributionRenderer.getTimeText(entry.getOtherTime()), DataFormatter.getPercentage((double)entry.getOtherPercentage())}));
        return result.toString();
    }
}

