/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.presentation.impl.typed.renderer;

import com.sap.jvm.profiling.i18n.I18n;
import com.sap.jvm.profiling.icons.ImageRepository;
import com.sap.jvm.profiling.presentation.impl.typed.renderer.EntryRendererBase;
import com.sap.jvm.profiling.presentation.impl.typed.renderer.RendererThemeImpl;
import com.sap.jvm.profiling.presentation.typed.ColumnContext;
import com.sap.jvm.profiling.presentation.typed.EntryContext;
import com.sap.jvm.profiling.presentation.typed.entries.DeadlockCycleEntry;
import com.sap.jvm.profiling.presentation.typed.entries.ProviderEntry;
import com.sap.jvm.profiling.viewer.ModelViewer;
import com.sap.jvm.profiling.viewer.renderer.ImageNode;
import com.sap.jvm.profiling.viewer.renderer.RendererInfo;
import com.sap.jvm.profiling.viewer.renderer.RendererNode;
import com.sap.jvm.profiling.viewer.renderer.SpaceNode;
import com.sap.jvm.profiling.viewer.renderer.TextNode;

public final class DeadlockCycleEntryRenderer
extends EntryRendererBase {
    public static final String NUMBER_TAG = "deadlockcycle.number";
    private final RendererNode[] roots;
    private final RendererNode[] rootsIndirect;
    private final TextNode cycleText;
    static final int MAX_CYCLES = 8;

    public DeadlockCycleEntryRenderer(ModelViewer viewer, RendererThemeImpl theme) {
        super(viewer, theme);
        this.cycleText = viewer.newTextNode(null);
        this.roots = new RendererNode[8];
        this.rootsIndirect = new RendererNode[8];
        SpaceNode space = viewer.newSpaceNode(5);
        for (int i = 0; i < 8; ++i) {
            String imageTag = "deadlockcycle.number." + i;
            String altText = I18n._s((String)"Deadlock with number {0}", (Object[])new Object[]{i + 1});
            this.roots[i] = viewer.newMultiChildNode(viewer.newSpaceNode(5), theme.decorate(imageTag, viewer, viewer.newMultiChildNode(space, this.cycleText, space), altText), space);
            ImageNode arrow = viewer.newImageNode(ImageRepository.getImageURI("navigation/move_back.png"), "blocked on");
            this.rootsIndirect[i] = viewer.newMultiChildNode(viewer.newSpaceNode(20), theme.decorate(imageTag, viewer, viewer.newMultiChildNode(space, arrow, space, this.cycleText, space), altText), space);
        }
    }

    @Override
    public RendererNode getRenderer(ProviderEntry entry, EntryContext context, ColumnContext columnContext) {
        DeadlockCycleEntry cycle = (DeadlockCycleEntry)entry;
        String text = "";
        text = cycle.isIndirect() ? I18n._s((String)"deadlocked by", (Object[])new Object[]{cycle.getDeadlockCycle()}) : I18n._s((String)"deadlock {0}", (Object[])new Object[]{cycle.getDeadlockCycle()});
        this.cycleText.setText(text);
        int value = cycle.getDeadlockCycle() - 1;
        return cycle.isIndirect() ? this.rootsIndirect[value] : this.roots[value %= this.roots.length];
    }

    @Override
    public RendererNode getMaximumVersion(RendererInfo info, EntryContext context, ColumnContext columnContext) {
        DeadlockCycleEntry dummy = new DeadlockCycleEntry(this.roots.length - 1, true);
        return this.getRenderer(dummy, context, columnContext);
    }

    @Override
    public String getToolTip(ProviderEntry entry, EntryContext context, ColumnContext columnContext) {
        DeadlockCycleEntry cycleEntry = (DeadlockCycleEntry)entry;
        int cycle = cycleEntry.getDeadlockCycle();
        if (cycle >= 0) {
            if (cycleEntry.isIndirect()) {
                return I18n._s((String)"Thread is blocked by deadlock cylce with number {0}", (Object[])new Object[]{cycle});
            }
            return I18n._s((String)"Thread is part of deadlock cylce with number {0}", (Object[])new Object[]{cycle});
        }
        return I18n._s((String)"Not part of any deadlock cycle");
    }
}

