/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.presentation.impl.typed.renderer;

import com.sap.jvm.profiling.i18n.I18n;
import com.sap.jvm.profiling.presentation.impl.typed.renderer.RendererThemeImpl;
import com.sap.jvm.profiling.presentation.typed.ColumnContext;
import com.sap.jvm.profiling.presentation.typed.EntryContext;
import com.sap.jvm.profiling.presentation.typed.EntryRenderer;
import com.sap.jvm.profiling.presentation.typed.entries.ProviderEntry;
import com.sap.jvm.profiling.viewer.ModelViewer;
import com.sap.jvm.profiling.viewer.renderer.RendererInfo;
import com.sap.jvm.profiling.viewer.renderer.RendererNode;
import com.sap.jvm.profiling.viewer.renderer.TextNode;

public abstract class EntryRendererBase
implements EntryRenderer {
    private String combinedText;
    private String otherText;
    private String skippedText;
    private TextNode textNode;
    protected final ModelViewer viewer;
    protected final RendererThemeImpl theme;

    protected EntryRendererBase(ModelViewer viewer, RendererThemeImpl theme) {
        this.viewer = viewer;
        this.theme = theme;
    }

    protected final String formatText(String pattern, Object ... args) {
        return I18n.formatText((String)pattern, (Object[])args);
    }

    protected final void setCombinedTexts(String combinedText, String otherText, String skippedText) {
        this.textNode = this.viewer.newTextNode(null);
        this.combinedText = combinedText;
        this.otherText = otherText;
        this.skippedText = skippedText;
    }

    @Override
    public RendererNode getMinimumVersion(RendererInfo info, EntryContext context, ColumnContext columnContext) {
        return this.getMaximumVersion(info, context, columnContext);
    }

    @Override
    public void dispose() {
    }

    @Override
    public RendererNode getRendererForCombinedItems(ProviderEntry[] entries, EntryContext context, ColumnContext columnContext) {
        if (this.combinedText != null) {
            this.textNode.setText(this.formatText(this.combinedText, entries.length));
            return this.textNode;
        }
        return null;
    }

    @Override
    public RendererNode getRendererForOtherChildren(ProviderEntry[] entries, EntryContext context, ColumnContext columnContext) {
        int numEntries = 0;
        for (ProviderEntry entry : entries) {
            if (entry == null) continue;
            ++numEntries;
        }
        if (this.otherText != null && numEntries > 0) {
            this.textNode.setText(this.formatText(this.otherText, numEntries));
            return this.textNode;
        }
        return null;
    }

    @Override
    public RendererNode getRendererForSkippedChildren(ProviderEntry[] entries, EntryContext context, ColumnContext columnContext) {
        if (this.skippedText != null) {
            this.textNode.setText(this.formatText(this.skippedText, entries.length));
            return this.textNode;
        }
        return null;
    }

    @Override
    public String getToolTip(ProviderEntry entry, EntryContext context, ColumnContext columnContext) {
        return null;
    }

    @Override
    public String getToolTip(ProviderEntry entry, EntryContext context, ColumnContext columnContext, boolean expanded) {
        return null;
    }

    @Override
    public String getToolTipForGraph(ProviderEntry entry, EntryContext context, ColumnContext columnContext) {
        return this.getToolTip(entry, context, columnContext);
    }

    @Override
    public String getToolTipForOtherChildren(ProviderEntry[] entries, EntryContext context, ColumnContext columnContext) {
        return this.getToolTipForOtherChildren(entries, context, columnContext, false);
    }

    @Override
    public RendererNode getRendererForSummarizedEntry(ProviderEntry entry, EntryContext context, ColumnContext columnContext, long count) {
        return this.viewer.newAlignNode(-1, this.viewer.newMultiChildNode(this.viewer.newAlignNode(-1, this.getRenderer(entry, context, columnContext)), this.viewer.newTextNode(I18n._s((String)"{0}: {1}", (Object[])new Object[]{"", ""})), this.viewer.newAlignNode(1, this.viewer.newTextNode(I18n._ss((String)"{0} a number of times", (String)"{0} \u00d7 ", (Object[])new Object[]{count})))));
    }

    @Override
    public String getToolTipForCombinedItems(ProviderEntry[] entries, EntryContext context, ColumnContext columnContext) {
        return this.getToolTipForOtherChildren(entries, context, columnContext);
    }

    @Override
    public String getToolTipForOtherChildren(ProviderEntry[] entries, EntryContext context, ColumnContext columnContext, boolean expanded) {
        RendererNode node = this.getRendererForOtherChildren(entries, context, columnContext);
        if (node != null) {
            return node.asString();
        }
        return "";
    }

    @Override
    public String getToolTipForSkippedChildren(ProviderEntry[] entries, EntryContext context, ColumnContext columnContext) {
        return this.getToolTipForOtherChildren(entries, context, columnContext);
    }

    @Override
    public String getToolTipForSkippedChildren(ProviderEntry[] entries, EntryContext context, ColumnContext columnContext, boolean expanded) {
        return this.getRendererForSkippedChildren(entries, context, columnContext).asString();
    }

    @Override
    public String getTooltTipForSummarizedEntry(ProviderEntry entry, EntryContext context, ColumnContext columnContext, long count) {
        String entryTip = this.getToolTip(entry, context, columnContext);
        return I18n._ss((String)"number of an entry", (String)"{0} of:\n{1}", (Object[])new Object[]{count, entryTip});
    }
}

