/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.presentation.impl.typed.renderer;

import com.sap.jvm.profiling.i18n.DataFormatter;
import com.sap.jvm.profiling.i18n.I18n;
import com.sap.jvm.profiling.presentation.impl.typed.renderer.EntryRendererBase;
import com.sap.jvm.profiling.presentation.impl.typed.renderer.RendererThemeImpl;
import com.sap.jvm.profiling.presentation.typed.ColumnContext;
import com.sap.jvm.profiling.presentation.typed.EntryContext;
import com.sap.jvm.profiling.presentation.typed.entries.FileDescriptor;
import com.sap.jvm.profiling.presentation.typed.entries.ProviderEntry;
import com.sap.jvm.profiling.viewer.ModelViewer;
import com.sap.jvm.profiling.viewer.renderer.NumberNode;
import com.sap.jvm.profiling.viewer.renderer.RendererInfo;
import com.sap.jvm.profiling.viewer.renderer.RendererNode;

public final class FileDescriptorRenderer
extends EntryRendererBase {
    public static final String NUMBER_TAG = "fileDescriptor.number";
    private final NumberNode numberNode;
    private final RendererNode root;

    public FileDescriptorRenderer(ModelViewer viewer, RendererThemeImpl theme) {
        super(viewer, theme);
        this.numberNode = viewer.newNumberNode();
        this.root = viewer.newAlignNode(1, theme.decorate(NUMBER_TAG, viewer, this.numberNode));
    }

    private RendererNode getRenderer(long fd, EntryContext context) {
        this.numberNode.setNumber(fd, this.getFileDescriptorText(fd));
        return this.root;
    }

    @Override
    public RendererNode getRenderer(ProviderEntry entry, EntryContext context, ColumnContext columnContext) {
        FileDescriptor fd = (FileDescriptor)entry;
        return this.getRenderer(fd.getFd(), context);
    }

    @Override
    public RendererNode getMaximumVersion(RendererInfo info, EntryContext context, ColumnContext columnContext) {
        this.numberNode.setNumber(context.getMaxFd(), "   " + this.getFileDescriptorText(context.getMaxFd()));
        return this.root;
    }

    @Override
    public String getToolTip(ProviderEntry entry, EntryContext context, ColumnContext columnContext) {
        FileDescriptor fileDescriptor = (FileDescriptor)entry;
        return I18n._s((String)"File descriptor {0}", (Object[])new Object[]{DataFormatter.getNumberText((long)fileDescriptor.getFd())});
    }

    public String getFileDescriptorText(long fd) {
        return DataFormatter.getNumberText((long)fd);
    }
}

