/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.presentation.impl.typed.renderer;

import com.sap.jvm.profiling.i18n.I18n;
import com.sap.jvm.profiling.memory.event.GcCause;
import com.sap.jvm.profiling.presentation.impl.typed.renderer.EntryRendererBase;
import com.sap.jvm.profiling.presentation.impl.typed.renderer.RendererThemeImpl;
import com.sap.jvm.profiling.presentation.typed.ColumnContext;
import com.sap.jvm.profiling.presentation.typed.EntryContext;
import com.sap.jvm.profiling.presentation.typed.entries.GcCauseEntry;
import com.sap.jvm.profiling.presentation.typed.entries.ProviderEntry;
import com.sap.jvm.profiling.viewer.ModelViewer;
import com.sap.jvm.profiling.viewer.renderer.AlternateNode;
import com.sap.jvm.profiling.viewer.renderer.RendererInfo;
import com.sap.jvm.profiling.viewer.renderer.RendererNode;

public final class GcCauseEntryRenderer
extends EntryRendererBase {
    private final AlternateNode<?> allCauses;
    private final RendererNode[] rawTexts;

    public GcCauseEntryRenderer(ModelViewer viewer, RendererThemeImpl theme) {
        super(viewer, theme);
        GcCause[] causes = GcCause.values();
        this.rawTexts = new RendererNode[causes.length];
        for (int i = 0; i < causes.length; ++i) {
            this.rawTexts[i] = viewer.newAlignNode(1, viewer.newTextNode(causes[i].getShortDescrDisplay()));
        }
        this.allCauses = viewer.newAlternateNode(0, this.rawTexts);
    }

    @Override
    public RendererNode getMaximumVersion(RendererInfo info, EntryContext context, ColumnContext columnContext) {
        return this.allCauses;
    }

    @Override
    public RendererNode getMinimumVersion(RendererInfo info, EntryContext context, ColumnContext columnContext) {
        return this.allCauses;
    }

    @Override
    public RendererNode getRenderer(ProviderEntry entry, EntryContext context, ColumnContext columnContext) {
        return this.rawTexts[((GcCauseEntry)entry).getCause().ordinal()];
    }

    @Override
    public String getToolTip(ProviderEntry entry, EntryContext context, ColumnContext columnContext) {
        return ((GcCauseEntry)entry).getCause().getLongDescrDisplay();
    }

    @Override
    public RendererNode getRendererForSummarizedEntry(ProviderEntry entry, EntryContext context, ColumnContext columnContext, long count) {
        GcCauseEntry cause = (GcCauseEntry)entry;
        return this.viewer.newMultiChildNode(this.rawTexts[cause.getCause().ordinal()], this.viewer.newTextNode(I18n._s((String)"{0}: {1}", (Object[])new Object[]{"", ""})), this.viewer.newAlignNode(1, this.viewer.newTextNode(I18n._ss((String)"{0} a number of times", (String)"{0} \u00d7 ", (Object[])new Object[]{count}))));
    }

    @Override
    public String getTooltTipForSummarizedEntry(ProviderEntry entry, EntryContext context, ColumnContext columnContext, long count) {
        GcCauseEntry cause = (GcCauseEntry)entry;
        return I18n._s((String)"{0} GCs triggered by:\n{1}", (Object[])new Object[]{count, cause.getCause().getLongDescrDisplay()});
    }
}

