/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.presentation.impl.typed.renderer;

import com.sap.jvm.profiling.i18n.I18n;
import com.sap.jvm.profiling.memory.event.GcG1CollectionSet;
import com.sap.jvm.profiling.presentation.impl.typed.renderer.EntryRendererBase;
import com.sap.jvm.profiling.presentation.impl.typed.renderer.RendererThemeImpl;
import com.sap.jvm.profiling.presentation.typed.ColumnContext;
import com.sap.jvm.profiling.presentation.typed.EntryContext;
import com.sap.jvm.profiling.presentation.typed.entries.GcG1CollectionSetEntry;
import com.sap.jvm.profiling.presentation.typed.entries.ProviderEntry;
import com.sap.jvm.profiling.viewer.ModelViewer;
import com.sap.jvm.profiling.viewer.renderer.AlternateNode;
import com.sap.jvm.profiling.viewer.renderer.RendererInfo;
import com.sap.jvm.profiling.viewer.renderer.RendererNode;

public final class GcG1CollectionSetEntryRenderer
extends EntryRendererBase {
    private final AlternateNode<?> allCollectionSetTypes;

    public GcG1CollectionSetEntryRenderer(ModelViewer viewer, RendererThemeImpl theme) {
        super(viewer, theme);
        GcG1CollectionSet[] cSetTypes = GcG1CollectionSet.values();
        RendererNode[] rawTexts = new RendererNode[cSetTypes.length];
        for (int i = 0; i < cSetTypes.length; ++i) {
            rawTexts[i] = viewer.newTextNode(cSetTypes[i].getShortDescription());
        }
        this.allCollectionSetTypes = viewer.newAlternateNode(0, rawTexts);
    }

    @Override
    public RendererNode getMaximumVersion(RendererInfo info, EntryContext context, ColumnContext columnContext) {
        return this.allCollectionSetTypes;
    }

    @Override
    public RendererNode getMinimumVersion(RendererInfo info, EntryContext context, ColumnContext columnContext) {
        return this.allCollectionSetTypes;
    }

    @Override
    public RendererNode getRenderer(ProviderEntry entry, EntryContext context, ColumnContext columnContext) {
        this.allCollectionSetTypes.setSelected(((GcG1CollectionSetEntry)entry).getCollectionSet().ordinal());
        return this.allCollectionSetTypes;
    }

    @Override
    public String getToolTip(ProviderEntry entry, EntryContext context, ColumnContext columnContext) {
        return ((GcG1CollectionSetEntry)entry).getCollectionSet().getLongDescription();
    }

    @Override
    public RendererNode getRendererForSummarizedEntry(ProviderEntry entry, EntryContext context, ColumnContext columnContext, long count) {
        GcG1CollectionSetEntry cSetEntry = (GcG1CollectionSetEntry)entry;
        this.allCollectionSetTypes.setSelected(cSetEntry.getCollectionSet().ordinal());
        return this.viewer.newMultiChildNode(this.allCollectionSetTypes, this.viewer.newTextNode(I18n._s((String)"{0}: {1}", (Object[])new Object[]{"", ""})), this.viewer.newAlignNode(1, this.viewer.newTextNode(I18n._ss((String)"{0} a number of times", (String)"{0} \u00d7 ", (Object[])new Object[]{count}))));
    }

    @Override
    public String getTooltTipForSummarizedEntry(ProviderEntry entry, EntryContext context, ColumnContext columnContext, long count) {
        GcG1CollectionSetEntry csetEntry = (GcG1CollectionSetEntry)entry;
        return I18n._s((String)"{0} selections of young gen target length because of:\n{1}", (Object[])new Object[]{count, csetEntry.getCollectionSet().getLongDescription()});
    }
}

