/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.presentation.impl.typed.renderer;

import com.sap.jvm.profiling.i18n.I18n;
import com.sap.jvm.profiling.memory.event.GcG1YoungListTargetSelReason;
import com.sap.jvm.profiling.presentation.impl.typed.renderer.EntryRendererBase;
import com.sap.jvm.profiling.presentation.impl.typed.renderer.RendererThemeImpl;
import com.sap.jvm.profiling.presentation.typed.ColumnContext;
import com.sap.jvm.profiling.presentation.typed.EntryContext;
import com.sap.jvm.profiling.presentation.typed.entries.GcG1YoungListTargetSelReasonEntry;
import com.sap.jvm.profiling.presentation.typed.entries.ProviderEntry;
import com.sap.jvm.profiling.viewer.ModelViewer;
import com.sap.jvm.profiling.viewer.renderer.AlternateNode;
import com.sap.jvm.profiling.viewer.renderer.RendererInfo;
import com.sap.jvm.profiling.viewer.renderer.RendererNode;

public final class GcG1YoungListTargetSelReasonEntryRenderer
extends EntryRendererBase {
    private final AlternateNode<?> allReasons;

    public GcG1YoungListTargetSelReasonEntryRenderer(ModelViewer viewer, RendererThemeImpl theme) {
        super(viewer, theme);
        GcG1YoungListTargetSelReason[] reasons = GcG1YoungListTargetSelReason.values();
        RendererNode[] rawTexts = new RendererNode[reasons.length];
        for (int i = 0; i < reasons.length; ++i) {
            rawTexts[i] = viewer.newTextNode(reasons[i].getShortDescription());
        }
        this.allReasons = viewer.newAlternateNode(0, rawTexts);
    }

    @Override
    public RendererNode getMaximumVersion(RendererInfo info, EntryContext context, ColumnContext columnContext) {
        return this.allReasons;
    }

    @Override
    public RendererNode getMinimumVersion(RendererInfo info, EntryContext context, ColumnContext columnContext) {
        return this.allReasons;
    }

    @Override
    public RendererNode getRenderer(ProviderEntry entry, EntryContext context, ColumnContext columnContext) {
        this.allReasons.setSelected(((GcG1YoungListTargetSelReasonEntry)entry).getReason().ordinal());
        return this.allReasons;
    }

    @Override
    public String getToolTip(ProviderEntry entry, EntryContext context, ColumnContext columnContext) {
        return ((GcG1YoungListTargetSelReasonEntry)entry).getReason().getLongDescription();
    }

    @Override
    public RendererNode getRendererForSummarizedEntry(ProviderEntry entry, EntryContext context, ColumnContext columnContext, long count) {
        GcG1YoungListTargetSelReasonEntry reason = (GcG1YoungListTargetSelReasonEntry)entry;
        this.allReasons.setSelected(reason.getReason().ordinal());
        return this.viewer.newMultiChildNode(this.allReasons, this.viewer.newTextNode(I18n._s((String)"{0}: {1}", (Object[])new Object[]{"", ""})), this.viewer.newAlignNode(1, this.viewer.newTextNode(I18n._ss((String)"{0} a number of times", (String)"{0} \u00d7 ", (Object[])new Object[]{count}))));
    }

    @Override
    public String getTooltTipForSummarizedEntry(ProviderEntry entry, EntryContext context, ColumnContext columnContext, long count) {
        GcG1YoungListTargetSelReasonEntry reason = (GcG1YoungListTargetSelReasonEntry)entry;
        return I18n._s((String)"{0} selections of young gen target length because of:\n{1}", (Object[])new Object[]{count, reason.getReason().getLongDescription()});
    }
}

