/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.presentation.impl.typed.renderer;

import com.sap.jvm.profiling.i18n.I18n;
import com.sap.jvm.profiling.presentation.impl.typed.renderer.EntryRendererBase;
import com.sap.jvm.profiling.presentation.impl.typed.renderer.RendererThemeImpl;
import com.sap.jvm.profiling.presentation.typed.ColumnContext;
import com.sap.jvm.profiling.presentation.typed.EntryContext;
import com.sap.jvm.profiling.presentation.typed.entries.GcTypeEntry;
import com.sap.jvm.profiling.presentation.typed.entries.ProviderEntry;
import com.sap.jvm.profiling.viewer.ModelViewer;
import com.sap.jvm.profiling.viewer.renderer.AlternateNode;
import com.sap.jvm.profiling.viewer.renderer.LongAndShortTextNode;
import com.sap.jvm.profiling.viewer.renderer.RendererInfo;
import com.sap.jvm.profiling.viewer.renderer.RendererNode;

public final class GcTypeEntryRenderer
extends EntryRendererBase {
    public static final String GC_TYPE_UNSPECIFIED_TAG = "gcType.image.unspecified";
    public static final String GC_TYPE_FULL_TAG = "gcType.image.full";
    public static final String GC_TYPE_PARTIAL_TAG = "gcType.image.partial";
    public static final String GC_TYPE_CONCURRENT_TAG = "gcType.image.concurrent";
    private final RendererNode[] images;
    private final AlternateNode<?> allTypes;
    private final String[] imageTags = new String[4];
    private final String[] altTexts;
    private final String[] shortTexts;
    private final String[] longTexts;

    public GcTypeEntryRenderer(ModelViewer viewer, RendererThemeImpl theme) {
        super(viewer, theme);
        this.imageTags[0] = GC_TYPE_UNSPECIFIED_TAG;
        this.imageTags[1] = GC_TYPE_FULL_TAG;
        this.imageTags[2] = GC_TYPE_PARTIAL_TAG;
        this.imageTags[3] = GC_TYPE_CONCURRENT_TAG;
        this.altTexts = new String[4];
        this.altTexts[0] = I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"The GC type is unknown.");
        this.altTexts[1] = I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"A full GC");
        this.altTexts[2] = I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"A partial GC");
        this.altTexts[3] = I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"A concurrent GC");
        this.shortTexts = new String[4];
        this.shortTexts[0] = I18n._ts((I18n.TextType)I18n.TextType.XMSG, (String)"unkn.");
        this.shortTexts[1] = I18n._ts((I18n.TextType)I18n.TextType.XMSG, (String)"Full");
        this.shortTexts[2] = I18n._ts((I18n.TextType)I18n.TextType.XMSG, (String)"Partial");
        this.shortTexts[3] = I18n._ts((I18n.TextType)I18n.TextType.XMSG, (String)"Conc.");
        this.longTexts = new String[4];
        this.longTexts[0] = I18n._ts((I18n.TextType)I18n.TextType.XMSG, (String)"<unknown>");
        this.longTexts[1] = I18n._ts((I18n.TextType)I18n.TextType.XMSG, (String)"Full GC");
        this.longTexts[2] = I18n._ts((I18n.TextType)I18n.TextType.XMSG, (String)"Partial GC");
        this.longTexts[3] = I18n._ts((I18n.TextType)I18n.TextType.XMSG, (String)"Concurrent GC");
        this.images = new RendererNode[this.imageTags.length];
        RendererNode[] rawImages = new RendererNode[this.imageTags.length];
        for (int i = 0; i < this.images.length; ++i) {
            LongAndShortTextNode text = viewer.newLongAndShortTextNode();
            text.setShortText(this.shortTexts[i]);
            text.setLongText(this.longTexts[i]);
            rawImages[i] = theme.decorate(this.imageTags[i], viewer, viewer.newMultiChildNode(viewer.newSpaceNode(5), text), this.altTexts[i]);
            this.images[i] = viewer.newMultiChildNode(viewer.newSpaceNode(5), rawImages[i], viewer.newSpaceNode(5));
        }
        this.allTypes = viewer.newAlternateNode(0, rawImages);
    }

    @Override
    public RendererNode getRenderer(ProviderEntry entry, EntryContext context, ColumnContext columnContext) {
        byte type = ((GcTypeEntry)entry).getType();
        assert (type >= 0 && type < this.shortTexts.length);
        return this.images[type];
    }

    @Override
    public RendererNode getMinimumVersion(RendererInfo info, EntryContext context, ColumnContext columnContext) {
        return this.viewer.newMultiChildNode(this.viewer.newSpaceNode(5), this.allTypes, this.viewer.newSpaceNode(5));
    }

    @Override
    public RendererNode getMaximumVersion(RendererInfo info, EntryContext context, ColumnContext columnContext) {
        return this.getMinimumVersion(info, context, columnContext);
    }

    @Override
    public String getToolTip(ProviderEntry entry, EntryContext context, ColumnContext columnContext) {
        return this.longTexts[((GcTypeEntry)entry).getType()];
    }

    @Override
    public RendererNode getRendererForSummarizedEntry(ProviderEntry entry, EntryContext context, ColumnContext columnContext, long count) {
        GcTypeEntry type = (GcTypeEntry)entry;
        this.allTypes.setSelected(type.getType());
        return this.viewer.newMultiChildNode(this.allTypes, this.viewer.newTextNode(I18n._s((String)"{0}: {1}", (Object[])new Object[]{"", ""})), this.viewer.newAlignNode(1, this.viewer.newTextNode(I18n._ss((String)"{0} a number of times", (String)"{0} \u00d7 ", (Object[])new Object[]{count}))));
    }

    @Override
    public String getTooltTipForSummarizedEntry(ProviderEntry entry, EntryContext context, ColumnContext columnContext, long count) {
        GcTypeEntry type = (GcTypeEntry)entry;
        switch (type.getType()) {
            case 1: {
                return I18n._s((String)"{0} full GCs", (Object[])new Object[]{count});
            }
            case 2: {
                return I18n._s((String)"{0} partial GCs", (Object[])new Object[]{count});
            }
            case 3: {
                return I18n._s((String)"{0} concurrent GCs", (Object[])new Object[]{count});
            }
        }
        return I18n._s((String)"{0} GCs of unknown type", (Object[])new Object[]{count});
    }
}

