/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.presentation.impl.typed.renderer;

import com.sap.jvm.profiling.i18n.DataFormatter;
import com.sap.jvm.profiling.i18n.I18n;
import com.sap.jvm.profiling.presentation.impl.typed.renderer.EntryRendererBase;
import com.sap.jvm.profiling.presentation.impl.typed.renderer.RendererThemeImpl;
import com.sap.jvm.profiling.presentation.typed.ColumnContext;
import com.sap.jvm.profiling.presentation.typed.EntryContext;
import com.sap.jvm.profiling.presentation.typed.entries.InterpretedFraction;
import com.sap.jvm.profiling.presentation.typed.entries.ProviderEntry;
import com.sap.jvm.profiling.viewer.ModelViewer;
import com.sap.jvm.profiling.viewer.renderer.PercentageBarNode;
import com.sap.jvm.profiling.viewer.renderer.RendererInfo;
import com.sap.jvm.profiling.viewer.renderer.RendererNode;
import com.sap.jvm.profiling.viewer.renderer.TextNode;

public class InterpretedFractionRenderer
extends EntryRendererBase {
    public static final String PERCENTAGE_TAG_UNKNOWN = "interpretedFraction.percentage-unknown";
    public static final String PERCENTAGE_TAG_GOOD = "interpretedFraction.percentage-good";
    public static final String PERCENTAGE_TAG_MEDIUM = "interpretedFraction.percentage-medium";
    public static final String PERCENTAGE_TAG_BAD = "interpretedFraction.percentage-bad";
    public static final String PERCENTAGE_BAR_TAG = "interpretedFraction.percentage-bar";
    private final PercentageBarNode percentageNode;
    private final TextNode percentageTextNode;
    private final RendererNode rootGood;
    private final RendererNode rootMedium;
    private final RendererNode rootBad;
    private final RendererNode rootUnknown;

    public InterpretedFractionRenderer(ModelViewer viewer, RendererThemeImpl theme) {
        super(viewer, theme);
        this.percentageNode = viewer.newPercentageBarNode();
        this.percentageTextNode = viewer.newTextNode(null);
        this.rootUnknown = viewer.newMultiChildNode(theme.decorate(PERCENTAGE_TAG_UNKNOWN, viewer, this.percentageTextNode));
        this.rootGood = viewer.newMultiChildNode(theme.decorate(PERCENTAGE_TAG_GOOD, viewer, this.percentageTextNode), viewer.newSpaceNode(10), theme.decorate(PERCENTAGE_BAR_TAG, viewer, this.percentageNode));
        this.rootMedium = viewer.newMultiChildNode(theme.decorate(PERCENTAGE_TAG_MEDIUM, viewer, this.percentageTextNode), viewer.newSpaceNode(10), theme.decorate(PERCENTAGE_BAR_TAG, viewer, this.percentageNode));
        this.rootBad = viewer.newMultiChildNode(theme.decorate(PERCENTAGE_TAG_BAD, viewer, this.percentageTextNode), viewer.newSpaceNode(10), theme.decorate(PERCENTAGE_BAR_TAG, viewer, this.percentageNode));
    }

    @Override
    public RendererNode getRenderer(ProviderEntry entry, EntryContext context, ColumnContext columnContext) {
        double fraction = ((InterpretedFraction)entry).getFraction();
        double badThreshold = 0.15;
        double mediumThreshold = 0.05;
        if (fraction < 0.0) {
            this.percentageTextNode.setText(I18n._s((String)"unknown"));
            return this.rootUnknown;
        }
        this.percentageNode.setPercentage(1.0, fraction, 0.0);
        this.percentageTextNode.setText(DataFormatter.getPercentage((double)fraction));
        return fraction > badThreshold ? this.rootBad : (fraction > mediumThreshold ? this.rootMedium : this.rootGood);
    }

    @Override
    public RendererNode getMaximumVersion(RendererInfo info, EntryContext context, ColumnContext columnContext) {
        return null;
    }

    @Override
    public String getToolTip(ProviderEntry entry, EntryContext context, ColumnContext columnContext) {
        return null;
    }
}

