/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.presentation.impl.typed.renderer;

import com.sap.jvm.profiling.core.type.ClassObject;
import com.sap.jvm.profiling.core.type.MethodLocation;
import com.sap.jvm.profiling.presentation.impl.typed.renderer.MethodRendererBase;
import com.sap.jvm.profiling.presentation.impl.typed.renderer.RendererThemeImpl;
import com.sap.jvm.profiling.presentation.typed.ColumnContext;
import com.sap.jvm.profiling.presentation.typed.EntryContext;
import com.sap.jvm.profiling.presentation.typed.entries.JRubyOrJavaMethod;
import com.sap.jvm.profiling.presentation.typed.entries.ProviderEntry;
import com.sap.jvm.profiling.viewer.ModelViewer;
import com.sap.jvm.profiling.viewer.renderer.RendererNode;
import com.sap.jvm.profiling.viewer.renderer.TextNode;

public abstract class JRubyOrJavaMethodRendererBase
extends MethodRendererBase {
    public static final String JRUBY_DIRECTORY_TAG = "MethodObj.jruby.directory";
    public static final String JRUBY_FILE_TAG = "MethodObj.jruby.file";
    public static final String JRUBY_METHOD_TAG = "MethodObj.jruby.file";
    private final TextNode directoryNode;
    private final TextNode fileNode;
    private final TextNode methodNode;
    private final RendererNode jrubyNode;

    public JRubyOrJavaMethodRendererBase(ModelViewer viewer, String imageTag, RendererThemeImpl theme) {
        super(viewer, imageTag, theme);
        this.directoryNode = viewer.newTextNode(null);
        this.fileNode = viewer.newTextNode(null);
        this.methodNode = viewer.newTextNode(null);
        this.jrubyNode = theme.decorate(imageTag, viewer, viewer.newMultiChildNode(theme.decorate(JRUBY_DIRECTORY_TAG, viewer, this.directoryNode), theme.decorate("MethodObj.jruby.file", viewer, this.fileNode), viewer.newSpaceNode(10), theme.decorate("MethodObj.jruby.file", viewer, this.methodNode)));
    }

    @Override
    public RendererNode getRenderer(ProviderEntry entry, EntryContext context, ColumnContext columnContext) {
        JRubyOrJavaMethod method = (JRubyOrJavaMethod)entry;
        if (method.getJRubyMethodName() == null || method.getLocation().getLineNumber() != 0) {
            return super.getRenderer(entry, context, columnContext);
        }
        this.fileNode.setText(method.getJRubyFileName());
        this.methodNode.setText(method.getJRubyMethodName());
        return this.jrubyNode;
    }

    @Override
    protected MethodLocation getLocation(ProviderEntry entry) {
        JRubyOrJavaMethod method = (JRubyOrJavaMethod)entry;
        return method.getLocation();
    }

    @Override
    protected ClassObject getReceiver(ProviderEntry entry) {
        return null;
    }
}

