/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.presentation.impl.typed.renderer;

import com.sap.jvm.profiling.i18n.DataFormatter;
import com.sap.jvm.profiling.i18n.I18n;
import com.sap.jvm.profiling.presentation.impl.typed.renderer.EntryRendererBase;
import com.sap.jvm.profiling.presentation.impl.typed.renderer.RendererThemeImpl;
import com.sap.jvm.profiling.presentation.typed.AxisModel;
import com.sap.jvm.profiling.presentation.typed.ColumnContext;
import com.sap.jvm.profiling.presentation.typed.EntryContext;
import com.sap.jvm.profiling.presentation.typed.QuantityRenderer;
import com.sap.jvm.profiling.presentation.typed.entries.LoadAverage;
import com.sap.jvm.profiling.presentation.typed.entries.ProviderEntry;
import com.sap.jvm.profiling.viewer.ModelViewer;
import com.sap.jvm.profiling.viewer.renderer.PercentageBarNode;
import com.sap.jvm.profiling.viewer.renderer.RendererInfo;
import com.sap.jvm.profiling.viewer.renderer.RendererNode;
import com.sap.jvm.profiling.viewer.renderer.TextNode;
import com.sap.jvm.util.pair.LongPair;
import java.util.ArrayList;
import java.util.Arrays;

public final class LoadAverageRenderer
extends EntryRendererBase
implements QuantityRenderer {
    public static final int MAX_LOADS_TO_DISPLAY = 3;
    public static final String NUMBER_TAG = "loadAverage.number";
    public static final String PERCENTAGE_TAG = "loadAverage.percentage";
    public static final String PERCENTAGE_BAR_TAG = "loadAverage.percentage-bar";
    private final TextNode[] textNodes = new TextNode[3];
    private final PercentageBarNode[] percentageNodes = new PercentageBarNode[3];
    private final RendererNode[] roots = new RendererNode[3];
    private final TextNode emptyRoot;
    private AxisModel axisModel;

    public LoadAverageRenderer(ModelViewer viewer, RendererThemeImpl theme) {
        super(viewer, theme);
        RendererNode[] valueRoots = new RendererNode[3];
        for (int i = 0; i < 3; ++i) {
            this.textNodes[i] = viewer.newTextNode(null);
            this.percentageNodes[i] = viewer.newPercentageBarNode();
            this.percentageNodes[i].setDisplayFormatHint(PercentageBarNode.DisplayFormatHint.NARROW);
            valueRoots[i] = viewer.newOrderedMultiChildNode(new int[]{0, 1, 2}, new RendererNode[]{theme.decorate(NUMBER_TAG, viewer, this.textNodes[i]), viewer.newSpaceNode(5), theme.decorate(PERCENTAGE_BAR_TAG, viewer, this.percentageNodes[i])});
            ArrayList<RendererNode> root = new ArrayList<RendererNode>();
            for (int j = 0; j < i; ++j) {
                root.add(valueRoots[j]);
                root.add(viewer.newSpaceNode(10));
            }
            root.add(valueRoots[i]);
            this.roots[i] = viewer.newAlignNode(1, viewer.newMultiChildNode(root.toArray(new RendererNode[root.size()])));
        }
        this.emptyRoot = viewer.newTextNode(null);
        this.emptyRoot.setText(I18n._s((String)"<not available>"));
        this.axisModel = new LoadAxisModel();
    }

    @Override
    public RendererNode getRenderer(ProviderEntry entry, EntryContext context, ColumnContext columnContext) {
        double[] loadData = ((LoadAverage)entry).getLoadData();
        return this.getRenderer(loadData);
    }

    private RendererNode getRenderer(double[] loadData) {
        int size;
        int n = size = loadData == null ? 0 : loadData.length;
        if (size == 0) {
            return this.emptyRoot;
        }
        if (loadData[0] == -1.0) {
            return this.emptyRoot;
        }
        for (int i = 0; i < size; ++i) {
            double val = loadData[i];
            this.textNodes[i].setText(DataFormatter.getNumberText((double)val, (int)2));
            double percentage1 = Math.min(val, 1.0);
            double percentage2 = Math.max(0.0, Math.min(val - 1.0, 1.0));
            double percentage3 = Math.max(0.0, Math.min(val - 2.0, 1.0));
            this.percentageNodes[i].setPercentage(percentage1, percentage2, percentage3);
        }
        return this.roots[size - 1];
    }

    @Override
    public RendererNode getMaximumVersion(RendererInfo info, EntryContext context, ColumnContext columnContext) {
        double[] data = new double[3];
        for (int i = 0; i < 3; ++i) {
            data[i] = 22.2;
        }
        return this.getRenderer(data);
    }

    @Override
    public String getToolTip(ProviderEntry entry, EntryContext context, ColumnContext columnContext) {
        if (entry == null) {
            return "";
        }
        double[] loadData = ((LoadAverage)entry).getLoadData();
        return Arrays.toString(loadData);
    }

    @Override
    public AxisModel getAxisModel() {
        return this.axisModel;
    }

    public static class LoadAxisModel
    implements AxisModel {
        private static final long[] tickSizes = new long[]{1L, 2L, 5L, 10L, 20L, 50L, 100L, 200L, 500L, 1000L, 2000L, 5000L, 10000L};

        @Override
        public String getExportUnit() {
            return "";
        }

        @Override
        public double getScale() {
            return 0.001;
        }

        @Override
        public long getMajorTickSize(long suggestedMajorTickSize, long min, long max) {
            int index;
            long range = max - min;
            for (index = 0; range / tickSizes[index] > 10L && index < tickSizes.length - 1; ++index) {
            }
            return tickSizes[index];
        }

        @Override
        public int getNrOfMinorTicks(long majorTickSize, long min, long max) {
            return 5;
        }

        @Override
        public LongPair getRange(long min, long max) {
            return new LongPair(0L, max);
        }

        @Override
        public String getTickLabel(long tickValue, long tickSize, long min, long max) {
            return DataFormatter.getNumberText((double)((double)tickValue / 1000.0), (int)2);
        }

        @Override
        public String getCaptionSuffix(long min, long max) {
            return "";
        }

        @Override
        public String getToolTip(long tickValue) {
            return "";
        }
    }
}

