/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.presentation.impl.typed.renderer;

import com.sap.jvm.profiling.i18n.DataFormatter;
import com.sap.jvm.profiling.i18n.I18n;
import com.sap.jvm.profiling.presentation.impl.typed.renderer.EntryRendererBase;
import com.sap.jvm.profiling.presentation.impl.typed.renderer.RendererThemeImpl;
import com.sap.jvm.profiling.presentation.typed.ColumnContext;
import com.sap.jvm.profiling.presentation.typed.EntryContext;
import com.sap.jvm.profiling.presentation.typed.entries.MemoryUsageBeforeAndAfter;
import com.sap.jvm.profiling.presentation.typed.entries.ProviderEntry;
import com.sap.jvm.profiling.viewer.ModelViewer;
import com.sap.jvm.profiling.viewer.renderer.PercentageBarNode;
import com.sap.jvm.profiling.viewer.renderer.RendererInfo;
import com.sap.jvm.profiling.viewer.renderer.RendererNode;
import com.sap.jvm.profiling.viewer.renderer.TextNode;

public class MemoryUsageBeforeAndAfterRenderer
extends EntryRendererBase {
    public static final String TEXT_TAG = "nrOfBytes.number";
    public static final String PERCENTAGE_BAR_TAG = "nrOfBytes.before-after-bar";
    private TextNode textNode;
    private PercentageBarNode percentageNode;
    private RendererNode root;

    public MemoryUsageBeforeAndAfterRenderer(ModelViewer viewer, RendererThemeImpl theme) {
        super(viewer, theme);
        this.textNode = viewer.newTextNode(null);
        this.percentageNode = viewer.newPercentageBarNode();
        this.root = viewer.newAlignNode(1, viewer.newOrderedMultiChildNode(new int[]{0, 1, 2}, new RendererNode[]{theme.decorate(TEXT_TAG, viewer, this.textNode), viewer.newSpaceNode(10), theme.decorate(PERCENTAGE_BAR_TAG, viewer, this.percentageNode)}));
    }

    @Override
    public RendererNode getRenderer(ProviderEntry entry, EntryContext context, ColumnContext columnContext) {
        MemoryUsageBeforeAndAfter usage = (MemoryUsageBeforeAndAfter)entry;
        long before = usage.getBefore();
        long after = usage.getAfter();
        long max = usage.getMax();
        return this.getRenderer(before, after, max);
    }

    @Override
    public RendererNode getMaximumVersion(RendererInfo info, EntryContext context, ColumnContext columnContext) {
        return this.getRenderer(9311354L, 9311354L, 9311354L);
    }

    @Override
    public String getToolTip(ProviderEntry entry, EntryContext context, ColumnContext columnContext) {
        MemoryUsageBeforeAndAfter usage = (MemoryUsageBeforeAndAfter)entry;
        long before = usage.getBefore();
        long after = usage.getAfter();
        long max = usage.getMax();
        long diff = usage.getQuantity();
        return this.getToolTip(before, after, max, diff);
    }

    private RendererNode getRenderer(long before, long after, long max) {
        this.textNode.setText(DataFormatter.getNrOfBytesText((long)before) + I18n.sanitize((String)" \u2192 ") + DataFormatter.getNrOfBytesText((long)after));
        long common = Math.min(before, after);
        double percBefore = (double)before / (double)max;
        double percAfter = (double)after / (double)max;
        double percCommon = (double)common / (double)max;
        if (percBefore >= percAfter) {
            this.percentageNode.setPercentage(percBefore, percCommon, percCommon);
        } else {
            this.percentageNode.setPercentage(percAfter, percAfter, percCommon);
        }
        return this.root;
    }

    private String getToolTip(long before, long after, long max, long diff) {
        StringBuilder result = new StringBuilder();
        if (before > 999L) {
            result.append(I18n._ss((String)"Absolute and percentage", (String)"{0} used before ({1} = {2,number,#.##%})", (Object[])new Object[]{DataFormatter.getNrOfBytesText((long)before), DataFormatter.getNumberText((long)before) + DataFormatter.UNIT_SEP + I18n._ss((String)"Unit|bytes", (String)"B"), (double)before / (double)max}));
        } else {
            result.append(I18n._ss((String)"Absolute and percentage", (String)"{0} used before ({1,number,#.##%})", (Object[])new Object[]{DataFormatter.getNrOfBytesText((long)before), (double)before / (double)max}));
        }
        result.append("\n");
        if (after > 999L) {
            result.append(I18n._ss((String)"Absolute and percentage", (String)"{0} used after ({1} = {2,number,#.##%})", (Object[])new Object[]{DataFormatter.getNrOfBytesText((long)after), DataFormatter.getNumberText((long)after) + DataFormatter.UNIT_SEP + I18n._ss((String)"Unit|bytes", (String)"B"), (double)after / (double)max}));
        } else {
            result.append(I18n._ss((String)"Absolute and percentage", (String)"{0} used before ({1,number,#.##%})", (Object[])new Object[]{DataFormatter.getNrOfBytesText((long)after), (double)after / (double)max}));
        }
        result.append("\n");
        result.append(I18n._s((String)"Difference: {0}", (Object[])new Object[]{DataFormatter.getNrOfBytesText((long)diff)}));
        return result.toString();
    }
}

