/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.presentation.impl.typed.renderer;

import com.sap.jvm.profiling.ProfilingSession;
import com.sap.jvm.profiling.core.ProfilingCapabilities;
import com.sap.jvm.profiling.core.type.ClassObject;
import com.sap.jvm.profiling.core.type.MethodLocation;
import com.sap.jvm.profiling.core.type.MethodObject;
import com.sap.jvm.profiling.core.type.NonArrayClassObject;
import com.sap.jvm.profiling.i18n.I18n;
import com.sap.jvm.profiling.icons.ImageRepository;
import com.sap.jvm.profiling.presentation.impl.typed.renderer.MultiEntryRendererBase;
import com.sap.jvm.profiling.presentation.impl.typed.renderer.NormalClassRenderer;
import com.sap.jvm.profiling.presentation.impl.typed.renderer.RendererThemeImpl;
import com.sap.jvm.profiling.presentation.typed.ColumnContext;
import com.sap.jvm.profiling.presentation.typed.EntryContext;
import com.sap.jvm.profiling.presentation.typed.MethodFormat;
import com.sap.jvm.profiling.presentation.typed.MethodIconFormat;
import com.sap.jvm.profiling.presentation.typed.entries.NormalMethodPers;
import com.sap.jvm.profiling.presentation.typed.entries.ProviderEntry;
import com.sap.jvm.profiling.presentation.typed.entries.StackFrameEntry;
import com.sap.jvm.profiling.viewer.ModelViewer;
import com.sap.jvm.profiling.viewer.renderer.AlignNode;
import com.sap.jvm.profiling.viewer.renderer.LinkNode;
import com.sap.jvm.profiling.viewer.renderer.LinkType;
import com.sap.jvm.profiling.viewer.renderer.LongAndShortTextNode;
import com.sap.jvm.profiling.viewer.renderer.OrderedMultiChildNode;
import com.sap.jvm.profiling.viewer.renderer.OverlayImageNode;
import com.sap.jvm.profiling.viewer.renderer.RendererInfo;
import com.sap.jvm.profiling.viewer.renderer.RendererNode;
import com.sap.jvm.profiling.viewer.renderer.RendererNodeUtils;
import com.sap.jvm.profiling.viewer.renderer.TextNode;
import java.net.URI;

public abstract class MethodRendererBase
extends MultiEntryRendererBase {
    public static final String PACKAGE_TAG = "MethodObj.package";
    public static final String SAME_PACKAGE_TAG = "MethodObj.package.same";
    public static final String DIFFERENT_PACKAGE_TAG = "MethodObj.package.different";
    public static final String CLASS_TAG = "MethodObj.class";
    public static final String SAME_CLASS_TAG = "MethodObj.class.same";
    public static final String DIFFERENT_CLASS_TAG = "MethodObj.class.different";
    public static final String METHOD_TAG = "MethodObj.method";
    public static final String MODIFICATION_LABEL_TAG = "MethodObj.label";
    public static final String SIGNATURE_TAG = "MethodObj.signature";
    public static final String RETURN_TYPE_TAG = "MethodObj.returnType";
    public static final int PUBLIC_INDEX = 0;
    public static final int PROTECTED_INDEX = 1;
    public static final int PRIVATE_INDEX = 2;
    public static final int PACKAGE_PRIVATE_INDEX = 3;
    public static final int UNKNOWN = 4;
    public static final int STATIC_INDEX = 5;
    public static final int FINAL_INDEX = 6;
    public static final int STATIC_FINAL_INDEX = 7;
    public static final int NATIVE_INDEX = 8;
    public static final int MPT_INDEX = 9;
    public static final int PROFILING_INDEX = 10;
    private final TextNode packageText;
    private final TextNode samePackageText;
    private final TextNode differentPackageText;
    private final TextNode classText;
    private final TextNode sameClassText;
    private final TextNode differentClassText;
    private final TextNode methodText;
    private final TextNode modificationLabelText;
    private final RendererNode methodOnlyRoot;
    private final LongAndShortTextNode signatureText;
    private final LongAndShortTextNode returnTypeText;
    protected final RendererNode root;
    private final RendererNode sameRoot;
    private final RendererNode differentRoot;
    protected final TextNode otherText;
    private final LinkNode<?> lineNrLink;
    private final RendererNode otherRoot;
    private final MethodFormat methodFormat;
    private final OverlayImageNode methodType;

    public MethodRendererBase(ModelViewer viewer, String imageTag, RendererThemeImpl theme) {
        super(viewer, theme);
        this.packageText = viewer.newTextNode(null);
        this.samePackageText = viewer.newTextNode(null);
        this.differentPackageText = viewer.newTextNode(null);
        this.classText = viewer.newTextNode(null);
        this.sameClassText = viewer.newTextNode(null);
        this.differentClassText = viewer.newTextNode(null);
        this.methodText = viewer.newTextNode(null);
        this.modificationLabelText = viewer.newTextNode(null);
        this.signatureText = viewer.newLongAndShortTextNode();
        this.returnTypeText = viewer.newLongAndShortTextNode();
        this.methodType = viewer.newOverlayImageNode(new URI[]{ImageRepository.getImageURI("decorators/method_public.gif"), ImageRepository.getImageURI("decorators/method_protected.gif"), ImageRepository.getImageURI("decorators/method_private.gif"), ImageRepository.getImageURI("decorators/method_package_private.gif"), ImageRepository.getImageURI("decorators/method_unknown.gif"), ImageRepository.getImageURI("decorators/dec_static.gif"), ImageRepository.getImageURI("decorators/dec_final.gif"), ImageRepository.getImageURI("decorators/dec_static_final.png"), ImageRepository.getImageURI("decorators/dec_native.gif"), ImageRepository.getImageURI("decorators/dec_mpt.gif"), ImageRepository.getImageURI("decorators/dec_profiling.gif")}, new int[0], "");
        AlignNode<? extends RendererNode> packageNode = viewer.newAlignNode(1, theme.decorate(PACKAGE_TAG, viewer, this.packageText));
        AlignNode<? extends RendererNode> samePackageNode = viewer.newAlignNode(1, theme.decorate(SAME_PACKAGE_TAG, viewer, this.samePackageText));
        AlignNode<? extends RendererNode> differentPackageNode = viewer.newAlignNode(1, theme.decorate(DIFFERENT_PACKAGE_TAG, viewer, this.differentPackageText));
        AlignNode<? extends RendererNode> classNode = viewer.newAlignNode(1, theme.decorate(CLASS_TAG, viewer, this.classText));
        AlignNode<? extends RendererNode> sameClassNode = viewer.newAlignNode(1, theme.decorate(SAME_CLASS_TAG, viewer, this.sameClassText));
        AlignNode<? extends RendererNode> differentClassNode = viewer.newAlignNode(1, theme.decorate(DIFFERENT_CLASS_TAG, viewer, this.differentClassText));
        AlignNode<? extends RendererNode> methodNode = viewer.newAlignNode(1, theme.decorate(METHOD_TAG, viewer, this.methodText));
        AlignNode<? extends RendererNode> labelNode = viewer.newAlignNode(1, theme.decorate(MODIFICATION_LABEL_TAG, viewer, this.modificationLabelText));
        AlignNode<? extends RendererNode> signatureNode = viewer.newAlignNode(-1, theme.decorate(SIGNATURE_TAG, viewer, this.signatureText));
        AlignNode<? extends RendererNode> returnTypeNode = viewer.newAlignNode(-1, theme.decorate(RETURN_TYPE_TAG, viewer, this.returnTypeText));
        OrderedMultiChildNode<? extends RendererNode> node = viewer.newOrderedMultiChildNode(new int[]{2, 1, 0, 3, 4, 5}, new RendererNode[]{packageNode, classNode, methodNode, labelNode, signatureNode, returnTypeNode});
        OrderedMultiChildNode<? extends RendererNode> sameNode = viewer.newOrderedMultiChildNode(new int[]{2, 1, 0, 3, 4, 5}, new RendererNode[]{samePackageNode, sameClassNode, methodNode, labelNode, signatureNode, returnTypeNode});
        OrderedMultiChildNode<? extends RendererNode> differentNode = viewer.newOrderedMultiChildNode(new int[]{2, 1, 0, 3, 4, 5}, new RendererNode[]{differentPackageNode, differentClassNode, methodNode, labelNode, signatureNode, returnTypeNode});
        MethodIconFormat iconFormat = theme.getSpec().getMethodIconFormat();
        boolean firstIsIcon = RendererNodeUtils.firstIsImage(theme.decorate(imageTag, viewer, node));
        if (iconFormat == MethodIconFormat.ALWAYS || iconFormat == MethodIconFormat.IF_ONLY_ICON && !firstIsIcon) {
            this.root = theme.decorate(imageTag, viewer, viewer.newMultiChildNode(this.methodType, viewer.newSpaceNode(4), node));
            this.sameRoot = theme.decorate(imageTag, viewer, viewer.newMultiChildNode(this.methodType, viewer.newSpaceNode(4), sameNode));
            this.differentRoot = theme.decorate(imageTag, viewer, viewer.newMultiChildNode(this.methodType, viewer.newSpaceNode(4), differentNode));
        } else {
            this.root = theme.decorate(imageTag, viewer, node);
            this.sameRoot = theme.decorate(imageTag, viewer, sameNode);
            this.differentRoot = theme.decorate(imageTag, viewer, differentNode);
        }
        this.methodFormat = theme.getSpec().getMethodFormat();
        this.otherText = viewer.newTextNode(null);
        this.lineNrLink = viewer.newLinkNode(null, LinkType.CTRL_AND_HOVER_ACTIVE, this.otherText);
        this.otherRoot = theme.decorate(imageTag, viewer, this.otherText);
        this.methodOnlyRoot = theme.decorate(imageTag, viewer, this.methodText);
    }

    protected abstract MethodLocation getLocation(ProviderEntry var1);

    protected abstract ClassObject getReceiver(ProviderEntry var1);

    @Override
    public RendererNode getMaximumVersion(RendererInfo info, EntryContext context, ColumnContext columnContext) {
        this.packageText.setText("aquiet.extensive.package.name.we.seldom.see.out.there.");
        this.classText.setText("AClassNameOfAn$InnerClassThisIs");
        this.methodText.setText("aLengthyMethodName");
        this.modificationLabelText.setText("#1234_Old");
        this.signatureText.setShortText("(Aboringsignaturebutwithalotofcharactersinitsoitsquietlong)");
        this.returnTypeText.setShortText("a.quiet.extensive.package.name.we.seldom.see.out.there.");
        return this.root;
    }

    @Override
    public RendererNode getMinimumVersion(RendererInfo info, EntryContext context, ColumnContext columnContext) {
        this.packageText.setText("a.small.package.");
        this.classText.setText("ANormalClass.");
        this.methodText.setText("theMethodName");
        this.modificationLabelText.setText("");
        this.signatureText.setShortText("()");
        this.returnTypeText.setShortText("void");
        return this.root;
    }

    @Override
    public RendererNode getRenderer(ProviderEntry entry, EntryContext context, ColumnContext columnContext) {
        boolean appendLineNr = false;
        if (entry instanceof NormalMethodPers) {
            return this.getRenderer((NormalMethodPers)entry);
        }
        if (entry instanceof StackFrameEntry) {
            appendLineNr = true;
        }
        MethodLocation location = this.getLocation(entry);
        assert (location != null);
        if (location.isNoStack()) {
            this.methodText.setText(I18n._s((String)"<no stack>"));
            return this.methodOnlyRoot;
        }
        if (location.isInlinedAway()) {
            this.methodText.setText(I18n._s((String)"<inlined away>"));
            return this.methodOnlyRoot;
        }
        if (location.getLineNumber() != 0) {
            this.otherText.setText("line " + location.getLineNumber());
            this.lineNrLink.setData(location);
            if (!appendLineNr) {
                return this.lineNrLink;
            }
        }
        ClassObject receiver = this.getReceiver(entry);
        MethodObject method = location.getMethod();
        boolean hasExplicitReceiver = receiver != null;
        receiver = receiver == null ? method.getMethodClass() : receiver;
        boolean isJavaScript = receiver.isSyntheticJavaScriptClass();
        String packageName = receiver.getPackageName();
        String className = receiver.getName() + (isJavaScript ? ":" : ".");
        String methodName = method.getName();
        String signatureName = this.getSignature(method);
        String returnTypeName = this.getReturnType(method);
        if (packageName.length() > 0) {
            packageName = packageName + ".";
        }
        this.methodText.setText(methodName);
        this.modificationLabelText.setText("");
        this.signatureText.setShortText("(" + (isJavaScript ? "" : signatureName) + ")");
        this.signatureText.setLongText("(" + (isJavaScript ? "" : method.getSignature()) + ")");
        this.returnTypeText.setShortText(isJavaScript ? method.getDefinitionLine() + ":" + method.getDefinitionColumn() : returnTypeName);
        this.returnTypeText.setLongText(isJavaScript ? method.getDefinitionLine() + ":" + method.getDefinitionColumn() : method.getReturnType());
        this.setMethodType(method, entry, context);
        if (hasExplicitReceiver) {
            if (receiver.equals(method.getMethodClass())) {
                this.samePackageText.setText(packageName);
                this.sameClassText.setText(className);
                return this.sameRoot;
            }
            this.differentPackageText.setText(packageName);
            this.differentClassText.setText(className);
            return this.differentRoot;
        }
        this.packageText.setText(packageName);
        this.classText.setText(className);
        return this.root;
    }

    private RendererNode getRenderer(NormalMethodPers method) {
        String label;
        String returnTypeName;
        String signatureName;
        if (method.isNoStack()) {
            this.methodText.setText(I18n._s((String)"<no stack>"));
            return this.methodOnlyRoot;
        }
        if (method.isInlinedAway()) {
            this.methodText.setText(I18n._s((String)"<inlined away>"));
            return this.methodOnlyRoot;
        }
        String packageName = method.getPackageName();
        String className = method.getClassName() + ".";
        String methodName = method.getName();
        String string = signatureName = this.methodFormat.hasShortSignature() ? MethodRendererBase.getShortVersion(method.getSignature()) : method.getSignature();
        String string2 = this.methodFormat.hasShortReturnType() ? MethodRendererBase.getShortVersion(method.getReturnType()) : (returnTypeName = this.methodFormat.showReturnType() ? method.getReturnType() : "");
        if (packageName.length() > 0) {
            packageName = packageName + ".";
        }
        if ((label = method.getModificationLabel()) == null) {
            label = "";
        }
        this.packageText.setText(packageName);
        this.classText.setText(className);
        this.methodText.setText(methodName);
        this.modificationLabelText.setText(label);
        this.signatureText.setShortText("(" + signatureName + ")");
        this.signatureText.setLongText("(" + method.getSignature() + ")");
        this.returnTypeText.setShortText(returnTypeName);
        this.returnTypeText.setLongText(method.getReturnType());
        this.setMethodType(method);
        return this.root;
    }

    private String getSignature(MethodObject method) {
        if (this.methodFormat.hasShortSignature()) {
            return MethodRendererBase.getShortVersion(method.getSignature());
        }
        return method.getSignature();
    }

    private String getReturnType(MethodObject method) {
        if (this.methodFormat.hasShortReturnType()) {
            return MethodRendererBase.getShortVersion(method.getReturnType());
        }
        return this.methodFormat.showReturnType() ? method.getReturnType() : "";
    }

    @Override
    public RendererNode getRendererForOtherChildren(ProviderEntry[] entries, EntryContext context, ColumnContext columnContext) {
        int[] skippedCounts = this.getNrSkippedMethodsAndLines(entries);
        if (skippedCounts[2] == entries.length) {
            return null;
        }
        String result = null;
        result = skippedCounts[0] == 0 ? I18n._ssn((String)"{0} other line", (String)"{0} other lines", (int)skippedCounts[1], (Object[])new Object[]{skippedCounts[1]}) : (skippedCounts[1] == 0 ? I18n._ssn((String)"{0} other method", (String)"{0} other methods", (int)skippedCounts[0], (Object[])new Object[]{skippedCounts[0]}) : I18n._ss((String)"sequence of two elements", (String)"{0}, {1}", (Object[])new Object[]{this.formatText(I18n._ssn((String)"{0} other method", (String)"{0} other methods", (int)skippedCounts[0]), skippedCounts[0]), this.formatText(I18n._ssn((String)"{0} other line", (String)"{0} other lines", (int)skippedCounts[1]), skippedCounts[1])}));
        this.otherText.setText(result);
        return this.otherRoot;
    }

    private int[] getNrSkippedMethodsAndLines(ProviderEntry[] entries) {
        int[] skippedCounts = new int[]{0, 0, 0};
        for (ProviderEntry entry : entries) {
            if (entry == null) {
                skippedCounts[2] = skippedCounts[2] + 1;
            }
            if (entry == null || entry instanceof NormalMethodPers) {
                skippedCounts[1] = skippedCounts[1] + 1;
                continue;
            }
            MethodLocation location = this.getLocation(entry);
            if (location == null || location.getLineNumber() == 0) {
                skippedCounts[0] = skippedCounts[0] + 1;
                continue;
            }
            skippedCounts[1] = skippedCounts[1] + 1;
        }
        return skippedCounts;
    }

    @Override
    public RendererNode getRendererForSkippedChildren(ProviderEntry[] entries, EntryContext context, ColumnContext columnContext) {
        int[] skippedCounts = this.getNrSkippedMethodsAndLines(entries);
        String result = null;
        result = skippedCounts[0] == 0 ? I18n._ssn((String)"{0} skipped line", (String)"{0} skipped lines", (int)skippedCounts[1], (Object[])new Object[]{skippedCounts[1]}) : (skippedCounts[1] == 0 ? I18n._ssn((String)"{0} skipped method", (String)"{0} skipped methods", (int)skippedCounts[0], (Object[])new Object[]{skippedCounts[0]}) : I18n._ss((String)"sequence of two elements", (String)"{0}, {1}", (Object[])new Object[]{this.formatText(I18n._ssn((String)"{0} skipped method", (String)"{0} skipped methods", (int)skippedCounts[0]), skippedCounts[0]), this.formatText(I18n._ssn((String)"{0} skipped line", (String)"{0} skipped lines", (int)skippedCounts[1]), skippedCounts[1])}));
        this.otherText.setText(result);
        return this.otherRoot;
    }

    @Override
    public RendererNode getRendererForCombinedItems(ProviderEntry[] entries, EntryContext context, ColumnContext columnContext) {
        int[] skippedCounts = this.getNrSkippedMethodsAndLines(entries);
        String result = null;
        result = skippedCounts[0] == 0 ? I18n._ssn((String)"{0} line", (String)"{0} lines", (int)skippedCounts[1], (Object[])new Object[]{skippedCounts[1]}) : (skippedCounts[1] == 0 ? I18n._ssn((String)"{0} method", (String)"{0} methods", (int)skippedCounts[0], (Object[])new Object[]{skippedCounts[0]}) : I18n._ss((String)"sequence of two elements", (String)"{0}, {1}", (Object[])new Object[]{this.formatText(I18n._ssn((String)"{0} method", (String)"{0} methods", (int)skippedCounts[0]), skippedCounts[0]), this.formatText(I18n._ssn((String)"{0} line", (String)"{0} lines", (int)skippedCounts[1]), skippedCounts[1])}));
        this.otherText.setText(result);
        return this.otherText;
    }

    @Override
    public String getToolTip(ProviderEntry entry, EntryContext context, ColumnContext columnContext) {
        if (entry instanceof NormalMethodPers) {
            return this.getToolTip((NormalMethodPers)entry);
        }
        MethodLocation location = this.getLocation(entry);
        if (location.isNoStack()) {
            return I18n._s((String)"Represents activities without having a stack trace");
        }
        ClassObject receiver = this.getReceiver(entry);
        if (receiver == null) {
            if (context.isTraceMethod(location.getMethod())) {
                return I18n._s((String)"{0} (a method parameter trace covers this)", (Object[])new Object[]{location.getMethod().getFullName()});
            }
            receiver = location.getMethod().getMethodClass();
            if (receiver.isSyntheticJavaScriptClass()) {
                String source = null;
                if (receiver instanceof NonArrayClassObject && (source = ((NonArrayClassObject)receiver).getSourceCode()) != null) {
                    String[] lines = source.split("[\r]?\n[\r]?");
                    source = "";
                    int linesLeft = 15;
                    int line = location.getLineNumber();
                    if (line == 0) {
                        line = location.getMethod().getDefinitionLine();
                    }
                    for (int i = line - 5; i < line + 20; ++i) {
                        if (i > 0 && i <= lines.length) {
                            source = source + i + "    " + lines[i - 1] + "\n";
                        }
                        if (--linesLeft == 0) break;
                    }
                }
                return location.getMethod().getName() + "() defined in " + receiver.getName() + " at " + location.getMethod().getDefinitionLine() + ":" + location.getMethod().getDefinitionColumn() + (source != null ? "\n\nSource:\n" + source : "");
            }
            String info = NormalClassRenderer.getGeneratedClassText((ClassObject)location.getMethod().getMethodClass());
            return location.getMethod().getFullName() + (info != null ? "\n" + info : "");
        }
        String info = NormalClassRenderer.getGeneratedClassText((ClassObject)location.getMethod().getMethodClass());
        if (location.getMethod().getMethodClass().equals(receiver)) {
            return location.getMethod().getFullName() + (info != null ? "\n" + info : "");
        }
        return location.getMethod().getFullName() + " called on class " + receiver.getFullName() + (info != null ? "\n" + info : "");
    }

    private String getToolTip(NormalMethodPers method) {
        if (method.isNoStack()) {
            return I18n._s((String)"Represents activities without having a stack trace");
        }
        StringBuilder result = new StringBuilder(method.getFullName());
        String label = method.getModificationLabel();
        if (label == null) {
            return result.toString();
        }
        result.append("\n");
        result.append(I18n._s((String)"This is one of multiple methods with the same name."));
        return result.toString();
    }

    @Override
    public String getToolTip(ProviderEntry entry, EntryContext context, ColumnContext columnContext, boolean expanded) {
        if (expanded) {
            return I18n._s((String)"Click to hide line numbers");
        }
        return I18n._s((String)"Click to show line numbers");
    }

    @Override
    public String getToolTipForOtherChildren(ProviderEntry[] entries, EntryContext context, ColumnContext columnContext) {
        int[] skippedCounts = this.getNrSkippedMethodsAndLines(entries);
        if (skippedCounts[2] == entries.length) {
            return null;
        }
        String result = null;
        result = skippedCounts[0] == 0 ? I18n._ssn((String)"{0} line which is considered irrelevant:\n\n", (String)"{0} lines which are considered irrelevant:\n\n", (int)skippedCounts[1], (Object[])new Object[]{skippedCounts[1]}) : (skippedCounts[1] == 0 ? I18n._ssn((String)"{0} method which is considered irrelevant:\n\n", (String)"{0} methods which are considered irrelevant:\n\n", (int)skippedCounts[0], (Object[])new Object[]{skippedCounts[0]}) : I18n._ss((String)"ex.: 3 methods and 1 line which are considerred irrelevant", (String)"{0} and {1} which are considered irrelevant:\n\n", (Object[])new Object[]{this.formatText(I18n._ssn((String)"{0} method", (String)"{0} methods", (int)skippedCounts[0]), skippedCounts[0]), this.formatText(I18n._ssn((String)"{0} line", (String)"{0} lines", (int)skippedCounts[1]), skippedCounts[1])}));
        return result + this.getEntryNames(entries, "", context);
    }

    @Override
    public String getToolTipForCombinedItems(ProviderEntry[] entries, EntryContext context, ColumnContext columnContext) {
        int[] skippedCounts = this.getNrSkippedMethodsAndLines(entries);
        String result = null;
        result = skippedCounts[0] == 0 ? I18n._ssn((String)"{0} line", (String)"{0} lines", (int)skippedCounts[1], (Object[])new Object[]{skippedCounts[1]}) : (skippedCounts[1] == 0 ? I18n._ssn((String)"{0} method", (String)"{0} methods", (int)skippedCounts[0], (Object[])new Object[]{skippedCounts[0]}) : I18n._ss((String)"sequence of two elements", (String)"{0} and {1}", (Object[])new Object[]{this.formatText(I18n._ssn((String)"{0} method", (String)"{0} methods", (int)skippedCounts[0]), skippedCounts[0]), this.formatText(I18n._ssn((String)"{0} line", (String)"{0} lines", (int)skippedCounts[1]), skippedCounts[1])}));
        return result;
    }

    @Override
    public String getToolTipForOtherChildren(ProviderEntry[] entries, EntryContext context, ColumnContext columnContext, boolean expanded) {
        assert (!expanded);
        int[] skippedCounts = this.getNrSkippedMethodsAndLines(entries);
        if (skippedCounts[2] == entries.length) {
            return null;
        }
        String result = null;
        result = skippedCounts[0] == 0 ? I18n._ssn((String)"Show the {0} line which is considered irrelevant.", (String)"Show the {0} lines which are considered irrelevant.", (int)skippedCounts[1], (Object[])new Object[]{skippedCounts[1]}) : (skippedCounts[1] == 0 ? I18n._ssn((String)"Show the {0} method which is considered irrelevant.", (String)"Show the {0} methods which are considered irrelevant.", (int)skippedCounts[0], (Object[])new Object[]{skippedCounts[0]}) : I18n._ss((String)"ex.: Show the 3 methods and 1 line which are considered irrelevant.", (String)"Show the {0} and {1} which are considered irrelevant.", (Object[])new Object[]{this.formatText(I18n._ssn((String)"{0} method", (String)"{0} methods", (int)skippedCounts[0]), skippedCounts[0]), this.formatText(I18n._ssn((String)"{0} line", (String)"{0} lines", (int)skippedCounts[1]), skippedCounts[1])}));
        return result;
    }

    @Override
    public String getToolTipForSkippedChildren(ProviderEntry[] entries, EntryContext context, ColumnContext columnContext) {
        int[] skippedCounts = this.getNrSkippedMethodsAndLines(entries);
        String result = null;
        result = skippedCounts[0] == 0 ? I18n._ssn((String)"{0} line which is skipped:\n\n", (String)"{0} lines which are skipped:\n\n", (int)skippedCounts[1], (Object[])new Object[]{skippedCounts[1]}) : (skippedCounts[1] == 0 ? I18n._ssn((String)"{0} method which is skipped:\n\n", (String)"{0} methods which are skipped:\n\n", (int)skippedCounts[0], (Object[])new Object[]{skippedCounts[0]}) : I18n._ss((String)"ex.: 3 methods and 1 line which are skipped", (String)"{0} and {1} which are skipped:\n\n", (Object[])new Object[]{this.formatText(I18n._ssn((String)"{0} method", (String)"{0} methods", (int)skippedCounts[0]), skippedCounts[0]), this.formatText(I18n._ssn((String)"{0} line", (String)"{0} lines", (int)skippedCounts[1]), skippedCounts[1])}));
        return result + this.getEntryNames(entries, "", context);
    }

    @Override
    public String getToolTipForSkippedChildren(ProviderEntry[] entries, EntryContext context, ColumnContext columnContext, boolean expanded) {
        assert (!expanded);
        int[] skippedCounts = this.getNrSkippedMethodsAndLines(entries);
        String result = null;
        result = skippedCounts[0] == 0 ? I18n._ssn((String)"Show the {0} line which is skipped.", (String)"Show the {0} lines which are skipped.", (int)skippedCounts[1], (Object[])new Object[]{skippedCounts[1]}) : (skippedCounts[1] == 0 ? I18n._ssn((String)"Show the {0} method which is skipped.", (String)"Show the {0} methods which are skipped.", (int)skippedCounts[0], (Object[])new Object[]{skippedCounts[0]}) : I18n._ss((String)"ex.: Show the 3 methods and 1 line which are skipped", (String)"Show the {0} and {1} which are skipped:\n\n", (Object[])new Object[]{this.formatText(I18n._ssn((String)"{0} method", (String)"{0} methods", (int)skippedCounts[0]), skippedCounts[0]), this.formatText(I18n._ssn((String)"{0} line", (String)"{0} lines", (int)skippedCounts[1]), skippedCounts[1])}));
        return result;
    }

    @Override
    protected String getEntryName(ProviderEntry entry, EntryContext contexts) {
        if (entry instanceof NormalMethodPers) {
            return ((NormalMethodPers)entry).getFullName();
        }
        MethodLocation location = this.getLocation(entry);
        ClassObject receiver = this.getReceiver(entry);
        if (location.getLineNumber() != 0) {
            return this.formatText(I18n._s((String)"line {0}"), location.getLineNumber());
        }
        MethodObject method = location.getMethod();
        if (receiver == null) {
            return method.getFullName();
        }
        return receiver.getFullName() + "(" + method.getSignature() + ")" + method.getReturnType();
    }

    private static String getShortVersion(String longVersion) {
        if (longVersion.length() < 1) {
            return longVersion;
        }
        StringBuffer result = new StringBuffer();
        int index = 0;
        while (index != longVersion.length()) {
            int startIndex;
            int newIndex = longVersion.indexOf(44, index);
            if (newIndex == -1) {
                newIndex = longVersion.length();
            }
            if ((startIndex = longVersion.lastIndexOf(46, newIndex) + 1) <= index) {
                result.append(longVersion.substring(index, newIndex));
            } else {
                result.append(longVersion.substring(startIndex, newIndex));
            }
            if (newIndex != longVersion.length()) {
                result.append(", ");
            }
            index = ++newIndex;
        }
        return result.toString();
    }

    private void setMethodType(MethodObject method, ProviderEntry entry, EntryContext context) {
        int typeIndex;
        if (method.isPublic()) {
            typeIndex = 0;
        } else if (method.isProtected()) {
            typeIndex = 1;
        } else if (method.isPrivate()) {
            typeIndex = 2;
        } else if (method.hasUnknownVisibility()) {
            typeIndex = 4;
        } else {
            assert (method.isPackagePrivate());
            ProfilingSession session = method.getSession();
            ProfilingCapabilities capabilities = session.getCapabilities();
            typeIndex = session.getSystemInfo() == null || capabilities.hasAdditionalMethodAttributes() ? 3 : 4;
        }
        boolean isStatic = method.isStatic();
        boolean isFinal = method.isFinal() || method.getMethodClass().isFinal();
        boolean isNative = method.isNative();
        boolean isMPT = context != null && context.isTraceMethod(method);
        boolean isProfiling = method.isProfilingMethod();
        int nrOfIndices = 1 + (isStatic || isFinal ? 1 : 0) + (isNative ? 1 : 0) + (isMPT ? 1 : 0) + (isProfiling ? 1 : 0);
        int[] indices = new int[nrOfIndices];
        indices[0] = typeIndex;
        int pos = 1;
        if (isStatic && isFinal) {
            indices[pos++] = 7;
        } else if (isStatic) {
            indices[pos++] = 5;
        } else if (isFinal) {
            indices[pos++] = 6;
        }
        if (isNative) {
            indices[pos++] = 8;
        }
        if (isMPT) {
            indices[pos++] = 9;
        }
        if (isProfiling) {
            indices[pos++] = 10;
        }
        assert (pos == indices.length);
        this.methodType.setIndices(indices);
    }

    private void setMethodType(NormalMethodPers method) {
        int typeIndex = 4;
        if (method.isPublic()) {
            typeIndex = 0;
        } else if (method.isProtected()) {
            typeIndex = 1;
        } else if (method.isPrivate()) {
            typeIndex = 2;
        } else if (method.isPackagePrivate()) {
            typeIndex = 3;
        } else if (!method.isUnknownType()) assert (false) : "Illegal method type";
        boolean isStatic = method.isStatic();
        boolean isFinal = method.isFinal();
        boolean isNative = method.isNative();
        int nrOfIndices = 1 + (isStatic || isFinal ? 1 : 0) + (isNative ? 1 : 0);
        int[] indices = new int[nrOfIndices];
        indices[0] = typeIndex;
        int pos = 1;
        if (isStatic && isFinal) {
            indices[pos++] = 7;
        } else if (isStatic) {
            indices[pos++] = 5;
        } else if (isFinal) {
            indices[pos++] = 6;
        }
        if (isNative) {
            indices[pos++] = 8;
        }
        assert (pos == indices.length);
        this.methodType.setIndices(indices);
    }
}

