/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.presentation.impl.typed.renderer;

import com.sap.jvm.profiling.presentation.impl.typed.renderer.EntryRendererBase;
import com.sap.jvm.profiling.presentation.impl.typed.renderer.RendererThemeImpl;
import com.sap.jvm.profiling.presentation.typed.ColumnContext;
import com.sap.jvm.profiling.presentation.typed.EntryContext;
import com.sap.jvm.profiling.presentation.typed.EntryRenderer;
import com.sap.jvm.profiling.presentation.typed.TypedModelRenderer;
import com.sap.jvm.profiling.presentation.typed.entries.MixedProviderEntry;
import com.sap.jvm.profiling.presentation.typed.entries.NormalMethod;
import com.sap.jvm.profiling.presentation.typed.entries.ProviderEntry;
import com.sap.jvm.profiling.viewer.ModelViewer;
import com.sap.jvm.profiling.viewer.renderer.RendererInfo;
import com.sap.jvm.profiling.viewer.renderer.RendererNode;

public final class MixedProviderEntryRenderer
extends EntryRendererBase {
    private final TypedModelRenderer renderer;

    public MixedProviderEntryRenderer(ModelViewer viewer, RendererThemeImpl theme, TypedModelRenderer renderer) {
        super(viewer, theme);
        this.renderer = renderer;
    }

    private ProviderEntry[] stripProviderEntries(ProviderEntry[] mixedEntries) {
        ProviderEntry[] result = new ProviderEntry[mixedEntries.length];
        for (int i = 0; i < mixedEntries.length; ++i) {
            result[i] = this.stripProviderEntry(mixedEntries[i]);
        }
        return result;
    }

    private ProviderEntry stripProviderEntry(ProviderEntry mixedEntry) {
        return ((MixedProviderEntry)mixedEntry).getProviderEntry();
    }

    private EntryRenderer stripRenderer(ProviderEntry mixedEntry) {
        ProviderEntry entry = this.stripProviderEntry(mixedEntry);
        Class<?> clazz = entry.getClass();
        return this.renderer.getRenderer(clazz);
    }

    @Override
    public RendererNode getMaximumVersion(RendererInfo info, EntryContext context, ColumnContext columnContext) {
        return this.renderer.getRenderer(NormalMethod.class).getMaximumVersion(info, context, columnContext);
    }

    @Override
    public RendererNode getMinimumVersion(RendererInfo info, EntryContext context, ColumnContext columnContext) {
        return this.renderer.getRenderer(NormalMethod.class).getMinimumVersion(info, context, columnContext);
    }

    @Override
    public RendererNode getRenderer(ProviderEntry entry, EntryContext context, ColumnContext columnContext) {
        return this.stripRenderer(entry).getRenderer(this.stripProviderEntry(entry), context, columnContext);
    }

    @Override
    public RendererNode getRendererForOtherChildren(ProviderEntry[] mixedEntries, EntryContext context, ColumnContext columnContext) {
        ProviderEntry[] entries = this.stripProviderEntries(mixedEntries);
        return this.stripRenderer(mixedEntries[0]).getRendererForOtherChildren(entries, context, columnContext);
    }

    @Override
    public RendererNode getRendererForSkippedChildren(ProviderEntry[] mixedEntries, EntryContext context, ColumnContext columnContext) {
        return this.stripRenderer(mixedEntries[0]).getRendererForSkippedChildren(this.stripProviderEntries(mixedEntries), context, columnContext);
    }

    @Override
    public RendererNode getRendererForCombinedItems(ProviderEntry[] mixedEntries, EntryContext context, ColumnContext columnContext) {
        return this.stripRenderer(mixedEntries[0]).getRendererForCombinedItems(this.stripProviderEntries(mixedEntries), context, columnContext);
    }

    @Override
    public String getToolTip(ProviderEntry mixedEntry, EntryContext context, ColumnContext columnContext) {
        return this.stripRenderer(mixedEntry).getToolTip(this.stripProviderEntry(mixedEntry), context, columnContext);
    }

    @Override
    public String getToolTipForCombinedItems(ProviderEntry[] mixedEntries, EntryContext context, ColumnContext columnContext) {
        return this.stripRenderer(mixedEntries[0]).getToolTipForCombinedItems(this.stripProviderEntries(mixedEntries), context, columnContext);
    }
}

