/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.presentation.impl.typed.renderer;

import com.sap.jvm.profiling.core.type.MonitorObjectUsage;
import com.sap.jvm.profiling.presentation.impl.typed.renderer.EntryRendererBase;
import com.sap.jvm.profiling.presentation.impl.typed.renderer.RendererThemeImpl;
import com.sap.jvm.profiling.presentation.typed.ColumnContext;
import com.sap.jvm.profiling.presentation.typed.EntryContext;
import com.sap.jvm.profiling.presentation.typed.entries.MonitorObjectEntry;
import com.sap.jvm.profiling.presentation.typed.entries.ProviderEntry;
import com.sap.jvm.profiling.viewer.ModelViewer;
import com.sap.jvm.profiling.viewer.renderer.RendererInfo;
import com.sap.jvm.profiling.viewer.renderer.RendererNode;
import com.sap.jvm.profiling.viewer.renderer.TextNode;

public final class MonitorObjectEntryRenderer
extends EntryRendererBase {
    public static final String PACKAGE_TAG = "classObject.package";
    public static final String CLASS_TAG = "classObject.class";
    private final RendererNode[] images;
    private final TextNode tagText;
    private final TextNode packageText;
    private final TextNode classText;
    private final TextNode idText;

    public MonitorObjectEntryRenderer(ModelViewer viewer, RendererThemeImpl theme) {
        super(viewer, theme);
        this.tagText = viewer.newTextNode(null);
        this.packageText = viewer.newTextNode(null);
        this.classText = viewer.newTextNode(null);
        this.idText = viewer.newTextNode(null);
        int numStates = MonitorObjectUsage.values().length;
        this.images = new RendererNode[numStates];
        for (int i = 0; i < numStates; ++i) {
            MonitorObjectUsage usage = MonitorObjectUsage.getMonitorUsage((int)i);
            String imageTag = "monitorobjectusage.image." + usage.getTag().toLowerCase();
            String altText = usage.getUsageText();
            this.images[i] = viewer.newMultiChildNode(theme.decorate(imageTag, viewer, viewer.newMultiChildNode(viewer.newSpaceNode(4), this.tagText, viewer.newSpaceNode(5), viewer.newAlignNode(-1, theme.decorate(PACKAGE_TAG, viewer, this.packageText)), viewer.newAlignNode(-1, theme.decorate(CLASS_TAG, viewer, this.classText)), viewer.newSpaceNode(5), this.idText), altText));
        }
    }

    private String getDisplayText(MonitorObjectEntry monitorEntry) {
        StringBuilder displayText = new StringBuilder();
        displayText.append(monitorEntry.getMonitorObject().getClassObject().getFullName());
        displayText.append(' ');
        displayText.append("[id = ");
        displayText.append(monitorEntry.getMonitorObject().getObjectId());
        displayText.append(']');
        return displayText.toString();
    }

    @Override
    public RendererNode getRenderer(ProviderEntry entry, EntryContext context, ColumnContext columnContext) {
        MonitorObjectEntry monitorEntry = (MonitorObjectEntry)entry;
        this.tagText.setText(monitorEntry.getMonitorUsage().getUsageText());
        this.packageText.setText(monitorEntry.getMonitorObject().getClassObject().getPackageName() + ".");
        this.classText.setText(monitorEntry.getMonitorObject().getClassObject().getName());
        StringBuilder idBuilder = new StringBuilder();
        idBuilder.append("[id = ");
        idBuilder.append(monitorEntry.getMonitorObject().getObjectId());
        idBuilder.append(']');
        this.idText.setText(idBuilder.toString());
        int value = monitorEntry.getMonitorUsage().getValue();
        assert (value >= 0 && value < this.images.length);
        return this.images[value];
    }

    @Override
    public RendererNode getMaximumVersion(RendererInfo info, EntryContext context, ColumnContext columnContext) {
        int maxValue = MonitorObjectUsage.values().length - 1;
        this.tagText.setText("blocked on a java.util.concurrent.locks.ReentrantLock [id = 12345678]");
        return this.images[maxValue];
    }

    @Override
    public String getToolTip(ProviderEntry entry, EntryContext context, ColumnContext columnContext) {
        return this.getDisplayText((MonitorObjectEntry)entry);
    }
}

