/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.presentation.impl.typed.renderer;

import com.sap.jvm.profiling.presentation.impl.typed.renderer.EntryRendererBase;
import com.sap.jvm.profiling.presentation.impl.typed.renderer.RendererThemeImpl;
import com.sap.jvm.profiling.presentation.typed.EntryContext;
import com.sap.jvm.profiling.presentation.typed.entries.ProviderEntry;
import com.sap.jvm.profiling.viewer.ModelViewer;

public abstract class MultiEntryRendererBase
extends EntryRendererBase {
    private static final int MAX_START = 10;
    private static final int MAX_END = 10;

    protected MultiEntryRendererBase(ModelViewer viewer, RendererThemeImpl theme) {
        super(viewer, theme);
    }

    protected abstract String getEntryName(ProviderEntry var1, EntryContext var2);

    protected final String getEntryNames(ProviderEntry[] entries, String indent, EntryContext context) {
        StringBuilder result = new StringBuilder();
        int count = 0;
        for (int i = 0; i < entries.length; ++i) {
            String name = this.getEntryName(entries[i], context);
            if (name.length() > 80) {
                name = name.substring(0, 80) + " ...";
            }
            String toAppend = null;
            if (i < 10 || entries.length - i <= 10) {
                toAppend = name;
            } else if (i == 10) {
                toAppend = "...";
            }
            if (toAppend == null) continue;
            for (int j = 0; j < count; ++j) {
                result.append(indent);
            }
            result.append(toAppend);
            result.append('\n');
            ++count;
        }
        return result.toString();
    }
}

