/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.presentation.impl.typed.renderer;

import com.sap.jvm.profiling.i18n.I18n;
import com.sap.jvm.profiling.presentation.impl.typed.renderer.EntryRendererBase;
import com.sap.jvm.profiling.presentation.impl.typed.renderer.RendererThemeImpl;
import com.sap.jvm.profiling.presentation.typed.ColumnContext;
import com.sap.jvm.profiling.presentation.typed.EntryContext;
import com.sap.jvm.profiling.presentation.typed.entries.NormalArrayLength;
import com.sap.jvm.profiling.presentation.typed.entries.ProviderEntry;
import com.sap.jvm.profiling.viewer.ModelViewer;
import com.sap.jvm.profiling.viewer.renderer.RendererInfo;
import com.sap.jvm.profiling.viewer.renderer.RendererNode;
import com.sap.jvm.profiling.viewer.renderer.TextNode;

public final class NormalArrayLengthRenderer
extends EntryRendererBase {
    public static final String TAG = "arrayLength";
    private final TextNode text;
    private final RendererNode root;

    public NormalArrayLengthRenderer(ModelViewer viewer, RendererThemeImpl theme) {
        super(viewer, theme);
        this.text = viewer.newTextNode(null);
        this.root = viewer.newAlignNode(1, theme.decorate(TAG, viewer, this.text));
        this.setCombinedTexts(I18n._s((String)"{0} lengths"), I18n._s((String)"{0} other lengths"), I18n._s((String)"{0} skipped lengths"));
    }

    @Override
    public RendererNode getRenderer(ProviderEntry entry, EntryContext context, ColumnContext columnContext) {
        NormalArrayLength arrayLength = (NormalArrayLength)entry;
        this.text.setText(arrayLength.getLength().toString());
        return this.root;
    }

    @Override
    public RendererNode getMaximumVersion(RendererInfo info, EntryContext context, ColumnContext columnContext) {
        this.text.setText("2000000000000");
        return this.root;
    }

    @Override
    public RendererNode getMinimumVersion(RendererInfo info, EntryContext context, ColumnContext columnContext) {
        this.text.setText("20000000000");
        return this.root;
    }

    @Override
    public String getToolTip(ProviderEntry entry, EntryContext context, ColumnContext columnContext) {
        NormalArrayLength arrayLength = (NormalArrayLength)entry;
        return this.formatText(I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"Arrays which have a length of {0}"), arrayLength.getLength());
    }
}

