/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.presentation.impl.typed.renderer;

import com.sap.jvm.profiling.core.type.ClassLoaderObject;
import com.sap.jvm.profiling.i18n.I18n;
import com.sap.jvm.profiling.presentation.impl.typed.renderer.MultiEntryRendererBase;
import com.sap.jvm.profiling.presentation.impl.typed.renderer.RendererThemeImpl;
import com.sap.jvm.profiling.presentation.typed.ColumnContext;
import com.sap.jvm.profiling.presentation.typed.EntryContext;
import com.sap.jvm.profiling.presentation.typed.entries.NormalClassLoader;
import com.sap.jvm.profiling.presentation.typed.entries.NormalClassLoaderPers;
import com.sap.jvm.profiling.presentation.typed.entries.NormalClassPers;
import com.sap.jvm.profiling.presentation.typed.entries.ProviderEntry;
import com.sap.jvm.profiling.viewer.ModelViewer;
import com.sap.jvm.profiling.viewer.renderer.RendererInfo;
import com.sap.jvm.profiling.viewer.renderer.RendererNode;
import com.sap.jvm.profiling.viewer.renderer.TextNode;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;

public final class NormalClassLoaderRenderer
extends MultiEntryRendererBase {
    public static final String IMAGE_TAG = "classLoader.image";
    public static final String NAME_TAG = "classLoader.name";
    public static final String URLS_TAG = "classLoader.urls";
    private final TextNode loaderClass;
    private final TextNode loaderPackage;
    private final TextNode name;
    private final TextNode urls;
    private final RendererNode noNameAndURLs;
    private final RendererNode noName;
    private final RendererNode noURLs;

    public NormalClassLoaderRenderer(ModelViewer viewer, RendererThemeImpl theme) {
        super(viewer, theme);
        this.setCombinedTexts(I18n._s((String)"{0} loaders"), I18n._s((String)"{0} other loaders"), I18n._s((String)"{0} skipped loaders"));
        this.loaderPackage = viewer.newTextNode(null);
        this.loaderClass = viewer.newTextNode(null);
        this.name = viewer.newTextNode(null);
        this.urls = viewer.newTextNode(null);
        this.noNameAndURLs = theme.decorate(IMAGE_TAG, viewer, viewer.newOrderedMultiChildNode(new int[]{0, 2, 1}, new RendererNode[]{viewer.newSpaceNode(4), viewer.newAlignNode(1, theme.decorate("classObject.package", viewer, this.loaderPackage)), theme.decorate("classObject.class", viewer, this.loaderClass)}));
        this.noName = theme.decorate(IMAGE_TAG, viewer, viewer.newOrderedMultiChildNode(new int[]{0, 2, 3, 1}, new RendererNode[]{viewer.newSpaceNode(4), viewer.newAlignNode(1, theme.decorate("classObject.package", viewer, this.loaderPackage)), theme.decorate("classObject.class", viewer, this.loaderClass), theme.decorate(URLS_TAG, viewer, this.urls)}));
        this.noURLs = theme.decorate(IMAGE_TAG, viewer, viewer.newMultiChildNode(viewer.newSpaceNode(4), theme.decorate(NAME_TAG, viewer, this.name)));
    }

    @Override
    public RendererNode getMaximumVersion(RendererInfo info, EntryContext context, ColumnContext columnContext) {
        this.loaderPackage.setText("a.very.long.package.name.your.will.seldom.see.in.real.live");
        this.loaderClass.setText("AClassLoaderClassWithAVeryLongName");
        this.urls.setText("URLS (lkjlkjkljljl.jar, kjsdhkjhakjhkj.jar, kjhsdkjahskdjhas.jarjkashdkjhaksjd.jar askjdhkajhsdkj.jar adjhakjshdkhj.jar asdkjhaskdj.jarasdjashkdjhask.jar asdjkhasjkdhkj.jar asdjhaksjdhkjash.jars");
        return this.noName;
    }

    @Override
    public RendererNode getMinimumVersion(RendererInfo info, EntryContext context, ColumnContext columnContext) {
        this.loaderPackage.setText("com.sap.vmc.core.impl.sapjvm.");
        this.loaderClass.setText("sharing.NativeSharedClassLoaderImpl");
        return this.noNameAndURLs;
    }

    @Override
    public RendererNode getRenderer(ProviderEntry entry, EntryContext context, ColumnContext columnContext) {
        String packageName;
        NormalClassLoaderPers loader = this.getSimplified(entry);
        if (loader.isBootstrapClassLoader()) {
            this.name.setText(I18n._s((String)"<bootstrap>"));
            return this.noURLs;
        }
        if (loader.isNoStack()) {
            this.name.setText(I18n._s((String)"<no stack>"));
            return this.noURLs;
        }
        if (loader.isInlinedAway()) {
            this.name.setText(I18n._s((String)"<inlined away>"));
            return this.noURLs;
        }
        String loaderName = loader.getName();
        if (loaderName.length() > 0) {
            this.name.setText(loaderName);
            return this.noURLs;
        }
        NormalClassPers loaderClassObj = loader.getClassObject();
        String string = packageName = loaderClassObj == null ? "" : loaderClassObj.getPackageName();
        if (packageName.length() == 0) {
            this.loaderPackage.setText("");
        } else {
            this.loaderPackage.setText(packageName + ".");
        }
        this.loaderClass.setText(loaderClassObj == null ? "" : loaderClassObj.getName());
        if (loader.getNrOfURLs() > 0) {
            this.urls.setText(" (" + loader.getShortURLs() + ")");
            return this.noName;
        }
        return this.noNameAndURLs;
    }

    private NormalClassLoaderPers getSimplified(ProviderEntry entry) {
        NormalClassLoaderPers loader = entry instanceof NormalClassLoaderPers ? (NormalClassLoaderPers)entry : new NormalClassLoaderPers(((NormalClassLoader)entry).getClassLoader());
        return loader;
    }

    @Override
    public String getToolTip(ProviderEntry entry, EntryContext context, ColumnContext columnContext) {
        return NormalClassLoaderRenderer.getAsMultiLine(this.getSimplified(entry), "");
    }

    public static String getAsMultiLine(ClassLoaderObject loader, String indent) {
        return NormalClassLoaderRenderer.getAsMultiLine(new NormalClassLoaderPers(loader), indent);
    }

    private static String getAsMultiLine(NormalClassLoaderPers loader, String indent) {
        StringBuilder result = new StringBuilder(indent);
        if (loader.isBootstrapClassLoader()) {
            result.append(I18n._s((String)"<bootstrap>"));
        } else {
            String name = loader.getName();
            if (name.length() == 0) {
                result.append(loader.getClassObject().getFullName());
            } else {
                result.append(I18n._s((String)"Loader '{0}'", (Object[])new Object[]{name}));
            }
        }
        result.append(" (id 0x");
        result.append(Long.toHexString(loader.getId()));
        result.append(")");
        if (loader.getNrOfURLs() > 0) {
            result.append("\n\n");
            result.append(indent);
            result.append("URLs:\n");
            for (int i = 0; i < loader.getNrOfURLs(); ++i) {
                result.append(indent);
                result.append("    ");
                try {
                    result.append(URLDecoder.decode(loader.getURLString(i), "UTF-8"));
                }
                catch (UnsupportedEncodingException e) {
                    result.append(loader.getURLString(i));
                }
                result.append('\n');
            }
        }
        return result.toString();
    }

    @Override
    public String getToolTipForOtherChildren(ProviderEntry[] entries, EntryContext context, ColumnContext columnContext) {
        return I18n._ssn((String)"{0} loader which is considered irrelevant:\n\n{1}", (String)"{0} loaders which are considered irrelevant:\n\n{1}", (int)entries.length, (Object[])new Object[]{entries.length, this.getEntryNames(entries, "", context)});
    }

    @Override
    public String getToolTipForCombinedItems(ProviderEntry[] entries, EntryContext context, ColumnContext columnContext) {
        return I18n._ssn((String)"{0} loader", (String)"{0} loaders", (int)entries.length, (Object[])new Object[]{entries.length});
    }

    @Override
    public String getToolTipForOtherChildren(ProviderEntry[] entries, EntryContext context, ColumnContext columnContext, boolean expanded) {
        assert (!expanded);
        return I18n._ssn((String)"Show the {0} loader which is considered irrelevant.", (String)"Show the {0} loaders which are considered irrelevant.", (int)entries.length, (Object[])new Object[]{entries.length});
    }

    @Override
    public String getToolTipForSkippedChildren(ProviderEntry[] entries, EntryContext context, ColumnContext columnContext) {
        return I18n._ssn((String)"{0} loader which is skipped:\n\n{1}", (String)"{0} loaders which are skipped:\n\n{1}", (int)entries.length, (Object[])new Object[]{entries.length, this.getEntryNames(entries, "   ", context)});
    }

    @Override
    public String getToolTipForSkippedChildren(ProviderEntry[] entries, EntryContext context, ColumnContext columnContext, boolean expanded) {
        assert (!expanded);
        return I18n._ssn((String)"Show the {0} loader which is skipped.", (String)"Show the {0} loaders which are skipped.", (int)entries.length, (Object[])new Object[]{entries.length});
    }

    @Override
    protected String getEntryName(ProviderEntry entry, EntryContext context) {
        return ((NormalClassLoader)entry).asString();
    }
}

